/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.impl;

import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.collection.Range;
import org.limewire.swarm.SwarmCoordinator;
import org.limewire.swarm.SwarmCoordinatorListener;
import org.limewire.swarm.SwarmFileSystem;

public class SwarmCoordinatorListenerList {
    private final SwarmCoordinator swarmCoordinator;
    private final CopyOnWriteArrayList<SwarmCoordinatorListener> listeners = new CopyOnWriteArrayList();

    public SwarmCoordinatorListenerList(SwarmCoordinator swarmCoordinator) {
        assert (swarmCoordinator != null);
        this.swarmCoordinator = swarmCoordinator;
    }

    public void downloadCompleted(SwarmFileSystem swarmFilesystem) {
        for (SwarmCoordinatorListener listener : this.listeners) {
            listener.downloadCompleted(this.swarmCoordinator, swarmFilesystem);
        }
    }

    public void blockLeased(Range block) {
        for (SwarmCoordinatorListener listener : this.listeners) {
            listener.blockLeased(this.swarmCoordinator, block);
        }
    }

    public void blockUnleased(Range block) {
        for (SwarmCoordinatorListener listener : this.listeners) {
            listener.blockUnleased(this.swarmCoordinator, block);
        }
    }

    public void blockPending(Range block) {
        for (SwarmCoordinatorListener listener : this.listeners) {
            listener.blockPending(this.swarmCoordinator, block);
        }
    }

    public void blockUnpending(Range block) {
        for (SwarmCoordinatorListener listener : this.listeners) {
            listener.blockUnpending(this.swarmCoordinator, block);
        }
    }

    public void blockWritten(Range block) {
        for (SwarmCoordinatorListener listener : this.listeners) {
            listener.blockWritten(this.swarmCoordinator, block);
        }
    }

    public void blockVerificationFailed(Range failedRange) {
        for (SwarmCoordinatorListener listener : this.listeners) {
            listener.blockVerificationFailed(this.swarmCoordinator, failedRange);
        }
    }

    public void blockVerified(Range block) {
        for (SwarmCoordinatorListener listener : this.listeners) {
            listener.blockVerified(this.swarmCoordinator, block);
        }
    }

    public void add(SwarmCoordinatorListener swarmListener) {
        this.listeners.add(swarmListener);
    }

    public void remove(SwarmCoordinatorListener swarmListener) {
        this.listeners.remove(swarmListener);
    }
}

