/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.file.selection;

import java.util.NoSuchElementException;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.swarm.SwarmBlockSelector;

public class ContiguousSelectionStrategy
implements SwarmBlockSelector {
    @Override
    public Range selectAssignment(IntervalSet candidateBytes, IntervalSet neededBytes, long blockSize) throws NoSuchElementException {
        Range ret;
        if (blockSize < 1L) {
            throw new IllegalArgumentException("Block size cannot be " + blockSize);
        }
        if (candidateBytes.isEmpty()) {
            throw new NoSuchElementException();
        }
        Range candidate = candidateBytes.getFirst();
        long alignedHigh = this.alignHigh(candidate.getLow(), blockSize);
        if (alignedHigh > candidate.getHigh()) {
            alignedHigh = candidate.getHigh();
        }
        if ((ret = candidate).getHigh() != alignedHigh) {
            ret = Range.createRange(candidate.getLow(), alignedHigh);
        }
        return ret;
    }

    protected long alignHigh(long location, long blockSize) {
        location += blockSize;
        location -= location % blockSize;
        return location - 1L;
    }
}

