/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.limewire.collection.Buffer;
import org.limewire.inspection.Inspectable;
import org.limewire.nio.channel.AbstractChannelInterestWriter;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.util.ByteUtils;

public class StatisticGatheringWriter
extends AbstractChannelInterestWriter
implements Inspectable {
    private static final long NANO_START = System.nanoTime();
    private static final int HISTORY = 50;
    private final Buffer<Long> handleWrites = new Buffer(50);
    private final Buffer<Long> interestWrites = new Buffer(50);
    private final Buffer<Boolean> interestWritesStatus = new Buffer(50);
    private final Buffer<Long> writeTimes = new Buffer(50);
    private final Buffer<Long> writeAmounts = new Buffer(50);
    private final long msStart = System.currentTimeMillis();
    private long amountWrote;
    private long totalHandleWrite;
    private long totalInterestWrite;
    private long positiveInterestWrite;

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.writeTimes.add(System.nanoTime() - NANO_START);
        int wrote = super.write(src);
        this.amountWrote += (long)wrote;
        this.writeAmounts.add(Long.valueOf(wrote));
        return wrote;
    }

    @Override
    public boolean handleWrite() throws IOException {
        this.handleWrites.add(System.nanoTime() - NANO_START);
        ++this.totalHandleWrite;
        return super.handleWrite();
    }

    @Override
    public void interestWrite(WriteObserver observer, boolean status) {
        this.interestWrites.add(System.nanoTime() - NANO_START);
        this.interestWritesStatus.add(status);
        ++this.totalInterestWrite;
        if (status) {
            ++this.positiveInterestWrite;
        }
        super.interestWrite(observer, status);
    }

    @Override
    public Object inspect() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("ver", 1);
        ret.put("ms", this.msStart);
        ret.put("hw", this.getPacked(this.handleWrites));
        ret.put("iw", this.getPacked(this.interestWrites));
        ret.put("iws", this.getPackedBool(this.interestWritesStatus));
        ret.put("wt", this.getPacked(this.writeTimes));
        ret.put("wa", this.getPacked(this.writeAmounts));
        ret.put("totalWrote", this.amountWrote);
        ret.put("totalHW", this.totalHandleWrite);
        ret.put("totalIW", this.totalInterestWrite);
        ret.put("totalIWP", this.positiveInterestWrite);
        return ret;
    }

    private byte[] getPacked(Buffer<Long> b) {
        byte[] ret = new byte[b.getSize() * 8];
        for (int i = 0; i < b.getSize(); ++i) {
            ByteUtils.long2beb(b.get(i), ret, i * 8);
        }
        return ret;
    }

    private byte[] getPackedBool(Buffer<Boolean> b) {
        byte[] ret = new byte[b.getSize()];
        for (int i = 0; i < b.getSize(); ++i) {
            ret[i] = (byte)(b.get(i) != false ? 1 : 0);
        }
        return ret;
    }
}

