/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.impl.AbstractLookupRequest;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

public class FindValueRequestImpl
extends AbstractLookupRequest
implements FindValueRequest {
    private final Collection<KUID> secondaryKeys;
    private final DHTValueType valueType;

    public FindValueRequestImpl(Context context, Contact contact, MessageID messageId, KUID lookupId, Collection<KUID> secondaryKeys, DHTValueType valueType) {
        super(context, DHTMessage.OpCode.FIND_VALUE_REQUEST, contact, messageId, Version.ZERO, lookupId);
        this.secondaryKeys = secondaryKeys;
        this.valueType = valueType;
    }

    public FindValueRequestImpl(Context context, SocketAddress src, MessageID messageId, Version msgVersion, MessageInputStream in) throws IOException {
        super(context, DHTMessage.OpCode.FIND_VALUE_REQUEST, src, messageId, msgVersion, in);
        this.secondaryKeys = in.readKUIDs();
        this.valueType = in.readValueType();
    }

    @Override
    public Collection<KUID> getSecondaryKeys() {
        return this.secondaryKeys;
    }

    @Override
    public DHTValueType getDHTValueType() {
        return this.valueType;
    }

    @Override
    protected void writeBody(MessageOutputStream out) throws IOException {
        super.writeBody(out);
        out.writeKUIDs(this.getSecondaryKeys());
        out.writeDHTValueType(this.getDHTValueType());
    }

    public String toString() {
        return "FindValueRequest: " + this.lookupId;
    }
}

