/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.reactor;

public class HttpBandwidthTracker {
    private static final int DEFAULT_INTERVAL = 500;
    private final int _interval;
    private long _lastAmount = 0L;
    private long _lastTimeMeasured = 0L;
    private long _firstTimeMeasured = 0L;
    private long _amount = 0L;
    private float _measuredBandwidth = -1.0f;

    public HttpBandwidthTracker() {
        this(500);
    }

    public HttpBandwidthTracker(int interval) {
        this._interval = interval;
    }

    public synchronized void count(int added) {
        if (added < 0) {
            throw new IllegalArgumentException("Count values must be positive: " + added);
        }
        this.startCounting(-1L);
        this._amount += (long)added;
    }

    private void startCounting(long now) {
        if (this._firstTimeMeasured == 0L) {
            if (now == -1L) {
                now = System.currentTimeMillis();
            }
            this._lastTimeMeasured = this._firstTimeMeasured = now;
        }
    }

    public synchronized long getTotalAmount() {
        return this._amount;
    }

    public synchronized void measureBandwidth() {
        long now = System.currentTimeMillis();
        this.startCounting(now);
        if (now - this._lastTimeMeasured < (long)this._interval) {
            return;
        }
        this._measuredBandwidth = (this._amount - this._lastAmount) / (now - this._lastTimeMeasured);
        this._lastAmount = this._amount;
        this._lastTimeMeasured = now;
    }

    public synchronized float getMeasuredBandwidth() {
        if (this._measuredBandwidth < 0.0f) {
            return 0.0f;
        }
        return this._measuredBandwidth;
    }

    public synchronized float getAverageBandwidth() {
        long time = System.currentTimeMillis() - this._firstTimeMeasured;
        return time <= 0L ? 0.0f : (float)(this._amount / time);
    }
}

