/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.api.search.SearchDetails;
import org.limewire.core.api.search.SearchEvent;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.search.sponsored.SponsoredResult;
import org.limewire.core.api.search.sponsored.SponsoredResultTarget;
import org.limewire.core.impl.library.FriendSearcher;
import org.limewire.core.impl.search.AdvancedQueryStringBuilder;
import org.limewire.core.impl.search.FriendSearchListener;
import org.limewire.core.impl.search.QueryReplyListener;
import org.limewire.core.impl.search.QueryReplyListenerList;
import org.limewire.core.impl.search.RemoteFileDescAdapter;
import org.limewire.core.impl.search.SearchUrlUtils;
import org.limewire.core.impl.search.sponsored.CoreSponsoredResult;
import org.limewire.core.settings.PromotionSettings;
import org.limewire.geocode.GeocodeInformation;
import org.limewire.io.GUID;
import org.limewire.io.IpPort;
import org.limewire.listener.EventBroadcaster;
import org.limewire.promotion.PromotionSearcher;
import org.limewire.promotion.containers.PromotionMessageContainer;
import org.limewire.util.Clock;

public class CoreSearch
implements Search {
    private final SearchDetails searchDetails;
    private final SearchServices searchServices;
    private final QueryReplyListenerList listenerList;
    private final PromotionSearcher promotionSearcher;
    private final FriendSearcher friendSearcher;
    private final Provider<GeocodeInformation> geoLocation;
    private final RemoteFileDescAdapter.Factory remoteFileDescAdapterFactory;
    final AtomicBoolean processingStarted = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<SearchListener> searchListeners = new CopyOnWriteArrayList();
    private final QrListener qrListener = new QrListener();
    private final FriendSearchListener friendSearchListener = new FriendSearchListenerImpl();
    private final ScheduledExecutorService backgroundExecutor;
    private final EventBroadcaster<SearchEvent> searchEventBroadcaster;
    private final Clock clock;
    private final AdvancedQueryStringBuilder compositeQueryBuilder;
    volatile byte[] searchGuid;

    @Inject
    public CoreSearch(@Assisted SearchDetails searchDetails, SearchServices searchServices, QueryReplyListenerList listenerList, PromotionSearcher promotionSearcher, FriendSearcher friendSearcher, Provider<GeocodeInformation> geoLocation, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, EventBroadcaster<SearchEvent> searchEventBroadcaster, LimeXMLDocumentFactory xmlDocumentFactory, Clock clock, AdvancedQueryStringBuilder compositeQueryBuilder, RemoteFileDescAdapter.Factory remoteFileDescAdapterFactory) {
        this.searchDetails = searchDetails;
        this.searchServices = searchServices;
        this.listenerList = listenerList;
        this.promotionSearcher = promotionSearcher;
        this.friendSearcher = friendSearcher;
        this.geoLocation = geoLocation;
        this.backgroundExecutor = backgroundExecutor;
        this.searchEventBroadcaster = searchEventBroadcaster;
        this.clock = clock;
        this.compositeQueryBuilder = compositeQueryBuilder;
        this.remoteFileDescAdapterFactory = remoteFileDescAdapterFactory;
    }

    @Override
    public SearchCategory getCategory() {
        return this.searchDetails.getSearchCategory();
    }

    @Override
    public void addSearchListener(SearchListener searchListener) {
        this.searchListeners.add(searchListener);
    }

    @Override
    public void removeSearchListener(SearchListener searchListener) {
        this.searchListeners.remove(searchListener);
    }

    @Override
    public void start() {
        if (this.processingStarted.getAndSet(true)) {
            throw new IllegalStateException("cannot start search which has already been processed!");
        }
        for (SearchListener listener : this.searchListeners) {
            listener.searchStarted(this);
        }
        this.doSearch(true);
    }

    private void doSearch(boolean initial) {
        this.searchEventBroadcaster.broadcast(new SearchEvent(this, SearchEvent.Type.STARTED));
        this.searchGuid = this.searchServices.newQueryGUID();
        this.listenerList.addQueryReplyListener(this.searchGuid, this.qrListener);
        switch (this.searchDetails.getSearchType()) {
            case KEYWORD: {
                this.doKeywordSearch(initial);
                break;
            }
            case WHATS_NEW: {
                this.doWhatsNewSearch(initial);
            }
        }
    }

    private void doWhatsNewSearch(boolean initial) {
        this.searchServices.queryWhatIsNew(this.searchGuid, this.searchDetails.getSearchCategory());
    }

    private void doKeywordSearch(boolean initial) {
        String query = this.searchDetails.getSearchQuery();
        String advancedQuery = "";
        Map<FilePropertyKey, String> advancedSearch = this.searchDetails.getAdvancedDetails();
        if (advancedSearch != null && advancedSearch.size() > 0) {
            if (query == null || query.equals("")) {
                query = this.compositeQueryBuilder.createSimpleCompositeQuery(advancedSearch);
            }
            advancedQuery = this.compositeQueryBuilder.createXMLQueryString(advancedSearch, this.searchDetails.getSearchCategory().getCategory());
        }
        String mutated = this.searchServices.mutateQuery(query);
        this.searchServices.query(this.searchGuid, mutated, advancedQuery, this.searchDetails.getSearchCategory());
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                CoreSearch.this.friendSearcher.doSearch(CoreSearch.this.searchDetails, CoreSearch.this.friendSearchListener);
            }
        });
        if (initial && PromotionSettings.PROMOTION_SYSTEM_IS_ENABLED.getValue() && this.promotionSearcher.isEnabled()) {
            final PromotionSearcher.PromotionSearchResultsCallback callback = new PromotionSearcher.PromotionSearchResultsCallback(){

                @Override
                public void process(PromotionMessageContainer result) {
                    SponsoredResultTarget target = result.getOptions().isOpenInStoreTab() ? SponsoredResultTarget.STORE : (result.getOptions().isOpenInHomeTab() ? SponsoredResultTarget.HOME : SponsoredResultTarget.EXTERNAL);
                    String title = result.getTitle();
                    String displayUrl = result.getDisplayUrl();
                    if (displayUrl.isEmpty()) {
                        displayUrl = SearchUrlUtils.stripUrl(result.getURL());
                    }
                    if (title.isEmpty()) {
                        title = displayUrl;
                    }
                    CoreSponsoredResult coreSponsoredResult = new CoreSponsoredResult(title, result.getDescription(), displayUrl, SearchUrlUtils.createPromotionUrl(result, CoreSearch.this.clock.now() / 1000L), target);
                    CoreSearch.this.handleSponsoredResults(new SponsoredResult[]{coreSponsoredResult});
                }
            };
            final String finalQuery = query;
            this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CoreSearch.this.promotionSearcher.search(finalQuery, callback, (GeocodeInformation)CoreSearch.this.geoLocation.get());
                }
            });
        }
    }

    @Override
    public void repeat() {
        if (!this.processingStarted.get()) {
            throw new IllegalStateException("must start!");
        }
        this.stop();
        for (SearchListener listener : this.searchListeners) {
            listener.searchStarted(this);
        }
        this.doSearch(false);
    }

    @Override
    public void stop() {
        if (!this.processingStarted.compareAndSet(true, true)) {
            return;
        }
        this.searchEventBroadcaster.broadcast(new SearchEvent(this, SearchEvent.Type.STOPPED));
        this.listenerList.removeQueryReplyListener(this.searchGuid, this.qrListener);
        this.searchServices.stopQuery(new GUID(this.searchGuid));
        for (SearchListener listener : this.searchListeners) {
            listener.searchStopped(this);
        }
    }

    public GUID getQueryGuid() {
        return new GUID(this.searchGuid);
    }

    private void handleSponsoredResults(SponsoredResult ... sponsoredResults) {
        List<SponsoredResult> resultList = Arrays.asList(sponsoredResults);
        for (SearchListener listener : this.searchListeners) {
            listener.handleSponsoredResults(this, resultList);
        }
    }

    private class FriendSearchListenerImpl
    implements FriendSearchListener {
        private FriendSearchListenerImpl() {
        }

        @Override
        public void handleFriendResults(Collection<SearchResult> results) {
            for (SearchListener listener : CoreSearch.this.searchListeners) {
                listener.handleSearchResults(CoreSearch.this, results);
            }
        }
    }

    private class QrListener
    implements QueryReplyListener {
        private QrListener() {
        }

        @Override
        public void handleQueryReply(RemoteFileDesc rfd, QueryReply queryReply, Set<? extends IpPort> locs) {
            RemoteFileDescAdapter rfdAdapter = CoreSearch.this.remoteFileDescAdapterFactory.create(rfd, locs);
            for (SearchListener listener : CoreSearch.this.searchListeners) {
                listener.handleSearchResult(CoreSearch.this, rfdAdapter);
            }
        }
    }
}

