/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.friend;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.limewire.core.impl.friend.GnutellaFriend;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.AddressFeature;
import org.limewire.friend.api.feature.Feature;
import org.limewire.friend.api.feature.FeatureTransport;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.io.GUID;

public abstract class GnutellaPresence
implements FriendPresence {
    private final GnutellaFriend friend;

    GnutellaPresence(Address address) {
        this.friend = new GnutellaFriend(address, this);
    }

    @Override
    public Friend getFriend() {
        return this.friend;
    }

    @Override
    public abstract String getPresenceId();

    @Override
    public FriendPresence.Type getType() {
        return FriendPresence.Type.available;
    }

    @Override
    public String getStatus() {
        return "";
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public FriendPresence.Mode getMode() {
        return FriendPresence.Mode.available;
    }

    public String toString() {
        return "GnutellaPresence for: " + this.friend;
    }

    @Override
    public void addFeature(Feature feature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <D, F extends Feature<D>> void addTransport(Class<F> clazz, FeatureTransport<D> transport) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Feature getFeature(URI id) {
        if (id.equals(AddressFeature.ID)) {
            return new AddressFeature(this.friend.getAddress());
        }
        return null;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return Collections.singleton(this.getFeature(AddressFeature.ID));
    }

    @Override
    public <F extends Feature<D>, D> FeatureTransport<D> getTransport(Class<F> feature) {
        return null;
    }

    @Override
    public boolean hasFeatures(URI ... ids) {
        int i$ = 0;
        URI[] arr$ = ids;
        int len$ = arr$.length;
        if (i$ < len$) {
            URI uri = arr$[i$];
            return uri.equals(AddressFeature.ID);
        }
        return false;
    }

    @Override
    public void removeFeature(URI id) {
        throw new UnsupportedOperationException();
    }

    public static class GnutellaPresenceWithConnectable
    extends GnutellaPresence {
        private final Connectable connectable;

        public GnutellaPresenceWithConnectable(Connectable address) {
            super(address);
            this.connectable = address;
        }

        @Override
        public String getPresenceId() {
            return this.connectable.getInetSocketAddress().toString();
        }
    }

    public static class GnutellaPresenceWithGuid
    extends GnutellaPresence {
        private final byte[] id;

        public GnutellaPresenceWithGuid(Address address, byte[] id) {
            super(address);
            this.id = id;
        }

        @Override
        public String getPresenceId() {
            return GUID.toHexString(this.id);
        }
    }

    public static class GnutellaPresenceWithString
    extends GnutellaPresence {
        private final String id;

        public GnutellaPresenceWithString(Address address, String id) {
            super(address);
            this.id = id;
        }

        @Override
        public String getPresenceId() {
            return this.id;
        }
    }
}

