/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.connection;

import com.limegroup.gnutella.connection.RoutedConnection;
import java.util.Properties;
import org.limewire.core.api.connection.ConnectionItem;
import org.limewire.core.impl.friend.GnutellaPresence;
import org.limewire.friend.api.FriendPresence;
import org.limewire.io.ConnectableImpl;

public class CoreConnectionItem
implements ConnectionItem {
    private final RoutedConnection routedConnection;
    private volatile String host;
    private ConnectionItem.Status status;
    private long time;
    private boolean addressResolved = false;
    private boolean connecting = true;

    public CoreConnectionItem(RoutedConnection routedConnection) {
        this.routedConnection = routedConnection;
        this.host = routedConnection.getAddress();
        this.status = ConnectionItem.Status.CONNECTING;
        this.time = System.currentTimeMillis();
    }

    @Override
    public boolean isAddressResolved() {
        return this.addressResolved;
    }

    @Override
    public void setAddressResolved(boolean resolved) {
        this.addressResolved = resolved;
    }

    @Override
    public FriendPresence getFriendPresence() {
        String id = this.routedConnection.getAddress() + ":" + this.routedConnection.getPort();
        return new GnutellaPresence.GnutellaPresenceWithString(new ConnectableImpl(this.routedConnection), id);
    }

    @Override
    public Properties getHeaderProperties() {
        return this.routedConnection.getConnectionCapabilities().getHeadersRead().props();
    }

    @Override
    public String getHostName() {
        return this.host;
    }

    @Override
    public void setHostName(String hostName) {
        this.host = hostName;
    }

    @Override
    public void resetHostName() {
        this.host = this.routedConnection.getInetAddress().getHostAddress();
        this.addressResolved = false;
    }

    @Override
    public float getMeasuredDownstreamBandwidth() {
        return this.routedConnection.getMeasuredDownstreamBandwidth();
    }

    @Override
    public float getMeasuredUpstreamBandwidth() {
        return this.routedConnection.getMeasuredUpstreamBandwidth();
    }

    @Override
    public int getNumMessagesReceived() {
        return this.routedConnection.getConnectionMessageStatistics().getNumMessagesReceived();
    }

    @Override
    public int getNumMessagesSent() {
        return this.routedConnection.getConnectionMessageStatistics().getNumMessagesSent();
    }

    @Override
    public long getNumReceivedMessagesDropped() {
        return this.routedConnection.getConnectionMessageStatistics().getNumReceivedMessagesDropped();
    }

    @Override
    public int getNumSentMessagesDropped() {
        return this.routedConnection.getConnectionMessageStatistics().getNumSentMessagesDropped();
    }

    @Override
    public int getPort() {
        return this.routedConnection.getPort();
    }

    @Override
    public int getQueryRouteTableEmptyUnits() {
        return this.routedConnection.getRoutedConnectionStatistics().getQueryRouteTableEmptyUnits();
    }

    @Override
    public double getQueryRouteTablePercentFull() {
        return this.routedConnection.getRoutedConnectionStatistics().getQueryRouteTablePercentFull();
    }

    @Override
    public int getQueryRouteTableSize() {
        return this.routedConnection.getRoutedConnectionStatistics().getQueryRouteTableSize();
    }

    @Override
    public int getQueryRouteTableUnitsInUse() {
        return this.routedConnection.getRoutedConnectionStatistics().getQueryRouteTableUnitsInUse();
    }

    @Override
    public float getReadLostFromSSL() {
        return this.routedConnection.getConnectionBandwidthStatistics().getReadLostFromSSL();
    }

    @Override
    public float getReadSavedFromCompression() {
        return this.routedConnection.getConnectionBandwidthStatistics().getReadSavedFromCompression();
    }

    @Override
    public float getSentLostFromSSL() {
        return this.routedConnection.getConnectionBandwidthStatistics().getSentLostFromSSL();
    }

    @Override
    public float getSentSavedFromCompression() {
        return this.routedConnection.getConnectionBandwidthStatistics().getSentSavedFromCompression();
    }

    @Override
    public ConnectionItem.Status getStatus() {
        return this.status;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public String getUserAgent() {
        return this.routedConnection.getConnectionCapabilities().getUserAgent();
    }

    @Override
    public boolean isConnected() {
        return !this.connecting;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    @Override
    public boolean isLeaf() {
        return this.routedConnection.isSupernodeClientConnection();
    }

    @Override
    public boolean isOutgoing() {
        return this.routedConnection.isOutgoing();
    }

    @Override
    public boolean isPeer() {
        return this.routedConnection.getConnectionCapabilities().isSupernodeSupernodeConnection();
    }

    @Override
    public boolean isUltrapeerConnection() {
        return this.routedConnection.getConnectionCapabilities().isSupernodeConnection();
    }

    @Override
    public boolean isUltrapeer() {
        return this.routedConnection.getConnectionCapabilities().isClientSupernodeConnection();
    }

    @Override
    public void update() {
        this.connecting = false;
        boolean outgoing = this.routedConnection.isOutgoing();
        this.status = outgoing ? ConnectionItem.Status.OUTGOING : ConnectionItem.Status.INCOMING;
        this.host = this.routedConnection.getInetAddress().getHostAddress();
        this.time = this.routedConnection.getConnectionTime();
    }

    public RoutedConnection getRoutedConnection() {
        return this.routedConnection;
    }
}

