/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FixedSizeExpiringSet<T>
implements Set<T>,
Collection<T> {
    private static final long MAX_EXPIRE_TIME = 9223372036854L;
    private static final int DEFAULT_SIZE = 50;
    private static final long DEFAULT_EXPIRE_TIME = 600000L;
    private final int _maxSize;
    private final long _expireTime;
    private Map<T, Long> _map;

    public FixedSizeExpiringSet() {
        this(50);
    }

    public FixedSizeExpiringSet(int size) {
        this(size, 600000L);
    }

    public FixedSizeExpiringSet(int size, long expireTime) {
        this._maxSize = size;
        expireTime = Math.min(9223372036854L, expireTime);
        this._expireTime = expireTime * 1000L * 1000L;
        this._map = new HashMap<T, Long>();
    }

    @Override
    public int size() {
        this.expire(false);
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        Long time = this._map.get(arg0);
        if (time == null) {
            return false;
        }
        if (time < System.nanoTime()) {
            this._map.remove(arg0);
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        this.expire(false);
        return this._map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        this.expire(false);
        return this._map.keySet().toArray();
    }

    @Override
    public <B> B[] toArray(B[] arg0) {
        this.expire(false);
        return this._map.keySet().toArray(arg0);
    }

    @Override
    public boolean add(T arg0) {
        if (arg0 == null) {
            return false;
        }
        this.expire(this.size() >= this._maxSize);
        if (this._map.containsKey(arg0)) {
            return false;
        }
        this._map.put(arg0, System.nanoTime() + this._expireTime);
        return true;
    }

    @Override
    public boolean remove(Object arg0) {
        return this._map.remove(arg0) != null;
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this._map.keySet().containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        if (coll.isEmpty()) {
            return false;
        }
        Iterator<T> iter = coll.iterator();
        for (int i = 0; i < this._maxSize && iter.hasNext(); ++i) {
            this.add(iter.next());
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        HashMap<T, Long> map = new HashMap<T, Long>();
        boolean ret = false;
        for (T o : this._map.keySet()) {
            if (arg0.contains(o)) {
                map.put(o, this._map.get(o));
                continue;
            }
            ret = true;
        }
        if (ret) {
            this._map = map;
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        if (arg0.isEmpty()) {
            return false;
        }
        boolean ret = false;
        for (Object anArg0 : arg0) {
            ret |= this.remove(anArg0);
        }
        return ret;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    private void expire(boolean forceRemove) {
        if (this._map.size() == 0) {
            return;
        }
        long now = System.nanoTime();
        long min = Long.MAX_VALUE;
        Object oldest = null;
        HashSet<T> expired = new HashSet<T>();
        for (T key : this._map.keySet()) {
            long time = this._map.get(key);
            if (time < now) {
                expired.add(key);
                forceRemove = false;
                continue;
            }
            if (!forceRemove || time >= min) continue;
            min = time;
            oldest = key;
        }
        if (expired.size() > 0) {
            this.removeAll(expired);
        }
        if (forceRemove) {
            this.remove(oldest);
        }
    }
}

