/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;

public class OfferConfirmation
extends IQ {
    private String userJID;
    private long sessionID;

    public String getUserJID() {
        return this.userJID;
    }

    public void setUserJID(String userJID) {
        this.userJID = userJID;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(long sessionID) {
        this.sessionID = sessionID;
    }

    public void notifyService(XMPPConnection con, String workgroup, String createdRoomName) throws XMPPException {
        NotifyServicePacket packet = new NotifyServicePacket(workgroup, createdRoomName);
        con.sendPacket(packet);
    }

    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<offer-confirmation xmlns=\"http://jabber.org/protocol/workgroup\">");
        buf.append("</offer-confirmation>");
        return buf.toString();
    }

    private class NotifyServicePacket
    extends IQ {
        String roomName;

        NotifyServicePacket(String workgroup, String roomName) {
            this.setTo(workgroup);
            this.setType(IQ.Type.RESULT);
            this.roomName = roomName;
        }

        public String getChildElementXML() {
            return "<offer-confirmation  roomname=\"" + this.roomName + "\" xmlns=\"http://jabber.org/protocol/workgroup" + "\"/>";
        }
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            OfferConfirmation confirmation = new OfferConfirmation();
            boolean done = false;
            while (!done) {
                parser.next();
                String elementName = parser.getName();
                if (parser.getEventType() == 2 && "user-jid".equals(elementName)) {
                    try {
                        confirmation.setUserJID(parser.nextText());
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (parser.getEventType() == 2 && "session-id".equals(elementName)) {
                    try {
                        confirmation.setSessionID(Long.valueOf(parser.nextText()));
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (parser.getEventType() != 3 || !"offer-confirmation".equals(elementName)) continue;
                done = true;
            }
            return confirmation;
        }
    }
}

