/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.valuepair;

import java.util.HashMap;
import java.util.Map;

public class ImageFormats {
    public static final String V22_JPG_FORMAT = "JPG";
    public static final String V22_PNG_FORMAT = "PNG";
    public static final String V22_GIF_FORMAT = "GIF";
    public static final String V22_BMP_FORMAT = "COVERART_BMP";
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_GIF = "image/gif";
    public static final String MIME_TYPE_BMP = "image/bmp";
    public static final String MIME_TYPE_JPG = "image/jpg";
    private static Map<String, String> imageFormatsToMimeType = new HashMap<String, String>();
    private static Map<String, String> imageMimeTypeToFormat = new HashMap<String, String>();

    public static String getMimeTypeForFormat(String format) {
        return imageFormatsToMimeType.get(format);
    }

    public static String getFormatForMimeType(String mimeType) {
        return imageMimeTypeToFormat.get(mimeType);
    }

    public static boolean binaryDataIsPngFormat(byte[] data) {
        return 137 == (data[0] & 0xFF) && 80 == (data[1] & 0xFF) && 78 == (data[2] & 0xFF) && 71 == (data[3] & 0xFF);
    }

    public static boolean binaryDataIsJpgFormat(byte[] data) {
        return 255 == (data[0] & 0xFF) && 216 == (data[1] & 0xFF) && 255 == (data[2] & 0xFF) && 255 == (data[3] & 0xE0);
    }

    public static boolean binaryDataIsGifFormat(byte[] data) {
        return 71 == (data[0] & 0xFF) && 73 == (data[1] & 0xFF) && 70 == (data[2] & 0xFF);
    }

    public static boolean binaryDataIsBmpFormat(byte[] data) {
        return 66 == (data[0] & 0xFF) && 77 == (data[1] & 0xFF) && 60 == (data[2] & 0xFF);
    }

    public static String getMimeTypeForBinarySignature(byte[] data) {
        if (ImageFormats.binaryDataIsPngFormat(data)) {
            return MIME_TYPE_PNG;
        }
        if (ImageFormats.binaryDataIsJpgFormat(data)) {
            return MIME_TYPE_JPEG;
        }
        if (ImageFormats.binaryDataIsGifFormat(data)) {
            return MIME_TYPE_GIF;
        }
        if (ImageFormats.binaryDataIsBmpFormat(data)) {
            return MIME_TYPE_BMP;
        }
        return null;
    }

    static {
        imageFormatsToMimeType.put(V22_JPG_FORMAT, MIME_TYPE_JPEG);
        imageFormatsToMimeType.put(V22_PNG_FORMAT, MIME_TYPE_PNG);
        imageFormatsToMimeType.put(V22_GIF_FORMAT, MIME_TYPE_GIF);
        imageFormatsToMimeType.put(V22_BMP_FORMAT, MIME_TYPE_BMP);
        for (String key : imageFormatsToMimeType.keySet()) {
            String value = imageFormatsToMimeType.get(key);
            imageMimeTypeToFormat.put(value, key);
        }
        imageMimeTypeToFormat.put(MIME_TYPE_JPG, V22_JPG_FORMAT);
    }
}

