/*
 * Decompiled with CFR 0.152.
 */
package memetic.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import memetic.crypto.Crypt;

public class RTPCrypt {
    private static final int PACKET_LENGTH_START = 2;
    private static final int PADDING = 32;
    private Crypt crypter = null;

    public RTPCrypt(Crypt crypter) {
        this.crypter = crypter;
    }

    public int encryptCtrl(byte[] input, int offset, int length, byte[] output, int outOffset) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        int blockSize = this.crypter.getBlockSize();
        int padding = blockSize - (length + 4) % blockSize;
        int sendLength = length + 4 + padding;
        byte[] sendData = new byte[sendLength];
        System.arraycopy(input, offset, sendData, 4, length);
        sendData[0] = (byte)(Math.random() * 255.0);
        sendData[1] = (byte)(Math.random() * 255.0);
        sendData[2] = (byte)(Math.random() * 255.0);
        sendData[3] = (byte)(Math.random() * 255.0);
        int sendOffset = 0;
        if (padding != 0) {
            int lastPacket = 0;
            int packetLength = 0;
            for (int position = 4; position < sendLength - padding; position += (packetLength *= 4)) {
                lastPacket = position;
                packetLength = sendData[position + 2] << 8 & 0xFF00 | sendData[position + 2 + 1] & 0xFF;
                ++packetLength;
            }
            boolean padded = (sendData[lastPacket] & 0x20) != 0;
            int paddingLength = 0;
            if (padded) {
                paddingLength = sendData[sendLength - 1] & 0xFF;
                sendData[sendLength - 1] = 0;
            }
            paddingLength += padding;
            packetLength += padding;
            packetLength /= 4;
            --packetLength;
            int n = lastPacket;
            sendData[n] = (byte)(sendData[n] | 0x20);
            for (int i = sendLength - paddingLength; i < sendLength; ++i) {
                sendData[i] = (byte)(paddingLength & 0xFF);
            }
            sendData[lastPacket + 2] = (byte)(packetLength >> 8 & 0xFF);
            sendData[lastPacket + 2 + 1] = (byte)(packetLength & 0xFF);
        }
        return this.crypter.encrypt(sendData, sendOffset, sendLength, output, outOffset);
    }

    public int encryptData(byte[] input, int offset, int length, byte[] output, int outOffset) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        byte[] sendData = input;
        int sendOffset = offset;
        int sendLength = length;
        int blockSize = this.crypter.getBlockSize();
        int padding = sendLength % blockSize;
        if (padding != 0) {
            padding = blockSize - padding;
            byte[] oldSendData = sendData;
            sendData = new byte[sendLength + padding];
            System.arraycopy(oldSendData, sendOffset, sendData, 0, sendLength);
            boolean padded = (sendData[0] & 0x20) != 0;
            int paddingLength = 0;
            if (padded) {
                paddingLength = sendData[sendLength - 1] & 0xFF;
                sendData[sendLength - 1] = 0;
            }
            sendData[0] = (byte)(sendData[0] | 0x20);
            for (int i = (sendLength += padding) - (paddingLength += padding); i < sendLength; ++i) {
                sendData[i] = (byte)(paddingLength & 0xFF);
            }
        }
        return this.crypter.encrypt(sendData, sendOffset, sendLength, output, outOffset);
    }

    public int decryptCtrl(byte[] input, int offset, int length, byte[] output, int outOffset) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        int readLength = this.crypter.decrypt(input, offset, length, output, outOffset);
        readLength -= 4;
        for (int i = outOffset; i < readLength; ++i) {
            output[outOffset + i] = output[outOffset + i + 4];
        }
        int lastPacket = 0;
        int packetLength = 0;
        for (int position = outOffset; position < outOffset + readLength; position += (packetLength *= 4)) {
            lastPacket = position;
            packetLength = output[position + 2] << 8 & 0xFF00 | output[position + 2] & 0xFF;
            ++packetLength;
        }
        boolean padded = (output[lastPacket] & 0x20) != 0;
        int paddingLength = 0;
        if (padded) {
            paddingLength = output[outOffset + readLength - 1] & 0xFF;
            output[lastPacket] = (byte)(output[lastPacket] & 0xFFFFFFDF);
            packetLength -= paddingLength;
            packetLength /= 4;
            output[lastPacket + 2] = (byte)(--packetLength >> 8 & 0xFF);
            output[lastPacket + 3] = (byte)(packetLength & 0xFF);
        }
        return readLength -= paddingLength;
    }

    public int decryptData(byte[] input, int offset, int length, byte[] output, int outOffset) throws InvalidKeyException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        int readLength = this.crypter.decrypt(input, offset, length, output, outOffset);
        boolean padded = (output[outOffset] & 0x20) != 0;
        int paddingLength = 0;
        if (padded) {
            paddingLength = output[outOffset + readLength - 1] & 0xFF;
            output[outOffset] = (byte)(output[outOffset] & 0xFFFFFFDF);
        }
        return readLength -= paddingLength;
    }

    public int getEncryptOutputSize(int inputSize) {
        int padding = this.getBlockSize() - (inputSize += 4) % this.getBlockSize();
        return this.crypter.getEncryptOutputSize(inputSize + padding);
    }

    public int getDecryptOutputSize(int inputSize) {
        return this.crypter.getDecryptOutputSize(inputSize);
    }

    public int getBlockSize() {
        return this.crypter.getBlockSize();
    }
}

