/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.limegroup.gnutella.security.CertificateProvider;
import com.limegroup.gnutella.security.CertificateProviderImpl;
import com.limegroup.gnutella.security.CertificateVerifier;
import com.limegroup.gnutella.security.CertifiedMessageVerifier;
import com.limegroup.gnutella.security.CertifiedMessageVerifierImpl;
import com.limegroup.gnutella.security.DefaultSignedMessageDataProvider;
import com.limegroup.gnutella.security.FileCertificateReader;
import com.limegroup.gnutella.security.HttpCertificateReader;
import com.limegroup.gnutella.version.Update;
import com.limegroup.gnutella.version.UpdateDefaultDataProviderImpl;
import java.io.File;
import java.net.URI;
import org.limewire.inject.LazySingleton;
import org.limewire.util.CommonUtils;

public class LimeWireUpdateModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(DefaultSignedMessageDataProvider.class).annotatedWith(Update.class).to(UpdateDefaultDataProviderImpl.class);
    }

    @Provides
    @LazySingleton
    @Update
    CertificateProvider updateCertificateProvider(FileCertificateReader fileCertificateReader, HttpCertificateReader httpCertificateReader, CertificateVerifier certificateVerifier) {
        return new CertificateProviderImpl(fileCertificateReader, httpCertificateReader, certificateVerifier, new File(CommonUtils.getUserSettingsDir(), "update.cert"), URI.create("http://certs.limewire.com/update/update.cert"));
    }

    @Provides
    @Update
    CertifiedMessageVerifier updateMessageVerifier(@Update CertificateProvider certificateProvider, CertificateVerifier certificateVerifier) {
        return new CertifiedMessageVerifierImpl(certificateProvider, certificateVerifier);
    }
}

