/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.AltLocTracker;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.IncompleteFileDesc;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.uploader.AbstractUploader;
import com.limegroup.gnutella.uploader.HTTPUploadSession;
import java.io.File;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpResponse;
import org.limewire.collection.Range;
import org.limewire.core.api.transfer.SourceInfo;

public class HTTPUploader
extends AbstractUploader
implements Uploader {
    private URN requestedURN;
    private boolean supportsQueueing = false;
    private AltLocTracker altLocTracker;
    private long uploadBegin;
    private long uploadEnd;
    private boolean containedRangeRequest;
    private long startTime = -1L;
    private boolean visible;
    private String method;
    private volatile String friendId;
    private HttpResponse lastResponse;
    private PushEndpoint pushEndpoint;

    public HTTPUploader(String fileName, HTTPUploadSession session) {
        super(fileName, session, null);
    }

    public HTTPUploader(String fileName, HTTPUploadSession session, TcpBandwidthStatistics tcpBandwidthStatistics) {
        super(fileName, session, tcpBandwidthStatistics);
    }

    @Override
    public void reinitialize() {
        super.reinitialize();
        this.requestedURN = null;
        this.uploadBegin = 0L;
        this.uploadEnd = 0L;
        this.containedRangeRequest = false;
        this.method = null;
    }

    @Override
    public void setFileDesc(FileDesc fd) {
        super.setFileDesc(fd);
        this.setUploadBegin(0L);
        this.setUploadEnd(this.getFileSize());
    }

    public void setFile(File file) {
        this.setFileSize(file.length());
        this.setUploadBegin(0L);
        this.setUploadEnd(this.getFileSize());
    }

    public void setFriendId(String id) {
        this.friendId = id;
    }

    public InetAddress getConnectedHost() {
        return this.getSession().getConnectedHost();
    }

    @Override
    public void stop() {
        if (this.getSession().getIOSession() != null) {
            this.getSession().getIOSession().shutdown();
        }
    }

    public long getUploadBegin() {
        return this.uploadBegin;
    }

    public long getUploadEnd() {
        return this.uploadEnd;
    }

    public boolean containedRangeRequest() {
        return this.containedRangeRequest;
    }

    public boolean validateRange() {
        long last;
        long first = this.getUploadBegin();
        if (first >= (last = this.getUploadEnd())) {
            return false;
        }
        if (this.getFileDesc() instanceof IncompleteFileDesc) {
            IncompleteFileDesc ifd = (IncompleteFileDesc)this.getFileDesc();
            if (this.containedRangeRequest()) {
                Range request = ifd.getAvailableSubRange(first, last - 1L);
                if (request == null) {
                    return false;
                }
                this.setUploadBegin(request.getLow());
                this.setUploadEnd(request.getHigh() + 1L);
            } else if (!ifd.isRangeSatisfiable(first, last - 1L)) {
                return false;
            }
        } else if (first < 0L || last > this.getFileSize()) {
            return false;
        }
        return true;
    }

    public URN getRequestedURN() {
        return this.requestedURN;
    }

    public void setRequestedURN(URN requestedURN) {
        this.requestedURN = requestedURN;
    }

    public boolean supportsQueueing() {
        return this.supportsQueueing && this.isValidQueueingAgent();
    }

    private boolean isValidQueueingAgent() {
        if (this.getUserAgent() == null) {
            return true;
        }
        return !this.getUserAgent().startsWith("Morpheus 3.0.2");
    }

    public void setSupportsQueueing(boolean supportsQueueing) {
        this.supportsQueueing = supportsQueueing;
    }

    public AltLocTracker getAltLocTracker() {
        if (this.altLocTracker == null) {
            this.altLocTracker = new AltLocTracker(this.getFileDesc().getSHA1Urn());
        }
        return this.altLocTracker;
    }

    public void setUploadBegin(long uploadBegin) {
        this.uploadBegin = uploadBegin;
    }

    public void setUploadEnd(long uploadEnd) {
        this.uploadEnd = uploadEnd;
    }

    public void setContainedRangeRequest(boolean containedRangeRequest) {
        this.containedRangeRequest = containedRangeRequest;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean isPartial() {
        return this.getUploadEnd() - this.getUploadBegin() < this.getFileSize();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setLastResponse(HttpResponse lastResponse) {
        this.lastResponse = lastResponse;
    }

    public HttpResponse getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public boolean isBrowseHostEnabled() {
        return super.isBrowseHostEnabled() && (this.getGnutellaPort() != -1 || this.pushEndpoint != null);
    }

    public void setPushEndpoint(PushEndpoint pushEndpoint) {
        this.pushEndpoint = pushEndpoint;
    }

    public PushEndpoint getPushEndpoint() {
        return this.pushEndpoint;
    }

    @Override
    public File getFile() {
        FileDesc fileDesc = this.getFileDesc();
        return fileDesc != null ? fileDesc.getFile() : null;
    }

    @Override
    public URN getUrn() {
        return this.getFileDesc().getSHA1Urn();
    }

    @Override
    public int getNumUploadConnections() {
        return 1;
    }

    @Override
    public String getPresenceId() {
        return this.friendId;
    }

    @Override
    public float getSeedRatio() {
        return -1.0f;
    }

    @Override
    public List<SourceInfo> getTransferDetails() {
        return Collections.emptyList();
    }
}

