/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.spam.RatingTable;
import com.limegroup.gnutella.spam.SpamManager;
import org.limewire.core.settings.SearchSettings;

@Singleton
class SpamManagerImpl
implements SpamManager {
    private final RatingTable ratingTable;

    @Inject
    SpamManagerImpl(RatingTable ratingTable) {
        this.ratingTable = ratingTable;
    }

    @Override
    public RatingTable getRatingTable() {
        return this.ratingTable;
    }

    @Override
    public void startedQuery(QueryRequest qr) {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            this.ratingTable.clear(qr);
        }
    }

    @Override
    public float calculateSpamRating(RemoteFileDesc rfd) {
        if (!SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            return 0.0f;
        }
        float rating = 0.0f;
        rating = 1.0f - (1.0f - rating) * (1.0f - this.ratingTable.getRating(rfd));
        rfd.setSpamRating(rating);
        return rating;
    }

    @Override
    public void handleSpamQueryReply(QueryReply qr) {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue()) {
            this.ratingTable.rate(qr, 1.0f);
        }
    }

    @Override
    public void handleUserMarkedSpam(RemoteFileDesc[] rfds) {
        for (RemoteFileDesc rfd : rfds) {
            rfd.setSpamRating(1.0f);
        }
        this.ratingTable.rate(rfds, 1.0f);
    }

    @Override
    public void handleUserMarkedGood(RemoteFileDesc[] rfds) {
        for (RemoteFileDesc rfd : rfds) {
            rfd.setSpamRating(0.0f);
        }
        this.ratingTable.rate(rfds, 0.0f);
    }

    @Override
    public void clearFilterData() {
        this.ratingTable.clear();
    }
}

