/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.google.inject.Inject;
import com.limegroup.gnutella.security.Certificate;
import com.limegroup.gnutella.security.CertificateParser;
import com.limegroup.gnutella.security.FileCertificateReader;
import java.io.File;
import java.io.IOException;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;

public class FileCertificateReaderImpl
implements FileCertificateReader {
    private final CertificateParser certificateParser;

    @Inject
    public FileCertificateReaderImpl(CertificateParser certificateParser) {
        this.certificateParser = certificateParser;
    }

    @Override
    public Certificate read(File file) throws IOException {
        if (file.length() > 10000L) {
            throw new IOException("file too big, corrupted");
        }
        byte[] data = FileUtils.readFileFully(file);
        if (data == null) {
            throw new IOException("file could not be read");
        }
        return this.certificateParser.parseCertificate(StringUtils.toUTF8String(data));
    }

    @Override
    public boolean write(Certificate certificate, File file) {
        return FileUtils.verySafeSave(file.getParentFile(), file.getName(), StringUtils.toUTF8Bytes(certificate.getCertificateString()));
    }
}

