/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public enum LicenseType {
    NO_LICENSE(""),
    CC_LICENSE("creativecommons.org/licenses/"),
    WEED_LICENSE("http://www.shmedlic.com/license/3play.aspx"),
    DRM_LICENSE(""),
    GPL("http://www.gnu.org/copyleft/gpl.html"),
    LGPL("http://www.gnu.org/copyleft/lgpl.html"),
    APACHE_BSD("http://opensource.org/licenses/apache2.0.php"),
    MIT_X("http://opensource.org/licenses/mit-license.php"),
    FDL("http://www.gnu.org/copyleft/fdl.html"),
    ARTISTIC("http://www.opensource.org/licenses/artistic-license.php"),
    PUBLIC_DOMAIN("http://www.public-domain.org"),
    SHAREWARE("http://en.wikipedia.org/wiki/Shareware"),
    LIMEWIRE_STORE_PURCHASE("LIMEWIRE_STORE_PURCHASE"),
    LIMEWIRE_STORE_RESHAREABLE("LIMEWIRE_STORE_RESHAREABLE");

    private final String keyword;
    private final List<String> indivList;

    private LicenseType(String keyword) {
        this.keyword = keyword;
        ArrayList<String> indiv = new ArrayList<String>(1);
        indiv.add(keyword);
        this.indivList = Collections.unmodifiableList(indiv);
    }

    public boolean isDRMLicense() {
        return this == WEED_LICENSE || this == DRM_LICENSE || this == LIMEWIRE_STORE_PURCHASE || this == LIMEWIRE_STORE_RESHAREABLE;
    }

    public List<String> getIndivisibleKeywords() {
        return this.indivList;
    }

    public static LicenseType determineLicenseType(String license, String type) {
        if (LicenseType.hasCCLicense(license, type)) {
            return CC_LICENSE;
        }
        if (LicenseType.hasWeedLicense(type)) {
            return WEED_LICENSE;
        }
        if (LicenseType.hasDRMLicense(type)) {
            return DRM_LICENSE;
        }
        if (LicenseType.hasLWSLicense(type)) {
            return LIMEWIRE_STORE_PURCHASE;
        }
        if (LicenseType.hasLWSRedistributionLicense(type)) {
            return LIMEWIRE_STORE_RESHAREABLE;
        }
        for (LicenseType licenseType : LicenseType.values()) {
            if (!licenseType.keyword.equals(type)) continue;
            return licenseType;
        }
        return NO_LICENSE;
    }

    private static boolean hasCCLicense(String license, String type) {
        if (license != null) {
            license = license.toLowerCase(Locale.US);
        }
        return type != null && type.equals("creativecommons.org/licenses/") || license != null && license.indexOf("creativecommons.org/licenses/") != -1 && license.indexOf("verify at") != -1;
    }

    private static boolean hasWeedLicense(String type) {
        return type != null && type.startsWith("http://www.shmedlic.com/license/3play.aspx") && type.indexOf(" vid: ") != -1 && type.indexOf(" cid: ") != -1;
    }

    private static boolean hasDRMLicense(String type) {
        return type != null && type.startsWith("licensed: ");
    }

    private static boolean hasLWSLicense(String type) {
        return type != null && type.startsWith("NOT CLEARED");
    }

    private static boolean hasLWSRedistributionLicense(String type) {
        return type != null && type.startsWith("SHAREABLE");
    }
}

