/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.AltLocFinder;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.downloader.RequeryListener;
import com.limegroup.gnutella.messages.QueryRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.activation.api.ActivationID;
import org.limewire.activation.api.ActivationManager;
import org.limewire.core.settings.DHTSettings;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.nio.observer.Shutdownable;

class RequeryManager
implements DHTEventListener {
    private static final Log LOG = LogFactory.getLog(RequeryManager.class);
    static long TIME_BETWEEN_REQUERIES = 180000L;
    private final RequeryListener requeryListener;
    private final DownloadManager downloadManager;
    private final AltLocFinder altLocFinder;
    private final DHTManager dhtManager;
    private final ActivationManager activationManager;
    private volatile QueryType lastQueryType;
    private volatile int numDHTQueries;
    private volatile long lastQuerySent;
    protected volatile boolean sentGnutellaQuery;
    protected volatile boolean activated;
    private volatile Shutdownable dhtQuery;
    private final ConnectionServices connectionServices;
    final AltLocSearchHandler searchHandler = new AltLocSearchHandler();
    private static final int CONNECTING_WAIT_TIME = 750;
    private static final int MIN_NUM_CONNECTIONS = 2;
    private static final int MIN_CONNECTION_MESSAGES = 6;
    private static final int MIN_TOTAL_MESSAGES = 45;
    static boolean NO_DELAY = false;

    RequeryManager(RequeryListener requeryListener, DownloadManager manager, AltLocFinder finder, DHTManager dhtManager, ConnectionServices connectionServices, ActivationManager activationManager) {
        this.requeryListener = requeryListener;
        this.downloadManager = manager;
        this.altLocFinder = finder;
        this.dhtManager = dhtManager;
        this.connectionServices = connectionServices;
        this.activationManager = activationManager;
        dhtManager.addEventListener(this);
    }

    boolean isWaitingForResults() {
        if (this.lastQueryType == null) {
            return false;
        }
        switch (this.lastQueryType) {
            case DHT: {
                return this.dhtQuery != null && this.getTimeLeftInQuery() > 0L;
            }
            case GNUTELLA: {
                return this.getTimeLeftInQuery() > 0L;
            }
        }
        return false;
    }

    QueryType getLastQueryType() {
        return this.lastQueryType;
    }

    long getTimeLeftInQuery() {
        return TIME_BETWEEN_REQUERIES - (System.currentTimeMillis() - this.lastQuerySent);
    }

    void sendQuery() {
        if (this.canSendQueryNow()) {
            if (this.canSendDHTQueryNow()) {
                this.sendDHTQuery();
            } else if (!this.sentGnutellaQuery) {
                this.sendGnutellaQuery();
            } else {
                LOG.debug("Can send a query now, but not sending it?!");
            }
        } else {
            LOG.debug("Tried to send query, but cannot do it now.");
        }
    }

    boolean canSendQueryAfterActivate() {
        return !this.sentGnutellaQuery || this.canSendDHTQueryNow();
    }

    boolean canSendQueryNow() {
        if (this.activationManager.isActive(ActivationID.OPTIMIZED_SEARCH_RESULT_MODULE)) {
            return this.canSendDHTQueryNow() || this.activated && this.canSendQueryAfterActivate();
        }
        return this.activated && this.canSendQueryAfterActivate();
    }

    void activate() {
        this.activated = true;
    }

    void cleanUp() {
        Shutdownable f = this.dhtQuery;
        this.dhtQuery = null;
        if (f != null) {
            f.shutdown();
        }
        this.dhtManager.removeEventListener(this);
    }

    @Override
    public void handleDHTEvent(DHTEvent evt) {
        if (evt.getType() == DHTEvent.Type.STOPPED) {
            this.handleAltLocSearchDone(false);
            this.numDHTQueries = 0;
        }
    }

    void handleAltLocSearchDone(boolean success) {
        this.dhtQuery = null;
        this.requeryListener.lookupFinished(QueryType.DHT);
    }

    private boolean isDHTUp() {
        return DHTSettings.ENABLE_DHT_ALT_LOC_QUERIES.getValue() && this.dhtManager.isMemberOfDHT();
    }

    private boolean canSendDHTQueryNow() {
        if (!this.isDHTUp()) {
            return false;
        }
        return this.numDHTQueries == 0 || this.numDHTQueries < DHTSettings.MAX_DHT_ALT_LOC_QUERY_ATTEMPTS.getValue() && System.currentTimeMillis() - this.lastQuerySent >= DHTSettings.TIME_BETWEEN_DHT_ALT_LOC_QUERIES.getValue();
    }

    private void sendDHTQuery() {
        LOG.debug("Sending a DHT requery!");
        this.lastQuerySent = System.currentTimeMillis();
        this.lastQueryType = QueryType.DHT;
        ++this.numDHTQueries;
        this.requeryListener.lookupStarted(QueryType.DHT, Math.max(TIME_BETWEEN_REQUERIES, LookupSettings.FIND_VALUE_LOOKUP_TIMEOUT.getValue()));
        URN sha1Urn = this.requeryListener.getSHA1Urn();
        if (sha1Urn != null) {
            this.dhtQuery = this.altLocFinder.findAltLocs(sha1Urn, this.searchHandler);
        }
    }

    private void sendGnutellaQuery() {
        if (this.hasStableConnections()) {
            QueryRequest qr = this.requeryListener.createQuery();
            if (qr != null) {
                this.downloadManager.sendQuery(qr);
                LOG.debug("Sent a gnutella requery!");
                this.sentGnutellaQuery = true;
                this.lastQueryType = QueryType.GNUTELLA;
                this.lastQuerySent = System.currentTimeMillis();
                this.requeryListener.lookupStarted(QueryType.GNUTELLA, TIME_BETWEEN_REQUERIES);
            } else {
                this.sentGnutellaQuery = true;
                this.requeryListener.lookupFinished(QueryType.GNUTELLA);
            }
        } else {
            LOG.debug("Tried to send a gnutella requery, but no stable connections.");
            this.requeryListener.lookupPending(QueryType.GNUTELLA, 750);
        }
    }

    private boolean hasStableConnections() {
        if (NO_DELAY) {
            return true;
        }
        return this.connectionServices.countConnectionsWithNMessages(6) >= 2 && this.connectionServices.getActiveConnectionMessages() >= 45;
    }

    private class AltLocSearchHandler
    implements SearchListener<AlternateLocation> {
        private AltLocSearchHandler() {
        }

        @Override
        public void searchFailed() {
            RequeryManager.this.handleAltLocSearchDone(false);
        }

        @Override
        public void handleResult(AlternateLocation alternateLocation) {
            RequeryManager.this.handleAltLocSearchDone(true);
        }
    }

    public static enum QueryType {
        DHT,
        GNUTELLA;

    }
}

