/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.RemoteFileDescCreator;
import com.limegroup.gnutella.downloader.RemoteFileDescDeserializer;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RemoteFileDescImpl;
import com.limegroup.gnutella.downloader.UrlRemoteFileDescImpl;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.net.address.AddressFactory;
import org.limewire.util.URIUtils;
import org.xml.sax.SAXException;

@Singleton
class RemoteFileDescFactoryImpl
implements RemoteFileDescFactory {
    private static final int COPY_INDEX = Integer.MAX_VALUE;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final PushEndpointFactory pushEndpointFactory;
    private final Provider<LimeHttpClient> httpClientProvider;
    private final AddressFactory addressFactory;
    private final ConcurrentMap<String, RemoteFileDescDeserializer> deserializers = new ConcurrentHashMap<String, RemoteFileDescDeserializer>();
    private final List<RemoteFileDescCreator> creators = new CopyOnWriteArrayList<RemoteFileDescCreator>();

    @Inject
    public RemoteFileDescFactoryImpl(LimeXMLDocumentFactory limeXMLDocumentFactory, PushEndpointFactory pushEndpointFactory, Provider<LimeHttpClient> httpClientProvider, AddressFactory addressFactory) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.pushEndpointFactory = pushEndpointFactory;
        this.httpClientProvider = httpClientProvider;
        this.addressFactory = addressFactory;
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(RemoteFileDesc rfd, IpPort ep) {
        return this.createRemoteFileDesc(ep.getAddress(), ep.getPort(), Integer.MAX_VALUE, rfd.getFileName(), rfd.getSize(), rfd.getClientGUID(), 0, false, 2, false, rfd.getXMLDocument(), rfd.getUrns(), false, false, "ALT", IpPort.EMPTY_SET, rfd.getCreationTime(), 0, null, ep instanceof Connectable ? ((Connectable)ep).isTLSCapable() : false);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(RemoteFileDesc rfd, PushEndpoint pe) {
        return this.createRemoteFileDesc(pe, Integer.MAX_VALUE, rfd.getFileName(), rfd.getSize(), pe.getClientGUID(), rfd.getSpeed(), rfd.getQuality(), false, rfd.getXMLDocument(), rfd.getUrns(), false, "ALT", rfd.getCreationTime());
    }

    public RemoteFileDesc createRemoteFileDesc(String host, int port, long index, String filename, long size, byte[] clientGUID, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, boolean firewalled, String vendor, Set<? extends IpPort> proxies, long createTime, int FWTVersion, boolean tlsCapable) {
        return this.createRemoteFileDesc(host, port, index, filename, size, clientGUID, speed, chat, quality, browseHost, xmlDoc, urns, replyToMulticast, firewalled, vendor, proxies, createTime, FWTVersion, null, tlsCapable);
    }

    public RemoteFileDesc createRemoteFileDesc(String host, int port, long index, String filename, long size, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, boolean firewalled, String vendor, long createTime, PushEndpoint pe) {
        return this.createRemoteFileDesc(host, port, index, filename, size, null, speed, chat, quality, browseHost, xmlDoc, urns, replyToMulticast, firewalled, vendor, null, createTime, 0, pe, false);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(Address address, long index, String filename, long size, byte[] clientGUID, int speed, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, String vendor, long createTime) {
        return this.createRemoteFileDesc(address, index, filename, size, clientGUID, speed, quality, browseHost, xmlDoc, urns, replyToMulticast, vendor, createTime, !urns.isEmpty(), null);
    }

    private RemoteFileDesc createRemoteFileDesc(String host, int port, long index, String filename, long size, byte[] clientGUID, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, boolean firewalled, String vendor, Set<? extends IpPort> proxies, long createTime, int FWTVersion, PushEndpoint pe, boolean tlsCapable) {
        Address address = null;
        if (firewalled) {
            if (pe == null) {
                IpPortImpl ipp;
                if (!host.equals("1.1.1.1")) {
                    try {
                        ipp = new IpPortImpl(host, port);
                    }
                    catch (UnknownHostException uhe) {
                        throw new IllegalArgumentException(uhe);
                    }
                } else {
                    ipp = null;
                    FWTVersion = 0;
                }
                address = this.pushEndpointFactory.createPushEndpoint(clientGUID, proxies, (byte)0, FWTVersion, ipp);
            }
        } else {
            assert (pe == null);
            try {
                address = new ConnectableImpl(host, port, tlsCapable);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("invalid host: " + host);
            }
        }
        if (urns == null) {
            urns = Collections.emptySet();
        }
        boolean http11 = !urns.isEmpty();
        return new RemoteFileDescImpl(address, index, filename, size, clientGUID, speed, quality, browseHost, xmlDoc, urns, replyToMulticast, vendor, createTime, http11, this.addressFactory, null);
    }

    public RemoteFileDesc createUrlRemoteFileDesc(Address address, String filename, long size, Set<? extends URN> urns, URL url) {
        UrlRemoteFileDescImpl rfd = new UrlRemoteFileDescImpl(address, filename, size, urns, url, this.addressFactory);
        assert (!rfd.isHTTP11());
        return rfd;
    }

    @Override
    public RemoteFileDesc createUrlRemoteFileDesc(URL url, String filename, URN urn, long size) throws IOException, URISyntaxException, HttpException, InterruptedException {
        int port = url.getPort();
        if (port < 0) {
            port = 80;
        }
        UrnSet urns = new UrnSet();
        if (urn != null) {
            urns.add(urn);
        }
        URI uri = URIUtils.toURI(url.toExternalForm());
        return this.createUrlRemoteFileDesc(new ConnectableImpl(url.getHost(), port, false), filename != null ? filename : MagnetOptions.extractFileName(uri), size <= 0L ? this.contentLength(uri) : size, urns, url);
    }

    private long contentLength(URI uri) throws HttpException, IOException, InterruptedException {
        HttpHead head = new HttpHead(uri);
        head.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        HttpResponse response = null;
        LimeHttpClient client = this.httpClientProvider.get();
        try {
            response = client.execute(head);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Got " + response.getStatusLine().getStatusCode() + " instead of 200 for URL: " + uri);
            }
            Header contentLength = response.getFirstHeader("Content-Length");
            if (contentLength != null) {
                try {
                    long len = Long.parseLong(contentLength.getValue());
                    if (len < 0L) {
                        throw new IOException("Invalid length: " + len);
                    }
                    long l = len;
                    return l;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("can't parse content length", nfe);
                }
            }
            throw new IOException("no content length header");
        }
        finally {
            client.releaseConnection(response);
        }
    }

    @Override
    public RemoteFileDesc createFromMemento(RemoteHostMemento remoteHostMemento) throws InvalidDataException {
        try {
            RemoteFileDescDeserializer deserializer = (RemoteFileDescDeserializer)this.deserializers.get(remoteHostMemento.getType());
            if (deserializer != null) {
                return deserializer.createRemoteFileDesc(remoteHostMemento.getAddress(this.addressFactory, this.pushEndpointFactory), remoteHostMemento.getIndex(), remoteHostMemento.getFileName(), remoteHostMemento.getSize(), remoteHostMemento.getClientGuid(), remoteHostMemento.getSpeed(), remoteHostMemento.getQuality(), this.xml(remoteHostMemento.getXml()), remoteHostMemento.getUrns(), remoteHostMemento.getVendor(), -1L);
            }
            if (remoteHostMemento.getCustomUrl() != null) {
                return this.createUrlRemoteFileDesc(remoteHostMemento.getAddress(this.addressFactory, this.pushEndpointFactory), remoteHostMemento.getFileName(), remoteHostMemento.getSize(), remoteHostMemento.getUrns(), remoteHostMemento.getCustomUrl());
            }
            return this.createRemoteFileDesc(remoteHostMemento.getAddress(this.addressFactory, this.pushEndpointFactory), remoteHostMemento.getIndex(), remoteHostMemento.getFileName(), remoteHostMemento.getSize(), remoteHostMemento.getClientGuid(), remoteHostMemento.getSpeed(), remoteHostMemento.getQuality(), remoteHostMemento.isBrowseHost(), this.xml(remoteHostMemento.getXml()), remoteHostMemento.getUrns(), remoteHostMemento.isReplyToMulticast(), remoteHostMemento.getVendor(), -1L);
        }
        catch (SAXException e) {
            throw new InvalidDataException(e);
        }
        catch (SchemaNotFoundException e) {
            throw new InvalidDataException(e);
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
    }

    private LimeXMLDocument xml(String xml) throws SAXException, SchemaNotFoundException, IOException {
        if (xml != null) {
            return this.limeXMLDocumentFactory.createLimeXMLDocument(xml);
        }
        return null;
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(Address address, long index, String filename, long size, byte[] clientGUID, int speed, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, String vendor, long createTime, boolean http1, byte[] queryGUID) {
        for (RemoteFileDescCreator creator : this.creators) {
            if (!creator.canCreateFor(address)) continue;
            return creator.create(address, index, filename, size, clientGUID, speed, quality, browseHost, xmlDoc, urns, replyToMulticast, vendor, createTime, http1);
        }
        return new RemoteFileDescImpl(address, index, filename, size, clientGUID, speed, quality, browseHost, xmlDoc, urns, replyToMulticast, vendor, createTime, http1, this.addressFactory, queryGUID);
    }

    @Override
    public void register(String type, RemoteFileDescDeserializer remoteFileDescDeserializer) {
        RemoteFileDescDeserializer other = this.deserializers.putIfAbsent(type, remoteFileDescDeserializer);
        assert (other == null) : "two deserializers registered for: " + type;
    }

    @Override
    public void register(RemoteFileDescCreator creator) {
        this.creators.add(creator);
    }
}

