/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.AbstractAltLocValue;
import com.limegroup.gnutella.dht.db.AbstractResultHandler;
import com.limegroup.gnutella.dht.db.AltLocFinder;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.PushEndpointService;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.dht.db.SearchListenerAdapter;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.DHTSettings;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GUID;
import org.limewire.io.IpPortImpl;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.nio.observer.Shutdownable;

@Singleton
class AltLocFinderImpl
implements AltLocFinder {
    private static final Log LOG = LogFactory.getLog(AltLocFinderImpl.class);
    private final DHTManager dhtManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final AltLocManager altLocManager;
    private final PushEndpointService pushEndpointManager;

    @Inject
    public AltLocFinderImpl(DHTManager dhtManager, AlternateLocationFactory alternateLocationFactory, AltLocManager altLocManager, @Named(value="pushEndpointManager") PushEndpointService pushEndpointManager) {
        this.dhtManager = dhtManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.altLocManager = altLocManager;
        this.pushEndpointManager = pushEndpointManager;
    }

    @Override
    public Shutdownable findAltLocs(URN urn, SearchListener<AlternateLocation> listener) {
        listener = SearchListenerAdapter.nonNullListener(listener);
        KUID key = KUIDUtils.toKUID(urn);
        EntityKey lookupKey = EntityKey.createEntityKey(key, AbstractAltLocValue.ALT_LOC);
        final DHTFuture<FindValueResult> future = this.dhtManager.get(lookupKey);
        if (future == null) {
            return null;
        }
        future.addDHTFutureListener(new AltLocsHandler(this.dhtManager, urn, key, listener));
        return new Shutdownable(){

            @Override
            public void shutdown() {
                future.cancel(true);
            }
        };
    }

    private void findPushAltLocs(GUID guid, final URN urn, final DHTValueEntity altLocEntity, final SearchListener<AlternateLocation> listener) {
        SearchListener<PushEndpoint> pushEndpointListener = new SearchListener<PushEndpoint>(){

            @Override
            public void handleResult(PushEndpoint pushEndpoint) {
                InetAddress creatorAddress = ((InetSocketAddress)altLocEntity.getCreator().getContactAddress()).getAddress();
                InetAddress externalAddress = pushEndpoint.getInetAddress();
                if (externalAddress != null && !externalAddress.equals(creatorAddress)) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Creator of " + altLocEntity + " and found " + pushEndpoint + " do not match!");
                    }
                    listener.searchFailed();
                } else {
                    AlternateLocation alternateLocation = AltLocFinderImpl.this.alternateLocationFactory.createPushAltLoc(pushEndpoint, urn);
                    AltLocFinderImpl.this.altLocManager.add(alternateLocation, this);
                    listener.handleResult(alternateLocation);
                }
            }

            @Override
            public void searchFailed() {
                listener.searchFailed();
            }
        };
        this.pushEndpointManager.findPushEndpoint(guid, pushEndpointListener);
    }

    private class AltLocsHandler
    extends AbstractResultHandler {
        private final SearchListener<AlternateLocation> listener;
        private final URN urn;

        private AltLocsHandler(DHTManager dhtManager, URN urn, KUID key, SearchListener<AlternateLocation> listener) {
            super(dhtManager, key, listener, AbstractAltLocValue.ALT_LOC);
            this.urn = urn;
            this.listener = listener;
        }

        @Override
        protected AbstractResultHandler.Result handleDHTValueEntity(DHTValueEntity entity) {
            DHTValue value = entity.getValue();
            if (!(value instanceof AltLocValue)) {
                return AbstractResultHandler.Result.NOT_FOUND;
            }
            AltLocValue altLoc = (AltLocValue)value;
            if (altLoc.isFirewalled()) {
                if (DHTSettings.ENABLE_PUSH_PROXY_QUERIES.getValue()) {
                    GUID guid = new GUID(altLoc.getGUID());
                    AltLocFinderImpl.this.findPushAltLocs(guid, this.urn, entity, this.listener);
                    return AbstractResultHandler.Result.NOT_YET_FOUND;
                }
            } else {
                Contact creator = entity.getCreator();
                InetAddress addr = ((InetSocketAddress)creator.getContactAddress()).getAddress();
                IpPortImpl ipp = new IpPortImpl(addr, altLoc.getPort());
                ConnectableImpl c = new ConnectableImpl(ipp, altLoc.supportsTLS());
                long fileSize = altLoc.getFileSize();
                byte[] ttroot = altLoc.getRootHash();
                try {
                    AlternateLocation location = AltLocFinderImpl.this.alternateLocationFactory.createDirectDHTAltLoc(c, this.urn, fileSize, ttroot);
                    AltLocFinderImpl.this.altLocManager.add(location, this);
                    this.listener.handleResult(location);
                    return AbstractResultHandler.Result.FOUND;
                }
                catch (IOException e) {
                    LOG.error("IOException", e);
                }
            }
            return AbstractResultHandler.Result.NOT_FOUND;
        }
    }
}

