/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.model;

import org.limewire.core.api.URN;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.library.LibraryFileList;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.ui.swing.search.model.BasicDownloadState;
import org.limewire.ui.swing.search.model.DownloadItemPropertyListener;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.model.VisualSearchResultStatusListener;

class AlreadyDownloadedListEventListener
implements VisualSearchResultStatusListener {
    private final LibraryManager libraryManager;
    private final DownloadListManager downloadListManager;

    public AlreadyDownloadedListEventListener(LibraryManager libraryManager, DownloadListManager downloadListManager) {
        this.libraryManager = libraryManager;
        this.downloadListManager = downloadListManager;
    }

    @Override
    public void resultChanged(VisualSearchResult vsr, String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void resultsCleared() {
    }

    @Override
    public void resultCreated(VisualSearchResult visualSearchResult) {
        URN urn;
        LibraryFileList libraryFileList = this.libraryManager.getLibraryManagedList();
        if (libraryFileList.contains(urn = visualSearchResult.getUrn())) {
            visualSearchResult.setDownloadState(BasicDownloadState.LIBRARY);
        } else {
            DownloadItem downloadItem = this.downloadListManager.getDownloadItem(urn);
            if (downloadItem != null) {
                downloadItem.addPropertyChangeListener(new DownloadItemPropertyListener(visualSearchResult));
                visualSearchResult.setPreExistingDownload(true);
                BasicDownloadState bstate = BasicDownloadState.fromState(downloadItem.getState());
                if (bstate != null) {
                    visualSearchResult.setDownloadState(bstate);
                }
            }
        }
    }
}

