/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.advanced;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.FriendAutoCompleterFactory;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.BasicAutoCompleter;
import org.limewire.ui.swing.components.CollectionBackedComboBoxModel;
import org.limewire.ui.swing.components.DropDownListAutoCompleteControl;
import org.limewire.ui.swing.components.FilteredDocument;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.util.FilePropertyKeyUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

abstract class AdvancedPanel
extends JPanel {
    private final Map<FilePropertyKey, JComponent> componentMap = new EnumMap<FilePropertyKey, JComponent>(FilePropertyKey.class);
    private final SearchCategory category;
    private final FriendAutoCompleterFactory friendAutoCompleterFactory;
    private final Action enterKeyAction;
    private final Resources resources = new Resources();

    public AdvancedPanel(SearchCategory category, FriendAutoCompleterFactory friendAutoCompleterFactory, Action enterKeyAction) {
        super(new MigLayout("fillx", "[]related[grow]", ""));
        this.category = category;
        this.friendAutoCompleterFactory = friendAutoCompleterFactory;
        this.enterKeyAction = enterKeyAction;
        GuiUtils.assignResources(this);
    }

    protected void addField(FilePropertyKey key) {
        this.addField(I18n.tr(FilePropertyKeyUtils.getUntraslatedDisplayName(key, this.category)), key);
    }

    private void addField(String description, FilePropertyKey key) {
        JLabel label = new JLabel(description);
        label.setFont(this.resources.font);
        this.add(label);
        JTextField textField = new JTextField();
        TextFieldClipboardControl.install(textField);
        FilteredDocument.configure(textField, key);
        this.addEnterAction(textField);
        textField.setFont(this.resources.font);
        DropDownListAutoCompleteControl autoCompleteControl = DropDownListAutoCompleteControl.install(textField, new BasicAutoCompleter(this.friendAutoCompleterFactory.getDictionary(this.category, key)));
        autoCompleteControl.setAutoComplete(true);
        this.add((Component)textField, "growx, wrap");
        this.componentMap.put(key, textField);
    }

    private void addEnterAction(JComponent component) {
        component.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "pressed");
        component.getActionMap().put("pressed", new AbstractAction("pressed"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedPanel.this.enterKeyAction != null) {
                    AdvancedPanel.this.enterKeyAction.actionPerformed(e);
                }
            }
        });
    }

    protected void addField(FilePropertyKey key, List<String> possibleValues) {
        this.addField(I18n.tr(FilePropertyKeyUtils.getUntraslatedDisplayName(key, this.category)), key, possibleValues);
    }

    private void addField(String name, FilePropertyKey key, List<String> possibleValues) {
        JLabel label = new JLabel(name);
        label.setFont(this.resources.font);
        this.add(label);
        JComboBox comboBox = new JComboBox(new CollectionBackedComboBoxModel(possibleValues));
        this.addEnterAction(comboBox);
        comboBox.setFont(this.resources.font);
        this.add(comboBox, "growx, wrap");
        this.componentMap.put(key, comboBox);
    }

    public Map<FilePropertyKey, String> getSearchData() {
        EnumMap<FilePropertyKey, String> searchData = new EnumMap<FilePropertyKey, String>(FilePropertyKey.class);
        for (Map.Entry<FilePropertyKey, JComponent> entry : this.componentMap.entrySet()) {
            String value = this.getData(entry.getValue());
            if (value == null || value.trim().equals("")) continue;
            searchData.put(entry.getKey(), value);
        }
        if (searchData.size() > 0) {
            return searchData;
        }
        return null;
    }

    public SearchCategory getSearchCategory() {
        return this.category;
    }

    private String getData(JComponent component) {
        if (component instanceof JTextField) {
            return ((JTextField)component).getText();
        }
        if (component instanceof JComboBox) {
            return ((JComboBox)component).getSelectedItem().toString();
        }
        throw new IllegalStateException("invalid component: " + component);
    }

    private static class Resources {
        @Resource(key="AdvancedPanel.font")
        public Font font;

        public Resources() {
            GuiUtils.assignResources(this);
        }
    }
}

