/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito;

import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Contact;

public class EntityKey {
    private final Contact node;
    private final KUID primaryKey;
    private final KUID secondaryKey;
    private final DHTValueType valueType;
    private final int hashCode;

    public static EntityKey createEntityKey(KUID primaryKey, DHTValueType valueType) {
        if (primaryKey == null) {
            throw new NullPointerException("PrimaryKey is null");
        }
        if (valueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        return new EntityKey(null, primaryKey, null, valueType);
    }

    public static EntityKey createEntityKey(Contact node, KUID primaryKey, KUID secondaryKey, DHTValueType valueType) {
        if (node == null) {
            throw new NullPointerException("Contact is null");
        }
        if (primaryKey == null) {
            throw new NullPointerException("PrimaryKey is null");
        }
        if (secondaryKey == null) {
            throw new NullPointerException("SecondaryKey is null");
        }
        if (valueType == null) {
            throw new NullPointerException("DHTValueType is null");
        }
        return new EntityKey(node, primaryKey, secondaryKey, valueType);
    }

    private EntityKey(Contact node, KUID primaryKey, KUID secondaryKey, DHTValueType valueType) {
        this.node = node;
        this.primaryKey = primaryKey;
        this.secondaryKey = secondaryKey;
        this.valueType = valueType;
        int hashCode = primaryKey.hashCode() ^ valueType.hashCode();
        if (secondaryKey != null) {
            hashCode ^= secondaryKey.hashCode();
        }
        this.hashCode = hashCode;
    }

    public boolean isLookupKey() {
        return this.secondaryKey == null;
    }

    public Contact getContact() {
        return this.node;
    }

    public KUID getPrimaryKey() {
        return this.primaryKey;
    }

    public KUID getSecondaryKey() {
        return this.secondaryKey;
    }

    public DHTValueType getDHTValueType() {
        return this.valueType;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityKey)) {
            return false;
        }
        EntityKey other = (EntityKey)o;
        if (this.isLookupKey() != other.isLookupKey()) {
            return false;
        }
        if (this.isLookupKey()) {
            return this.primaryKey.equals(other.primaryKey) && this.valueType.equals(other.valueType);
        }
        return this.primaryKey.equals(other.primaryKey) && this.secondaryKey.equals(other.secondaryKey) && this.valueType.equals(other.valueType);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Contact: ").append(this.getContact()).append("\n");
        buffer.append("PrimaryKey: ").append(this.getPrimaryKey()).append("\n");
        buffer.append("SecondaryKey: ").append(this.getSecondaryKey()).append("\n");
        buffer.append("DHTValueType: ").append(this.getDHTValueType()).append("\n");
        buffer.append("IsLookupKey: ").append(this.isLookupKey()).append("\n");
        return buffer.toString();
    }
}

