/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search.browse;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.limewire.core.api.library.RemoteLibrary;
import org.limewire.core.api.library.RemoteLibraryEvent;
import org.limewire.core.api.library.RemoteLibraryManager;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.search.browse.BrowseStatus;
import org.limewire.core.api.search.browse.BrowseStatusListener;
import org.limewire.core.impl.search.browse.AbstractBrowseSearch;
import org.limewire.friend.api.Friend;
import org.limewire.listener.EventListener;

class AllFriendsBrowseSearch
extends AbstractBrowseSearch {
    private final RemoteLibraryManager remoteLibraryManager;
    private final ExecutorService backgroundExecutor;
    private final AllFriendsListEventListener listEventListener = new AllFriendsListEventListener();

    public AllFriendsBrowseSearch(RemoteLibraryManager remoteLibraryManager, ExecutorService backgroundExecutor) {
        this.remoteLibraryManager = remoteLibraryManager;
        this.backgroundExecutor = backgroundExecutor;
    }

    @Override
    public void start() {
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                for (SearchListener listener : AllFriendsBrowseSearch.this.searchListeners) {
                    listener.searchStarted(AllFriendsBrowseSearch.this);
                }
                AllFriendsBrowseSearch.this.installListener();
                AllFriendsBrowseSearch.this.loadSnapshot();
            }
        });
    }

    @Override
    public void stop() {
        for (SearchListener listener : this.searchListeners) {
            listener.searchStopped(this);
        }
        this.removeListener();
    }

    private void loadSnapshot() {
        RemoteLibrary allFriendsLibrary = this.remoteLibraryManager.getAllFriendsLibrary();
        ArrayList<SearchResult> remoteFileItems = new ArrayList<SearchResult>(allFriendsLibrary.size());
        for (SearchResult searchResult : allFriendsLibrary) {
            remoteFileItems.add(searchResult);
        }
        for (SearchListener listener : this.searchListeners) {
            listener.handleSearchResults(this, remoteFileItems);
        }
        for (SearchListener listener : this.searchListeners) {
            listener.searchStopped(this);
        }
        BrowseStatus status = remoteFileItems.size() > 0 ? new BrowseStatus(this, BrowseStatus.BrowseState.LOADED, new Friend[0]) : new BrowseStatus(this, BrowseStatus.BrowseState.NO_FRIENDS_SHARING, new Friend[0]);
        for (BrowseStatusListener listener : this.browseStatusListeners) {
            listener.statusChanged(status);
        }
    }

    private void installListener() {
        this.remoteLibraryManager.getAllFriendsLibrary().addListener(this.listEventListener);
    }

    private void removeListener() {
        this.remoteLibraryManager.getAllFriendsLibrary().removeListener(this.listEventListener);
    }

    @Override
    public void repeat() {
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AllFriendsBrowseSearch.this.loadSnapshot();
            }
        });
    }

    private class AllFriendsListEventListener
    implements EventListener<RemoteLibraryEvent> {
        private AllFriendsListEventListener() {
        }

        @Override
        public void handleEvent(RemoteLibraryEvent event) {
            if (event.getType() != RemoteLibraryEvent.Type.STATE_CHANGED) {
                BrowseStatus status = new BrowseStatus(AllFriendsBrowseSearch.this, BrowseStatus.BrowseState.UPDATED, new Friend[0]);
                for (BrowseStatusListener listener : AllFriendsBrowseSearch.this.browseStatusListeners) {
                    listener.statusChanged(status);
                }
            }
        }
    }
}

