/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.UnmodifiableIterator;

public class Buffer<E>
implements Cloneable,
Iterable<E> {
    private final int size;
    protected E[] buf;
    private int head;
    private int tail;

    public Buffer(int size) {
        assert (size >= 1);
        this.size = size + 1;
        this.head = 0;
        this.tail = 0;
    }

    public Buffer(Buffer<? extends E> other) {
        this.size = other.size;
        this.head = other.head;
        this.tail = other.tail;
        if (other.buf != null) {
            this.buf = this.createArray(other.buf.length);
            System.arraycopy(other.buf, 0, this.buf, 0, other.buf.length);
        }
    }

    protected E[] createArray(int size) {
        return new Object[size];
    }

    protected void initialize() {
        if (this.buf == null) {
            this.buf = this.createArray(this.size + 1);
        }
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public boolean isFull() {
        return this.increment(this.tail) == this.head;
    }

    public final int size() {
        return this.getSize();
    }

    public int getSize() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.size - this.head + this.tail;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    private int decrement(int i) {
        if (i == 0) {
            return this.size - 1;
        }
        return i - 1;
    }

    private int increment(int i) {
        if (i == this.size - 1) {
            return 0;
        }
        return i + 1;
    }

    private int index(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.getSize()) {
            throw new IndexOutOfBoundsException("index: " + i);
        }
        return (i + this.head) % this.size;
    }

    public E get(int i) throws IndexOutOfBoundsException {
        this.initialize();
        return this.buf[this.index(i)];
    }

    public void set(int i, E o) throws IndexOutOfBoundsException {
        this.initialize();
        this.buf[this.index((int)i)] = o;
    }

    public E add(E x) {
        return this.addFirst(x);
    }

    public E addFirst(E x) {
        this.initialize();
        E ret = null;
        if (this.isFull()) {
            ret = this.removeLast();
        }
        this.head = this.decrement(this.head);
        this.buf[this.head] = x;
        return ret;
    }

    public E addLast(E x) {
        this.initialize();
        E ret = null;
        if (this.isFull()) {
            ret = this.removeFirst();
        }
        this.buf[this.tail] = x;
        this.tail = this.increment(this.tail);
        return ret;
    }

    public boolean contains(Object x) {
        for (E e : this) {
            if (!e.equals(x)) continue;
            return true;
        }
        return false;
    }

    public E first() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.head];
    }

    public E last() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.decrement(this.tail)];
    }

    public E removeFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        E ret = this.buf[this.head];
        this.buf[this.head] = null;
        this.head = this.increment(this.head);
        return ret;
    }

    public E removeLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tail = this.decrement(this.tail);
        E ret = this.buf[this.tail];
        this.buf[this.tail] = null;
        return ret;
    }

    public E remove(int i) throws IndexOutOfBoundsException {
        E ret = this.get(i);
        int j = this.index(i);
        while (j != this.tail) {
            this.buf[j] = this.buf[this.increment(j)];
            j = this.increment(j);
        }
        this.tail = this.decrement(this.tail);
        this.buf[this.tail] = null;
        return ret;
    }

    public boolean remove(Object x) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!x.equals(this.get(i))) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeAll(Object x) {
        boolean ret = false;
        for (int i = 0; i < this.getSize(); ++i) {
            if (!x.equals(this.get(i))) continue;
            this.remove(i);
            --i;
            ret = true;
        }
        return ret;
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.removeFirst();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new BufferIterator();
    }

    public Buffer<E> clone() throws CloneNotSupportedException {
        return new Buffer<E>(this);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        boolean isFirst = true;
        for (E o : this) {
            if (!isFirst) {
                buf.append(", ");
            } else {
                isFirst = false;
            }
            buf.append(o.toString());
        }
        buf.append("]");
        return buf.toString();
    }

    private class BufferIterator
    extends UnmodifiableIterator<E> {
        int i;
        int oldHead;
        int oldTail;

        BufferIterator() {
            this.i = Buffer.this.head;
            this.oldHead = Buffer.this.head;
            this.oldTail = Buffer.this.tail;
        }

        @Override
        public boolean hasNext() {
            this.ensureNoModifications();
            return this.i != Buffer.this.tail;
        }

        @Override
        public E next() throws NoSuchElementException {
            this.ensureNoModifications();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object ret = Buffer.this.buf[this.i];
            this.i = Buffer.this.increment(this.i);
            return ret;
        }

        private void ensureNoModifications() {
            if (this.oldHead != Buffer.this.head || this.oldTail != Buffer.this.tail) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

