/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.vorbiscomment;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTagField;
import org.jaudiotagger.tag.vorbiscomment.util.Base64Coder;

public class VorbisCommentTag
extends AbstractTag {
    private static EnumMap<TagFieldKey, VorbisCommentFieldKey> tagFieldToOggField = new EnumMap(TagFieldKey.class);
    public static final String DEFAULT_VENDOR = "jaudiotagger";

    VorbisCommentTag() {
    }

    public static VorbisCommentTag createNewTag() {
        VorbisCommentTag tag = new VorbisCommentTag();
        tag.setVendor(DEFAULT_VENDOR);
        return tag;
    }

    @Override
    public TagField createAlbumField(String content) {
        if (content == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        return new VorbisCommentTagField(this.getAlbumId(), content);
    }

    @Override
    public TagField createArtistField(String content) {
        if (content == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        return new VorbisCommentTagField(this.getArtistId(), content);
    }

    @Override
    public TagField createCommentField(String content) {
        if (content == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        return new VorbisCommentTagField(this.getCommentId(), content);
    }

    @Override
    public TagField createGenreField(String content) {
        if (content == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        return new VorbisCommentTagField(this.getGenreId(), content);
    }

    @Override
    public TagField createTitleField(String content) {
        if (content == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        return new VorbisCommentTagField(this.getTitleId(), content);
    }

    @Override
    public TagField createTrackField(String content) {
        if (content == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        return new VorbisCommentTagField(this.getTrackId(), content);
    }

    @Override
    public TagField createYearField(String content) {
        if (content == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        return new VorbisCommentTagField(this.getYearId(), content);
    }

    @Override
    protected String getAlbumId() {
        return VorbisCommentFieldKey.ALBUM.name();
    }

    @Override
    protected String getArtistId() {
        return VorbisCommentFieldKey.ARTIST.name();
    }

    @Override
    protected String getCommentId() {
        return VorbisCommentFieldKey.COMMENT.name();
    }

    @Override
    protected String getGenreId() {
        return VorbisCommentFieldKey.GENRE.name();
    }

    @Override
    protected String getTitleId() {
        return VorbisCommentFieldKey.TITLE.name();
    }

    @Override
    protected String getTrackId() {
        return VorbisCommentFieldKey.TRACKNUMBER.name();
    }

    public String getVendor() {
        return this.getFirst(VorbisCommentFieldKey.VENDOR.name());
    }

    @Override
    protected String getYearId() {
        return VorbisCommentFieldKey.DATE.toString();
    }

    public void setVendor(String vendor) {
        if (vendor == null) {
            vendor = DEFAULT_VENDOR;
        }
        super.set(new VorbisCommentTagField(VorbisCommentFieldKey.VENDOR.name(), vendor));
    }

    @Override
    protected boolean isAllowedEncoding(String enc) {
        return enc.equals("UTF-8");
    }

    @Override
    public String toString() {
        return "OGG " + super.toString();
    }

    @Override
    public TagField createTagField(TagFieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return this.createTagField(tagFieldToOggField.get((Object)genericKey), value);
    }

    public TagField createTagField(VorbisCommentFieldKey vorbisCommentFieldKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (vorbisCommentFieldKey == null) {
            throw new KeyNotFoundException();
        }
        return new VorbisCommentTagField(vorbisCommentFieldKey.name(), value);
    }

    public TagField createTagField(String vorbisCommentFieldKey, String value) {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        return new VorbisCommentTagField(vorbisCommentFieldKey, value);
    }

    @Override
    public List<TagField> get(TagFieldKey genericKey) throws KeyNotFoundException {
        VorbisCommentFieldKey vorbisCommentFieldKey = tagFieldToOggField.get((Object)genericKey);
        if (vorbisCommentFieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.get(vorbisCommentFieldKey.name());
    }

    public List<TagField> get(VorbisCommentFieldKey vorbisCommentKey) throws KeyNotFoundException {
        if (vorbisCommentKey == null) {
            throw new KeyNotFoundException();
        }
        return super.get(vorbisCommentKey.name());
    }

    @Override
    public String getFirst(TagFieldKey genericKey) throws KeyNotFoundException {
        VorbisCommentFieldKey vorbisCommentFieldKey = tagFieldToOggField.get((Object)genericKey);
        if (vorbisCommentFieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(vorbisCommentFieldKey.name());
    }

    public String getFirst(VorbisCommentFieldKey vorbisCommentKey) throws KeyNotFoundException {
        if (vorbisCommentKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(vorbisCommentKey.name());
    }

    @Override
    public void deleteTagField(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        VorbisCommentFieldKey vorbisCommentFieldKey = tagFieldToOggField.get((Object)genericKey);
        this.deleteTagField(vorbisCommentFieldKey);
    }

    public void deleteTagField(VorbisCommentFieldKey vorbisCommentFieldKey) throws KeyNotFoundException {
        if (vorbisCommentFieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(vorbisCommentFieldKey.name());
    }

    public void setArtworkField(byte[] data, String mimeType) {
        char[] testdata = Base64Coder.encode(data);
        String base64image = new String(testdata);
        VorbisCommentTagField dataField = new VorbisCommentTagField(VorbisCommentFieldKey.COVERART.name(), base64image);
        VorbisCommentTagField mimeField = new VorbisCommentTagField(VorbisCommentFieldKey.COVERARTMIME.name(), mimeType);
        this.set(dataField);
        this.set(mimeField);
    }

    public byte[] getArtworkBinaryData() {
        String base64data = this.getFirst(VorbisCommentFieldKey.COVERART);
        byte[] rawdata = Base64Coder.decode(base64data.toCharArray());
        return rawdata;
    }

    public String getArtworkMimeType() {
        return this.getFirst(VorbisCommentFieldKey.COVERARTMIME);
    }

    @Override
    public boolean isEmpty() {
        return this.fields.size() <= 1;
    }

    @Override
    public void add(TagField field) {
        if (field.getId().equals(VorbisCommentFieldKey.VENDOR.name())) {
            super.set(field);
        } else {
            super.add(field);
        }
    }

    @Override
    public TagField getFirstField(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return this.getFirstField(tagFieldToOggField.get((Object)genericKey).name());
    }

    @Override
    public List<Artwork> getArtworkList() {
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(1);
        if (this.getArtworkBinaryData() != null & this.getArtworkBinaryData().length > 0) {
            Artwork artwork = new Artwork();
            artwork.setMimeType(this.getArtworkMimeType());
            artwork.setBinaryData(this.getArtworkBinaryData());
            artworkList.add(artwork);
        }
        return artworkList;
    }

    @Override
    public TagField createArtworkField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException("Please use createAndSetArtworkField instead");
    }

    @Override
    public void createAndSetArtworkField(Artwork artwork) throws FieldDataInvalidException {
        char[] testdata = Base64Coder.encode(artwork.getBinaryData());
        String base64image = new String(testdata);
        TagField imageTagField = this.createTagField(VorbisCommentFieldKey.COVERART, base64image);
        TagField imageTypeField = this.createTagField(VorbisCommentFieldKey.COVERARTMIME, artwork.getMimeType());
        this.set(imageTagField);
        this.set(imageTypeField);
    }

    static {
        tagFieldToOggField.put(TagFieldKey.ARTIST, VorbisCommentFieldKey.ARTIST);
        tagFieldToOggField.put(TagFieldKey.ALBUM, VorbisCommentFieldKey.ALBUM);
        tagFieldToOggField.put(TagFieldKey.TITLE, VorbisCommentFieldKey.TITLE);
        tagFieldToOggField.put(TagFieldKey.TRACK, VorbisCommentFieldKey.TRACKNUMBER);
        tagFieldToOggField.put(TagFieldKey.YEAR, VorbisCommentFieldKey.DATE);
        tagFieldToOggField.put(TagFieldKey.GENRE, VorbisCommentFieldKey.GENRE);
        tagFieldToOggField.put(TagFieldKey.COMMENT, VorbisCommentFieldKey.COMMENT);
        tagFieldToOggField.put(TagFieldKey.ALBUM_ARTIST, VorbisCommentFieldKey.ALBUMARTIST);
        tagFieldToOggField.put(TagFieldKey.COMPOSER, VorbisCommentFieldKey.COMPOSER);
        tagFieldToOggField.put(TagFieldKey.GROUPING, VorbisCommentFieldKey.GROUPING);
        tagFieldToOggField.put(TagFieldKey.DISC_NO, VorbisCommentFieldKey.DISCNUMBER);
        tagFieldToOggField.put(TagFieldKey.BPM, VorbisCommentFieldKey.BPM);
        tagFieldToOggField.put(TagFieldKey.MUSICBRAINZ_ARTISTID, VorbisCommentFieldKey.MUSICBRAINZ_ARTISTID);
        tagFieldToOggField.put(TagFieldKey.MUSICBRAINZ_RELEASEID, VorbisCommentFieldKey.MUSICBRAINZ_ALBUMID);
        tagFieldToOggField.put(TagFieldKey.MUSICBRAINZ_RELEASEARTISTID, VorbisCommentFieldKey.MUSICBRAINZ_ALBUMARTISTID);
        tagFieldToOggField.put(TagFieldKey.MUSICBRAINZ_TRACK_ID, VorbisCommentFieldKey.MUSICBRAINZ_TRACKID);
        tagFieldToOggField.put(TagFieldKey.MUSICBRAINZ_DISC_ID, VorbisCommentFieldKey.MUSICBRAINZ_DISCID);
        tagFieldToOggField.put(TagFieldKey.MUSICIP_ID, VorbisCommentFieldKey.MUSICIP_PUID);
        tagFieldToOggField.put(TagFieldKey.AMAZON_ID, VorbisCommentFieldKey.ASIN);
        tagFieldToOggField.put(TagFieldKey.MUSICBRAINZ_RELEASE_STATUS, VorbisCommentFieldKey.MUSICBRAINZ_ALBUMSTATUS);
        tagFieldToOggField.put(TagFieldKey.MUSICBRAINZ_RELEASE_TYPE, VorbisCommentFieldKey.MUSICBRAINZ_ALBUMTYPE);
        tagFieldToOggField.put(TagFieldKey.MUSICBRAINZ_RELEASE_COUNTRY, VorbisCommentFieldKey.RELEASECOUNTRY);
        tagFieldToOggField.put(TagFieldKey.LYRICS, VorbisCommentFieldKey.LYRICS);
        tagFieldToOggField.put(TagFieldKey.IS_COMPILATION, VorbisCommentFieldKey.COMPILATION);
        tagFieldToOggField.put(TagFieldKey.ARTIST_SORT, VorbisCommentFieldKey.ARTISTSORT);
        tagFieldToOggField.put(TagFieldKey.ALBUM_ARTIST_SORT, VorbisCommentFieldKey.ALBUMARTISTSORT);
        tagFieldToOggField.put(TagFieldKey.ALBUM_SORT, VorbisCommentFieldKey.ALBUMSORT);
        tagFieldToOggField.put(TagFieldKey.TITLE_SORT, VorbisCommentFieldKey.TITLESORT);
        tagFieldToOggField.put(TagFieldKey.COMPOSER_SORT, VorbisCommentFieldKey.COMPOSERSORT);
        tagFieldToOggField.put(TagFieldKey.ENCODER, VorbisCommentFieldKey.VENDOR);
        tagFieldToOggField.put(TagFieldKey.ISRC, VorbisCommentFieldKey.ISRC);
        tagFieldToOggField.put(TagFieldKey.BARCODE, VorbisCommentFieldKey.BARCODE);
        tagFieldToOggField.put(TagFieldKey.CATALOG_NO, VorbisCommentFieldKey.CATALOGNUMBER);
        tagFieldToOggField.put(TagFieldKey.RECORD_LABEL, VorbisCommentFieldKey.LABEL);
        tagFieldToOggField.put(TagFieldKey.LYRICIST, VorbisCommentFieldKey.LYRICIST);
        tagFieldToOggField.put(TagFieldKey.CONDUCTOR, VorbisCommentFieldKey.CONDUCTOR);
        tagFieldToOggField.put(TagFieldKey.REMIXER, VorbisCommentFieldKey.REMIXER);
        tagFieldToOggField.put(TagFieldKey.MOOD, VorbisCommentFieldKey.MOOD);
        tagFieldToOggField.put(TagFieldKey.MEDIA, VorbisCommentFieldKey.MEDIA);
        tagFieldToOggField.put(TagFieldKey.URL_DISCOGS_ARTIST_SITE, VorbisCommentFieldKey.URL_DISCOGS_ARTIST_SITE);
        tagFieldToOggField.put(TagFieldKey.URL_DISCOGS_RELEASE_SITE, VorbisCommentFieldKey.URL_DISCOGS_RELEASE_SITE);
        tagFieldToOggField.put(TagFieldKey.URL_OFFICIAL_ARTIST_SITE, VorbisCommentFieldKey.URL_OFFICIAL_ARTIST_SITE);
        tagFieldToOggField.put(TagFieldKey.URL_OFFICIAL_RELEASE_SITE, VorbisCommentFieldKey.URL_OFFICIAL_RELEASE_SITE);
        tagFieldToOggField.put(TagFieldKey.URL_WIKIPEDIA_ARTIST_SITE, VorbisCommentFieldKey.URL_WIKIPEDIA_ARTIST_SITE);
        tagFieldToOggField.put(TagFieldKey.URL_WIKIPEDIA_RELEASE_SITE, VorbisCommentFieldKey.URL_WIKIPEDIA_RELEASE_SITE);
        tagFieldToOggField.put(TagFieldKey.LANGUAGE, VorbisCommentFieldKey.LANGUAGE);
        tagFieldToOggField.put(TagFieldKey.KEY, VorbisCommentFieldKey.KEY);
    }
}

