/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.rtp.RTPDataStream;
import net.sf.fmj.media.rtp.RTPHeader;

public class RTPVideoDataStream
extends RTPDataStream
implements PushBufferStream {
    private double durationMultiplier;

    public RTPVideoDataStream(long ssrc, Format format) {
        super(ssrc, format);
        this.clockRate = 90000.0;
        this.durationMultiplier = 1000.0 / this.clockRate;
    }

    protected void addPacket(RTPHeader header, byte[] data, int offset, int length) {
        this.packetSize = length;
        int sequence = header.getSequence();
        long timestamp = header.getTimestamp();
        this.calculateJitter(timestamp);
        Buffer buffer = new Buffer();
        buffer.setHeader(header);
        buffer.setData(data);
        buffer.setOffset(offset);
        buffer.setLength(length);
        buffer.setTimeStamp(timestamp);
        buffer.setSequenceNumber(sequence);
        buffer.setDuration(Math.round((double)length * this.durationMultiplier * 1000000.0));
        int flags = 4352;
        if (header.getMarker() == 1) {
            flags |= 0x800;
        }
        buffer.setFlags(flags);
        if (null != this.handler) {
            try {
                this.itsRTPBuffer.addWait(buffer);
                this.handler.transferData(this);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    public void read(Buffer buffer) {
        try {
            Buffer data = this.itsRTPBuffer.removeWait();
            if (data != null && buffer != null) {
                buffer.setData(data.getData());
                buffer.setOffset(data.getOffset());
                buffer.setLength(data.getLength());
                buffer.setTimeStamp(data.getTimeStamp());
                buffer.setSequenceNumber(data.getSequenceNumber());
                buffer.setFlags(data.getFlags());
                buffer.setFormat(this.format);
                long currentTimestamp = System.nanoTime();
                if (-1L == this.lastTimestamp) {
                    this.lastTimestamp = currentTimestamp;
                }
                this.bytesProcessed += data.getLength();
                if (currentTimestamp - this.lastTimestamp > 1000000000L) {
                    this.bitsPerSecond = this.bytesProcessed << 3;
                    this.bytesProcessed = 0;
                    this.lastTimestamp = currentTimestamp;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

