/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.Track;
import net.sf.fmj.filtergraph.InputPin;
import net.sf.fmj.filtergraph.Link;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.filtergraph.OutputPin;

public class DemuxNode
extends Node {
    private final Format inputFormat;
    private final Demultiplexer demux;
    private Track[] tracks;
    public long sequenceNumber = 0L;

    public DemuxNode(Format format, Demultiplexer demux, Track[] tracks) {
        super(demux, 0, tracks.length);
        for (int i = 0; i < tracks.length; ++i) {
            this.setOutputPin(i, new OutputPin(this, i, i));
        }
        this.inputFormat = format;
        this.demux = demux;
        this.setTracks(tracks);
    }

    public int getPlugInType() {
        return 1;
    }

    Format setPlugInInputFormat(InputPin pin, Format format) {
        throw new UnsupportedOperationException();
    }

    Format setPlugInOutputFormat(OutputPin pin, Format format) {
        throw new UnsupportedOperationException();
    }

    public Node duplicate() {
        return this.propagateDuplicate(new DemuxNode(this.getInputFormat(), this.getDemux(), this.getTracks()));
    }

    public void setTracks(Track[] tracks) {
        this.tracks = tracks;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public Format getInputFormat() {
        return this.inputFormat;
    }

    public Demultiplexer getDemux() {
        return this.demux;
    }

    public void start() throws IOException {
        this.getDemux().start();
    }

    public void stop() {
        this.getDemux().stop();
    }

    public int process(Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        for (int i = 0; i < this.getTracks().length; ++i) {
            Link destLink;
            if (sourceTrackNumber >= 0 && i != sourceTrackNumber || (destLink = this.getDestLink(i)) == null || (flags & 1) != 0) continue;
            if (this.getOutputBuffer(i) == null) {
                this.setOutputBuffer(i, new Buffer());
            }
            Buffer buffer1 = this.getOutputBuffer(i);
            buffer1.setLength(0);
            buffer1.setSequenceNumber(this.sequenceNumber++);
            buffer1.setFlags(0);
            this.getTracks()[i].readFrame(buffer1);
            if (buffer1.getFormat() != null) continue;
            buffer1.setFormat(this.getTracks()[i].getFormat());
        }
        return 0;
    }
}

