/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.writer;

import com.limegroup.gnutella.metadata.MetaWriter;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.limewire.util.FileUtils;

public class AudioDataEditor
implements MetaWriter {
    protected Tag updateTag(Tag tag, AudioMetaData audioData) throws FieldDataInvalidException {
        tag.setAlbum(audioData.getAlbum());
        tag.setArtist(audioData.getArtist());
        tag.setComment(audioData.getComment());
        tag.setGenre(audioData.getGenre());
        tag.setTitle(audioData.getTitle());
        tag.setYear(audioData.getYear());
        tag.setTrack(audioData.getTrack());
        return tag;
    }

    protected boolean isValidFileType(String fileName) {
        String fileExtension = FileUtils.getFileExtension(fileName).toLowerCase(Locale.US);
        for (String extension : this.getSupportedExtensions()) {
            if (!fileExtension.equals(extension)) continue;
            return true;
        }
        return false;
    }

    protected Tag createTag(AudioFile audioFile, AudioMetaData audioData) {
        return audioFile.getTagOrCreateAndSetDefault();
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"fla", "flac", "m4a", "m4p", "ogg"};
    }

    @Override
    public LimeXMLReplyCollection.MetaDataState commitMetaData(String fileName, AudioMetaData audioData) {
        if (!this.isValidFileType(fileName)) {
            return LimeXMLReplyCollection.MetaDataState.INCORRECT_FILETYPE;
        }
        File f = new File(fileName);
        FileUtils.setWriteable(f);
        try {
            AudioFile audioFile = AudioFileIO.read(f);
            Tag audioTag = this.createTag(audioFile, audioData);
            audioTag = this.updateTag(audioTag, audioData);
            audioFile.setTag(audioTag);
            audioFile.commit();
        }
        catch (CannotReadException e) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        catch (IOException e) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        catch (TagException e) {
            return LimeXMLReplyCollection.MetaDataState.FAILED_ALBUM;
        }
        catch (ReadOnlyFileException e) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        catch (InvalidAudioFrameException e) {
            return LimeXMLReplyCollection.MetaDataState.FAILED_ALBUM;
        }
        catch (CannotWriteException e) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        return LimeXMLReplyCollection.MetaDataState.NORMAL;
    }
}

