/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.GGEP;

public class HUGEExtension {
    private GGEP _ggep = null;
    private Set<URN> _urns = null;
    private Set<URN.Type> _urnTypes = null;
    private Set<String> _miscBlocks = null;
    private List<GGEPBlock> _ggepBlocks = null;

    public GGEP getGGEP() {
        return this._ggep;
    }

    public List<GGEPBlock> getGGEPBlocks() {
        if (this._ggepBlocks == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._ggepBlocks);
    }

    public Set<URN> getURNS() {
        if (this._urns == null) {
            return Collections.emptySet();
        }
        return this._urns;
    }

    public Set<URN.Type> getURNTypes() {
        if (this._urnTypes == null) {
            return Collections.emptySet();
        }
        return this._urnTypes;
    }

    public Set<String> getMiscBlocks() {
        if (this._miscBlocks == null) {
            return Collections.emptySet();
        }
        return this._miscBlocks;
    }

    public HUGEExtension(byte[] extsBytes) {
        int currIndex = 0;
        while (currIndex < extsBytes.length && extsBytes[currIndex] != 0) {
            int delimIndex;
            if (extsBytes[currIndex] == -61) {
                int start = currIndex;
                int[] endIndex = new int[]{currIndex + 1};
                try {
                    GGEP ggep = new GGEP(extsBytes, currIndex, endIndex);
                    if (this._ggep == null) {
                        this._ggep = new GGEP();
                    }
                    this._ggep.merge(ggep);
                    if (this._ggepBlocks == null) {
                        this._ggepBlocks = new ArrayList<GGEPBlock>(2);
                    }
                    this._ggepBlocks.add(new GGEPBlock(ggep, start, endIndex[0]));
                }
                catch (BadGGEPBlockException ignored) {
                    // empty catch block
                }
                currIndex = endIndex[0];
                continue;
            }
            for (delimIndex = currIndex; delimIndex < extsBytes.length && extsBytes[delimIndex] != 28; ++delimIndex) {
            }
            if (delimIndex <= extsBytes.length) {
                try {
                    String curExtStr = new String(extsBytes, currIndex, delimIndex - currIndex, "UTF-8");
                    if (URN.isUrn(curExtStr)) {
                        URN urn = URN.createSHA1Urn(curExtStr);
                        if (this._urns == null) {
                            this._urns = new UrnSet();
                        }
                        this._urns.add(urn);
                    } else if (URN.Type.isSupportedUrnType(curExtStr)) {
                        if (this._urnTypes == null) {
                            this._urnTypes = EnumSet.noneOf(URN.Type.class);
                        }
                        this._urnTypes.add(URN.Type.createUrnType(curExtStr));
                    } else {
                        if (this._miscBlocks == null) {
                            this._miscBlocks = new HashSet<String>(1);
                        }
                        this._miscBlocks.add(curExtStr);
                    }
                }
                catch (IOException bad) {
                    // empty catch block
                }
            }
            currIndex = delimIndex + 1;
        }
    }

    public static class GGEPBlock {
        private int start;
        private int end;
        private GGEP ggep;

        public GGEPBlock(GGEP ggep, int start, int end) {
            this.ggep = ggep;
            this.start = start;
            this.end = end;
        }

        public GGEP getGGEP() {
            return this.ggep;
        }

        public int getStartPos() {
            return this.start;
        }

        public int getEndPos() {
            return this.end;
        }
    }
}

