/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.malware;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AbstractCoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.malware.VirusDefinitionDownloadMemento;
import com.limegroup.gnutella.malware.VirusDefinitionDownloader;
import com.limegroup.gnutella.malware.VirusDefinitionHandler;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadPiecesInfo;
import org.limewire.core.api.download.SaveLocationManager;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.malware.AntivirusUpdateType;
import org.limewire.core.api.transfer.SourceInfo;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.http.httpclient.HttpClientInstanceUtils;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.io.IOUtils;
import org.limewire.io.InvalidDataException;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.FileUtils;

class VirusDefinitionDownloaderImpl
extends AbstractCoreDownloader
implements VirusDefinitionDownloader {
    private static final Log LOG = LogFactory.getLog(VirusDefinitionDownloaderImpl.class);
    private static final int TIMEOUT = 5000;
    private static final String AVG_LW_USER_AGENT = "AVGINETSDK-LIMEWIRE";
    private final DownloadManager downloadManager;
    private final HttpExecutor httpExecutor;
    private final EventListenerList<DownloadStateEvent> eventListenerList;
    private final BandwidthTrackerImpl bandwidthTracker;
    private final Provider<HttpParams> defaultParams;
    private final HttpClientInstanceUtils httpClientInstanceUtils;
    private volatile URI uri = null;
    private volatile File incompleteFile = null;
    private volatile VirusDefinitionHandler handler = null;
    private volatile Downloader.DownloadState state = Downloader.DownloadState.QUEUED;
    private final AtomicReference<AbortableHttpRequest> activeRequest = new AtomicReference();
    private volatile long contentLength = 0L;
    private volatile long amountRead = 0L;
    private volatile long amountWritten = 0L;
    private volatile boolean aborted = false;
    private File mementoFile;
    private File mementoBackupFile;

    @Inject
    public VirusDefinitionDownloaderImpl(SaveLocationManager saveLocationManager, CategoryManager categoryManager, DownloadManager downloadManager, HttpExecutor httpExecutor, @Named(value="defaults") Provider<HttpParams> defaultParams, HttpClientInstanceUtils httpClientInstanceUtils) {
        super(saveLocationManager, categoryManager);
        this.downloadManager = downloadManager;
        this.httpExecutor = httpExecutor;
        this.eventListenerList = new EventListenerList();
        this.bandwidthTracker = new BandwidthTrackerImpl();
        this.defaultParams = defaultParams;
        this.httpClientInstanceUtils = httpClientInstanceUtils;
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento memento) throws InvalidDataException {
        super.initFromMemento(memento);
        VirusDefinitionDownloadMemento vm = (VirusDefinitionDownloadMemento)memento;
        this.amountWritten = vm.getAmountWritten();
        this.uri = vm.getUri();
        this.incompleteFile = vm.getIncompleteFile();
        DownloadSettings.NUM_AV_MEMENTOS_RESUMED.set(DownloadSettings.NUM_AV_MEMENTOS_RESUMED.get() + 1);
    }

    URI getUri() {
        return this.uri;
    }

    long getAmountWritten() {
        return this.amountWritten;
    }

    File getIncompleteFile() {
        return this.incompleteFile;
    }

    void setAmountWritten(long amountWritten) {
        this.amountWritten = amountWritten;
    }

    @Override
    public void setUriAndName(URI uri, String name) {
        this.uri = uri;
        this.setDefaultFileName(name);
        this.incompleteFile = new File(SharingSettings.INCOMPLETE_DIRECTORY.get(), name);
    }

    @Override
    public void fetch(VirusDefinitionHandler handler, File mementoFile, File mementoBackupFile) {
        assert (this.uri != null);
        assert (this.incompleteFile != null);
        assert (this.getDefaultFileName() != null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching " + this.uri);
        }
        this.handler = handler;
        this.mementoFile = mementoFile;
        this.mementoBackupFile = mementoBackupFile;
        this.downloadManager.addNewDownloader(this);
    }

    private void failDownload(Downloader.DownloadState failureState) {
        if (this.aborted) {
            failureState = Downloader.DownloadState.ABORTED;
        }
        if (this.state == Downloader.DownloadState.QUEUED || this.state == Downloader.DownloadState.DOWNLOADING) {
            this.state = failureState;
            if (this.handler != null) {
                this.handler.downloadFailed(this.incompleteFile);
            }
            this.deleteIncompleteFiles();
            this.eventListenerList.broadcast(new DownloadStateEvent(this, this.state));
            this.downloadManager.remove(this, true);
        }
    }

    @Override
    public void discardUnscannedPreview(boolean delete) {
    }

    @Override
    public long getAmountLost() {
        return 0L;
    }

    @Override
    public int getAmountPending() {
        return 0;
    }

    @Override
    public long getAmountRead() {
        return this.amountRead;
    }

    @Override
    public long getAmountVerified() {
        return 0L;
    }

    @Override
    public List<RemoteFileDesc> getRemoteFileDescs() {
        return Collections.emptyList();
    }

    @Override
    public int getChunkSize() {
        return 1;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public File getDownloadFragment(Downloader.ScanListener listener) {
        return null;
    }

    @Override
    public File getFile() {
        return this.getSaveFile();
    }

    @Override
    public int getNumHosts() {
        return 0;
    }

    @Override
    public List<Address> getSourcesAsAddresses() {
        return Collections.emptyList();
    }

    @Override
    public List<SourceInfo> getSourcesDetails() {
        return Collections.emptyList();
    }

    @Override
    public int getQueuePosition() {
        return 0;
    }

    @Override
    public int getQueuedHostCount() {
        return 0;
    }

    @Override
    public int getRemainingStateTime() {
        return 0;
    }

    @Override
    public URN getSha1Urn() {
        return null;
    }

    @Override
    public File getSaveFile() {
        return this.incompleteFile;
    }

    @Override
    public void setSaveFile(File saveDirectory, String fileName, boolean overwrite) throws DownloadException {
    }

    @Override
    public Downloader.DownloadState getState() {
        return this.state;
    }

    @Override
    public boolean isCompleted() {
        return this.state == Downloader.DownloadState.COMPLETE;
    }

    @Override
    public boolean isLaunchable() {
        return false;
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public boolean isRelocatable() {
        return false;
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean resume() {
        return false;
    }

    @Override
    public void stop() {
        this.aborted = true;
        AbortableHttpRequest req = this.activeRequest.getAndSet(null);
        if (req != null) {
            req.abort();
        }
        this.failDownload(Downloader.DownloadState.ABORTED);
    }

    @Override
    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    @Override
    public void measureBandwidth() {
        this.bandwidthTracker.measureBandwidth(this.amountRead);
    }

    @Override
    public void finish() {
    }

    @Override
    public GUID getQueryGUID() {
        return null;
    }

    @Override
    public void handleInactivity() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isAlive() {
        return this.state == Downloader.DownloadState.DOWNLOADING;
    }

    @Override
    public boolean isQueuable() {
        return false;
    }

    @Override
    public void setInactivePriority(int priority) {
    }

    @Override
    public boolean shouldBeRemoved() {
        return this.isCompleted() || this.state == Downloader.DownloadState.ABORTED || this.state == Downloader.DownloadState.INVALID || this.state == Downloader.DownloadState.UNABLE_TO_CONNECT;
    }

    @Override
    public boolean shouldBeRestarted() {
        return this.state == Downloader.DownloadState.QUEUED;
    }

    @Override
    public void startDownload() {
        String uriWithLWInfo = this.httpClientInstanceUtils.addClientInfoToUrl(this.uri.toString());
        HttpGet get = new HttpGet(uriWithLWInfo);
        get.addHeader("User-Agent", "AVGINETSDK-LIMEWIRE " + LimeWireUtils.getLimeWireVersion());
        get.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        if (this.amountWritten > 0L) {
            LOG.debugf("Adding Range header starting at {0}", (Object)this.amountWritten);
            get.addHeader(HTTPHeaderName.RANGE.httpStringValue(), "bytes=" + this.amountWritten + "-");
        }
        HttpParams params = this.defaultParams.get();
        HttpConnectionParams.setConnectionTimeout(params, 5000);
        HttpConnectionParams.setSoTimeout(params, 5000);
        HttpClientParams.setRedirecting(params, true);
        this.state = Downloader.DownloadState.DOWNLOADING;
        this.activeRequest.set(get);
        this.eventListenerList.broadcast(new DownloadStateEvent(this, this.state));
        this.httpExecutor.execute(get, params, new Listener());
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.ANTIVIRUS;
    }

    @Override
    public void addListener(EventListener<DownloadStateEvent> listener) {
        this.eventListenerList.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<DownloadStateEvent> listener) {
        return this.eventListenerList.removeListener(listener);
    }

    @Override
    public boolean isMementoSupported() {
        return false;
    }

    @Override
    protected DownloadMemento createMemento() {
        VirusDefinitionDownloadMemento memento = new VirusDefinitionDownloadMemento();
        memento.setUri(this.uri);
        memento.setAmountWritten(this.amountWritten);
        memento.setIncompleteFile(this.incompleteFile);
        memento.setAntivirusUpdateType(AntivirusUpdateType.FULL);
        return memento;
    }

    @Override
    protected void fillInMemento(DownloadMemento memento) {
        super.fillInMemento(memento);
        memento.setSaveFile(this.getSaveFile());
        memento.setDefaultFileName(this.getDefaultFileName());
    }

    @Override
    protected File getDefaultSaveFile() {
        return this.getSaveFile();
    }

    @Override
    public boolean conflicts(URN urn, long fileSize, File ... files) {
        return false;
    }

    @Override
    public boolean conflictsWithIncompleteFile(File incomplete) {
        return false;
    }

    @Override
    public void deleteIncompleteFiles() {
        if (this.incompleteFile != null) {
            FileUtils.forceDelete(this.incompleteFile);
        }
        if (this.mementoFile != null) {
            FileUtils.forceDelete(this.mementoFile);
        }
        if (this.mementoBackupFile != null) {
            FileUtils.forceDelete(this.mementoBackupFile);
        }
    }

    private void saveMemento() {
        if (this.mementoFile != null) {
            LOG.debugf("Writing memento to {0}", (Object)this.mementoFile);
            DownloadMemento memento = this.toMemento();
            FileUtils.writeWithBackupFile(memento, this.mementoBackupFile, this.mementoFile, LOG);
        }
    }

    @Override
    public DownloadPiecesInfo getPieceInfo() {
        return null;
    }

    private class Listener
    implements HttpClientListener {
        private Listener() {
        }

        @Override
        public boolean requestFailed(HttpUriRequest method, HttpResponse response, IOException e) {
            VirusDefinitionDownloaderImpl.this.activeRequest.set(null);
            VirusDefinitionDownloaderImpl.this.failDownload(Downloader.DownloadState.UNABLE_TO_CONNECT);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestComplete(HttpUriRequest method, HttpResponse response) {
            try {
                boolean downloadCompleted;
                block16: {
                    int status = response.getStatusLine().getStatusCode();
                    if (status < 200 || status >= 300) {
                        LOG.debugf("Bad status code: {0}", (Object)status);
                        VirusDefinitionDownloaderImpl.this.failDownload(Downloader.DownloadState.UNABLE_TO_CONNECT);
                        boolean bl = false;
                        return bl;
                    }
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        LOG.error("Invalid response: no entity");
                        VirusDefinitionDownloaderImpl.this.failDownload(Downloader.DownloadState.INVALID);
                        boolean bl = false;
                        return bl;
                    }
                    long length = entity.getContentLength();
                    VirusDefinitionDownloaderImpl.this.contentLength = length > 0L ? length : 0L;
                    VirusDefinitionDownloaderImpl.this.incompleteFile.getParentFile().mkdirs();
                    InputStream downloadStream = null;
                    RandomAccessFile outputStream = null;
                    downloadCompleted = false;
                    try {
                        long startPoint = HTTPUtils.getStartPoint(response);
                        if (startPoint > VirusDefinitionDownloaderImpl.this.amountWritten) {
                            throw new IOException("must start at or before amount written");
                        }
                        LOG.debugf("Seeking ahead to {0}, amountWritten was {1}", (Object)startPoint, (Object)VirusDefinitionDownloaderImpl.this.amountWritten);
                        outputStream = new RandomAccessFile(VirusDefinitionDownloaderImpl.this.incompleteFile, "rw");
                        outputStream.seek(startPoint);
                        VirusDefinitionDownloaderImpl.this.amountWritten = startPoint;
                        downloadStream = entity.getContent();
                        int read = 0;
                        byte[] buf = new byte[2048];
                        long lastRecord = System.currentTimeMillis();
                        while ((read = downloadStream.read(buf, 0, buf.length)) != -1) {
                            VirusDefinitionDownloaderImpl.this.amountRead += read;
                            outputStream.write(buf, 0, read);
                            VirusDefinitionDownloaderImpl.this.amountWritten += read;
                            long now = System.currentTimeMillis();
                            if (TimeUnit.MILLISECONDS.toSeconds(now - lastRecord) <= 1L) continue;
                            lastRecord = now;
                            VirusDefinitionDownloaderImpl.this.saveMemento();
                        }
                        downloadCompleted = true;
                        IOUtils.close(downloadStream);
                    }
                    catch (IOException e) {
                        LOG.debugf(e, "error downloading virus definitions from {0}", VirusDefinitionDownloaderImpl.this.uri);
                        break block16;
                    }
                    finally {
                        IOUtils.close(downloadStream);
                        IOUtils.close(outputStream);
                    }
                    IOUtils.close(outputStream);
                }
                if (downloadCompleted) {
                    VirusDefinitionDownloaderImpl.this.state = Downloader.DownloadState.APPLYING_ANTIVIRUS_DEFINITION_UPDATE;
                    VirusDefinitionDownloaderImpl.this.eventListenerList.broadcast(new DownloadStateEvent(VirusDefinitionDownloaderImpl.this, VirusDefinitionDownloaderImpl.this.state));
                    VirusDefinitionDownloaderImpl.this.handler.downloadSucceeded(VirusDefinitionDownloaderImpl.this.incompleteFile);
                    VirusDefinitionDownloaderImpl.this.state = Downloader.DownloadState.COMPLETE;
                    VirusDefinitionDownloaderImpl.this.deleteIncompleteFiles();
                    VirusDefinitionDownloaderImpl.this.eventListenerList.broadcast(new DownloadStateEvent(VirusDefinitionDownloaderImpl.this, VirusDefinitionDownloaderImpl.this.state));
                    VirusDefinitionDownloaderImpl.this.downloadManager.remove(VirusDefinitionDownloaderImpl.this, true);
                } else {
                    VirusDefinitionDownloaderImpl.this.failDownload(Downloader.DownloadState.INVALID);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                VirusDefinitionDownloaderImpl.this.httpExecutor.releaseResources(response);
                VirusDefinitionDownloaderImpl.this.activeRequest.set(null);
            }
        }

        @Override
        public boolean allowRequest(HttpUriRequest request) {
            return true;
        }
    }
}

