/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;

public class UDPPingerImpl
implements UDPPinger {
    private static final Log LOG = LogFactory.getLog(UDPPingerImpl.class);
    protected static final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("UDPHostRanker");
    public static int DEFAULT_LISTEN_EXPIRE_TIME = 20000;
    private static final long SEND_INTERVAL = 500L;
    private static final int MAX_SENDS = 15;
    private static int _sentAmount;
    private static long _lastSentTime;
    private final Provider<MessageRouter> messageRouter;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<UDPService> udpService;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public UDPPingerImpl(Provider<MessageRouter> messageRouter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<UDPService> udpService, PingRequestFactory pingRequestFactory) {
        this.messageRouter = messageRouter;
        this.backgroundExecutor = backgroundExecutor;
        this.udpService = udpService;
        this.pingRequestFactory = pingRequestFactory;
    }

    @Override
    public void rank(Collection<? extends IpPort> hosts, Cancellable canceller) {
        this.rank(hosts, null, canceller, null);
    }

    @Override
    public void rank(Collection<? extends IpPort> hosts, MessageListener listener, Cancellable canceller, Message message) {
        this.rank(hosts, listener, canceller, message, -1);
    }

    @Override
    public void rank(Collection<? extends IpPort> hosts, MessageListener listener, Cancellable canceller, Message message, int expireTime) {
        if (hosts == null) {
            throw new NullPointerException("null hosts not allowed");
        }
        if (canceller == null) {
            canceller = new Cancellable(){

                @Override
                public boolean isCancelled() {
                    return false;
                }
            };
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding hosts " + hosts + " with message: " + message + " to processing queue");
        }
        SenderBundle bundle = expireTime > 0 ? new SenderBundle(hosts, listener, canceller, message, expireTime) : new SenderBundle(hosts, listener, canceller, message, DEFAULT_LISTEN_EXPIRE_TIME);
        bundle.validateHosts();
        QUEUE.execute(bundle);
    }

    private boolean waitForListening(Cancellable canceller) {
        int waits;
        for (waits = 0; !this.udpService.get().isListening() && waits < 10 && !canceller.isCancelled(); ++waits) {
            try {
                Thread.sleep(600L);
                continue;
            }
            catch (InterruptedException e) {
                ErrorService.error(e);
            }
        }
        return waits < 10;
    }

    protected void send(Collection<? extends IpPort> hosts, final MessageListener listener, Cancellable canceller, Message message, int expireTime) {
        if (!this.waitForListening(canceller)) {
            return;
        }
        if (message == null) {
            message = this.pingRequestFactory.createUDPPing();
        }
        final byte[] messageGUID = message.getGUID();
        if (listener != null) {
            this.messageRouter.get().registerMessageListener(messageGUID, listener);
        }
        for (IpPort ipPort : hosts) {
            if (canceller.isCancelled()) break;
            this.sendSingleMessage(ipPort, message);
        }
        if (listener != null) {
            Runnable udpMessagePurger = new Runnable(){

                @Override
                public void run() {
                    ((MessageRouter)UDPPingerImpl.this.messageRouter.get()).unregisterMessageListener(messageGUID, listener);
                }
            };
            this.backgroundExecutor.schedule(udpMessagePurger, (long)expireTime, TimeUnit.MILLISECONDS);
        }
    }

    protected void sendSingleMessage(IpPort host, Message message) {
        long now = System.currentTimeMillis();
        if (now > _lastSentTime + 500L) {
            _sentAmount = 0;
        } else if (_sentAmount == 15) {
            try {
                Thread.sleep(500L);
                now = System.currentTimeMillis();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            _sentAmount = 0;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending to " + host + ": " + message.getClass() + " " + message);
        }
        this.udpService.get().send(message, host);
        ++_sentAmount;
        _lastSentTime = now;
    }

    private class SenderBundle
    implements Runnable {
        private final Collection<? extends IpPort> hosts;
        private final MessageListener listener;
        private final Cancellable canceller;
        private final Message message;
        private final int expireTime;

        public SenderBundle(Collection<? extends IpPort> hosts, MessageListener listener, Cancellable canceller, Message message, int expireTime) {
            this.hosts = hosts;
            this.listener = listener;
            this.canceller = canceller;
            this.message = message;
            this.expireTime = expireTime;
        }

        @Override
        public void run() {
            UDPPingerImpl.this.send(this.hosts, this.listener, this.canceller, this.message, this.expireTime);
        }

        void validateHosts() {
            for (IpPort ipPort : this.hosts) {
                if (NetworkUtils.isValidAddressAndPort(ipPort.getInetAddress().getAddress(), ipPort.getPort())) continue;
                throw new IllegalArgumentException("invalid host: " + ipPort);
            }
        }
    }
}

