/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats;

import com.google.gdata.model.Attribute;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementVisitor;
import com.google.gdata.model.QName;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import com.google.gdata.wireformats.GeneratorUtils;
import com.google.gdata.wireformats.StreamProperties;
import com.google.gdata.wireformats.WireFormatGenerator;
import com.google.gdata.wireformats.XmlWireFormatProperties;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlGenerator
implements WireFormatGenerator,
ElementVisitor {
    private static final XmlNamespace USE_ROOT_ELEMENT_NAMESPACE = new XmlNamespace("__USE_ROOT_ELEMENT_NAMESPACE__");
    protected final ElementMetadata<?, ?> rootMetadata;
    protected final XmlWriter xw;
    private final XmlNamespace defaultNamespace;
    private static final ElementGenerator DEFAULT_GENERATOR = new XmlElementGenerator();

    public XmlGenerator(StreamProperties props, Writer w, Charset cs, boolean prettyPrint) {
        this(props, w, cs, prettyPrint, USE_ROOT_ELEMENT_NAMESPACE);
    }

    public XmlGenerator(StreamProperties props, Writer w, Charset cs, boolean prettyPrint, XmlNamespace defaultNamespace) {
        EnumSet<XmlWriter.WriterFlags> flags = EnumSet.of(XmlWriter.WriterFlags.WRITE_HEADER);
        if (prettyPrint) {
            flags.add(XmlWriter.WriterFlags.PRETTY_PRINT);
        }
        try {
            this.xw = new XmlWriter(w, flags, cs.name());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create XML generator", ioe);
        }
        this.rootMetadata = props.getRootMetadata();
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public void generate(Element element) throws IOException {
        this.generate(element, this.rootMetadata);
    }

    public void generate(Element element, ElementMetadata<?, ?> metadata) throws IOException {
        if (metadata != null && !metadata.getKey().equals(element.getElementKey())) {
            throw new IllegalStateException("Element key (" + element.getElementKey() + ") does not match metadata key (" + metadata.getKey() + ")");
        }
        try {
            element.visit(this, metadata);
        }
        catch (ElementVisitor.StoppedException se) {
            Throwable cause = se.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw se;
        }
    }

    private ElementGenerator getElementGenerator(ElementMetadata<?, ?> metadata) {
        ElementGenerator elementGenerator;
        XmlWireFormatProperties xmlProperties;
        if (metadata != null && (xmlProperties = (XmlWireFormatProperties)metadata.getProperties()) != null && (elementGenerator = xmlProperties.getElementGenerator()) != null) {
            return elementGenerator;
        }
        return DEFAULT_GENERATOR;
    }

    @Override
    public boolean visit(Element parent, Element e, ElementMetadata<?, ?> metadata) throws ElementVisitor.StoppedException {
        try {
            if (parent == null) {
                this.setRootNamespace(metadata, e);
            }
            if (metadata == null || metadata.isSelected(e)) {
                ElementGenerator gen = this.getElementGenerator(metadata);
                return gen.startElement(this.xw, parent, e, metadata);
            }
        }
        catch (IOException ioe) {
            throw new ElementVisitor.StoppedException(ioe);
        }
        return false;
    }

    private void setRootNamespace(ElementMetadata<?, ?> meta, Element e) {
        XmlNamespace rootNs = this.defaultNamespace;
        if (rootNs == USE_ROOT_ELEMENT_NAMESPACE) {
            rootNs = meta != null ? meta.getDefaultNamespace() : e.getElementId().getNs();
        }
        if (rootNs != null) {
            this.xw.setDefaultNamespace(rootNs);
        }
    }

    @Override
    public void visitComplete(Element parent, Element e, ElementMetadata<?, ?> metadata) throws ElementVisitor.StoppedException {
        try {
            if (metadata == null || metadata.isSelected(e)) {
                ElementGenerator elementGenerator = this.getElementGenerator(metadata);
                elementGenerator.textContent(this.xw, e, metadata);
                elementGenerator.endElement(this.xw, e, metadata);
            }
        }
        catch (IOException ioe) {
            throw new ElementVisitor.StoppedException(ioe);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmlElementGenerator
    implements ElementGenerator {
        @Override
        public boolean startElement(XmlWriter xw, Element parent, Element e, ElementMetadata<?, ?> metadata) throws IOException {
            Collection<XmlNamespace> namespaces = this.getNamespaces(parent, e, metadata);
            List<XmlWriter.Attribute> attrs = this.getAttributes(e, metadata);
            QName name = this.getName(e, metadata);
            xw.startElement(name.getNs(), name.getLocalName(), attrs, namespaces);
            return true;
        }

        protected QName getName(Element e, ElementMetadata<?, ?> metadata) {
            return metadata == null ? e.getElementId() : metadata.getName();
        }

        protected Collection<XmlNamespace> getNamespaces(Element parent, Element e, ElementMetadata<?, ?> metadata) {
            if (parent == null) {
                return GeneratorUtils.calculateNamespaces(e, metadata).values();
            }
            return null;
        }

        protected List<XmlWriter.Attribute> getAttributes(Element e, ElementMetadata<?, ?> metadata) {
            ArrayList<XmlWriter.Attribute> attrs = null;
            Iterator<Attribute> attributeIterator = e.getAttributeIterator(metadata);
            if (attributeIterator.hasNext()) {
                ElementKey<?, ?> key = e.getElementKey();
                attrs = new ArrayList<XmlWriter.Attribute>();
                while (attributeIterator.hasNext()) {
                    Attribute attribute = attributeIterator.next();
                    AttributeKey<?> attKey = attribute.getAttributeKey();
                    AttributeMetadata<?> attMeta = metadata == null ? null : metadata.bindAttribute(attKey);
                    QName qName = attMeta != null ? attMeta.getName() : attKey.getId();
                    String alias = qName.getNs() != null ? qName.getNs().getAlias() : null;
                    attrs.add(new XmlWriter.Attribute(alias, qName.getLocalName(), attribute.getValue().toString()));
                }
            }
            return attrs;
        }

        @Override
        public void textContent(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) throws IOException {
            String valStr;
            Object value;
            Object object = value = metadata == null ? e.getTextValue() : metadata.generateValue(e, metadata);
            if (value != null && (valStr = value.toString()).length() > 0) {
                xw.characters(valStr);
            }
        }

        @Override
        public void endElement(XmlWriter xw, Element e, ElementMetadata<?, ?> metadata) throws IOException {
            QName name = this.getName(e, metadata);
            xw.endElement(name.getNs(), name.getLocalName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ElementGenerator {
        public boolean startElement(XmlWriter var1, Element var2, Element var3, ElementMetadata<?, ?> var4) throws IOException;

        public void textContent(XmlWriter var1, Element var2, ElementMetadata<?, ?> var3) throws IOException;

        public void endElement(XmlWriter var1, Element var2, ElementMetadata<?, ?> var3) throws IOException;
    }
}

