/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.sf.profiler4j.console.Console;
import net.sf.profiler4j.console.InfoPanel;
import net.sf.profiler4j.console.Project;
import net.sf.profiler4j.console.Rule;
import net.sf.profiler4j.console.RuleTableModel;
import net.sf.profiler4j.console.util.Validator;

public class ProjectDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel jPanel1 = null;
    private Validator validator = new Validator(this);
    private Console app;
    private boolean edited = false;
    private JScrollPane tableScrollPane = null;
    private JTable rulesTable = null;
    private JComboBox accessComboBox = null;
    private JPanel defaultOptionsPanel = null;
    private JLabel jLabel = null;
    private JCheckBox beanpropsCheckBox = null;
    private JPanel jPanel2 = null;
    private JToolBar toolBar = null;
    private JButton addRuleButton = null;
    private JButton removeRuleButton = null;
    private JButton moveRuleUpButton = null;
    private JButton moveRuleDownButton = null;
    RuleTableModel ruleTableModel = new RuleTableModel();
    private JPanel jPanel3 = null;
    private InfoPanel infoPanel = null;
    private JPanel jPanel4 = null;
    private JLabel jLabel1 = null;
    private JTextField hostTextField = null;
    private JTextField portTextField = null;
    private JLabel jLabel2 = null;

    public ProjectDialog(JFrame owner, Console app) {
        super(owner);
        this.app = app;
        this.initialize();
    }

    private void initialize() {
        this.setSize(712, 549);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Profiling Project Details");
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(null);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "South");
            this.jContentPane.add((Component)this.getJPanel1(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(flowLayout);
            this.jPanel.add((Component)this.getOkButton(), null);
            this.jPanel.add((Component)this.getJButton(), null);
        }
        return this.jPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ProjectDialog.this.validator.validate(true)) {
                        ProjectDialog.this.edited = true;
                        ProjectDialog.this.setVisible(false);
                    }
                }
            });
        }
        return this.okButton;
    }

    private JButton getJButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(null);
            this.jPanel1.add((Component)this.getJPanel3(), null);
        }
        return this.jPanel1;
    }

    private JScrollPane getTableScrollPane() {
        if (this.tableScrollPane == null) {
            this.tableScrollPane = new JScrollPane();
            this.tableScrollPane.setBorder(null);
            this.tableScrollPane.setViewportView(this.getRulesTable());
        }
        return this.tableScrollPane;
    }

    private JTable getRulesTable() {
        if (this.rulesTable == null) {
            this.rulesTable = new JTable();
            this.rulesTable.setModel(this.ruleTableModel);
            this.rulesTable.setRowMargin(4);
            this.rulesTable.setRowHeight(24);
            this.rulesTable.setFont(new Font("Monospaced", 0, 14));
            TableColumn c = this.rulesTable.getColumnModel().getColumn(0);
            c.setMinWidth(300);
            c = this.rulesTable.getColumnModel().getColumn(1);
            c.setMinWidth(80);
            c.setMaxWidth(80);
            JComboBox<Rule.Action> editorCb = new JComboBox<Rule.Action>();
            for (Rule.Action a : Rule.Action.values()) {
                editorCb.addItem(a);
            }
            c.setCellEditor(new DefaultCellEditor(editorCb));
            c.setCellRenderer(new DefaultTableCellRenderer(){
                Font font = new Font("Monospaced", 1, 13);

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    Rule.Action r = (Rule.Action)((Object)value);
                    this.setHorizontalAlignment(0);
                    this.setFont(this.font);
                    if (r == Rule.Action.ACCEPT) {
                        this.setBackground(Color.GREEN);
                    } else {
                        this.setBackground(Color.RED);
                    }
                    if (isSelected) {
                        this.setForeground(Color.YELLOW);
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                    return this;
                }
            });
        }
        return this.rulesTable;
    }

    private JComboBox getAccessComboBox() {
        if (this.accessComboBox == null) {
            this.accessComboBox = new JComboBox();
            this.accessComboBox.setBounds(new Rectangle(210, 32, 105, 23));
            for (Rule.AccessOption op : Rule.AccessOption.values()) {
                this.accessComboBox.addItem(op);
            }
        }
        return this.accessComboBox;
    }

    private JPanel getDefaultOptionsPanel() {
        if (this.defaultOptionsPanel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Minimum method visibility");
            this.jLabel.setBounds(new Rectangle(16, 32, 200, 17));
            this.defaultOptionsPanel = new JPanel();
            this.defaultOptionsPanel.setLayout(null);
            this.defaultOptionsPanel.setBorder(BorderFactory.createTitledBorder(null, "Rule Options (applies to all ACCEPT rules)", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.defaultOptionsPanel.setBounds(new Rectangle(16, 56, 385, 103));
            this.defaultOptionsPanel.add((Component)this.jLabel, null);
            this.defaultOptionsPanel.add((Component)this.getAccessComboBox(), null);
            this.defaultOptionsPanel.add((Component)this.getBeanpropsCheckBox(), null);
        }
        return this.defaultOptionsPanel;
    }

    private JCheckBox getBeanpropsCheckBox() {
        if (this.beanpropsCheckBox == null) {
            this.beanpropsCheckBox = new JCheckBox();
            this.beanpropsCheckBox.setText("Include getters/setters");
            this.beanpropsCheckBox.setBounds(new Rectangle(16, 64, 200, 23));
        }
        return this.beanpropsCheckBox;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new BorderLayout());
            this.jPanel2.setBounds(new Rectangle(7, 165, 691, 311));
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Method Rules (evaluated top-down)", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanel2.add((Component)this.getTableScrollPane(), "Center");
            this.jPanel2.add((Component)this.getToolBar(), "North");
        }
        return this.jPanel2;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.setFloatable(false);
            this.toolBar.add(this.getAddRuleButton());
            this.toolBar.add(this.getRemoveRuleButton());
            this.toolBar.add(this.getMoveRuleDownButton());
            this.toolBar.add(this.getMoveRuleUpButton());
        }
        return this.toolBar;
    }

    private JButton getAddRuleButton() {
        if (this.addRuleButton == null) {
            this.addRuleButton = new JButton();
            this.addRuleButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/plus.gif")));
            this.addRuleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = ProjectDialog.this.rulesTable.getSelectedRow();
                    ProjectDialog.this.ruleTableModel.insert(row, new Rule("*(*)", Rule.Action.ACCEPT));
                }
            });
        }
        return this.addRuleButton;
    }

    private JButton getRemoveRuleButton() {
        if (this.removeRuleButton == null) {
            this.removeRuleButton = new JButton();
            this.removeRuleButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/delete.gif")));
            this.removeRuleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = ProjectDialog.this.rulesTable.getSelectedRow();
                    if (row != -1) {
                        ProjectDialog.this.ruleTableModel.remove(row);
                        ProjectDialog.this.rulesTable.getSelectionModel().addSelectionInterval(row, row);
                    }
                }
            });
        }
        return this.removeRuleButton;
    }

    private JButton getMoveRuleUpButton() {
        if (this.moveRuleUpButton == null) {
            this.moveRuleUpButton = new JButton();
            this.moveRuleUpButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/up.gif")));
            this.moveRuleUpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = ProjectDialog.this.rulesTable.getSelectedRow();
                    if (row != -1) {
                        ProjectDialog.this.ruleTableModel.moveUp(row);
                        row = Math.max(row - 1, 0);
                        ProjectDialog.this.rulesTable.getSelectionModel().addSelectionInterval(row, row);
                    }
                }
            });
        }
        return this.moveRuleUpButton;
    }

    private JButton getMoveRuleDownButton() {
        if (this.moveRuleDownButton == null) {
            this.moveRuleDownButton = new JButton();
            this.moveRuleDownButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/down.gif")));
            this.moveRuleDownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = ProjectDialog.this.rulesTable.getSelectedRow();
                    if (row != -1) {
                        ProjectDialog.this.ruleTableModel.moveDown(row);
                        row = Math.min(row + 1, ProjectDialog.this.ruleTableModel.getRowCount());
                        ProjectDialog.this.rulesTable.getSelectionModel().addSelectionInterval(row, row);
                    }
                }
            });
        }
        return this.moveRuleDownButton;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(null);
            this.jPanel3.setBounds(new Rectangle(0, 0, 706, 481));
            this.jPanel3.add((Component)this.getDefaultOptionsPanel(), null);
            this.jPanel3.add((Component)this.getJPanel2(), null);
            this.jPanel3.add((Component)this.getInfoPanel(), null);
        }
        return this.jPanel3;
    }

    private InfoPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new InfoPanel();
            this.infoPanel.setTitle("Bytecode Instrumentation Rules");
            this.infoPanel.setBounds(new Rectangle(0, 0, 706, 46));
            this.infoPanel.setDescription("Please specify the rules to be used by the profiling agent in the remote JVM");
        }
        return this.infoPanel;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setBounds(new Rectangle(16, 64, 49, 17));
            this.jLabel2.setText("Port");
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Host");
            this.jLabel1.setBounds(new Rectangle(16, 32, 49, 17));
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(null);
            this.jPanel4.setBounds(new Rectangle(16, 56, 385, 103));
            this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Remote JVM", 0, 0, null, null));
            this.jPanel4.add((Component)this.jLabel1, null);
            this.jPanel4.add((Component)this.getHostTextField(), null);
            this.jPanel4.add((Component)this.getPortTextField(), null);
            this.jPanel4.add((Component)this.jLabel2, null);
        }
        return this.jPanel4;
    }

    private JTextField getHostTextField() {
        if (this.hostTextField == null) {
            this.hostTextField = new JTextField();
            this.hostTextField.setBounds(new Rectangle(64, 32, 297, 19));
            this.validator.newNonEmpty(this.hostTextField);
        }
        return this.hostTextField;
    }

    private JTextField getPortTextField() {
        if (this.portTextField == null) {
            this.portTextField = new JTextField();
            this.portTextField.setBounds(new Rectangle(64, 64, 49, 19));
            this.validator.newInteger(this.portTextField, 1024, 65535);
        }
        return this.portTextField;
    }

    public boolean edit(Project p) {
        this.beanpropsCheckBox.setSelected(p.isBeanprops());
        this.accessComboBox.setSelectedItem((Object)p.getAccess());
        for (Rule r : p.getRules()) {
            this.ruleTableModel.insert(r);
        }
        this.setVisible(true);
        if (this.edited) {
            p.setBeanprops(this.beanpropsCheckBox.isSelected());
            p.setAccess((Rule.AccessOption)((Object)this.accessComboBox.getSelectedItem()));
            p.getRules().clear();
            for (Rule r : this.ruleTableModel.getRules()) {
                p.getRules().add(r);
            }
        }
        return this.edited;
    }
}

