/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.util.Map;
import net.sf.profiler4j.agent.Config;
import net.sf.profiler4j.agent.Profiler4JError;
import net.sf.profiler4j.agent.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Rule {
    private String pattern;
    private Action action;
    private Map<Option, String> options;

    public Rule(String pattern, Action action, Map<Option, String> options) {
        this.pattern = pattern;
        this.action = action;
        this.options = options;
    }

    public Action getAction() {
        return this.action;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isBooleanOptionSet(Option option, Config c) {
        String v = this.options.get((Object)option);
        if (v == null && (v = c.getDefaultRuleOptions().get((Object)option)) == null) {
            throw new Profiler4JError("[INTERNAL] No default set for boolean option " + (Object)((Object)option));
        }
        return Utils.parseBoolean(v);
    }

    public String getOption(Option option, Config c) {
        String v = this.options.get((Object)option);
        if (v == null && (v = c.getDefaultRuleOptions().get((Object)option)) == null) {
            throw new Profiler4JError("[INTERNAL] No default set for option " + (Object)((Object)option));
        }
        return v;
    }

    public boolean matches(String methodFqn) {
        return Utils.getRegex(this.pattern).matcher(methodFqn).matches();
    }

    public String toString() {
        return "Rule[pattern=" + this.pattern + ", action=" + (Object)((Object)this.action) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        ACCESS,
        BEANPROPS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ACCEPT,
        REJECT;

    }
}

