/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.ListenerStatus;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.SocketListener;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;
import javax.jmdns.impl.tasks.RecordReaper;
import javax.jmdns.impl.tasks.Responder;
import javax.jmdns.impl.tasks.resolver.ServiceInfoResolver;
import javax.jmdns.impl.tasks.resolver.ServiceResolver;
import javax.jmdns.impl.tasks.resolver.TypeResolver;
import javax.jmdns.impl.tasks.state.Announcer;
import javax.jmdns.impl.tasks.state.Canceler;
import javax.jmdns.impl.tasks.state.Prober;
import javax.jmdns.impl.tasks.state.Renewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmDNSImpl
extends JmDNS
implements DNSStatefulObject {
    private static Logger logger = Logger.getLogger(JmDNSImpl.class.getName());
    private volatile InetAddress _group;
    private volatile MulticastSocket _socket;
    private volatile boolean _closed = false;
    private final List<DNSListener> _listeners;
    private final ConcurrentMap<String, List<ListenerStatus.ServiceListenerStatus>> _serviceListeners;
    private final Set<ListenerStatus.ServiceTypeListenerStatus> _typeListeners;
    private final DNSCache _cache;
    private final ConcurrentMap<String, ServiceInfo> _services;
    private final ConcurrentMap<String, Set<String>> _serviceTypes;
    protected Thread _shutdown;
    private HostInfo _localHost;
    private Thread _incomingListener;
    private int _throttle;
    private long _lastThrottleIncrement;
    private final ExecutorService _executor = Executors.newSingleThreadExecutor();
    private final Timer _timer;
    private final Timer _stateTimer;
    private static final Random _random = new Random();
    private final ReentrantLock _ioLock = new ReentrantLock();
    private DNSIncoming _plannedAnswer;
    private final ConcurrentMap<String, ServiceCollector> _serviceCollectors;
    private final String _name;

    public static void main(String[] argv) {
        String version = null;
        try {
            Properties pomProperties = new Properties();
            pomProperties.load(JmDNSImpl.class.getResourceAsStream("/META-INF/maven/javax.jmdns/jmdns/pom.properties"));
            version = pomProperties.getProperty("version");
        }
        catch (Exception e) {
            version = "RUNNING.IN.IDE.FULL";
        }
        System.out.println("JmDNS version \"" + version + "\"");
        System.out.println(" ");
        System.out.println("Running on java version \"" + System.getProperty("java.version") + "\"" + " (build " + System.getProperty("java.runtime.version") + ")" + " from " + System.getProperty("java.vendor"));
        System.out.println("Operating environment \"" + System.getProperty("os.name") + "\"" + " version " + System.getProperty("os.version") + " on " + System.getProperty("os.arch"));
        System.out.println("For more information on JmDNS please visit https://sourceforge.net/projects/jmdns/");
    }

    public JmDNSImpl(InetAddress address, String name) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("JmDNS instance created");
        }
        this._cache = new DNSCache(100);
        this._listeners = Collections.synchronizedList(new ArrayList());
        this._serviceListeners = new ConcurrentHashMap<String, List<ListenerStatus.ServiceListenerStatus>>();
        this._typeListeners = Collections.synchronizedSet(new HashSet());
        this._serviceCollectors = new ConcurrentHashMap<String, ServiceCollector>();
        this._services = new ConcurrentHashMap<String, ServiceInfo>(20);
        this._serviceTypes = new ConcurrentHashMap<String, Set<String>>(20);
        this._localHost = HostInfo.newHostInfo(address, this);
        this._name = name != null ? name : this._localHost.getName();
        this._timer = new Timer("JmDNS(" + this._name + ").Timer", true);
        this._stateTimer = new Timer("JmDNS(" + this._name + ").State.Timer", false);
        this.openMulticastSocket(this.getLocalHost());
        this.start(this.getServices().values());
        new RecordReaper(this).start(this._timer);
    }

    private void start(Collection<? extends ServiceInfo> serviceInfos) {
        if (this._incomingListener == null) {
            this._incomingListener = new SocketListener(this);
            this._incomingListener.start();
        }
        this.startProber();
        for (ServiceInfo serviceInfo : serviceInfos) {
            try {
                this.registerService(new ServiceInfoImpl(serviceInfo));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "start() Registration exception ", exception);
            }
        }
    }

    private void openMulticastSocket(HostInfo hostInfo) throws IOException {
        block5: {
            if (this._group == null) {
                this._group = InetAddress.getByName("224.0.0.251");
            }
            if (this._socket != null) {
                this.closeMulticastSocket();
            }
            this._socket = new MulticastSocket(DNSConstants.MDNS_PORT);
            if (hostInfo != null && hostInfo.getInterface() != null) {
                try {
                    this._socket.setNetworkInterface(hostInfo.getInterface());
                }
                catch (SocketException e) {
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    logger.fine("openMulticastSocket() Set network interface exception: " + e.getMessage());
                }
            }
        }
        this._socket.setTimeToLive(255);
        this._socket.joinGroup(this._group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMulticastSocket() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("closeMulticastSocket()");
        }
        if (this._socket != null) {
            try {
                try {
                    this._socket.leaveGroup(this._group);
                }
                catch (SocketException exception) {
                    // empty catch block
                }
                this._socket.close();
                while (this._incomingListener != null && this._incomingListener.isAlive()) {
                    JmDNSImpl exception = this;
                    synchronized (exception) {
                        try {
                            if (this._incomingListener != null && this._incomingListener.isAlive()) {
                                if (logger.isLoggable(Level.FINER)) {
                                    logger.finer("closeMulticastSocket(): waiting for jmDNS monitor");
                                }
                                this.wait(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this._incomingListener = null;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "closeMulticastSocket() Close socket exception ", exception);
            }
            this._socket = null;
        }
    }

    @Override
    public boolean advanceState(DNSTask task) {
        return this._localHost.advanceState(task);
    }

    @Override
    public boolean revertState() {
        return this._localHost.revertState();
    }

    @Override
    public boolean cancelState() {
        return this._localHost.cancelState();
    }

    @Override
    public boolean recoverState() {
        return this._localHost.recoverState();
    }

    @Override
    public JmDNSImpl getDns() {
        return this;
    }

    @Override
    public void associateWithTask(DNSTask task, DNSState state) {
        this._localHost.associateWithTask(task, state);
    }

    @Override
    public void removeAssociationWithTask(DNSTask task) {
        this._localHost.removeAssociationWithTask(task);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
        return this._localHost.isAssociatedWithTask(task, state);
    }

    @Override
    public boolean isProbing() {
        return this._localHost.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this._localHost.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this._localHost.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this._localHost.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this._localHost.isCanceled();
    }

    @Override
    public boolean waitForAnnounced(long timeout) {
        return this._localHost.waitForAnnounced(timeout);
    }

    @Override
    public boolean waitForCanceled(long timeout) {
        return this._localHost.waitForCanceled(timeout);
    }

    public DNSCache getCache() {
        return this._cache;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getHostName() {
        return this._localHost.getName();
    }

    public HostInfo getLocalHost() {
        return this._localHost;
    }

    @Override
    public InetAddress getInterface() throws IOException {
        return this._socket.getInterface();
    }

    @Override
    public ServiceInfo getServiceInfo(String type, String name) {
        return this.getServiceInfo(type, name, false, 6000L);
    }

    @Override
    public ServiceInfo getServiceInfo(String type, String name, long timeout) {
        return this.getServiceInfo(type, name, false, timeout);
    }

    @Override
    public ServiceInfo getServiceInfo(String type, String name, boolean persistent) {
        return this.getServiceInfo(type, name, persistent, 6000L);
    }

    @Override
    public ServiceInfo getServiceInfo(String type, String name, boolean persistent, long timeout) {
        ServiceInfoImpl info = this.resolveServiceInfo(type, name, "", persistent);
        this.waitForInfoData(info, timeout);
        return info.hasData() ? info : null;
    }

    ServiceInfoImpl resolveServiceInfo(String type, String name, String subtype, boolean persistent) {
        String lotype = type.toLowerCase();
        this.registerServiceType(lotype);
        if (this._serviceCollectors.putIfAbsent(lotype, new ServiceCollector(lotype)) == null) {
            this.addServiceListener(lotype, (ServiceListener)this._serviceCollectors.get(lotype));
        }
        ServiceInfoImpl info = this.getServiceInfoFromCache(type, name, subtype, persistent);
        new ServiceInfoResolver(this, info).start(this._timer);
        return info;
    }

    ServiceInfoImpl getServiceInfoFromCache(String type, String name, String subtype, boolean persistent) {
        ServiceInfoImpl cachedInfo;
        ServiceInfoImpl info = new ServiceInfoImpl(type, name, subtype, 0, 0, 0, persistent, (byte[])null);
        DNSEntry pointerEntry = this.getCache().getDNSEntry(new DNSRecord.Pointer(type, DNSRecordClass.CLASS_ANY, false, 0, info.getQualifiedName()));
        if (pointerEntry instanceof DNSRecord && (cachedInfo = (ServiceInfoImpl)((DNSRecord)pointerEntry).getServiceInfo(persistent)) != null) {
            ServiceInfo cachedTextInfo;
            DNSEntry textEntry;
            ServiceInfo cachedAddressInfo;
            DNSEntry addressEntry;
            ServiceInfo cachedServiceEntryInfo;
            Map<ServiceInfo.Fields, String> map = cachedInfo.getQualifiedNameMap();
            byte[] srvBytes = null;
            String server = "";
            DNSEntry serviceEntry = this.getCache().getDNSEntry(info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_ANY);
            if (serviceEntry instanceof DNSRecord && (cachedServiceEntryInfo = ((DNSRecord)serviceEntry).getServiceInfo(persistent)) != null) {
                cachedInfo = new ServiceInfoImpl(map, cachedServiceEntryInfo.getPort(), cachedServiceEntryInfo.getWeight(), cachedServiceEntryInfo.getPriority(), persistent, (byte[])null);
                srvBytes = cachedServiceEntryInfo.getTextBytes();
                server = cachedServiceEntryInfo.getServer();
            }
            if ((addressEntry = this.getCache().getDNSEntry(server, DNSRecordType.TYPE_A, DNSRecordClass.CLASS_ANY)) instanceof DNSRecord && (cachedAddressInfo = ((DNSRecord)addressEntry).getServiceInfo(persistent)) != null) {
                cachedInfo.setAddress(cachedAddressInfo.getInet4Address());
                cachedInfo._setText(cachedAddressInfo.getTextBytes());
            }
            if ((addressEntry = this.getCache().getDNSEntry(server, DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_ANY)) instanceof DNSRecord && (cachedAddressInfo = ((DNSRecord)addressEntry).getServiceInfo(persistent)) != null) {
                cachedInfo.setAddress(cachedAddressInfo.getInet6Address());
                cachedInfo._setText(cachedAddressInfo.getTextBytes());
            }
            if ((textEntry = this.getCache().getDNSEntry(cachedInfo.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_ANY)) instanceof DNSRecord && (cachedTextInfo = ((DNSRecord)textEntry).getServiceInfo(persistent)) != null) {
                cachedInfo._setText(cachedTextInfo.getTextBytes());
            }
            if (cachedInfo.getTextBytes().length == 0) {
                cachedInfo._setText(srvBytes);
            }
            if (cachedInfo.hasData()) {
                info = cachedInfo;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInfoData(ServiceInfo info, long timeout) {
        ServiceInfo serviceInfo = info;
        synchronized (serviceInfo) {
            long loops = timeout / 200L;
            if (loops < 1L) {
                loops = 1L;
            }
            int i = 0;
            while ((long)i < loops && !info.hasData()) {
                try {
                    info.wait(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    @Override
    public void requestServiceInfo(String type, String name) {
        this.requestServiceInfo(type, name, false, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, boolean persistent) {
        this.requestServiceInfo(type, name, persistent, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, long timeout) {
        this.requestServiceInfo(type, name, false, 6000L);
    }

    @Override
    public void requestServiceInfo(String type, String name, boolean persistent, long timeout) {
        ServiceInfoImpl info = this.resolveServiceInfo(type, name, "", persistent);
        this.waitForInfoData(info, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleServiceResolved(ServiceEvent event) {
        List list = (List)this._serviceListeners.get(event.getType().toLowerCase());
        if (list != null && !list.isEmpty() && event.getInfo() != null && event.getInfo().hasData()) {
            ArrayList listCopy;
            final ServiceEvent localEvent = event;
            List list2 = list;
            synchronized (list2) {
                listCopy = new ArrayList(list);
            }
            for (final ListenerStatus.ServiceListenerStatus listener : listCopy) {
                this._executor.submit(new Runnable(){

                    public void run() {
                        listener.serviceResolved(localEvent);
                    }
                });
            }
        }
    }

    @Override
    public void addServiceTypeListener(ServiceTypeListener listener) throws IOException {
        ListenerStatus.ServiceTypeListenerStatus status = new ListenerStatus.ServiceTypeListenerStatus(listener);
        this._typeListeners.add(status);
        for (String type : this._serviceTypes.keySet()) {
            status.serviceTypeAdded(new ServiceEventImpl(this, type, "", null));
        }
        new TypeResolver(this).start(this._timer);
    }

    @Override
    public void removeServiceTypeListener(ServiceTypeListener listener) {
        ListenerStatus.ServiceTypeListenerStatus status = new ListenerStatus.ServiceTypeListenerStatus(listener);
        this._typeListeners.remove(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(String type, ServiceListener listener) {
        ListenerStatus.ServiceListenerStatus status = new ListenerStatus.ServiceListenerStatus(listener);
        String lotype = type.toLowerCase();
        List list = (List)this._serviceListeners.get(lotype);
        if (list == null) {
            if (this._serviceListeners.putIfAbsent(lotype, new LinkedList()) == null && this._serviceCollectors.putIfAbsent(lotype, new ServiceCollector(lotype)) == null) {
                this.addServiceListener(lotype, (ServiceListener)this._serviceCollectors.get(lotype));
            }
            list = (List)this._serviceListeners.get(lotype);
        }
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                if (!list.contains(listener)) {
                    list.add(status);
                }
            }
        }
        ArrayList<ServiceEventImpl> serviceEvents = new ArrayList<ServiceEventImpl>();
        Collection<DNSEntry> dnsEntryLits = this.getCache().allValues();
        for (DNSEntry dNSEntry : dnsEntryLits) {
            DNSRecord record = (DNSRecord)dNSEntry;
            if (record.getRecordType() != DNSRecordType.TYPE_SRV || !record.getName().endsWith(type)) continue;
            serviceEvents.add(new ServiceEventImpl(this, type, JmDNSImpl.toUnqualifiedName(type, record.getName()), record.getServiceInfo()));
        }
        for (ServiceEvent serviceEvent : serviceEvents) {
            status.serviceAdded(serviceEvent);
        }
        new ServiceResolver(this, type).start(this._timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(String type, ServiceListener listener) {
        String aType = type.toLowerCase();
        List list = (List)this._serviceListeners.get(aType);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                ListenerStatus.ServiceListenerStatus status = new ListenerStatus.ServiceListenerStatus(listener);
                list.remove(status);
                if (list.isEmpty()) {
                    this._serviceListeners.remove(aType, list);
                }
            }
        }
    }

    @Override
    public void registerService(ServiceInfo infoAbstract) throws IOException {
        ServiceInfoImpl info = (ServiceInfoImpl)infoAbstract;
        if (info.getDns() != null && info.getDns() != this) {
            throw new IllegalStateException("This service information is already registered with another DNS.");
        }
        info.setDns(this);
        this.registerServiceType(info.getTypeWithSubtype());
        info.setServer(this._localHost.getName());
        info.setAddress(this._localHost.getInet4Address());
        info.setAddress(this._localHost.getInet6Address());
        this.waitForAnnounced(0L);
        this.makeServiceNameUnique(info);
        while (this._services.putIfAbsent(info.getQualifiedName().toLowerCase(), info) != null) {
            this.makeServiceNameUnique(info);
        }
        this.startProber();
        info.waitForAnnounced(0L);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("registerService() JmDNS registered service as " + info);
        }
    }

    @Override
    public void unregisterService(ServiceInfo infoAbstract) {
        ServiceInfoImpl info = (ServiceInfoImpl)infoAbstract;
        info.cancelState();
        this.startCanceler();
        info.waitForCanceled(0L);
        this._services.remove(info.getQualifiedName().toLowerCase(), info);
    }

    @Override
    public void unregisterAllServices() {
        ServiceInfoImpl info;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("unregisterAllServices()");
        }
        for (String name : this._services.keySet()) {
            info = (ServiceInfoImpl)this._services.get(name);
            if (info == null) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Cancelling service info: " + info);
            }
            info.cancelState();
        }
        this.startCanceler();
        for (String name : this._services.keySet()) {
            info = (ServiceInfoImpl)this._services.get(name);
            if (info == null) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Wait for service info cancel: " + info);
            }
            info.waitForCanceled(5000L);
            this._services.remove(name, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerServiceType(String type) {
        Set subtypes;
        boolean typeAdded = false;
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(type);
        String domain = map.get((Object)ServiceInfo.Fields.Domain);
        String protocol = map.get((Object)ServiceInfo.Fields.Protocol);
        String application = map.get((Object)ServiceInfo.Fields.Application);
        String subtype = map.get((Object)ServiceInfo.Fields.Subtype);
        String name = (application.length() > 0 ? "_" + application + "." : "") + (protocol.length() > 0 ? "_" + protocol + "." : "") + domain + ".";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ".registering service type: " + type + " as: " + name + (subtype.length() > 0 ? " subtype: " + subtype : ""));
        }
        if (!(this._serviceTypes.containsKey(name) || application.equals("dns-sd") || domain.endsWith("in-addr.arpa") || domain.endsWith("ip6.arpa"))) {
            boolean bl = typeAdded = this._serviceTypes.putIfAbsent(name, new HashSet()) == null;
            if (typeAdded) {
                ListenerStatus.ServiceTypeListenerStatus[] list = this._typeListeners.toArray(new ListenerStatus.ServiceTypeListenerStatus[this._typeListeners.size()]);
                final ServiceEventImpl event = new ServiceEventImpl(this, name, "", null);
                for (final ListenerStatus.ServiceTypeListenerStatus status : list) {
                    this._executor.submit(new Runnable(){

                        public void run() {
                            status.serviceTypeAdded(event);
                        }
                    });
                }
            }
        }
        if (subtype.length() > 0 && (subtypes = (Set)this._serviceTypes.get(name)) != null && !subtypes.contains(subtype)) {
            Set set = subtypes;
            synchronized (set) {
                if (!subtypes.contains(subtype)) {
                    typeAdded = true;
                    subtypes.add(subtype);
                    ListenerStatus.ServiceTypeListenerStatus[] list = this._typeListeners.toArray(new ListenerStatus.ServiceTypeListenerStatus[this._typeListeners.size()]);
                    final ServiceEventImpl event = new ServiceEventImpl(this, "_" + subtype + "._sub." + name, "", null);
                    for (final ListenerStatus.ServiceTypeListenerStatus status : list) {
                        this._executor.submit(new Runnable(){

                            public void run() {
                                status.subTypeForServiceTypeAdded(event);
                            }
                        });
                    }
                }
            }
        }
        return typeAdded;
    }

    private boolean makeServiceNameUnique(ServiceInfoImpl info) {
        boolean collision;
        String originalQualifiedName = info.getQualifiedName();
        long now = System.currentTimeMillis();
        do {
            ServiceInfo selfService;
            collision = false;
            Collection<? extends DNSEntry> entryList = this.getCache().getDNSEntryList(info.getQualifiedName().toLowerCase());
            if (entryList != null) {
                for (DNSEntry dNSEntry : entryList) {
                    DNSRecord.Service s;
                    if (!DNSRecordType.TYPE_SRV.equals((Object)dNSEntry.getRecordType()) || dNSEntry.isExpired(now) || (s = (DNSRecord.Service)dNSEntry).getPort() == info.getPort() && s.getServer().equals(this._localHost.getName())) continue;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("makeServiceNameUnique() JmDNS.makeServiceNameUnique srv collision:" + dNSEntry + " s.server=" + s.getServer() + " " + this._localHost.getName() + " equals:" + s.getServer().equals(this._localHost.getName()));
                    }
                    info.setName(this.incrementName(info.getName()));
                    collision = true;
                    break;
                }
            }
            if ((selfService = (ServiceInfo)this._services.get(info.getQualifiedName().toLowerCase())) == null || selfService == info) continue;
            info.setName(this.incrementName(info.getName()));
            collision = true;
        } while (collision);
        return !originalQualifiedName.equals(info.getQualifiedName());
    }

    String incrementName(String name) {
        String aName = name;
        try {
            int l = aName.lastIndexOf(40);
            int r = aName.lastIndexOf(41);
            aName = l >= 0 && l < r ? aName.substring(0, l) + "(" + (Integer.parseInt(aName.substring(l + 1, r)) + 1) + ")" : aName + " (2)";
        }
        catch (NumberFormatException e) {
            aName = aName + " (2)";
        }
        return aName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DNSListener listener, DNSQuestion question) {
        Collection<? extends DNSEntry> entryList;
        long now = System.currentTimeMillis();
        this._listeners.add(listener);
        if (question != null && (entryList = this.getCache().getDNSEntryList(question.getName().toLowerCase())) != null) {
            Collection<? extends DNSEntry> collection = entryList;
            synchronized (collection) {
                for (DNSEntry dNSEntry : entryList) {
                    if (!question.answeredBy(dNSEntry) || dNSEntry.isExpired(now)) continue;
                    listener.updateRecord(this.getCache(), now, dNSEntry);
                }
            }
        }
    }

    public void removeListener(DNSListener listener) {
        this._listeners.remove(listener);
    }

    public void renewServiceCollector(DNSRecord record) {
        ServiceInfo info = record.getServiceInfo();
        if (this._serviceCollectors.containsKey(info.getType().toLowerCase())) {
            new ServiceResolver(this, info.getType()).start(this._timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(long now, DNSRecord rec, Operation operation) {
        ArrayList<DNSListener> listenerList = null;
        List<DNSListener> list = this._listeners;
        synchronized (list) {
            listenerList = new ArrayList<DNSListener>(this._listeners);
        }
        for (DNSListener listener : listenerList) {
            listener.updateRecord(this.getCache(), now, rec);
        }
        if (DNSRecordType.TYPE_PTR.equals((Object)rec.getRecordType())) {
            List<ListenerStatus.ServiceListenerStatus> serviceListenerList;
            List list2;
            ServiceInfoImpl info;
            ServiceEvent event = rec.getServiceEvent(this);
            if ((event.getInfo() == null || !event.getInfo().hasData()) && ((ServiceInfo)(info = this.getServiceInfoFromCache(event.getType(), event.getName(), "", false))).hasData()) {
                event = new ServiceEventImpl(this, event.getType(), event.getName(), info);
            }
            if ((list2 = (List)this._serviceListeners.get(event.getType())) != null) {
                List list3 = list2;
                synchronized (list3) {
                    serviceListenerList = new ArrayList<ListenerStatus.ServiceListenerStatus>(list2);
                }
            } else {
                serviceListenerList = Collections.emptyList();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.getName() + ".updating record for event: " + event + " list " + serviceListenerList + " operation: " + (Object)((Object)operation));
            }
            if (!serviceListenerList.isEmpty()) {
                final ServiceEvent localEvent = event;
                switch (operation) {
                    case Add: {
                        for (final ListenerStatus.ServiceListenerStatus listener : serviceListenerList) {
                            this._executor.submit(new Runnable(){

                                public void run() {
                                    listener.serviceAdded(localEvent);
                                }
                            });
                        }
                        break;
                    }
                    case Remove: {
                        for (final ListenerStatus.ServiceListenerStatus listener : serviceListenerList) {
                            this._executor.submit(new Runnable(){

                                public void run() {
                                    listener.serviceRemoved(localEvent);
                                }
                            });
                        }
                        break;
                    }
                }
            }
        }
    }

    void handleRecord(DNSRecord record, long now) {
        DNSRecord newRecord = record;
        Operation cacheOperation = Operation.Noop;
        boolean expired = newRecord.isExpired(now);
        DNSRecord cachedRecord = (DNSRecord)this.getCache().getDNSEntry(newRecord);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ".handle response: " + newRecord + "\ncached record: " + cachedRecord);
        }
        if (cachedRecord != null) {
            if (expired) {
                cacheOperation = Operation.Remove;
                this.getCache().removeDNSEntry(cachedRecord);
            } else if (!newRecord.sameValue(cachedRecord) || !newRecord.sameSubtype(cachedRecord) && newRecord.getSubtype().length() > 0) {
                cacheOperation = Operation.Update;
                this.getCache().replaceDNSEntry(newRecord, cachedRecord);
            } else {
                cachedRecord.resetTTL(newRecord);
                newRecord = cachedRecord;
            }
        } else if (!expired) {
            cacheOperation = Operation.Add;
            this.getCache().addDNSEntry(newRecord);
        }
        switch (newRecord.getRecordType()) {
            case TYPE_PTR: {
                boolean typeAdded = false;
                if (newRecord.isServicesDiscoveryMetaQuery()) {
                    if (!expired) {
                        typeAdded = this.registerServiceType(((DNSRecord.Pointer)newRecord).getAlias());
                    }
                    return;
                }
                if (!(typeAdded |= this.registerServiceType(newRecord.getName())) || cacheOperation != Operation.Noop) break;
                cacheOperation = Operation.RegisterServiceType;
                break;
            }
        }
        if (cacheOperation != Operation.Noop) {
            this.updateRecord(now, newRecord, cacheOperation);
        }
    }

    void handleResponse(DNSIncoming msg) throws IOException {
        long now = System.currentTimeMillis();
        boolean hostConflictDetected = false;
        boolean serviceConflictDetected = false;
        for (DNSRecord dNSRecord : msg.getAllAnswers()) {
            this.handleRecord(dNSRecord, now);
            if (DNSRecordType.TYPE_A.equals((Object)dNSRecord.getRecordType()) || DNSRecordType.TYPE_AAAA.equals((Object)dNSRecord.getRecordType())) {
                hostConflictDetected |= dNSRecord.handleResponse(this);
                continue;
            }
            serviceConflictDetected |= dNSRecord.handleResponse(this);
        }
        if (hostConflictDetected || serviceConflictDetected) {
            this.startProber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleQuery(DNSIncoming in, InetAddress addr, int port) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getName() + ".handle query: " + in);
        }
        boolean conflictDetected = false;
        long expirationTime = System.currentTimeMillis() + 120L;
        for (DNSRecord dNSRecord : in.getAllAnswers()) {
            conflictDetected |= dNSRecord.handleQuery(this, expirationTime);
        }
        this._ioLock.lock();
        try {
            if (this._plannedAnswer != null) {
                this._plannedAnswer.append(in);
            } else {
                if (in.isTruncated()) {
                    this._plannedAnswer = in;
                }
                new Responder(this, in, port).start(this._timer);
            }
        }
        finally {
            this._ioLock.unlock();
        }
        long now = System.currentTimeMillis();
        for (DNSRecord dNSRecord : in.getAnswers()) {
            this.handleRecord(dNSRecord, now);
        }
        if (conflictDetected) {
            this.startProber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respondToQuery(DNSIncoming in) {
        this._ioLock.lock();
        try {
            if (this._plannedAnswer == in) {
                this._plannedAnswer = null;
            }
        }
        finally {
            this._ioLock.unlock();
        }
    }

    public DNSOutgoing addAnswer(DNSIncoming in, InetAddress addr, int port, DNSOutgoing out, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        if (newOut == null) {
            newOut = new DNSOutgoing(33792, false, in.getSenderUDPPayload());
        }
        try {
            newOut.addAnswer(in, rec);
        }
        catch (IOException e) {
            newOut.setFlags(newOut.getFlags() | 0x200);
            newOut.setId(in.getId());
            this.send(newOut);
            newOut = new DNSOutgoing(33792, false, in.getSenderUDPPayload());
            newOut.addAnswer(in, rec);
        }
        return newOut;
    }

    public void send(DNSOutgoing out) throws IOException {
        if (!out.isEmpty()) {
            MulticastSocket ms;
            byte[] message = out.data();
            DatagramPacket packet = new DatagramPacket(message, message.length, this._group, DNSConstants.MDNS_PORT);
            if (logger.isLoggable(Level.FINEST)) {
                try {
                    DNSIncoming msg = new DNSIncoming(packet);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("send(" + this.getName() + ") JmDNS out:" + msg.print(true));
                    }
                }
                catch (IOException e) {
                    logger.throwing(this.getClass().toString(), "send(" + this.getName() + ") - JmDNS can not parse what it sends!!!", e);
                }
            }
            if ((ms = this._socket) != null && !ms.isClosed()) {
                ms.send(packet);
            }
        }
    }

    public void startProber() {
        new Prober(this).start(this._stateTimer);
    }

    public void startAnnouncer() {
        new Announcer(this).start(this._stateTimer);
    }

    public void startRenewer() {
        new Renewer(this).start(this._stateTimer);
    }

    public void startCanceler() {
        new Canceler(this).start(this._stateTimer);
    }

    public void recover() {
        logger.finer("recover()");
        if (this.isCanceling() || this.isCanceled()) {
            return;
        }
        if (this.cancelState()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("recover() Cleanning up");
            }
            this._timer.purge();
            ArrayList<ServiceInfo> oldServiceInfos = new ArrayList<ServiceInfo>(this.getServices().values());
            this.unregisterAllServices();
            this.disposeServiceCollectors();
            this.waitForCanceled(0L);
            this._stateTimer.purge();
            this.closeMulticastSocket();
            this.getCache().clear();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("recover() All is clean");
            }
            for (ServiceInfo info : oldServiceInfos) {
                ((ServiceInfoImpl)info).recoverState();
            }
            this.recoverState();
            try {
                this.openMulticastSocket(this.getLocalHost());
                this.start(oldServiceInfos);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "recover() Start services exception ", exception);
            }
            logger.log(Level.WARNING, "recover() We are back!");
        }
    }

    @Override
    public void close() {
        if (this.isCanceling() || this.isCanceled()) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Cancelling JmDNS: " + this);
        }
        if (this.cancelState()) {
            this._timer.cancel();
            this.unregisterAllServices();
            this.disposeServiceCollectors();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Wait for JmDNS cancel: " + this);
            }
            this.waitForCanceled(5000L);
            this._stateTimer.cancel();
            this._executor.shutdown();
            this.closeMulticastSocket();
            if (this._shutdown != null) {
                Runtime.getRuntime().removeShutdownHook(this._shutdown);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("JmDNS closed.");
            }
        }
    }

    @Override
    public void printServices() {
        System.err.println(this.toString());
    }

    public String toString() {
        StringBuilder aLog = new StringBuilder(2048);
        aLog.append("\t---- Local Host -----");
        aLog.append("\n\t" + this._localHost);
        aLog.append("\n\t---- Services -----");
        for (String key : this._services.keySet()) {
            aLog.append("\n\t\tService: " + key + ": " + this._services.get(key));
        }
        aLog.append("\n");
        aLog.append("\t---- Types ----");
        for (String key : this._serviceTypes.keySet()) {
            Set subtypes = (Set)this._serviceTypes.get(key);
            aLog.append("\n\t\tType: " + key + ": " + (subtypes == null || subtypes.isEmpty() ? "no subtypes" : subtypes));
        }
        aLog.append("\n");
        aLog.append(this._cache.toString());
        aLog.append("\n");
        aLog.append("\t---- Service Collectors ----");
        for (String key : this._serviceCollectors.keySet()) {
            aLog.append("\n\t\tService Collector: " + key + ": " + this._serviceCollectors.get(key));
        }
        aLog.append("\n");
        aLog.append("\t---- Service Listeners ----");
        for (String key : this._serviceListeners.keySet()) {
            aLog.append("\n\t\tService Listener: " + key + ": " + this._serviceListeners.get(key));
        }
        return aLog.toString();
    }

    @Override
    public ServiceInfo[] list(String type) {
        return this.list(type, 6000L);
    }

    @Override
    public ServiceInfo[] list(String type, long timeout) {
        String aType = type.toLowerCase();
        boolean newCollectorCreated = false;
        if (this.isCanceling() || this.isCanceled()) {
            return new ServiceInfo[0];
        }
        ServiceCollector collector = (ServiceCollector)this._serviceCollectors.get(aType);
        if (collector == null) {
            newCollectorCreated = this._serviceCollectors.putIfAbsent(aType, new ServiceCollector(aType)) == null;
            collector = (ServiceCollector)this._serviceCollectors.get(aType);
            if (newCollectorCreated) {
                this.addServiceListener(aType, collector);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.getName() + ".collector: " + collector);
        }
        return collector != null ? collector.list(timeout) : new ServiceInfo[]{};
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String type) {
        return this.listBySubtype(type, 6000L);
    }

    @Override
    public Map<String, ServiceInfo[]> listBySubtype(String type, long timeout) {
        HashMap map = new HashMap(5);
        for (ServiceInfo info : this.list(type, timeout)) {
            String subtype = info.getSubtype();
            if (!map.containsKey(subtype)) {
                map.put(subtype, new ArrayList(10));
            }
            ((List)map.get(subtype)).add(info);
        }
        HashMap<String, ServiceInfo[]> result = new HashMap<String, ServiceInfo[]>(map.size());
        for (String subtype : map.keySet()) {
            List infoForSubType = (List)map.get(subtype);
            result.put(subtype, infoForSubType.toArray(new ServiceInfo[infoForSubType.size()]));
        }
        return result;
    }

    private void disposeServiceCollectors() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("disposeServiceCollectors()");
        }
        for (String type : this._serviceCollectors.keySet()) {
            ServiceCollector collector = (ServiceCollector)this._serviceCollectors.get(type);
            if (collector == null) continue;
            this.removeServiceListener(type, collector);
            this._serviceCollectors.remove(type, collector);
        }
    }

    static String toUnqualifiedName(String type, String qualifiedName) {
        if (qualifiedName.endsWith(type) && !qualifiedName.equals(type)) {
            return qualifiedName.substring(0, qualifiedName.length() - type.length() - 1);
        }
        return qualifiedName;
    }

    public Map<String, ServiceInfo> getServices() {
        return this._services;
    }

    public void setLastThrottleIncrement(long lastThrottleIncrement) {
        this._lastThrottleIncrement = lastThrottleIncrement;
    }

    public long getLastThrottleIncrement() {
        return this._lastThrottleIncrement;
    }

    public void setThrottle(int throttle) {
        this._throttle = throttle;
    }

    public int getThrottle() {
        return this._throttle;
    }

    public static Random getRandom() {
        return _random;
    }

    public void ioLock() {
        this._ioLock.lock();
    }

    public void ioUnlock() {
        this._ioLock.unlock();
    }

    public void setPlannedAnswer(DNSIncoming plannedAnswer) {
        this._plannedAnswer = plannedAnswer;
    }

    public DNSIncoming getPlannedAnswer() {
        return this._plannedAnswer;
    }

    void setLocalHost(HostInfo localHost) {
        this._localHost = localHost;
    }

    public Map<String, Set<String>> getServiceTypes() {
        return this._serviceTypes;
    }

    public void setClosed(boolean closed) {
        this._closed = closed;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public MulticastSocket getSocket() {
        return this._socket;
    }

    public InetAddress getGroup() {
        return this._group;
    }

    private static class ServiceCollector
    implements ServiceListener {
        private final ConcurrentMap<String, ServiceInfo> _infos = new ConcurrentHashMap<String, ServiceInfo>();
        private final ConcurrentMap<String, ServiceEvent> _events = new ConcurrentHashMap<String, ServiceEvent>();
        private final String _type;
        private volatile boolean _needToWaitForInfos;

        public ServiceCollector(String type) {
            this._type = type;
            this._needToWaitForInfos = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceAdded(ServiceEvent event) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                ServiceInfo info = event.getInfo();
                if (info != null && info.hasData()) {
                    this._infos.put(event.getName(), info);
                } else {
                    String subtype = info != null ? info.getSubtype() : "";
                    info = ((JmDNSImpl)event.getDNS()).resolveServiceInfo(event.getType(), event.getName(), subtype, true);
                    if (info != null) {
                        this._infos.put(event.getName(), info);
                    } else {
                        this._events.put(event.getName(), event);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRemoved(ServiceEvent event) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                this._infos.remove(event.getName());
                this._events.remove(event.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceResolved(ServiceEvent event) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                this._infos.put(event.getName(), event.getInfo());
                this._events.remove(event.getName());
            }
        }

        public ServiceInfo[] list(long timeout) {
            if (this._infos.isEmpty() || !this._events.isEmpty() || this._needToWaitForInfos) {
                long loops = timeout / 200L;
                if (loops < 1L) {
                    loops = 1L;
                }
                int i = 0;
                while ((long)i < loops) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this._events.isEmpty() && !this._infos.isEmpty() && !this._needToWaitForInfos) break;
                    ++i;
                }
            }
            this._needToWaitForInfos = false;
            return this._infos.values().toArray(new ServiceInfo[this._infos.size()]);
        }

        public String toString() {
            StringBuffer aLog = new StringBuffer();
            aLog.append("\n\tType: " + this._type);
            if (this._infos.isEmpty()) {
                aLog.append("\n\tNo services collected.");
            } else {
                aLog.append("\n\tServices");
                for (String key : this._infos.keySet()) {
                    aLog.append("\n\t\tService: " + key + ": " + this._infos.get(key));
                }
            }
            if (this._events.isEmpty()) {
                aLog.append("\n\tNo event queued.");
            } else {
                aLog.append("\n\tEvents");
                for (String key : this._events.keySet()) {
                    aLog.append("\n\t\tEvent: " + key + ": " + this._events.get(key));
                }
            }
            return aLog.toString();
        }
    }

    protected class Shutdown
    implements Runnable {
        protected Shutdown() {
        }

        public void run() {
            try {
                JmDNSImpl.this._shutdown = null;
                JmDNSImpl.this.close();
            }
            catch (Throwable exception) {
                System.err.println("Error while shuting down. " + exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        Remove,
        Update,
        Add,
        RegisterServiceType,
        Noop;

    }
}

