/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.ITask;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.ApplicationActionBarAdvisor;
import org.rssowl.ui.internal.ApplicationServer;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.EntityGroupItem;
import org.rssowl.ui.internal.ILinkHandler;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.ArchiveNewsAction;
import org.rssowl.ui.internal.actions.AutomateFilterAction;
import org.rssowl.ui.internal.actions.CreateFilterAction;
import org.rssowl.ui.internal.actions.MakeNewsStickyAction;
import org.rssowl.ui.internal.actions.MarkAllNewsReadAction;
import org.rssowl.ui.internal.actions.MoveCopyNewsToBinAction;
import org.rssowl.ui.internal.actions.NavigationActionFactory;
import org.rssowl.ui.internal.actions.OpenInExternalBrowserAction;
import org.rssowl.ui.internal.actions.OpenNewsAction;
import org.rssowl.ui.internal.actions.ToggleReadStateAction;
import org.rssowl.ui.internal.dialogs.SearchNewsDialog;
import org.rssowl.ui.internal.editors.feed.IFeedViewSite;
import org.rssowl.ui.internal.editors.feed.Messages;
import org.rssowl.ui.internal.editors.feed.NewsBrowserLabelProvider;
import org.rssowl.ui.internal.editors.feed.NewsBrowserViewModel;
import org.rssowl.ui.internal.editors.feed.NewsContentProvider;
import org.rssowl.ui.internal.editors.feed.NewsFilter;
import org.rssowl.ui.internal.undo.NewsStateOperation;
import org.rssowl.ui.internal.undo.StickyOperation;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.CBrowser;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.JobTracker;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.util.UIBackgroundJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsBrowserViewer
extends ContentViewer
implements ILinkHandler {
    static final String MARK_READ_HANDLER_ID = "org.rssowl.ui.MarkRead";
    static final String TOGGLE_READ_HANDLER_ID = "org.rssowl.ui.ToggleRead";
    static final String TOGGLE_STICKY_HANDLER_ID = "org.rssowl.ui.ToggleSticky";
    static final String ARCHIVE_HANDLER_ID = "org.rssowl.ui.Archive";
    static final String DELETE_HANDLER_ID = "org.rssowl.ui.Delete";
    static final String ATTACHMENT_HANDLER_ID = "org.rssowl.ui.DownloadAttachment";
    static final String ATTACHMENTS_MENU_HANDLER_ID = "org.rssowl.ui.AttachmentsMenu";
    static final String LABELS_MENU_HANDLER_ID = "org.rssowl.ui.LabelsMenu";
    static final String EXPAND_NEWS_HANDLER_ID = "org.rssowl.ui.ExpandNews";
    static final String COLLAPSE_NEWS_HANDLER_ID = "org.rssowl.ui.CollapseNews";
    static final String EXPAND_GROUP_HANDLER_ID = "org.rssowl.ui.ExpandGroup";
    static final String COLLAPSE_GROUP_HANDLER_ID = "org.rssowl.ui.CollapseGroup";
    static final String GROUP_MENU_HANDLER_ID = "org.rssowl.ui.GroupMenu";
    static final String NEWS_MENU_HANDLER_ID = "org.rssowl.ui.NewsMenu";
    static final String SHARE_NEWS_MENU_HANDLER_ID = "org.rssowl.ui.ShareNewsMenu";
    static final String NEXT_NEWS_HANDLER_ID = "org.rssowl.ui.NextNews";
    static final String NEXT_UNREAD_NEWS_HANDLER_ID = "org.rssowl.ui.NextUnreadNews";
    static final String PREVIOUS_NEWS_HANDLER_ID = "org.rssowl.ui.PreviousNews";
    static final String PREVIOUS_UNREAD_NEWS_HANDLER_ID = "org.rssowl.ui.PreviousUnreadNews";
    static final String TRANSFORM_HANDLER_ID = "org.rssowl.ui.TransformNews";
    static final String RELATED_NEWS_MENU_HANDLER_ID = "org.rssowl.ui.RelatedNewsMenu";
    static final String NEXT_PAGE_HANDLER_ID = "org.rssowl.ui.NextPage";
    static final String SCROLL_NEXT_PAGE_HANDLER_ID = "org.rssowl.ui.ScrollNextPage";
    private static final int USER_INTERACTION_DELAY = 500;
    private static final String BODY_ELEMENT_ID = "owlbody";
    private Object fInput;
    private CBrowser fBrowser;
    private IFeedViewSite fSite;
    private boolean fIsEmbedded;
    private Menu fNewsContextMenu;
    private Menu fAttachmentsContextMenu;
    private Menu fLabelsContextMenu;
    private Menu fShareNewsContextMenu;
    private Menu fFindRelatedContextMenu;
    private IStructuredSelection fCurrentSelection = StructuredSelection.EMPTY;
    private final ApplicationServer fServer;
    private final String fId;
    private boolean fBlockRefresh;
    private boolean fMarkReadOnExpand = true;
    private boolean fMarkReadOnScrolling = true;
    private int fPageSize;
    private final IModelFactory fFactory;
    private final IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();
    private final INewsDAO fNewsDao = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);
    private final JobTracker fUserInteractionTracker = new JobTracker(500, false, true, ITask.Priority.INTERACTIVE);
    private final Set<Long> fMarkedUnreadByUserCache = Collections.synchronizedSet(new HashSet());
    private ViewerComparator fSorter;
    private List<ViewerFilter> fFilters;
    private NewsFilter fNewsFilter;
    private final NewsBrowserViewModel fViewModel;

    public NewsBrowserViewer(Composite parent, int style) {
        this(parent, style, null);
    }

    public NewsBrowserViewer(Composite parent, int style, IFeedViewSite site) {
        this.fBrowser = new CBrowser(parent, style);
        this.fBrowser.setCanOpenLinksInTabs(true);
        this.fViewModel = new NewsBrowserViewModel(this);
        this.fSite = site;
        this.fIsEmbedded = this.fSite != null;
        this.hookControl((Control)this.fBrowser.getControl());
        this.hookNewsContextMenu();
        this.hookAttachmentsContextMenu();
        this.hookLabelContextMenu();
        this.hookShareNewsContextMenu();
        this.hookFindRelatedContextMenu();
        this.fId = String.valueOf(this.hashCode());
        this.fServer = ApplicationServer.getDefault();
        this.fServer.register(this.fId, this);
        this.fFactory = Owl.getModelFactory();
        this.fBrowser.addLinkHandler(MARK_READ_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(TOGGLE_READ_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(TOGGLE_STICKY_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(ARCHIVE_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(DELETE_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(ATTACHMENT_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(ATTACHMENTS_MENU_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(LABELS_MENU_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(EXPAND_NEWS_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(COLLAPSE_NEWS_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(EXPAND_GROUP_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(COLLAPSE_GROUP_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(GROUP_MENU_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(NEWS_MENU_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(SHARE_NEWS_MENU_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(NEXT_NEWS_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(NEXT_UNREAD_NEWS_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(PREVIOUS_NEWS_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(PREVIOUS_UNREAD_NEWS_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(TRANSFORM_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(RELATED_NEWS_MENU_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(NEXT_PAGE_HANDLER_ID, this);
        this.fBrowser.addLinkHandler(SCROLL_NEXT_PAGE_HANDLER_ID, this);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                NewsBrowserViewer.this.onUserInteraction();
            }
        };
        this.fBrowser.getControl().addListener(37, listener);
        this.fBrowser.getControl().addListener(3, listener);
        this.fBrowser.getControl().addListener(1, listener);
    }

    private void onUserInteraction() {
        if (!this.fIsEmbedded || !this.fMarkReadOnScrolling && this.fPageSize == 0) {
            return;
        }
        if (this.fBrowser.getControl().isDisposed() || this.fUserInteractionTracker.isRunning()) {
            return;
        }
        this.fUserInteractionTracker.run(new UserInteractionTask(this.fViewModel, this.fBrowser));
    }

    private void hookNewsContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean entityGroupSelected;
                boolean useSeparator = true;
                if (!NewsBrowserViewer.this.fIsEmbedded) {
                    manager.add((IContributionItem)new Separator("internalopen"));
                    if (!NewsBrowserViewer.this.fCurrentSelection.isEmpty()) {
                        manager.appendToGroup("internalopen", (IAction)new OpenNewsAction(NewsBrowserViewer.this.fCurrentSelection, NewsBrowserViewer.this.fBrowser.getControl().getShell()));
                        useSeparator = false;
                    }
                }
                manager.add((IContributionItem)(useSeparator ? new Separator("open") : new GroupMarker("open")));
                if (!NewsBrowserViewer.this.fCurrentSelection.isEmpty() && !OwlUI.useExternalBrowser()) {
                    manager.add((IAction)new OpenInExternalBrowserAction(NewsBrowserViewer.this.fCurrentSelection));
                }
                ApplicationActionBarAdvisor.fillAttachmentsMenu(manager, NewsBrowserViewer.this.fCurrentSelection, (IShellProvider)new SameShellProvider((Control)NewsBrowserViewer.this.fBrowser.getControl().getShell()), false);
                manager.add((IContributionItem)new Separator("mark"));
                MenuManager markMenu = new MenuManager(Messages.NewsBrowserViewer_MARK, "mark");
                manager.add((IContributionItem)markMenu);
                Action action = new ToggleReadStateAction(NewsBrowserViewer.this.fCurrentSelection);
                action.setEnabled(!NewsBrowserViewer.this.fCurrentSelection.isEmpty());
                markMenu.add((IAction)action);
                action = new MarkAllNewsReadAction();
                markMenu.add((IAction)action);
                markMenu.add((IContributionItem)new Separator());
                action = new MakeNewsStickyAction(NewsBrowserViewer.this.fCurrentSelection);
                action.setEnabled(!NewsBrowserViewer.this.fCurrentSelection.isEmpty());
                markMenu.add((IAction)action);
                ApplicationActionBarAdvisor.fillLabelMenu(manager, NewsBrowserViewer.this.fCurrentSelection, (IShellProvider)new SameShellProvider((Control)NewsBrowserViewer.this.fBrowser.getControl().getShell()), false);
                if (!NewsBrowserViewer.this.fCurrentSelection.isEmpty()) {
                    manager.add((IContributionItem)new Separator("movecopy"));
                    ArrayList newsbins = new ArrayList(DynamicDAO.loadAll(INewsBin.class));
                    Comparator<INewsBin> comparator = new Comparator<INewsBin>(){

                        @Override
                        public int compare(INewsBin o1, INewsBin o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    };
                    Collections.sort(newsbins, comparator);
                    MenuManager moveMenu = new MenuManager(Messages.NewsBrowserViewer_MOVE_TO, "moveto");
                    manager.add((IContributionItem)moveMenu);
                    for (INewsBin bin : newsbins) {
                        if (NewsBrowserViewer.this.contained(bin, NewsBrowserViewer.this.fCurrentSelection)) continue;
                        moveMenu.add((IAction)new MoveCopyNewsToBinAction(NewsBrowserViewer.this.fCurrentSelection, bin, true));
                    }
                    moveMenu.add((IAction)new MoveCopyNewsToBinAction(NewsBrowserViewer.this.fCurrentSelection, null, true));
                    moveMenu.add((IContributionItem)new Separator());
                    moveMenu.add((IAction)new AutomateFilterAction(CreateFilterAction.PresetAction.MOVE, (ISelection)NewsBrowserViewer.this.fCurrentSelection));
                    MenuManager copyMenu = new MenuManager(Messages.NewsBrowserViewer_COPY_TO, "copyto");
                    manager.add((IContributionItem)copyMenu);
                    for (INewsBin bin : newsbins) {
                        if (NewsBrowserViewer.this.contained(bin, NewsBrowserViewer.this.fCurrentSelection)) continue;
                        copyMenu.add((IAction)new MoveCopyNewsToBinAction(NewsBrowserViewer.this.fCurrentSelection, bin, false));
                    }
                    copyMenu.add((IAction)new MoveCopyNewsToBinAction(NewsBrowserViewer.this.fCurrentSelection, null, false));
                    copyMenu.add((IContributionItem)new Separator());
                    copyMenu.add((IAction)new AutomateFilterAction(CreateFilterAction.PresetAction.COPY, (ISelection)NewsBrowserViewer.this.fCurrentSelection));
                    manager.add((IAction)new ArchiveNewsAction(NewsBrowserViewer.this.fCurrentSelection));
                }
                if (!(entityGroupSelected = ModelUtils.isEntityGroupSelected((ISelection)NewsBrowserViewer.this.fCurrentSelection))) {
                    ApplicationActionBarAdvisor.fillShareMenu(manager, NewsBrowserViewer.this.fCurrentSelection, (IShellProvider)new SameShellProvider((Control)NewsBrowserViewer.this.fBrowser.getControl().getShell()), false);
                }
                manager.add((IContributionItem)new Separator("filter"));
                manager.add((IContributionItem)new Separator("copy"));
                manager.add((IContributionItem)new GroupMarker("edit"));
                if (entityGroupSelected) {
                    manager.add((IContributionItem)new Separator());
                    ImageDescriptor icon = OwlUI.getImageDescriptor("icons/etool16/collapseall.gif");
                    manager.add((IAction)new Action(Messages.NewsBrowserViewer_COLLAPSE_GROUPS, icon){

                        public void run() {
                            Set<Map.Entry<Long, List<Long>>> groups = NewsBrowserViewer.this.fViewModel.getGroups().entrySet();
                            for (Map.Entry<Long, List<Long>> group : groups) {
                                List<Long> newsIds;
                                Long groupId = group.getKey();
                                if (!NewsBrowserViewer.this.fViewModel.isGroupVisible(groupId) || (newsIds = group.getValue()) == null || newsIds.isEmpty()) continue;
                                NewsBrowserViewer.this.setGroupExpanded(groupId, newsIds, false);
                            }
                        }
                    });
                }
                manager.add((IContributionItem)new Separator("additions"));
                if (NewsBrowserViewer.this.fSite == null) {
                    ObjectActionContributorManager.getManager().contributeObjectActions(null, manager, (ISelectionProvider)NewsBrowserViewer.this);
                }
            }
        });
        this.fNewsContextMenu = manager.createContextMenu((Control)this.fBrowser.getControl().getShell());
        if (this.fSite != null) {
            this.fSite.getEditorSite().registerContextMenu(manager, (ISelectionProvider)this);
        }
    }

    private void hookAttachmentsContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationActionBarAdvisor.fillAttachmentsMenu(manager, NewsBrowserViewer.this.fCurrentSelection, (IShellProvider)new SameShellProvider((Control)NewsBrowserViewer.this.fBrowser.getControl().getShell()), true);
            }
        });
        this.fAttachmentsContextMenu = manager.createContextMenu((Control)this.fBrowser.getControl().getShell());
    }

    private void hookLabelContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationActionBarAdvisor.fillLabelMenu(manager, NewsBrowserViewer.this.fCurrentSelection, (IShellProvider)new SameShellProvider((Control)NewsBrowserViewer.this.fBrowser.getControl().getShell()), true);
            }
        });
        this.fLabelsContextMenu = manager.createContextMenu((Control)this.fBrowser.getControl().getShell());
    }

    private void hookShareNewsContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationActionBarAdvisor.fillShareMenu(manager, NewsBrowserViewer.this.fCurrentSelection, (IShellProvider)new SameShellProvider((Control)NewsBrowserViewer.this.fBrowser.getControl().getShell()), true);
            }
        });
        this.fShareNewsContextMenu = manager.createContextMenu((Control)this.fBrowser.getControl().getShell());
    }

    private void hookFindRelatedContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object element;
                if (NewsBrowserViewer.this.fCurrentSelection.size() == 1 && (element = NewsBrowserViewer.this.fCurrentSelection.getFirstElement()) instanceof INews) {
                    final INews news = (INews)element;
                    final String entity = INews.class.getName();
                    manager.add((IAction)new Action(Messages.NewsBrowserViewer_SIMILAR_CONTENT){

                        public void run() {
                            ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
                            String headline = CoreUtils.getHeadline((INews)news, (boolean)false);
                            ISearchField field = NewsBrowserViewer.this.fFactory.createSearchField(-1, entity);
                            ISearchCondition condition = NewsBrowserViewer.this.fFactory.createSearchCondition(field, SearchSpecifier.CONTAINS, (Object)headline);
                            conditions.add(condition);
                            NewsBrowserViewer.this.doSearch(conditions, true);
                        }
                    });
                    if (news.getAuthor() != null) {
                        String author;
                        IPerson person = news.getAuthor();
                        String name = person.getName();
                        String email = person.getEmail() != null ? person.getEmail().toASCIIString() : null;
                        String string = author = StringUtils.isSet((String)name) ? name : email;
                        if (StringUtils.isSet((String)author)) {
                            manager.add((IContributionItem)new Separator());
                            manager.add((IAction)new Action(NLS.bind((String)Messages.NewsBrowserViewer_AUTHORED_BY, (Object)NewsBrowserViewer.this.escapeForMenu(author))){

                                public void run() {
                                    ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
                                    ISearchField field = NewsBrowserViewer.this.fFactory.createSearchField(3, entity);
                                    ISearchCondition condition = NewsBrowserViewer.this.fFactory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)author);
                                    conditions.add(condition);
                                    NewsBrowserViewer.this.doSearch(conditions, false);
                                }
                            });
                        }
                    }
                    if (!news.getCategories().isEmpty()) {
                        if (news.getCategories().size() == 1) {
                            final String name = ((ICategory)news.getCategories().get(0)).getName();
                            if (StringUtils.isSet((String)name)) {
                                manager.add((IAction)new Action(NLS.bind((String)Messages.NewsBrowserViewer_CATEGORIZED_N, (Object)NewsBrowserViewer.this.escapeForMenu(name))){

                                    public void run() {
                                        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
                                        ISearchField field = NewsBrowserViewer.this.fFactory.createSearchField(12, entity);
                                        ISearchCondition condition = NewsBrowserViewer.this.fFactory.createSearchCondition(field, SearchSpecifier.IS, (Object)name);
                                        conditions.add(condition);
                                        NewsBrowserViewer.this.doSearch(conditions, false);
                                    }
                                });
                            }
                        } else {
                            MenuManager categoriesMenu = new MenuManager(Messages.NewsBrowserViewer_BY_CATEGORY);
                            for (ICategory category : news.getCategories()) {
                                final String name = category.getName();
                                if (!StringUtils.isSet((String)name)) continue;
                                categoriesMenu.add((IAction)new Action(NewsBrowserViewer.this.escapeForMenu(name)){

                                    public void run() {
                                        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
                                        ISearchField field = NewsBrowserViewer.this.fFactory.createSearchField(12, entity);
                                        ISearchCondition condition = NewsBrowserViewer.this.fFactory.createSearchCondition(field, SearchSpecifier.IS, (Object)name);
                                        conditions.add(condition);
                                        NewsBrowserViewer.this.doSearch(conditions, false);
                                    }
                                });
                            }
                            manager.add((IContributionItem)categoriesMenu);
                        }
                    }
                    if (!news.getLabels().isEmpty()) {
                        manager.add((IContributionItem)new Separator());
                        for (final ILabel label : news.getLabels()) {
                            manager.add((IAction)new Action(NLS.bind((String)Messages.NewsBrowserViewer_LABELED_N, (Object)NewsBrowserViewer.this.escapeForMenu(label.getName()))){

                                public void run() {
                                    ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(1);
                                    ISearchField field = NewsBrowserViewer.this.fFactory.createSearchField(15, entity);
                                    ISearchCondition condition = NewsBrowserViewer.this.fFactory.createSearchCondition(field, SearchSpecifier.IS, (Object)label.getName());
                                    conditions.add(condition);
                                    NewsBrowserViewer.this.doSearch(conditions, false);
                                }
                            });
                        }
                    }
                }
            }
        });
        this.fFindRelatedContextMenu = manager.createContextMenu((Control)this.fBrowser.getControl().getShell());
    }

    private String escapeForMenu(String str) {
        return StringUtils.replaceAll((String)str, (String)"&", (String)"&&");
    }

    private void doSearch(final List<ISearchCondition> conditions, final boolean useLowScoreFilter) {
        if (conditions.size() >= 1 && !this.fBrowser.getControl().isDisposed()) {
            this.delayInUI(new Runnable(){

                public void run() {
                    SearchNewsDialog dialog = new SearchNewsDialog(NewsBrowserViewer.this.fBrowser.getControl().getShell(), conditions, true, true);
                    dialog.setUseLowScoreFilter(useLowScoreFilter);
                    dialog.open();
                }
            });
        }
    }

    private boolean contained(INewsBin bin, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (element instanceof INews) {
            INews news = (INews)element;
            return news.getParentId() == bin.getId().longValue();
        }
        return false;
    }

    void setBlockRefresh(boolean block) {
        this.fBlockRefresh = block;
    }

    @Override
    public void handle(final String id, URI link) {
        String query = link.getQuery();
        boolean queryProvided = StringUtils.isSet((String)query);
        if (queryProvided) {
            query = URIUtils.urlDecode((String)query).trim();
            queryProvided = StringUtils.isSet((String)query);
        }
        if (queryProvided && MARK_READ_HANDLER_ID.equals(id)) {
            final List<INews> news = this.getNewsList(query);
            Runnable runnable = new Runnable(){

                public void run() {
                    INews.State newState = INews.State.READ;
                    boolean affectEquivalentNews = OwlUI.markReadDuplicates();
                    UndoStack.getInstance().addOperation(new NewsStateOperation(news, newState, affectEquivalentNews));
                    NewsBrowserViewer.this.fNewsDao.setState((Collection)news, newState, affectEquivalentNews, false);
                }
            };
            if (CBrowser.isMozillaRunningOnWindows()) {
                this.delayInUI(runnable);
            } else {
                runnable.run();
            }
        } else if (queryProvided && TOGGLE_READ_HANDLER_ID.equals(id)) {
            INews news = this.getNews(query);
            if (news != null) {
                this.blur(NewsBrowserLabelProvider.Dynamic.TOGGLE_READ_LINK.getId(news));
                INews.State newState = news.getState() == INews.State.READ ? INews.State.UNREAD : INews.State.READ;
                Set<INews> singleNewsSet = Collections.singleton(news);
                boolean affectEquivalentNews = newState != INews.State.UNREAD && OwlUI.markReadDuplicates();
                UndoStack.getInstance().addOperation(new NewsStateOperation(singleNewsSet, newState, affectEquivalentNews));
                this.fNewsDao.setState(singleNewsSet, newState, affectEquivalentNews, false);
                if (newState == INews.State.UNREAD) {
                    this.fMarkedUnreadByUserCache.add(news.getId());
                }
            }
        } else if (queryProvided && TOGGLE_STICKY_HANDLER_ID.equals(id)) {
            INews news = this.getNews(query);
            if (news != null) {
                this.blur(NewsBrowserLabelProvider.Dynamic.TOGGLE_STICKY_LINK.getId(news));
                if (this.isHeadlinesLayout()) {
                    this.blur(NewsBrowserLabelProvider.Dynamic.TINY_TOGGLE_STICKY_LINK.getId(news), true);
                }
                Set<INews> singleNewsSet = Collections.singleton(news);
                UndoStack.getInstance().addOperation(new StickyOperation(singleNewsSet, !news.isFlagged()));
                news.setFlagged(!news.isFlagged());
                Controller.getDefault().getSavedSearchService().forceQuickUpdate();
                DynamicDAO.saveAll(singleNewsSet);
            }
        } else if (queryProvided && ARCHIVE_HANDLER_ID.equals(id)) {
            INews news = this.getNews(query);
            if (news != null) {
                ArchiveNewsAction action = new ArchiveNewsAction((IStructuredSelection)new StructuredSelection((Object)news));
                action.run();
            }
        } else if (queryProvided && DELETE_HANDLER_ID.equals(id)) {
            INews news = this.getNews(query);
            if (news != null) {
                Set<INews> singleNewsSet = Collections.singleton(news);
                UndoStack.getInstance().addOperation(new NewsStateOperation(singleNewsSet, INews.State.HIDDEN, false));
                this.fNewsDao.setState(singleNewsSet, INews.State.HIDDEN, false, false);
            }
        } else if (queryProvided && LABELS_MENU_HANDLER_ID.equals(id)) {
            INews news = this.getNews(query);
            if (news != null) {
                this.blur(NewsBrowserLabelProvider.Dynamic.LABELS_MENU_LINK.getId(news));
                this.setSelection((ISelection)new StructuredSelection((Object)news));
                Point cursorLocation = this.fBrowser.getControl().getDisplay().getCursorLocation();
                cursorLocation.y += 16;
                this.fLabelsContextMenu.setLocation(cursorLocation);
                this.fLabelsContextMenu.setVisible(true);
            }
        } else if (queryProvided && (ATTACHMENTS_MENU_HANDLER_ID.equals(id) || ATTACHMENT_HANDLER_ID.equals(id))) {
            INews news = this.getNews(query);
            if (news != null) {
                if (ATTACHMENT_HANDLER_ID.equals(id)) {
                    this.blur(NewsBrowserLabelProvider.Dynamic.ATTACHMENT_LINK.getId(news));
                } else if (ATTACHMENTS_MENU_HANDLER_ID.equals(id)) {
                    this.blur(NewsBrowserLabelProvider.Dynamic.ATTACHMENTS_MENU_LINK.getId(news));
                }
                this.setSelection((ISelection)new StructuredSelection((Object)news));
                Point cursorLocation = this.fBrowser.getControl().getDisplay().getCursorLocation();
                cursorLocation.y += 16;
                this.fAttachmentsContextMenu.setLocation(cursorLocation);
                this.fAttachmentsContextMenu.setVisible(true);
            }
        } else if (queryProvided && (EXPAND_NEWS_HANDLER_ID.equals(id) || COLLAPSE_NEWS_HANDLER_ID.equals(id))) {
            INews news = this.getNews(query);
            if (news != null) {
                this.setNewsExpanded(news, EXPAND_NEWS_HANDLER_ID.equals(id));
                this.onUserInteraction();
            }
        } else if (queryProvided && (EXPAND_GROUP_HANDLER_ID.equals(id) || COLLAPSE_GROUP_HANDLER_ID.equals(id))) {
            long groupId = this.getId(query);
            List<Long> newsIds = this.fViewModel.getNewsIds(groupId);
            if (!newsIds.isEmpty()) {
                this.setGroupExpanded(groupId, newsIds, EXPAND_GROUP_HANDLER_ID.equals(id));
            }
        } else if (queryProvided && GROUP_MENU_HANDLER_ID.equals(id)) {
            EntityGroup group = this.getEntityGroup(query);
            if (group != null) {
                this.blur(NewsBrowserLabelProvider.Dynamic.GROUP_MENU_LINK.getId(group));
                this.setSelection((ISelection)new StructuredSelection((Object)group));
                Point cursorLocation = this.fBrowser.getControl().getDisplay().getCursorLocation();
                cursorLocation.y += 16;
                this.fNewsContextMenu.setLocation(cursorLocation);
                this.fNewsContextMenu.setVisible(true);
            }
        } else if (queryProvided && NEWS_MENU_HANDLER_ID.equals(id)) {
            INews news = this.getNews(query);
            if (news != null) {
                this.blur(NewsBrowserLabelProvider.Dynamic.NEWS_MENU_LINK.getId(news), true);
                this.blur(NewsBrowserLabelProvider.Dynamic.FOOTER_NEWS_MENU_LINK.getId(news), true);
                this.setSelection((ISelection)new StructuredSelection((Object)news));
                Point cursorLocation = this.fBrowser.getControl().getDisplay().getCursorLocation();
                cursorLocation.y += 16;
                this.fNewsContextMenu.setLocation(cursorLocation);
                this.fNewsContextMenu.setVisible(true);
            }
        } else if (queryProvided && SHARE_NEWS_MENU_HANDLER_ID.equals(id)) {
            INews news = this.getNews(query);
            if (news != null) {
                this.blur(NewsBrowserLabelProvider.Dynamic.SHARE_MENU_LINK.getId(news));
                this.setSelection((ISelection)new StructuredSelection((Object)news));
                Point cursorLocation = this.fBrowser.getControl().getDisplay().getCursorLocation();
                cursorLocation.y += 16;
                this.fShareNewsContextMenu.setLocation(cursorLocation);
                this.fShareNewsContextMenu.setVisible(true);
            }
        } else if (queryProvided && RELATED_NEWS_MENU_HANDLER_ID.equals(id)) {
            INews news = this.getNews(query);
            if (news != null) {
                this.blur(NewsBrowserLabelProvider.Dynamic.FIND_RELATED_MENU_LINK.getId(news));
                this.setSelection((ISelection)new StructuredSelection((Object)news));
                Point cursorLocation = this.fBrowser.getControl().getDisplay().getCursorLocation();
                cursorLocation.y += 16;
                this.fFindRelatedContextMenu.setLocation(cursorLocation);
                this.fFindRelatedContextMenu.setVisible(true);
            }
        } else if (NEXT_NEWS_HANDLER_ID.equals(id) || NEXT_UNREAD_NEWS_HANDLER_ID.equals(id) || PREVIOUS_NEWS_HANDLER_ID.equals(id) || PREVIOUS_UNREAD_NEWS_HANDLER_ID.equals(id)) {
            Runnable runnable = new Runnable(){

                public void run() {
                    NewsBrowserViewer.this.handleNavigateAction(id);
                }
            };
            if (CBrowser.isMozillaRunningOnWindows()) {
                this.delayInUI(runnable);
            } else {
                runnable.run();
            }
        } else if (TRANSFORM_HANDLER_ID.equals(id)) {
            INews news = this.getNews(query);
            if (news != null) {
                this.transformNews(news);
            }
        } else if (NEXT_PAGE_HANDLER_ID.equals(id)) {
            this.revealNextPage(true);
        } else if (SCROLL_NEXT_PAGE_HANDLER_ID.equals(id)) {
            Runnable runnable = new Runnable(){

                public void run() {
                    NewsBrowserViewer.this.revealNextPage(false);
                }
            };
            if (CBrowser.isMozillaRunningOnWindows()) {
                this.delayInUI(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void handleNavigateAction(final String id) {
        if (!this.isHeadlinesLayout() && this.fPageSize != 0 && (NEXT_NEWS_HANDLER_ID.equals(id) || NEXT_UNREAD_NEWS_HANDLER_ID.equals(id))) {
            long firstHiddenNewsId;
            boolean onlyUnread = NEXT_UNREAD_NEWS_HANDLER_ID.equals(id);
            int totalNewsCount = this.fViewModel.getNewsCount();
            int visibleNewsCount = this.fViewModel.getVisibleNewsCount();
            if (totalNewsCount != 0 && totalNewsCount > visibleNewsCount && (firstHiddenNewsId = this.fViewModel.getFirstHiddenNews(onlyUnread)) != -1L) {
                this.showSelection((ISelection)new StructuredSelection((Object)new NewsReference(firstHiddenNewsId)));
                return;
            }
        }
        this.delayInUI(new Runnable(){

            public void run() {
                NavigationActionFactory factory = new NavigationActionFactory();
                try {
                    NavigationActionFactory.NavigationActionType type = null;
                    if (NewsBrowserViewer.NEXT_NEWS_HANDLER_ID.equals(id)) {
                        type = NavigationActionFactory.NavigationActionType.NEXT_FEED_NEXT_NEWS;
                    } else if (NewsBrowserViewer.NEXT_UNREAD_NEWS_HANDLER_ID.equals(id)) {
                        type = NavigationActionFactory.NavigationActionType.NEXT_UNREAD_FEED_NEXT_UNREAD_NEWS;
                    } else if (NewsBrowserViewer.PREVIOUS_NEWS_HANDLER_ID.equals(id)) {
                        type = NavigationActionFactory.NavigationActionType.PREVIOUS_FEED_PREVIOUS_NEWS;
                    } else if (NewsBrowserViewer.PREVIOUS_UNREAD_NEWS_HANDLER_ID.equals(id)) {
                        type = NavigationActionFactory.NavigationActionType.PREVIOUS_UNREAD_FEED_PREVIOUS_UNREAD_NEWS;
                    }
                    if (type != null) {
                        factory.setInitializationData(null, null, type.getId());
                        IWorkbenchWindowActionDelegate action = (IWorkbenchWindowActionDelegate)factory.create();
                        action.run(null);
                    }
                }
                catch (CoreException coreException) {}
            }
        });
    }

    private void setNewsExpanded(INews news, boolean expanded) {
        this.setNewsExpanded(news, expanded, true);
    }

    private void setNewsExpanded(INews news, boolean expanded, boolean scrollIntoView) {
        INews item;
        long expandedNewsId;
        long groupId;
        boolean showHeadlinesSeparator;
        if (expanded == this.fViewModel.isNewsExpanded(news)) {
            return;
        }
        final StringBuilder js = new StringBuilder();
        String newsLink = CoreUtils.getLink((INews)news);
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TITLE_LINK.getId(news)).append(".blur(); "));
        String link = "rssowl://" + (expanded ? COLLAPSE_NEWS_HANDLER_ID : EXPAND_NEWS_HANDLER_ID) + "?" + news.getId();
        if (expanded && StringUtils.isSet((String)newsLink)) {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TITLE_LINK.getId(news)).append(".href = '" + URIUtils.toManaged((String)newsLink) + "'; "));
        } else {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TITLE_LINK.getId(news)).append(".href='").append(link).append("'; "));
        }
        if (expanded) {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TINY_TOGGLE_STICKY_LINK.getId(news))).append(".style.display='none'; ");
        } else {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TINY_TOGGLE_STICKY_LINK.getId(news))).append(".style.display='inline'; ");
        }
        if (expanded) {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.SUBTITLE_LINK.getId(news))).append(".style.display='none'; ");
        } else {
            StringBuilder subtitleContent = new StringBuilder();
            IBaseLabelProvider lp = this.getLabelProvider();
            if (lp instanceof NewsBrowserLabelProvider) {
                ((NewsBrowserLabelProvider)lp).fillSubtitle(subtitleContent, news, CoreUtils.getSortedLabels((INews)news), false);
            }
            if (subtitleContent.length() > 0) {
                js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.SUBTITLE_LINK.getId(news))).append(".innerHTML='").append(this.escapeForInnerHtml(subtitleContent.toString())).append("'; ");
            }
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.SUBTITLE_LINK.getId(news))).append(".style.display='inline'; ");
        }
        EnumSet<NewsBrowserLabelProvider.Dynamic> elements = EnumSet.of(NewsBrowserLabelProvider.Dynamic.SUBLINE, NewsBrowserLabelProvider.Dynamic.DELETE, NewsBrowserLabelProvider.Dynamic.CONTENT, NewsBrowserLabelProvider.Dynamic.FOOTER);
        for (NewsBrowserLabelProvider.Dynamic element : elements) {
            if (expanded) {
                js.append((CharSequence)this.getElementById(element.getId(news))).append(".style.display='block'; ");
                continue;
            }
            js.append((CharSequence)this.getElementById(element.getId(news))).append(".style.display='none'; ");
        }
        boolean bl = showHeadlinesSeparator = !expanded;
        if (this.isGroupingEnabled() && !this.fViewModel.isGroupExpanded(groupId = this.fViewModel.findGroup(news.getId()))) {
            showHeadlinesSeparator = false;
        }
        js.append("if (").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.HEADLINE_SEPARATOR.getId(news))).append(") {");
        if (showHeadlinesSeparator) {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.HEADLINE_SEPARATOR.getId(news))).append(".style.display='block'; ");
        } else {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.HEADLINE_SEPARATOR.getId(news))).append(".style.display='none'; ");
        }
        js.append("}");
        if (expanded) {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TITLE.getId(news))).append(".className='titleExpanded'; ");
        } else {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TITLE.getId(news))).append(".className='titleCollapsed'; ");
        }
        if (expanded) {
            this.fillNewsContent(news, js, newsLink);
        } else {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.CONTENT.getId(news)).append(".innerHTML = ''; "));
        }
        if (scrollIntoView && expanded) {
            this.scrollIfNecessary(news, js);
        }
        if (expanded && (expandedNewsId = this.fViewModel.getExpandedNews()) != -1L && (item = this.resolve(expandedNewsId)) != null) {
            this.setNewsExpanded(item, false);
        }
        this.fBrowser.blockExternalNavigationWhile(new Runnable(){

            public void run() {
                NewsBrowserViewer.this.fBrowser.execute(js.toString(), "setNewsExpanded");
            }
        });
        if (this.fMarkReadOnExpand && expanded && news.getState() != INews.State.READ && !this.isGroupingByState()) {
            Set<INews> singleNewsSet = Collections.singleton(news);
            boolean affectEquivalentNews = OwlUI.markReadDuplicates();
            UndoStack.getInstance().addOperation(new NewsStateOperation(singleNewsSet, INews.State.READ, affectEquivalentNews));
            this.fNewsDao.setState(singleNewsSet, INews.State.READ, affectEquivalentNews, false);
        }
        this.fViewModel.setNewsExpanded(news, expanded);
    }

    private void fillNewsContent(INews news, StringBuilder js, String newsLink) {
        String description = news.getDescription();
        if (StringUtils.isSet((String)description) && !description.equals(news.getTitle())) {
            IBaseLabelProvider labelProvider = this.getLabelProvider();
            if (labelProvider instanceof NewsBrowserLabelProvider) {
                description = ((NewsBrowserLabelProvider)labelProvider).stripMediaTagsIfNecessary(description);
                description = ((NewsBrowserLabelProvider)labelProvider).highlightSearchTermsIfNecessary(description);
            }
        } else {
            StringBuilder emptyDescription = new StringBuilder();
            emptyDescription.append(Messages.NewsBrowserViewer_NO_CONTENT);
            if (StringUtils.isSet((String)newsLink)) {
                String link = "rssowl://org.rssowl.ui.TransformNews?" + news.getId();
                emptyDescription.append(" <a href=\"").append(link).append("\">").append(Messages.NewsBrowserViewer_DOWNLOAD_CONTENT).append("</a>");
            }
            description = emptyDescription.toString();
        }
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.CONTENT.getId(news)).append(".innerHTML = '" + this.escapeForInnerHtml(description) + "'; "));
    }

    private void scrollIfNecessary(INews news, StringBuilder js) {
        if (this.fBrowser.isIE()) {
            js.append("var scrollPosY = document.body.scrollTop; ");
            js.append("var windowHeight = document.body.clientHeight; ");
        } else {
            js.append("var scrollPosY = window.pageYOffset; ");
            js.append("var windowHeight = window.innerHeight; ");
        }
        js.append("var divPosY = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(news))).append(".offsetTop; ");
        js.append("var divHeight = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(news))).append(".offsetHeight; ");
        js.append("if (scrollPosY > divPosY || divHeight > windowHeight) {");
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(news))).append(".scrollIntoView(true); ");
        js.append("} else if (scrollPosY + windowHeight < divPosY + divHeight) {");
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(news))).append(".scrollIntoView(false); ");
        js.append("}");
    }

    private void setGroupExpanded(long groupId, List<Long> newsIds, boolean expanded) {
        this.setGroupExpanded(groupId, newsIds, expanded, true);
    }

    private void setGroupExpanded(long groupId, List<Long> newsIds, boolean expanded, boolean scrollIntoView) {
        StringBuilder js = new StringBuilder();
        String newToggleImgUri = this.fBrowser.isIE() ? (expanded ? OwlUI.getImageUri("/icons/elcl16/expanded.gif", "expanded.gif") : OwlUI.getImageUri("/icons/elcl16/collapsed.gif", "collapsed.gif")) : (expanded ? ApplicationServer.getDefault().toResourceUrl("/icons/elcl16/expanded.gif") : ApplicationServer.getDefault().toResourceUrl("/icons/elcl16/collapsed.gif"));
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TOGGLE_GROUP_LINK.getId(groupId)).append(".blur(); "));
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.GROUP_MENU_LINK.getId(groupId)).append(".blur(); "));
        String toggleVisibilityLink = "rssowl://" + (expanded ? COLLAPSE_GROUP_HANDLER_ID : EXPAND_GROUP_HANDLER_ID) + "?" + groupId;
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TOGGLE_GROUP_LINK.getId(groupId)).append(".href='").append(toggleVisibilityLink).append("'; "));
        if (expanded) {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.GROUP_MENU_LINK.getId(groupId)).append(".href='").append("rssowl://org.rssowl.ui.GroupMenu?" + groupId).append("'; "));
        } else {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.GROUP_MENU_LINK.getId(groupId)).append(".href='").append(toggleVisibilityLink).append("'; "));
        }
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TOGGLE_GROUP_IMG.getId(groupId)).append(".src = '" + newToggleImgUri + "'; "));
        for (Long id : newsIds) {
            if (!this.fViewModel.isNewsVisible(id)) continue;
            if (expanded) {
                js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(id))).append(".style.display='block'; ");
            } else {
                js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(id))).append(".style.display='none'; ");
            }
            if (!this.isHeadlinesLayout()) continue;
            js.append("if (").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.HEADLINE_SEPARATOR.getId(id))).append(") {");
            if (expanded) {
                js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.HEADLINE_SEPARATOR.getId(id))).append(".style.display='block'; ");
            } else {
                js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.HEADLINE_SEPARATOR.getId(id))).append(".style.display='none'; ");
            }
            js.append("}");
        }
        if (scrollIntoView && expanded && !newsIds.isEmpty()) {
            if (this.fBrowser.isIE()) {
                js.append("var scrollPosY = document.body.scrollTop; ");
                js.append("var windowHeight = document.body.clientHeight; ");
            } else {
                js.append("var scrollPosY = window.pageYOffset; ");
                js.append("var windowHeight = window.innerHeight; ");
            }
            long lastVisibleNewsId = -1L;
            int i = newsIds.size() - 1;
            while (i >= 0) {
                if (this.fViewModel.isNewsVisible(newsIds.get(i))) {
                    lastVisibleNewsId = newsIds.get(i);
                    break;
                }
                --i;
            }
            if (lastVisibleNewsId != -1L) {
                js.append("var divPosY = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(lastVisibleNewsId))).append(".offsetTop; ");
                js.append("var divHeight = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(lastVisibleNewsId))).append(".offsetHeight; ");
                js.append("if (scrollPosY + windowHeight < divPosY + divHeight) {");
                js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TOGGLE_GROUP_IMG.getId(groupId))).append(".scrollIntoView(true); ");
                js.append("}");
            }
        }
        this.fBrowser.execute(js.toString(), "setGroupExpanded");
        this.fViewModel.setGroupExpanded(groupId, expanded);
    }

    private void blur(String elementId) {
        this.blur(elementId, false);
    }

    private void blur(String elementId, boolean guardNull) {
        StringBuilder js = new StringBuilder();
        if (guardNull) {
            js.append("if (").append((CharSequence)this.getElementById(elementId)).append(") {");
            js.append((CharSequence)this.getElementById(elementId).append(".blur();"));
            js.append("}");
        } else {
            js.append((CharSequence)this.getElementById(elementId).append(".blur();"));
        }
        this.fBrowser.execute(js.toString(), "blur");
    }

    private void transformNews(final INews news) {
        String link = CoreUtils.getLink((INews)news);
        if (!StringUtils.isSet((String)link)) {
            return;
        }
        StringBuilder js = new StringBuilder();
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.FULL_CONTENT_LINK_TEXT.getId(news)).append(".innerHTML='").append(this.escapeForInnerHtml(Messages.NewsBrowserViewer_LOADING)).append("'; "));
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.FULL_CONTENT_LINK.getId(news)).append(".blur(); "));
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.FULL_CONTENT_LINK.getId(news)).append(".style.fontStyle = 'italic'; "));
        this.fBrowser.execute(js.toString(), "transformNews");
        NewsReference reference = news.toReference();
        Job.getJobManager().cancel((Object)reference);
        final String transformedUrl = Controller.getDefault().getEmbeddedTransformedUrl(link);
        UIBackgroundJob transformationJob = new UIBackgroundJob((Control)this.fBrowser.getControl(), Messages.NewsBrowserViewer_RETRIEVING_ARTICLE_CONTENT, reference){
            StringBuilder result;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.result = new StringBuilder();
            }

            protected void runInBackground(IProgressMonitor monitor) {
                block17: {
                    try {
                        URI uri = new URI(transformedUrl);
                        IProtocolHandler handler = Owl.getConnectionService().getHandler(uri);
                        if (handler == null) break block17;
                        BufferedReader reader = null;
                        try {
                            try {
                                String line;
                                InputStream inS = handler.openStream(uri, monitor, null);
                                reader = new BufferedReader(new InputStreamReader(inS, "UTF-8"));
                                while (!monitor.isCanceled() && (line = reader.readLine()) != null) {
                                    this.result.append(line);
                                }
                            }
                            catch (IOException e) {
                                Activator.getDefault().logError(e.getMessage(), e);
                                monitor.setCanceled(true);
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException iOException) {
                                        monitor.setCanceled(true);
                                    }
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {
                                    monitor.setCanceled(true);
                                }
                            }
                            throw throwable;
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {
                                monitor.setCanceled(true);
                            }
                        }
                    }
                    catch (URISyntaxException e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                        monitor.setCanceled(true);
                    }
                    catch (ConnectionException e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                        monitor.setCanceled(true);
                    }
                }
            }

            protected void runInUI(IProgressMonitor monitor) {
                if (this.result.length() > 0 && !monitor.isCanceled() && !NewsBrowserViewer.this.fBrowser.getControl().isDisposed()) {
                    NewsBrowserViewer.this.showTransformation(news, this.result.toString());
                }
            }
        };
        JobRunner.runUIUpdater(transformationJob, true);
    }

    private void showTransformation(INews news, String result) {
        IBaseLabelProvider labelProvider;
        int index = result.indexOf("<div");
        if (index != -1 && index < 10) {
            StringBuilder inlineResult = new StringBuilder();
            inlineResult.append(result.substring(0, index += "<div".length()));
            inlineResult.append(" style=\"display: inline;\" ");
            inlineResult.append(result.substring(index));
            result = inlineResult.toString();
        }
        if ((labelProvider = this.getLabelProvider()) instanceof NewsBrowserLabelProvider) {
            result = ((NewsBrowserLabelProvider)labelProvider).stripMediaTagsIfNecessary(result);
            result = ((NewsBrowserLabelProvider)labelProvider).highlightSearchTermsIfNecessary(result);
        }
        final StringBuilder js = new StringBuilder();
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.CONTENT.getId(news)).append(".innerHTML='").append(this.escapeForInnerHtml(result)).append("'; "));
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.FULL_CONTENT_LINK.getId(news)).append(".style.fontStyle = 'normal'; "));
        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.FULL_CONTENT_LINK_TEXT.getId(news)).append(".innerHTML='").append(this.escapeForInnerHtml(Messages.NewsBrowserViewer_FULL_CONTENT)).append("'; "));
        this.scrollIfNecessary(news, js);
        this.fBrowser.blockExternalNavigationWhile(new Runnable(){

            public void run() {
                NewsBrowserViewer.this.fBrowser.execute(js.toString(), "showTransformation");
            }
        });
    }

    private String escapeForInnerHtml(String str) {
        StringBuilder result = new StringBuilder(str.length());
        BufferedReader reader = new BufferedReader(new StringReader(str));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                line = StringUtils.replaceAll((String)line, (String)"\"", (String)"\\\"");
                line = StringUtils.replaceAll((String)line, (String)"'", (String)"\\'");
                if (CBrowser.isMozillaRunningOnWindows()) {
                    line = StringUtils.replaceAll((String)line, (String)"%", (String)"%25");
                }
                result.append(line).append("\\n");
            }
        }
        catch (IOException iOException) {}
        return result.toString().trim();
    }

    private void revealNextPage(boolean scrollIntoView) {
        Pair<List<Long>, List<Long>> nextPage = this.fViewModel.getNextPage(this.fPageSize);
        List revealedGroups = (List)nextPage.getFirst();
        List revealedNews = (List)nextPage.getSecond();
        this.revealItems(revealedGroups, revealedNews, scrollIntoView);
    }

    private void revealItems(List<Long> revealedGroups, List<Long> revealedNews, boolean scrollIntoView) {
        long group;
        if (revealedNews.isEmpty()) {
            return;
        }
        final StringBuilder js = new StringBuilder();
        if (scrollIntoView) {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.PAGE_LATCH_LINK.getId()).append(".blur(); "));
        }
        if ((group = this.fViewModel.findGroup(revealedNews.get(0))) != -1L && this.fViewModel.isGroupVisible(group) && !this.fViewModel.isGroupExpanded(group)) {
            this.setGroupExpanded(group, this.fViewModel.getNewsIds(group), true, false);
        }
        for (Long groupId : revealedGroups) {
            if (this.fViewModel.isGroupVisible(groupId)) continue;
            this.fViewModel.setGroupVisible(groupId, true);
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.GROUP.getId(groupId))).append(".style.display='block'; ");
        }
        Long firstNewsId = null;
        for (Long newsId : revealedNews) {
            if (this.fViewModel.isNewsVisible(newsId)) continue;
            if (firstNewsId == null) {
                firstNewsId = newsId;
            }
            this.fViewModel.setNewsVisible(newsId, true);
            INews news = this.resolve(newsId);
            if (news == null) continue;
            final StringBuilder newsJs = new StringBuilder();
            String html = ((NewsBrowserLabelProvider)this.getLabelProvider()).getLabel(news, true, true, true, this.fViewModel.indexOfNewsItem(newsId));
            newsJs.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(newsId))).append(".style.display='block'; ");
            newsJs.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(newsId))).append(".innerHTML ='").append(this.escapeForInnerHtml(html)).append("'; ");
            if (this.isHeadlinesLayout()) {
                newsJs.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.HEADLINE_SEPARATOR.getId(newsId))).append(".style.display='block'; ");
            }
            this.fBrowser.blockExternalNavigationWhile(new Runnable(){

                public void run() {
                    NewsBrowserViewer.this.fBrowser.execute(newsJs.toString(), "revealItems#0");
                }
            });
        }
        if (firstNewsId != null && scrollIntoView) {
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(firstNewsId))).append(".scrollIntoView(true); ");
        }
        this.updateLatchIfNecessary(js);
        this.fBrowser.blockExternalNavigationWhile(new Runnable(){

            public void run() {
                NewsBrowserViewer.this.fBrowser.execute(js.toString(), "revealItems#1");
            }
        });
    }

    private void updateLatchIfNecessary(StringBuilder js) {
        if (this.fPageSize == 0) {
            return;
        }
        if (this.fViewModel.getVisibleNewsCount() == this.fViewModel.getNewsCount()) {
            js.append("var latch = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.PAGE_LATCH.getId())).append("; ");
            js.append("if (latch) {");
            js.append("  latch.style.display='none'; ");
            js.append("}");
        } else if (this.getLabelProvider() instanceof NewsBrowserLabelProvider) {
            String updatedLatchName = ((NewsBrowserLabelProvider)this.getLabelProvider()).getLatchName();
            js.append("var latch = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.PAGE_LATCH_TEXT.getId())).append("; ");
            js.append("if (latch) {");
            js.append("  latch.innerHTML='").append(this.escapeForInnerHtml(updatedLatchName)).append("'; ");
            js.append("}");
        }
    }

    private void delayInUI(Runnable runnable) {
        JobRunner.runInUIThread(0, true, (Widget)this.getControl(), runnable);
    }

    private long getId(String query) {
        return Long.parseLong(query);
    }

    private INews getNews(String query) {
        try {
            long id = this.getId(query);
            return this.resolve(id);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private List<INews> getNewsList(String query) {
        ArrayList<INews> news = new ArrayList<INews>();
        StringTokenizer tokenizer = new StringTokenizer(query, ",");
        while (tokenizer.hasMoreTokens()) {
            INews item;
            String nextElement = tokenizer.nextToken();
            if (!StringUtils.isSet((String)nextElement) || (item = this.getNews(nextElement)) == null) continue;
            news.add(item);
        }
        return news;
    }

    private EntityGroup getEntityGroup(String query) {
        long id = this.getId(query);
        List<Long> newsIds = this.fViewModel.getNewsIds(id);
        if (!newsIds.isEmpty()) {
            ArrayList<INews> news = new ArrayList<INews>(newsIds.size());
            for (Long newsId : newsIds) {
                try {
                    INews item = this.resolve(newsId);
                    if (item == null) continue;
                    news.add(item);
                }
                catch (NullPointerException nullPointerException) {}
            }
            EntityGroup group = new EntityGroup(id, "org.rssowl.ui.internal.editors.feed.NewsGrouping");
            for (INews item : news) {
                new EntityGroupItem(group, (IEntity)item);
            }
            return group;
        }
        return null;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fBlockRefresh = true;
        try {
            super.setLabelProvider(labelProvider);
        }
        finally {
            this.fBlockRefresh = false;
        }
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.fBlockRefresh = true;
        try {
            super.setContentProvider(contentProvider);
        }
        finally {
            this.fBlockRefresh = false;
        }
    }

    public void refresh() {
        if (!this.fBlockRefresh) {
            this.fBrowser.refresh();
            this.onRefresh();
        }
    }

    public void refresh(boolean restoreInput, boolean moveToTop) {
        if (restoreInput && !ApplicationServer.getDefault().isDisplayOperation(this.fBrowser.getControl().getUrl())) {
            this.internalSetInput(this.fInput, true, false);
        } else {
            if (moveToTop) {
                this.fBrowser.execute("scroll(0,0);", "refresh");
            }
            this.refresh();
        }
    }

    protected void onRefresh() {
    }

    protected void handleDispose(DisposeEvent event) {
        this.fServer.unregister(this.fId);
        this.fCurrentSelection = null;
        OwlUI.safeDispose(this.fNewsContextMenu);
        OwlUI.safeDispose(this.fAttachmentsContextMenu);
        OwlUI.safeDispose(this.fLabelsContextMenu);
        OwlUI.safeDispose(this.fShareNewsContextMenu);
        OwlUI.safeDispose(this.fFindRelatedContextMenu);
        super.handleDispose(event);
    }

    public void setInput(Object input) {
        this.setInput(input, false);
    }

    public void setInput(Object input, boolean blockExternalNavigation) {
        this.internalSetInput(input, false, blockExternalNavigation);
    }

    void onLayoutChanged(OwlUI.Layout newLayout) {
        if (this.fSite == null) {
            return;
        }
        this.fPageSize = newLayout == OwlUI.Layout.HEADLINES || newLayout == OwlUI.Layout.NEWSPAPER ? OwlUI.getPageSize(this.fSite.getInputPreferences()).getPageSize() : OwlUI.PageSize.NO_PAGING.getPageSize();
        this.fMarkReadOnScrolling = newLayout == OwlUI.Layout.NEWSPAPER && this.fSite.getInputPreferences().getBoolean(DefaultPreferences.MARK_READ_ON_SCROLLING);
    }

    private void internalSetInput(Object input, boolean force, boolean blockExternalNavigation) {
        String url;
        if (!force && this.sameInput(input)) {
            return;
        }
        this.fInput = input;
        this.fMarkedUnreadByUserCache.clear();
        if (this.fSite != null) {
            IPreferenceScope inputPreferences = this.fSite.getInputPreferences();
            this.fMarkReadOnExpand = inputPreferences.getBoolean(DefaultPreferences.MARK_READ_STATE);
            OwlUI.Layout layout = OwlUI.getLayout(inputPreferences);
            this.onLayoutChanged(layout);
        }
        if (!"".equals(url = this.fBrowser.getControl().getUrl())) {
            this.fBrowser.getControl().stop();
        }
        if (input instanceof String) {
            this.fBrowser.setUrl((String)input, !blockExternalNavigation);
            return;
        }
        String inputUrl = this.fServer.toUrl(this.fId, input);
        if (this.fServer.isDisplayOperation(inputUrl) && !inputUrl.equals(url)) {
            this.fBrowser.setUrl(inputUrl);
        }
        if (input == null && this.fBrowser.getControl().getVisible()) {
            this.fBrowser.getControl().setVisible(false);
        }
    }

    private boolean sameInput(Object input) {
        if (this.fInput instanceof Object[]) {
            return input instanceof Object[] && Arrays.equals((Object[])this.fInput, (Object[])input);
        }
        if (this.fInput != null) {
            return this.fInput.equals(input);
        }
        return false;
    }

    public Object getInput() {
        return this.fInput;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList<ViewerFilter>();
        }
        this.fFilters.add(filter);
        if (filter instanceof NewsFilter) {
            this.fNewsFilter = (NewsFilter)filter;
        }
    }

    public void removeFilter(ViewerFilter filter) {
        Assert.isNotNull((Object)filter);
        if (this.fFilters != null) {
            Iterator<ViewerFilter> i = this.fFilters.iterator();
            while (i.hasNext()) {
                ViewerFilter o = i.next();
                if (o != filter) continue;
                i.remove();
                this.refresh();
                if (this.fFilters.size() == 0) {
                    this.fFilters = null;
                }
                return;
            }
        }
        if (filter == this.fNewsFilter) {
            this.fNewsFilter = null;
        }
    }

    public void setComparator(ViewerComparator comparator) {
        if (this.fSorter != comparator) {
            this.fSorter = comparator;
        }
    }

    public Control getControl() {
        return this.fBrowser.getControl();
    }

    public CBrowser getBrowser() {
        return this.fBrowser;
    }

    public ISelection getSelection() {
        return this.fCurrentSelection;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.fCurrentSelection = (IStructuredSelection)selection;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
    }

    void showSelection(ISelection selection) {
        if (!(selection instanceof StructuredSelection) || selection.isEmpty()) {
            return;
        }
        NewsReference newsToShow = null;
        Object firstElement = ((StructuredSelection)selection).getFirstElement();
        if (firstElement instanceof INews) {
            newsToShow = ((INews)firstElement).toReference();
        } else if (firstElement instanceof NewsReference) {
            newsToShow = (NewsReference)firstElement;
        }
        if (newsToShow != null) {
            Pair<List<Long>, List<Long>> itemsToReveal = this.fViewModel.revealPage(newsToShow.getId(), this.fPageSize);
            this.revealItems((List)itemsToReveal.getFirst(), (List)itemsToReveal.getSecond(), false);
            if (this.isHeadlinesLayout()) {
                INews news = this.resolve(newsToShow.getId());
                if (news != null) {
                    this.setNewsExpanded(news, true);
                }
            } else {
                StringBuilder js = new StringBuilder();
                js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(newsToShow))).append(".scrollIntoView(true);");
                this.fBrowser.execute(js.toString(), "showSelection");
            }
        }
    }

    void navigate(boolean next, boolean unread, boolean onInputSet) {
        if (this.isHeadlinesLayout()) {
            this.navigateInHeadlines(next, unread);
        } else {
            this.navigateInNewspaper(next, unread, onInputSet);
        }
    }

    private void navigateInNewspaper(boolean next, boolean unread, boolean onInputSet) {
        if (unread && onInputSet && this.fViewModel.isFirstItemUnread()) {
            return;
        }
        StringBuilder js = new StringBuilder();
        if (this.fBrowser.isIE()) {
            js.append("var scrollPosY = document.body.scrollTop; ");
        } else {
            js.append("var scrollPosY = window.pageYOffset; ");
        }
        js.append("var body = ").append((CharSequence)this.getElementById(BODY_ELEMENT_ID)).append("; ");
        js.append("var divs = body.childNodes; ");
        if (next) {
            js.append("  for (var i = 1; i < divs.length; i++) { ");
            js.append("    if (divs[i].nodeType != 1) { ");
            js.append("      continue; ");
            js.append("    } ");
            js.append("    var divPosY = divs[i].offsetTop; ");
            if (unread) {
                js.append("  if (divPosY > scrollPosY + 15 && divs[i].className == \"newsitemUnread\") { ");
            } else {
                js.append("  if (divPosY > scrollPosY + 15 && (divs[i].className == \"newsitemUnread\" || divs[i].className == \"newsitemRead\")) { ");
            }
            js.append("      divs[i].scrollIntoView(true); ");
            js.append("      break; ");
            js.append("    } ");
            js.append("  } ");
        } else {
            js.append("  for (var i = divs.length - 1; i >= 0; i--) { ");
            js.append("    if (divs[i].nodeType != 1) { ");
            js.append("      continue; ");
            js.append("    } ");
            js.append("    var divPosY = divs[i].offsetTop; ");
            if (unread) {
                js.append("  if (divPosY < scrollPosY - 15 && divs[i].className == \"newsitemUnread\") { ");
            } else {
                js.append("  if (divPosY < scrollPosY - 15 && (divs[i].className == \"newsitemUnread\" || divs[i].className == \"newsitemRead\")) { ");
            }
            js.append("      divs[i].scrollIntoView(true); ");
            js.append("      break; ");
            js.append("    } ");
            js.append("  } ");
        }
        if (this.fBrowser.isIE()) {
            js.append("var newScrollPosY = document.body.scrollTop; ");
        } else {
            js.append("var newScrollPosY = window.pageYOffset; ");
        }
        if (unread || this.fViewModel.hasItems()) {
            js.append("if (scrollPosY == newScrollPosY) { ");
            js.append("  window.location.href = '").append("rssowl://" + this.getNavigationActionId(next, unread)).append("'; ");
            js.append("} ");
        }
        this.fBrowser.execute(js.toString(), "navigateInNewspaper");
        this.onUserInteraction();
    }

    private void navigateInHeadlines(boolean next, boolean unread) {
        long targetNews = -1L;
        long offset = this.fViewModel.getExpandedNews();
        targetNews = next ? this.fViewModel.nextNews(unread, offset) : this.fViewModel.previousNews(unread, offset);
        if (targetNews != -1L) {
            List<Long> newsIds;
            Pair<List<Long>, List<Long>> itemsToReveal = this.fViewModel.revealPage(targetNews, this.fPageSize);
            this.revealItems((List)itemsToReveal.getFirst(), (List)itemsToReveal.getSecond(), false);
            long groupId = this.fViewModel.findGroup(targetNews);
            if (groupId != -1L && !this.fViewModel.isGroupExpanded(groupId) && !(newsIds = this.fViewModel.getNewsIds(groupId)).isEmpty()) {
                this.setGroupExpanded(groupId, newsIds, true, false);
            }
            this.setNewsExpanded(this.resolve(targetNews), true, false);
            StringBuilder js = new StringBuilder();
            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(targetNews))).append(".scrollIntoView(true); ");
            this.fBrowser.execute(js.toString(), "navigateInHeadlines#0");
            this.onUserInteraction();
        } else if (unread || this.fViewModel.hasItems()) {
            StringBuilder js = new StringBuilder();
            js.append("window.location.href = '").append("rssowl://" + this.getNavigationActionId(next, unread)).append("'; ");
            this.fBrowser.execute(js.toString(), "navigateInHeadlines#1");
        }
    }

    private String getNavigationActionId(boolean next, boolean unread) {
        if (next) {
            if (unread) {
                return NEXT_UNREAD_NEWS_HANDLER_ID;
            }
            return NEXT_NEWS_HANDLER_ID;
        }
        if (unread) {
            return PREVIOUS_UNREAD_NEWS_HANDLER_ID;
        }
        return PREVIOUS_NEWS_HANDLER_ID;
    }

    public void home() {
        this.internalSetInput(this.fInput, true, false);
    }

    ViewerComparator getComparator() {
        return this.fSorter;
    }

    private Object[] getSortedChildren(Object parent) {
        Object[] result = this.getFilteredChildren(parent);
        if (this.fSorter != null) {
            result = (Object[])result.clone();
            this.fSorter.sort((Viewer)this, result);
        }
        return result;
    }

    private Object[] getFilteredChildren(Object parent) {
        Object[] result = this.getRawChildren(parent);
        if (this.fInput instanceof INews) {
            return result;
        }
        if (this.fFilters != null) {
            Iterator<ViewerFilter> iterator = this.fFilters.iterator();
            while (iterator.hasNext()) {
                ViewerFilter filter;
                ViewerFilter f = filter = iterator.next();
                result = f.filter((Viewer)this, parent, result);
            }
        }
        return result;
    }

    private Object[] getRawChildren(Object parent) {
        IStructuredContentProvider cp;
        Object[] result = null;
        if (parent != null && (cp = (IStructuredContentProvider)this.getContentProvider()) != null) {
            result = cp.getElements(parent);
        }
        return result != null ? result : new Object[]{};
    }

    public void updateViewModel(Object[] input) {
        this.fViewModel.setInput(input, this.fPageSize);
    }

    public Object[] getFlattendChildren(Object input) {
        return this.getFlattendChildren(input, true);
    }

    public Object[] getFlattendChildren(Object input, boolean withGroups) {
        if (input != null && this.getContentProvider() instanceof NewsContentProvider) {
            NewsContentProvider cp = (NewsContentProvider)this.getContentProvider();
            if (cp.isGroupingEnabled() && !this.isNews(input)) {
                Object[] groups;
                ArrayList<Object> flatList = new ArrayList<Object>();
                if (!(input instanceof Object[])) {
                    input = new Object[]{input};
                }
                int newsCount = 0;
                Object[] objectArray = groups = (Object[])input;
                int n = groups.length;
                int n2 = 0;
                while (n2 < n) {
                    Object group = objectArray[n2];
                    if (cp.hasChildren(group)) {
                        Object[] sortedChilds = this.getSortedChildren(group);
                        if (sortedChilds.length > 0) {
                            if (withGroups) {
                                flatList.add(group);
                            }
                            if (group instanceof EntityGroup) {
                                ((EntityGroup)group).setSizeHint(sortedChilds.length);
                            }
                            flatList.addAll(Arrays.asList(sortedChilds));
                            newsCount += sortedChilds.length;
                        }
                    } else if (withGroups) {
                        flatList.add(group);
                    }
                    ++n2;
                }
                return this.fillPagingIfNecessary(flatList.toArray(), newsCount);
            }
            return this.fillPagingIfNecessary(this.getSortedChildren(input));
        }
        if (input != null && this.getContentProvider() instanceof IStructuredContentProvider) {
            return this.getSortedChildren(input);
        }
        return new Object[0];
    }

    private Object[] fillPagingIfNecessary(Object[] elements) {
        return this.fillPagingIfNecessary(elements, elements.length);
    }

    private Object[] fillPagingIfNecessary(Object[] elements, int newsCount) {
        if (this.fPageSize == 0 || newsCount <= this.fPageSize) {
            return elements;
        }
        Object[] elementsWithPaging = new Object[elements.length + 1];
        System.arraycopy(elements, 0, elementsWithPaging, 0, elements.length);
        elementsWithPaging[elements.length] = new PageLatch();
        return elementsWithPaging;
    }

    private boolean isNews(Object input) {
        if (input instanceof Object[]) {
            Object[] elements;
            Object[] objectArray = elements = (Object[])input;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (!(element instanceof INews)) {
                    return false;
                }
                ++n2;
            }
        } else if (!(input instanceof INews)) {
            return false;
        }
        return true;
    }

    public void add(Object parentElement, Object[] childElements) {
        Assert.isNotNull((Object)parentElement);
        this.assertElementsNotNull(childElements);
        if (childElements.length > 0) {
            this.refresh();
        }
    }

    public void update(Collection<NewsEvent> news) {
        boolean resetInput;
        String inputUrl = this.fServer.toUrl(this.fId, this.fInput);
        String browserUrl = this.fBrowser.getControl().getUrl();
        boolean bl = resetInput = browserUrl.length() == 0 || "about:blank".equals(browserUrl);
        if (inputUrl.equals(browserUrl)) {
            if (!this.internalUpdate(news)) {
                this.refresh();
            }
        } else if (this.fServer.isDisplayOperation(inputUrl) && resetInput) {
            this.fBrowser.setUrl(inputUrl);
        }
    }

    public void remove(Object[] objects) {
        this.assertElementsNotNull(objects);
        if (!this.internalRemove(objects)) {
            this.refresh();
        }
    }

    public void remove(Object element) {
        Assert.isNotNull((Object)element);
        if (!this.internalRemove(new Object[]{element})) {
            this.refresh();
        }
    }

    private boolean internalUpdate(Collection<NewsEvent> newsEvents) {
        boolean toggleJS = this.fBrowser.shouldDisableScript();
        try {
            if (toggleJS) {
                this.fBrowser.setScriptDisabled(false);
            }
            for (NewsEvent newsEvent : newsEvents) {
                boolean res;
                INews news = newsEvent.getEntity();
                if (!this.fViewModel.isNewsVisible(news) || news.getId() == null || !this.fViewModel.hasNews(news.getId())) continue;
                StringBuilder js = new StringBuilder();
                if (CoreUtils.isStateChange((NewsEvent)newsEvent)) {
                    String markRead = Messages.NewsBrowserViewer_MARK_READ;
                    String markUnread = Messages.NewsBrowserViewer_MARK_UNREAD;
                    boolean isRead = INews.State.READ == news.getState();
                    js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(news)).append(isRead ? ".className='newsitemRead'; " : ".className='newsitemUnread'; "));
                    js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TITLE_LINK.getId(news)).append(isRead ? ".className='read'; " : ".className='unread'; "));
                    js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TOGGLE_READ_LINK.getId(news)).append(isRead ? ".title='" + markUnread + "'; " : ".title='" + markRead + "'; "));
                    js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TOGGLE_READ_IMG.getId(news)).append(isRead ? ".alt='" + markUnread + "'; " : ".alt='" + markRead + "'; "));
                }
                if (CoreUtils.isStickyStateChange((NewsEvent)newsEvent)) {
                    boolean isSticky = news.isFlagged();
                    js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.HEADER.getId(news)).append(isSticky ? ".className='headerSticky'; " : ".className='header'; "));
                    js.append("var footer = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.FOOTER.getId(news))).append("; ");
                    js.append("if (footer) {");
                    js.append("  footer").append(isSticky ? ".className='footerSticky'; " : ".className='footer'; ");
                    js.append("}");
                    String stickyImgUri = this.fBrowser.isIE() ? (isSticky ? OwlUI.getImageUri("/icons/obj16/news_pinned_light.gif", "news_pinned_light.gif") : OwlUI.getImageUri("/icons/obj16/news_pin_light.gif", "news_pin_light.gif")) : (isSticky ? ApplicationServer.getDefault().toResourceUrl("/icons/obj16/news_pinned_light.gif") : ApplicationServer.getDefault().toResourceUrl("/icons/obj16/news_pin_light.gif"));
                    js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TOGGLE_STICKY_IMG.getId(news)).append(".src='").append(stickyImgUri).append("'; "));
                }
                if (CoreUtils.isLabelChange((NewsEvent)newsEvent)) {
                    String color;
                    Set labels = CoreUtils.getSortedLabels((INews)news);
                    String defaultColor = CoreUtils.getLink((INews)news) != null && !this.isHeadlinesLayout() ? "#009" : "rgb(0,0,0)";
                    String string = color = labels.isEmpty() ? defaultColor : "rgb(" + OwlUI.toString(OwlUI.getRGB((ILabel)labels.iterator().next())) + ")";
                    if ("rgb(0,0,0)".equals(color)) {
                        color = defaultColor;
                    }
                    js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.TITLE_LINK.getId(news)).append(".style.color='").append(color).append("'; "));
                    if (labels.isEmpty()) {
                        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.LABELS_SEPARATOR.getId(news)).append(".style.display='none'; "));
                        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.LABELS.getId(news)).append(".innerHTML=''; "));
                    } else {
                        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.LABELS_SEPARATOR.getId(news)).append(".style.display='inline'; "));
                        StringBuilder labelsHtml = new StringBuilder(Messages.NewsBrowserViewer_LABELS);
                        labelsHtml.append(" ");
                        int c = 0;
                        for (ILabel label : labels) {
                            if (++c < labels.size()) {
                                this.span(labelsHtml, String.valueOf(StringUtils.htmlEscape((String)label.getName())) + ", ", label.getColor());
                                continue;
                            }
                            this.span(labelsHtml, StringUtils.htmlEscape((String)label.getName()), label.getColor());
                        }
                        js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.LABELS.getId(news)).append(".innerHTML='").append(this.escapeForInnerHtml(labelsHtml.toString())).append("'; "));
                    }
                    if (this.isHeadlinesLayout() && !this.fViewModel.isNewsExpanded(news)) {
                        StringBuilder subtitleContent = new StringBuilder();
                        IBaseLabelProvider lp = this.getLabelProvider();
                        if (lp instanceof NewsBrowserLabelProvider) {
                            ((NewsBrowserLabelProvider)lp).fillSubtitle(subtitleContent, news, labels, false);
                        }
                        if (subtitleContent.length() > 0) {
                            js.append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.SUBTITLE_LINK.getId(news))).append(".innerHTML='").append(this.escapeForInnerHtml(subtitleContent.toString())).append("'; ");
                        }
                    }
                }
                if (js.length() <= 0 || (res = this.fBrowser.execute(js.toString(), false, "internalUpdate"))) continue;
                return false;
            }
        }
        finally {
            if (toggleJS) {
                this.fBrowser.setScriptDisabled(true);
            }
        }
        return true;
    }

    private void span(StringBuilder builder, String content, String color) {
        builder.append("<span style=\"color: rgb(").append(color).append(");\"");
        builder.append(">").append(content).append("</span>");
    }

    private StringBuilder getElementById(String id) {
        return new StringBuilder("document.getElementById('" + id + "')");
    }

    private boolean internalRemove(Object[] elements) {
        StringBuilder js = new StringBuilder();
        js.append("var body = ").append((CharSequence)this.getElementById(BODY_ELEMENT_ID)).append("; ");
        boolean varDefined = false;
        HashSet<Long> groupsToUpdate = new HashSet<Long>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            INews news;
            Object element = objectArray[n2];
            if (element instanceof INews && (news = (INews)element).getId() != null && this.fViewModel.hasNews(news.getId())) {
                long groupToUpdate = this.fViewModel.removeNews(news);
                if (groupToUpdate != -1L) {
                    groupsToUpdate.add(groupToUpdate);
                }
                if (!varDefined) {
                    js.append("var ");
                    varDefined = true;
                }
                js.append("node = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.NEWS.getId(news))).append("; ");
                js.append("if (node && node.parentNode == body) { ");
                js.append("  body.removeChild(node); ");
                js.append("} else if (node) { ");
                js.append("  node.className='hidden';");
                js.append("} ");
                if (this.isHeadlinesLayout()) {
                    js.append("node = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.HEADLINE_SEPARATOR.getId(news))).append("; ");
                    js.append("if (node && node.parentNode == body) { ");
                    js.append("  body.removeChild(node); ");
                    js.append("} else if (node) {");
                    js.append("  node.className='hidden';");
                    js.append("} ");
                }
            }
            ++n2;
        }
        IBaseLabelProvider labelProvider = this.getLabelProvider();
        for (Long groupId : groupsToUpdate) {
            if (!varDefined) {
                js.append("var ");
                varDefined = true;
            }
            if (!this.fViewModel.hasGroup(groupId)) {
                js.append("node = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.GROUP.getId(groupId))).append("; ");
                js.append("if (node && node.parentNode == body) { ");
                js.append("  body.removeChild(node); ");
                js.append("} else if (node) { ");
                js.append("  node.className='hidden';");
                js.append("} ");
                continue;
            }
            if (!(labelProvider instanceof NewsBrowserLabelProvider)) continue;
            int count = this.fViewModel.getGroupSize(groupId);
            NewsBrowserLabelProvider browserLabelProvider = (NewsBrowserLabelProvider)labelProvider;
            String groupNote = browserLabelProvider.getGroupNote(count, count);
            js.append("node = ").append((CharSequence)this.getElementById(NewsBrowserLabelProvider.Dynamic.GROUP_NOTE.getId(groupId))).append("; ");
            js.append("if (node) { ");
            js.append("  node.innerHTML = '").append(this.escapeForInnerHtml(groupNote)).append("'; ");
            js.append("} ");
        }
        this.updateLatchIfNecessary(js);
        return this.fBrowser.execute(js.toString(), "internalRemove");
    }

    private void assertElementsNotNull(Object[] elements) {
        Assert.isNotNull((Object)elements);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Assert.isNotNull((Object)element);
            ++n2;
        }
    }

    protected Collection<String> getHighlightedWords() {
        if (this.getContentProvider() instanceof NewsContentProvider && this.fPreferences.getBoolean(DefaultPreferences.FV_HIGHLIGHT_SEARCH_RESULTS)) {
            HashSet<String> extractedWords;
            INewsMark mark = ((NewsContentProvider)this.getContentProvider()).getInput();
            if (mark instanceof ISearch) {
                List conditions = ((ISearch)mark).getSearchConditions();
                extractedWords = CoreUtils.extractWords((List)conditions);
            } else {
                extractedWords = new HashSet(1);
            }
            if (this.fNewsFilter != null && StringUtils.isSet((String)this.fNewsFilter.getPatternString())) {
                String pattern = this.fNewsFilter.getPatternString();
                if (StringUtils.supportsTrailingWildcards((String)pattern)) {
                    pattern = String.valueOf(pattern) + "*";
                }
                extractedWords.addAll(CoreUtils.extractWords((String)pattern));
            }
            return extractedWords;
        }
        return Collections.emptyList();
    }

    NewsBrowserViewModel getViewModel() {
        return this.fViewModel;
    }

    private boolean isGroupingEnabled() {
        IContentProvider cp = this.getContentProvider();
        if (cp instanceof NewsContentProvider) {
            return ((NewsContentProvider)cp).isGroupingEnabled();
        }
        return false;
    }

    private boolean isGroupingByState() {
        IContentProvider cp = this.getContentProvider();
        if (cp instanceof NewsContentProvider) {
            return ((NewsContentProvider)cp).isGroupingByState();
        }
        return false;
    }

    private boolean isHeadlinesLayout() {
        IBaseLabelProvider lp = this.getLabelProvider();
        if (lp instanceof NewsBrowserLabelProvider) {
            return ((NewsBrowserLabelProvider)lp).isHeadlinesOnly();
        }
        return false;
    }

    INews resolve(long newsId) {
        INews news = null;
        if (this.getContentProvider() instanceof NewsContentProvider) {
            news = ((NewsContentProvider)this.getContentProvider()).obtainFromCache(newsId);
        }
        if (news == null) {
            return (INews)this.fNewsDao.load(newsId);
        }
        return news;
    }

    static final class PageLatch {
        PageLatch() {
        }
    }

    final class UserInteractionTask
    implements ITask {
        private final NewsBrowserViewModel fViewModel;
        private final CBrowser fCBrowser;

        public UserInteractionTask(NewsBrowserViewModel model, CBrowser browser) {
            this.fViewModel = model;
            this.fCBrowser = browser;
        }

        public IStatus run(IProgressMonitor monitor) {
            long lastVisibleNewsId;
            if (monitor.isCanceled() || this.fCBrowser.getControl().isDisposed()) {
                return Status.OK_STATUS;
            }
            if (NewsBrowserViewer.this.fPageSize != 0 && this.fViewModel.hasHiddenNews() && (lastVisibleNewsId = this.fViewModel.getLastVisibleNews()) != -1L) {
                StringBuilder js = new StringBuilder();
                if (this.fCBrowser.isIE()) {
                    js.append("var scrollPosY = document.body.scrollTop; ");
                    js.append("var windowHeight = document.body.clientHeight; ");
                } else {
                    js.append("var scrollPosY = window.pageYOffset; ");
                    js.append("var windowHeight = window.innerHeight; ");
                }
                js.append("if (scrollPosY > 0) {");
                js.append("  var node = document.getElementById('").append(NewsBrowserLabelProvider.Dynamic.NEWS.getId(lastVisibleNewsId)).append("'); ");
                js.append("  if (node) {");
                js.append("    if ((scrollPosY + windowHeight) >= node.offsetTop) {");
                js.append("      window.location.href = '").append("rssowl://org.rssowl.ui.ScrollNextPage").append("'; ");
                js.append("    }");
                js.append("  }");
                js.append("}");
                if (!monitor.isCanceled() && !this.fCBrowser.getControl().isDisposed()) {
                    this.fCBrowser.execute(js.toString(), "UserInteractionTask#0");
                }
            }
            if (monitor.isCanceled() || this.fCBrowser.getControl().isDisposed()) {
                return Status.OK_STATUS;
            }
            if (NewsBrowserViewer.this.fMarkReadOnScrolling && !NewsBrowserViewer.this.isGroupingByState()) {
                StringBuilder js = new StringBuilder();
                if (this.fCBrowser.isIE()) {
                    js.append("var scrollPosY = document.body.scrollTop; ");
                    js.append("var windowHeight = document.body.clientHeight; ");
                } else {
                    js.append("var scrollPosY = window.pageYOffset; ");
                    js.append("var windowHeight = window.innerHeight; ");
                }
                boolean varDefined = false;
                List<Long> visibleUnreadNews = this.fViewModel.getVisibleUnreadNews();
                long lastNews = this.fViewModel.getLastNews();
                js.append("var lastNews = document.getElementById('").append(NewsBrowserLabelProvider.Dynamic.NEWS.getId(lastNews)).append("'); ");
                js.append("if (lastNews) {");
                js.append("  var newsIds = ''; ");
                js.append("  var lastNewsPosY = lastNews.offsetTop; ");
                js.append("  var lastNewsHeight = lastNews.offsetHeight; ");
                for (Long id : visibleUnreadNews) {
                    if (NewsBrowserViewer.this.fMarkedUnreadByUserCache.contains(id)) continue;
                    if (!varDefined) {
                        js.append("var ");
                        varDefined = true;
                    }
                    js.append("node = document.getElementById('").append(NewsBrowserLabelProvider.Dynamic.NEWS.getId(id)).append("'); ");
                    js.append("  if (node) {");
                    js.append("    var divPosY = node.offsetTop; ");
                    js.append("    var divHeight = node.offsetHeight; ");
                    js.append("    if (divPosY < scrollPosY || (lastNewsPosY > 0 && lastNewsPosY < scrollPosY + windowHeight)) {");
                    js.append("      newsIds = newsIds + '").append(id).append(",'; ");
                    js.append("    }");
                    js.append("  }");
                }
                js.append("  if (newsIds.length != 0) { ");
                js.append("    window.location.href = '").append("rssowl://org.rssowl.ui.MarkRead?").append("' + newsIds; ");
                js.append("  } ");
                js.append("}");
                if (!monitor.isCanceled() && !this.fCBrowser.getControl().isDisposed()) {
                    this.fCBrowser.execute(js.toString(), "UserInteractionTask#1");
                }
            }
            return Status.OK_STATUS;
        }

        public String getName() {
            return null;
        }

        public ITask.Priority getPriority() {
            return ITask.Priority.INTERACTIVE;
        }
    }
}

