/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.ICategoryDAO;
import org.rssowl.core.persist.dao.ILabelDAO;
import org.rssowl.core.persist.dao.IPersonDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.importer.Messages;
import org.rssowl.ui.internal.dialogs.welcome.WelcomeWizard;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

public class ImportSourcePage
extends WizardPage {
    private static final int MAX_REMEMBER_SOURCES = 20;
    private Button fImportFromResourceRadio;
    private Combo fResourceInput;
    private Button fBrowseFileButton;
    private Button fImportFromKeywordRadio;
    private Combo fKeywordInput;
    private Button fImportGoogleReaderRadio;
    private Button fImportFromRecommendedRadio;
    private Button fImportNoneRadio;
    private IPreferenceScope fPreferences;
    private boolean fIsAutoCompleteKeywordHooked;
    private final String fFileOrWebsite;
    private final boolean fIsKewordSearch;
    private Button fLocalizedFeedSearch;

    ImportSourcePage(String fileOrWebsite, boolean isKewordSearch) {
        super(Messages.ImportSourcePage_CHOOSE_SOURCE, Messages.ImportSourcePage_CHOOSE_SOURCE, null);
        this.fFileOrWebsite = fileOrWebsite;
        this.fIsKewordSearch = isKewordSearch;
        this.fPreferences = Owl.getPreferenceService().getGlobalScope();
    }

    public Source getSource() {
        if (this.fImportFromResourceRadio.getSelection()) {
            return Source.RESOURCE;
        }
        if (this.fImportFromKeywordRadio.getSelection()) {
            return Source.KEYWORD;
        }
        if (this.fImportNoneRadio != null && this.fImportNoneRadio.getSelection()) {
            return Source.NONE;
        }
        return Source.RECOMMENDED;
    }

    String getImportResource() {
        return this.fImportFromResourceRadio.getSelection() ? this.fResourceInput.getText() : null;
    }

    String getImportKeywords() {
        return this.fImportFromKeywordRadio.getSelection() ? this.fKeywordInput.getText() : null;
    }

    boolean isRemoteSource() {
        String resource;
        Source source = this.getSource();
        if (source == Source.KEYWORD) {
            return true;
        }
        if (source == Source.GOOGLE) {
            return true;
        }
        return source == Source.RESOURCE && !new File(resource = this.getImportResource()).exists() && URIUtils.looksLikeLink((String)resource, (boolean)false);
    }

    boolean isLocalizedFeedSearch() {
        return this.fLocalizedFeedSearch.getSelection();
    }

    public void createControl(Composite parent) {
        boolean isWelcome = this.isWelcome();
        this.setImageDescriptor(OwlUI.getImageDescriptor(isWelcome ? "icons/wizban/welcome_wiz.gif" : "icons/wizban/import_wiz.png"));
        if (isWelcome) {
            this.setTitle(Messages.ImportSourcePage_WELCOME);
            this.setMessage(Messages.ImportSourcePage_WELCOME_INFO);
        } else {
            this.setMessage(Messages.ImportSourcePage_CHOOSE_SOURCE_FOR_IMPORT);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        if (isWelcome) {
            this.createImportRecommendedControls(container);
            this.createImportResourceControls(container);
            this.createImportKeywordControls(container);
            this.createImportNoneControls(container);
        } else {
            this.createImportResourceControls(container);
            this.createImportKeywordControls(container);
            this.createImportRecommendedControls(container);
        }
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        this.updatePageComplete();
    }

    private void createImportResourceControls(Composite container) {
        String[] previousResources;
        String cbLink;
        this.fImportFromResourceRadio = new Button(container, 16);
        this.fImportFromResourceRadio.setSelection(!this.fIsKewordSearch && !this.isWelcome());
        this.fImportFromResourceRadio.setLayoutData((Object)new GridData(4, 1, true, false));
        if (this.isWelcome()) {
            ((GridData)this.fImportFromResourceRadio.getLayoutData()).verticalIndent = 10;
        }
        this.fImportFromResourceRadio.setText(Messages.ImportSourcePage_IMPORT_FROM_FILE_OR_WEBSITE);
        this.fImportFromResourceRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSourcePage.this.updatePageComplete();
                boolean importFromResource = ImportSourcePage.this.fImportFromResourceRadio.getSelection();
                ImportSourcePage.this.fResourceInput.setEnabled(importFromResource);
                ImportSourcePage.this.fBrowseFileButton.setEnabled(importFromResource);
                if (importFromResource) {
                    ImportSourcePage.this.fResourceInput.setFocus();
                }
            }
        });
        Composite sourceInputContainer = new Composite(container, 0);
        sourceInputContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)sourceInputContainer.getLayout()).marginLeft = 15;
        ((GridLayout)sourceInputContainer.getLayout()).marginBottom = 10;
        sourceInputContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fResourceInput = new Combo(sourceInputContainer, 2052);
        OwlUI.makeAccessible((Control)this.fResourceInput, (Control)this.fImportFromResourceRadio);
        this.fResourceInput.setEnabled(this.fImportFromResourceRadio.getSelection());
        this.fResourceInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (StringUtils.isSet((String)this.fFileOrWebsite)) {
            this.fResourceInput.setText(this.fFileOrWebsite);
        } else if (!this.isWelcome() && !this.fIsKewordSearch && StringUtils.isSet((String)(cbLink = this.loadInitialLinkFromClipboard(sourceInputContainer.getDisplay())))) {
            this.fResourceInput.setText(cbLink);
        }
        if (this.fImportFromResourceRadio.getSelection()) {
            this.fResourceInput.setFocus();
        }
        if ((previousResources = this.fPreferences.getStrings(DefaultPreferences.IMPORT_RESOURCES)) != null) {
            this.fResourceInput.setVisibleItemCount(previousResources.length);
            String[] stringArray = previousResources;
            int n = previousResources.length;
            int n2 = 0;
            while (n2 < n) {
                String source = stringArray[n2];
                this.fResourceInput.add(source);
                ++n2;
            }
        }
        this.fResourceInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportSourcePage.this.updatePageComplete();
            }
        });
        this.fBrowseFileButton = new Button(sourceInputContainer, 8);
        this.fBrowseFileButton.setText(Messages.ImportSourcePage_BROWSE);
        this.fBrowseFileButton.setEnabled(this.fImportFromResourceRadio.getSelection());
        Dialog.applyDialogFont((Control)this.fBrowseFileButton);
        this.setButtonLayoutData(this.fBrowseFileButton);
        this.fBrowseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSourcePage.this.onBrowse();
            }
        });
    }

    private String loadInitialLinkFromClipboard(Display display) {
        Clipboard cb = new Clipboard(display);
        TextTransfer transfer = TextTransfer.getInstance();
        String data = (String)cb.getContents((Transfer)transfer);
        data = data != null ? data.trim() : null;
        cb.dispose();
        if (URIUtils.looksLikeLink((String)data, (boolean)false)) {
            return URIUtils.ensureProtocol((String)data);
        }
        return null;
    }

    private void createImportKeywordControls(Composite container) {
        String[] previousKeywords;
        this.fImportFromKeywordRadio = new Button(container, 16);
        this.fImportFromKeywordRadio.setSelection(this.fIsKewordSearch && !this.isWelcome());
        this.fImportFromKeywordRadio.setText(Messages.ImportSourcePage_IMPORT_BY_KEYWORD);
        this.fImportFromKeywordRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSourcePage.this.updatePageComplete();
                boolean importFromKeyword = ImportSourcePage.this.fImportFromKeywordRadio.getSelection();
                ImportSourcePage.this.fKeywordInput.setEnabled(importFromKeyword);
                ImportSourcePage.this.fLocalizedFeedSearch.setEnabled(importFromKeyword);
                if (importFromKeyword) {
                    ImportSourcePage.this.hookKeywordAutocomplete(false);
                    ImportSourcePage.this.fKeywordInput.setFocus();
                }
            }
        });
        Composite keywordInputContainer = new Composite(container, 0);
        keywordInputContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        ((GridLayout)keywordInputContainer.getLayout()).marginLeft = 15;
        ((GridLayout)keywordInputContainer.getLayout()).marginBottom = 10;
        keywordInputContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fKeywordInput = new Combo(keywordInputContainer, 2052);
        OwlUI.makeAccessible((Control)this.fKeywordInput, (Control)this.fImportFromKeywordRadio);
        this.fKeywordInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fKeywordInput.setEnabled(this.fImportFromKeywordRadio.getSelection());
        if (this.fImportFromKeywordRadio.getSelection()) {
            this.hookKeywordAutocomplete(true);
            this.fKeywordInput.setFocus();
        }
        if ((previousKeywords = this.fPreferences.getStrings(DefaultPreferences.IMPORT_KEYWORDS)) != null) {
            this.fKeywordInput.setVisibleItemCount(previousKeywords.length);
            String[] stringArray = previousKeywords;
            int n = previousKeywords.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                this.fKeywordInput.add(keyword);
                ++n2;
            }
        }
        this.fKeywordInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportSourcePage.this.updatePageComplete();
            }
        });
        this.fLocalizedFeedSearch = new Button(keywordInputContainer, 32);
        this.fLocalizedFeedSearch.setSelection(this.fPreferences.getBoolean(DefaultPreferences.LOCALIZED_FEED_SEARCH));
        this.fLocalizedFeedSearch.setEnabled(this.fImportFromKeywordRadio.getSelection());
        String clientLanguage = Locale.getDefault().getDisplayLanguage(Locale.ENGLISH);
        if (StringUtils.isSet((String)clientLanguage)) {
            this.fLocalizedFeedSearch.setText(NLS.bind((String)Messages.ImportSourcePage_MATCH_LANGUAGE_N, (Object)clientLanguage));
        } else {
            this.fLocalizedFeedSearch.setText(Messages.ImportSourcePage_MATCH_LANGUAGE);
        }
    }

    private void createImportGoogleReaderControls(Composite container) {
        this.fImportGoogleReaderRadio = new Button(container, 16);
        this.fImportGoogleReaderRadio.setText(Messages.ImportSourcePage_IMPORT_GOOGLE_READER);
        this.fImportGoogleReaderRadio.setLayoutData((Object)new GridData(4, 1, true, false));
        if (this.isWelcome()) {
            ((GridData)this.fImportGoogleReaderRadio.getLayoutData()).verticalIndent = 10;
        }
        this.fImportGoogleReaderRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSourcePage.this.updatePageComplete();
            }
        });
    }

    private void createImportRecommendedControls(Composite container) {
        this.fImportFromRecommendedRadio = new Button(container, 16);
        this.fImportFromRecommendedRadio.setText(Messages.ImportSourcePage_IMPORT_RECOMMENDED);
        this.fImportFromRecommendedRadio.setSelection(this.isWelcome());
        this.fImportFromRecommendedRadio.setLayoutData((Object)new GridData(4, 1, true, false));
        if (!this.isWelcome()) {
            ((GridData)this.fImportFromRecommendedRadio.getLayoutData()).verticalIndent = 10;
        }
        this.fImportFromRecommendedRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSourcePage.this.updatePageComplete();
            }
        });
    }

    private void createImportNoneControls(Composite container) {
        this.fImportNoneRadio = new Button(container, 16);
        this.fImportNoneRadio.setText(Messages.ImportSourcePage_NO_MPORT);
        this.fImportNoneRadio.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fImportNoneRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSourcePage.this.updatePageComplete();
            }
        });
    }

    private void onBrowse() {
        String string;
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(Messages.ImportSourcePage_CHOOSE_FILE);
        ArrayList<String> filterExtensions = new ArrayList<String>();
        filterExtensions.add("*.opml");
        filterExtensions.add("*.xml");
        Collection exportFormats = Owl.getInterpreter().getExportFormats();
        for (String exportFormat : exportFormats) {
            String format = "*." + exportFormat.toLowerCase();
            if (filterExtensions.contains(format)) continue;
            filterExtensions.add(format);
        }
        if (!filterExtensions.contains("*.*")) {
            filterExtensions.add("*.*");
        }
        dialog.setFilterExtensions(filterExtensions.toArray(new String[filterExtensions.size()]));
        if (StringUtils.isSet((String)this.fResourceInput.getText())) {
            dialog.setFileName(this.fResourceInput.getText());
        }
        if ((string = dialog.open()) != null) {
            this.fResourceInput.setText(string);
        }
        this.updatePageComplete();
    }

    private void updatePageComplete() {
        String errorMessage = null;
        if (this.fImportFromRecommendedRadio.getSelection()) {
            this.setPageComplete(true);
        }
        if (this.fImportNoneRadio != null && this.fImportNoneRadio.getSelection()) {
            this.setPageComplete(true);
        } else if (this.fImportFromResourceRadio.getSelection()) {
            if (!StringUtils.isSet((String)this.fResourceInput.getText())) {
                this.setPageComplete(false);
            } else if (this.isRemoteSource()) {
                this.setPageComplete(true);
            } else {
                String filePath = this.fResourceInput.getText();
                File fileToImport = new File(filePath);
                boolean fileExists = fileToImport.exists() && fileToImport.isFile();
                this.setPageComplete(fileExists);
                if (!fileExists) {
                    errorMessage = Messages.ImportSourcePage_CHOOSE_EXISTING_FILE;
                }
            }
        } else if (this.fImportFromKeywordRadio.getSelection()) {
            this.setPageComplete(StringUtils.isSet((String)this.fKeywordInput.getText()));
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setErrorMessage(null);
            this.setMessage(this.isWelcome() ? Messages.ImportSourcePage_WELCOME_INFO : Messages.ImportSourcePage_CHOOSE_SOURCE_FOR_IMPORT);
        }
    }

    private boolean isWelcome() {
        return this.getWizard() instanceof WelcomeWizard;
    }

    void saveSettings() {
        this.saveComboSettings(this.fImportFromResourceRadio.getSelection() ? this.fResourceInput.getText() : null, DefaultPreferences.IMPORT_RESOURCES);
        this.saveComboSettings(this.fImportFromKeywordRadio.getSelection() ? this.fKeywordInput.getText() : null, DefaultPreferences.IMPORT_KEYWORDS);
        this.fPreferences.putBoolean(DefaultPreferences.LOCALIZED_FEED_SEARCH, this.fLocalizedFeedSearch.getSelection());
    }

    private void saveComboSettings(String valueToAdd, String prefKey) {
        String[] oldValues;
        ArrayList<String> newValues = new ArrayList<String>();
        if (StringUtils.isSet((String)valueToAdd)) {
            newValues.add(valueToAdd);
        }
        if ((oldValues = this.fPreferences.getStrings(prefKey)) != null) {
            int i = 0;
            while (i < oldValues.length && newValues.size() < 20) {
                if (!newValues.contains(oldValues[i])) {
                    newValues.add(oldValues[i]);
                }
                ++i;
            }
        }
        if (!newValues.isEmpty()) {
            this.fPreferences.putStrings(prefKey, newValues.toArray(new String[newValues.size()]));
        }
    }

    private void hookKeywordAutocomplete(boolean delay) {
        if (this.isWelcome()) {
            return;
        }
        if (this.fIsAutoCompleteKeywordHooked) {
            return;
        }
        this.fIsAutoCompleteKeywordHooked = true;
        final Pair<SimpleContentProposalProvider, ContentProposalAdapter> autoComplete = OwlUI.hookAutoComplete(this.fKeywordInput, null, true);
        JobRunner.runInBackgroundThread(delay ? 100 : 0, new Runnable(){

            public void run() {
                if (!ImportSourcePage.this.fKeywordInput.isDisposed()) {
                    TreeSet<String> values = new TreeSet<String>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareToIgnoreCase(o2);
                        }
                    });
                    values.addAll(((ICategoryDAO)DynamicDAO.getDAO(ICategoryDAO.class)).loadAllNames());
                    values.addAll(((IPersonDAO)DynamicDAO.getDAO(IPersonDAO.class)).loadAllNames());
                    Collection labels = ((ILabelDAO)DynamicDAO.getDAO(ILabelDAO.class)).loadAll();
                    for (ILabel label : labels) {
                        values.add(label.getName());
                    }
                    if (!ImportSourcePage.this.fKeywordInput.isDisposed()) {
                        OwlUI.applyAutoCompleteProposals(values, (SimpleContentProposalProvider)autoComplete.getFirst(), (ContentProposalAdapter)autoComplete.getSecond(), false);
                    }
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Source {
        NONE,
        RESOURCE,
        KEYWORD,
        RECOMMENDED,
        GOOGLE;

    }
}

