/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.AuthenticationRequiredException;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.CredentialsException;
import org.rssowl.core.connection.HttpConnectionInputStream;
import org.rssowl.core.connection.IAbortable;
import org.rssowl.core.connection.ICredentials;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.connection.SyncConnectionException;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.interpreter.InterpreterException;
import org.rssowl.core.interpreter.ParserException;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.RegExUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.CustomWizardDialog;
import org.rssowl.ui.internal.dialogs.LoginDialog;
import org.rssowl.ui.internal.dialogs.PreviewFeedDialog;
import org.rssowl.ui.internal.dialogs.importer.ImportSourcePage;
import org.rssowl.ui.internal.dialogs.importer.Messages;
import org.rssowl.ui.internal.dialogs.welcome.WelcomeWizard;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.FolderChildCheckboxTree;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportElementsPage
extends WizardPage {
    private static final int INITIAL_CON_TIMEOUT = 30000;
    private static final int FEED_CON_TIMEOUT = 7000;
    private static final String DEFAULT_LANGUAGE = "en";
    private CheckboxTreeViewer fViewer;
    private FolderChildCheckboxTree fFolderChildTree;
    private Button fDeselectAll;
    private Button fSelectAll;
    private Button fPreviewButton;
    private Button fFlattenCheck;
    private Button fHideExistingCheck;
    private ExistingBookmarkFilter fExistingFilter = new ExistingBookmarkFilter();
    private Map<URI, IFeed> fLoadedFeedCache = new ConcurrentHashMap<URI, IFeed>();
    private IProgressMonitor fCurrentProgressMonitor;
    private ImportSourcePage.Source fCurrentSourceKind;
    private String fCurrentSourceResource;
    private String fCurrentSourceKeywords;
    private boolean fCurrentSourceLocalizedFeedSearch;
    private long fCurrentSourceFileModified;
    private List<ILabel> fLabels = Collections.synchronizedList(new ArrayList());
    private List<ISearchFilter> fFilters = Collections.synchronizedList(new ArrayList());
    private List<IPreference> fPreferences = Collections.synchronizedList(new ArrayList());

    ImportElementsPage() {
        super(Messages.ImportElementsPage_CHOOSE_ELEMENTS, Messages.ImportElementsPage_CHOOSE_ELEMENTS, null);
        this.setMessage(Messages.ImportElementsPage_CHOOSE_ELEMENTS_MESSAGE);
    }

    List<IFolderChild> getFolderChildsToImport() {
        this.doImportSource();
        return this.fFolderChildTree.getCheckedElements();
    }

    List<ILabel> getLabelsToImport() {
        this.doImportSource();
        return this.fLabels;
    }

    List<ISearchFilter> getFiltersToImport() {
        this.doImportSource();
        return this.fFilters;
    }

    List<IPreference> getPreferencesToImport() {
        this.doImportSource();
        return this.fPreferences;
    }

    boolean excludeExisting() {
        return this.fHideExistingCheck.getSelection();
    }

    boolean showOptionsPage() {
        return !this.fLabels.isEmpty() || !this.fFilters.isEmpty() || !this.fPreferences.isEmpty();
    }

    public void createControl(Composite parent) {
        Button cancelButton;
        boolean isWelcome = this.getWizard() instanceof WelcomeWizard;
        this.setImageDescriptor(OwlUI.getImageDescriptor(this.getWizard() instanceof WelcomeWizard ? "icons/wizban/welcome_wiz.gif" : "icons/wizban/import_wiz.png"));
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.fFolderChildTree = new FolderChildCheckboxTree(container);
        if (!isWelcome) {
            ((GridData)this.fFolderChildTree.getViewer().getTree().getLayoutData()).heightHint = 140;
        }
        this.fViewer = this.fFolderChildTree.getViewer();
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ImportElementsPage.this.openPreview(event.getSelection());
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                ImportElementsPage.this.fPreviewButton.setEnabled(!selection.isEmpty() && ((IStructuredSelection)selection).getFirstElement() instanceof IBookMark);
            }
        });
        this.fViewer.addFilter((ViewerFilter)this.fExistingFilter);
        this.fViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportElementsPage.this.updatePageComplete();
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(isWelcome ? 5 : 6, 0, 0));
        buttonContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSelectAll = new Button(buttonContainer, 8);
        this.fSelectAll.setText(Messages.ImportElementsPage_SELECT_ALL);
        Dialog.applyDialogFont((Control)this.fSelectAll);
        this.setButtonLayoutData(this.fSelectAll);
        this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportElementsPage.this.fFolderChildTree.setAllChecked(true);
                ImportElementsPage.this.updatePageComplete();
            }
        });
        this.fDeselectAll = new Button(buttonContainer, 8);
        this.fDeselectAll.setText(Messages.ImportElementsPage_DESELECT_ALL);
        Dialog.applyDialogFont((Control)this.fDeselectAll);
        this.setButtonLayoutData(this.fDeselectAll);
        this.fDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportElementsPage.this.fFolderChildTree.setAllChecked(false);
                ImportElementsPage.this.updatePageComplete();
            }
        });
        if (!Application.IS_MAC) {
            Label sep = new Label(buttonContainer, 514);
            sep.setLayoutData((Object)new GridData(1, 4, false, false));
            ((GridData)sep.getLayoutData()).heightHint = 20;
        }
        this.fPreviewButton = new Button(buttonContainer, 8);
        this.fPreviewButton.setText(Messages.ImportElementsPage_PREVIEW);
        this.fPreviewButton.setEnabled(false);
        this.fPreviewButton.setToolTipText(Messages.ImportElementsPage_SHOW_PREVIEW);
        Dialog.applyDialogFont((Control)this.fPreviewButton);
        this.setButtonLayoutData(this.fPreviewButton);
        this.fPreviewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportElementsPage.this.openPreview(ImportElementsPage.this.fViewer.getSelection());
            }
        });
        this.fFlattenCheck = new Button(buttonContainer, 32);
        this.fFlattenCheck.setText(Messages.ImportElementsPage_FLATTEN);
        Dialog.applyDialogFont((Control)this.fFlattenCheck);
        this.setButtonLayoutData(this.fFlattenCheck);
        ((GridData)this.fFlattenCheck.getLayoutData()).horizontalAlignment = 0x1000008;
        ((GridData)this.fFlattenCheck.getLayoutData()).horizontalIndent = 30;
        ((GridData)this.fFlattenCheck.getLayoutData()).grabExcessHorizontalSpace = true;
        this.fFlattenCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportElementsPage.this.fFolderChildTree.setFlat(ImportElementsPage.this.fFlattenCheck.getSelection());
                ImportElementsPage.this.fViewer.expandToLevel(2);
                ImportElementsPage.this.fFolderChildTree.setAllChecked(true);
            }
        });
        this.fHideExistingCheck = new Button(buttonContainer, 32);
        this.fHideExistingCheck.setText(Messages.ImportElementsPage_HIDE_EXISTING);
        this.fHideExistingCheck.setSelection(true);
        Dialog.applyDialogFont((Control)this.fHideExistingCheck);
        this.setButtonLayoutData(this.fHideExistingCheck);
        ((GridData)this.fHideExistingCheck.getLayoutData()).exclude = isWelcome;
        this.fHideExistingCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImportElementsPage.this.fHideExistingCheck.getSelection()) {
                    ImportElementsPage.this.fViewer.addFilter((ViewerFilter)ImportElementsPage.this.fExistingFilter);
                } else {
                    ImportElementsPage.this.fViewer.removeFilter((ViewerFilter)ImportElementsPage.this.fExistingFilter);
                }
                ImportElementsPage.this.fViewer.expandToLevel(2);
                ImportElementsPage.this.updateMessage(false);
            }
        });
        if (this.getContainer() instanceof CustomWizardDialog && (cancelButton = ((CustomWizardDialog)this.getContainer()).getButton(1)) != null) {
            cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImportElementsPage.this.onCancel();
                }
            });
        }
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private void onCancel() {
        if (this.fCurrentProgressMonitor != null && this.getShell() != null && !this.getShell().isDisposed()) {
            IProgressMonitor monitor = this.fCurrentProgressMonitor;
            monitor.setTaskName(Messages.ImportElementsPage_CANCEL_SEARCH);
            monitor.subTask("");
        }
    }

    private void openPreview(ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (!sel.isEmpty()) {
            Object[] elements = sel.toArray();
            int offset = 0;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IBookMark) {
                    IBookMark bookmark = (IBookMark)element;
                    IFeed loadedFeed = this.fLoadedFeedCache.get(bookmark.getFeedLinkReference().getLink());
                    PreviewFeedDialog dialog = new PreviewFeedDialog(this.getShell(), bookmark, loadedFeed);
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                    if (offset != 0) {
                        Point location = dialog.getShell().getLocation();
                        dialog.getShell().setLocation(location.x + offset, location.y + offset);
                    }
                    offset += 20;
                }
                ++n2;
            }
        }
    }

    private void updateMessage(boolean clearErrors) {
        List input = (List)this.fViewer.getInput();
        if (!input.isEmpty() && this.fViewer.getTree().getItemCount() == 0 && this.fViewer.getFilters().length > 0) {
            this.setMessage(Messages.ImportElementsPage_HIDDEN_ELEMENTS_INFO, 1);
        } else {
            this.setMessage(Messages.ImportElementsPage_CHOOSE_ELEMENTS_MESSAGE);
        }
        if (clearErrors) {
            this.setErrorMessage(null);
        }
        this.updatePageComplete();
    }

    private void updatePageComplete() {
        boolean complete = this.showOptionsPage() || this.fViewer.getCheckedElements().length > 0;
        this.setPageComplete(complete);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        this.fViewer.getControl().setFocus();
        this.doImportSource();
    }

    private void doImportSource() {
        ImportSourcePage importSourcePage = (ImportSourcePage)this.getPreviousPage();
        final ImportSourcePage.Source source = importSourcePage.getSource();
        if (source == ImportSourcePage.Source.RECOMMENDED && this.fCurrentSourceKind == ImportSourcePage.Source.RECOMMENDED) {
            return;
        }
        if (source == ImportSourcePage.Source.GOOGLE && this.fCurrentSourceKind == ImportSourcePage.Source.GOOGLE) {
            return;
        }
        if (source == ImportSourcePage.Source.KEYWORD && this.fCurrentSourceKind == ImportSourcePage.Source.KEYWORD && importSourcePage.getImportKeywords().equals(this.fCurrentSourceKeywords) && this.fCurrentSourceLocalizedFeedSearch == importSourcePage.isLocalizedFeedSearch()) {
            return;
        }
        if (source == ImportSourcePage.Source.RESOURCE && this.fCurrentSourceKind == ImportSourcePage.Source.RESOURCE) {
            File file;
            String importResource = importSourcePage.getImportResource();
            if (importSourcePage.isRemoteSource() && importResource.equals(this.fCurrentSourceResource)) {
                return;
            }
            if (importResource.equals(this.fCurrentSourceResource) && (file = new File(importResource)).exists() && file.lastModified() == this.fCurrentSourceFileModified) {
                return;
            }
        }
        this.fCurrentSourceKind = source;
        this.fCurrentSourceResource = importSourcePage.getImportResource();
        final File sourceFile = source == ImportSourcePage.Source.RESOURCE ? new File(importSourcePage.getImportResource()) : null;
        this.fCurrentSourceFileModified = sourceFile != null && sourceFile.exists() ? sourceFile.lastModified() : 0L;
        this.fCurrentSourceKeywords = importSourcePage.getImportKeywords();
        this.fCurrentSourceLocalizedFeedSearch = importSourcePage.isLocalizedFeedSearch();
        this.fLabels.clear();
        this.fFilters.clear();
        this.fPreferences.clear();
        this.setErrorMessage(null);
        this.setMessage(Messages.ImportElementsPage_CHOOSE_ELEMENTS_MESSAGE);
        this.setImportedElements(Collections.EMPTY_LIST);
        if (source == ImportSourcePage.Source.GOOGLE && !SyncUtils.hasSyncCredentials() && OwlUI.openSyncLogin(this.getShell()) != 0) {
            this.setErrorMessage(Messages.ImportElementsPage_MISSING_ACCOUNT);
            this.setPageComplete(false);
            this.fCurrentSourceKind = null;
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (source == ImportSourcePage.Source.RESOURCE && sourceFile != null && sourceFile.exists()) {
                        ImportElementsPage.this.importFromLocalResource(sourceFile);
                    } else if (source == ImportSourcePage.Source.RESOURCE && URIUtils.looksLikeLink((String)ImportElementsPage.this.fCurrentSourceResource, (boolean)false)) {
                        ImportElementsPage.this.importFromOnlineResource(new URI(URIUtils.ensureProtocol((String)ImportElementsPage.this.fCurrentSourceResource)));
                    } else if (source == ImportSourcePage.Source.GOOGLE) {
                        ImportElementsPage.this.importFromGoogleReader();
                    } else if (source == ImportSourcePage.Source.KEYWORD) {
                        ImportElementsPage.this.importFromKeywordSearch(ImportElementsPage.this.fCurrentSourceKeywords, ImportElementsPage.this.fCurrentSourceLocalizedFeedSearch);
                    } else if (source == ImportSourcePage.Source.RECOMMENDED) {
                        ImportElementsPage.this.importFromLocalResource(this.getClass().getResourceAsStream("/default_feeds.xml"));
                    }
                }
                catch (Exception e) {
                    String userLink;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof AuthenticationRequiredException && source == ImportSourcePage.Source.GOOGLE && OwlUI.openSyncLogin(ImportElementsPage.this.getShell()) == 0) {
                        try {
                            ImportElementsPage.this.importFromGoogleReader();
                            return;
                        }
                        catch (InvocationTargetException ex1) {
                            e = ex1;
                        }
                        catch (InterruptedException ex2) {
                            e = ex2;
                        }
                    }
                    if (e instanceof InvocationTargetException && e.getCause() instanceof SyncConnectionException && StringUtils.isSet((String)(userLink = ((SyncConnectionException)e.getCause()).getUserUrl()))) {
                        MessageBox box = new MessageBox(ImportElementsPage.this.getShell(), 289);
                        box.setText(Messages.ImportElementsPage_ERROR_IMPORT_GR);
                        String msg = NLS.bind((String)Messages.ImportElementsPage_ERROR_IMPORT_GR_DETAILS, (Object)e.getCause().getMessage());
                        box.setMessage(msg);
                        if (box.open() == 32) {
                            BrowserUtils.openLinkExternal(userLink);
                        }
                    }
                    String logMessage = e.getMessage();
                    if (e instanceof InvocationTargetException && e.getCause() != null && StringUtils.isSet((String)e.getCause().getMessage())) {
                        logMessage = e.getCause().getMessage();
                    }
                    logMessage = StringUtils.isSet((String)logMessage) ? NLS.bind((String)Messages.ImportElementsPage_UNABLE_TO_IMPORT_REASON, (Object)logMessage) : Messages.ImportElementsPage_UNABLE_TO_IMPORT;
                    String userMessage = CoreUtils.toMessage((Throwable)e);
                    userMessage = StringUtils.isSet((String)userMessage) ? NLS.bind((String)Messages.ImportElementsPage_UNABLE_TO_IMPORT_REASON, (Object)userMessage) : Messages.ImportElementsPage_UNABLE_TO_IMPORT;
                    Activator.getDefault().logError(logMessage, e);
                    ImportElementsPage.this.setErrorMessage(userMessage);
                    ImportElementsPage.this.setPageComplete(false);
                    ImportElementsPage.this.fCurrentSourceKind = null;
                }
            }
        };
        if (importSourcePage.isRemoteSource()) {
            JobRunner.runInUIThread(50, (Widget)this.getShell(), runnable);
        } else {
            runnable.run();
        }
    }

    private void importFromLocalResource(InputStream in) throws InterpreterException, ParserException {
        List types = Owl.getInterpreter().importFrom(in);
        this.setImportedElements(types);
        this.updateMessage(true);
    }

    private void importFromLocalResource(final File file) throws FileNotFoundException, InvocationTargetException, InterruptedException {
        boolean bruteForce = false;
        try {
            this.importFromLocalResource(new FileInputStream(file));
        }
        catch (ParserException parserException) {
            bruteForce = true;
        }
        catch (InterpreterException interpreterException) {
            bruteForce = true;
        }
        if (bruteForce) {
            this.setMessage(Messages.ImportElementsPage_INVALID_OPML_WARNING, 2);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask(Messages.ImportElementsPage_SEARCHING_FOR_FEEDS, -1);
                    ImportElementsPage.this.fCurrentProgressMonitor = monitor;
                    if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                        return;
                    }
                    FileReader reader = null;
                    try {
                        try {
                            reader = new FileReader(file);
                            String content = StringUtils.readString((Reader)reader);
                            ArrayList links = new ArrayList();
                            if (StringUtils.isSet((String)content)) {
                                links.addAll(RegExUtils.extractLinksFromText((String)content, (boolean)false));
                            }
                            ImportElementsPage.this.importFromLinksBruteforce(links, monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        ImportElementsPage.this.fCurrentProgressMonitor = null;
                        monitor.done();
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                }
            };
            this.getContainer().run(true, true, runnable);
        }
    }

    private void importFromOnlineResource(final URI link) throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Unable to fully structure code
             */
            public void run(final IProgressMonitor monitor) throws InvocationTargetException {
                block55: {
                    block51: {
                        block52: {
                            block50: {
                                in = null;
                                canceled = false;
                                error = null;
                                bruteForce = false;
                                monitor.beginTask(Messages.ImportElementsPage_SEARCHING_FOR_FEEDS, -1);
                                monitor.subTask(Messages.ImportElementsPage_CONNECTING);
                                ImportElementsPage.access$19(ImportElementsPage.this, monitor);
                                if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) break block50;
                                canceled = true;
lbl11:
                                // 2 sources

                                while (true) {
                                    if (canceled || error != null) {
                                        ImportElementsPage.access$19(ImportElementsPage.this, null);
                                    }
                                    if (in != null) {
                                        try {
                                            if ((canceled || error != null) && in instanceof IAbortable) {
                                                ((IAbortable)in).abort();
                                            } else {
                                                in.close();
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new InvocationTargetException(e);
                                        }
                                    }
                                    return;
                                }
                            }
                            in = ImportElementsPage.access$21(ImportElementsPage.this, link, monitor, 30000, false, false, null);
                            if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                                canceled = true;
                                ** continue;
                            }
                            types = Owl.getInterpreter().importFrom(in);
                            if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) break block51;
                            canceled = true;
                            if (!canceled && error == null) break block52;
                            ImportElementsPage.access$19(ImportElementsPage.this, null);
                        }
                        if (in != null) {
                            try {
                                if ((canceled || error != null) && in instanceof IAbortable) {
                                    ((IAbortable)in).abort();
                                } else {
                                    in.close();
                                }
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        return;
                    }
                    try {
                        try {
                            JobRunner.runInUIThread((Widget)ImportElementsPage.this.getShell(), new Runnable(){

                                public void run() {
                                    ImportElementsPage.this.setImportedElements(types);
                                    ImportElementsPage.this.updateMessage(true);
                                }
                            });
                            {
                                catch (Exception e) {
                                    error = e;
                                    bruteForce = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            showError = new boolean[]{true};
                            if (e instanceof AuthenticationRequiredException && !monitor.isCanceled() && !Controller.getDefault().isShuttingDown() && (shell = ImportElementsPage.this.getShell()) != null && !shell.isDisposed() && (locked = Controller.getDefault().getLoginDialogLock().tryLock())) {
                                try {
                                    authEx = (AuthenticationRequiredException)e;
                                    JobRunner.runSyncedInUIThread((Widget)shell, new Runnable(){

                                        public void run() {
                                            try {
                                                if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                                                    return;
                                                }
                                                try {
                                                    URI normalizedUri = URIUtils.normalizeUri((URI)link, (boolean)true);
                                                    if (Owl.getConnectionService().getAuthCredentials(normalizedUri, authEx.getRealm()) != null) {
                                                        ImportElementsPage.this.importFromOnlineResource(link);
                                                        showError[0] = false;
                                                        return;
                                                    }
                                                }
                                                catch (CredentialsException exe) {
                                                    Activator.getDefault().getLog().log(exe.getStatus());
                                                }
                                                LoginDialog login = new LoginDialog(shell, link, authEx.getRealm());
                                                if (login.open() == 0 && !monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) {
                                                    ImportElementsPage.this.importFromOnlineResource(link);
                                                    showError[0] = false;
                                                }
                                            }
                                            catch (InvocationTargetException invocationTargetException) {
                                            }
                                            catch (InterruptedException interruptedException) {}
                                        }
                                    });
                                }
                                finally {
                                    Controller.getDefault().getLoginDialogLock().unlock();
                                }
                            }
                            if (showError[0]) {
                                throw new InvocationTargetException(e);
                            }
                            if (canceled || error != null) {
                                ImportElementsPage.access$19(ImportElementsPage.this, null);
                            }
                            if (in == null) break block55;
                            try {
                                if ((canceled || error != null) && in instanceof IAbortable) {
                                    ((IAbortable)in).abort();
                                } else {
                                    in.close();
                                }
                                break block55;
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                    catch (Throwable var12_21) {
                        if (canceled || error != null) {
                            ImportElementsPage.access$19(ImportElementsPage.this, null);
                        }
                        if (in != null) {
                            try {
                                if ((canceled || error != null) && in instanceof IAbortable) {
                                    ((IAbortable)in).abort();
                                } else {
                                    in.close();
                                }
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        throw var12_21;
                    }
                    if (canceled || error != null) {
                        ImportElementsPage.access$19(ImportElementsPage.this, null);
                    }
                    if (in != null) {
                        try {
                            if ((canceled || error != null) && in instanceof IAbortable) {
                                ((IAbortable)in).abort();
                            } else {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                if (bruteForce && !monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) {
                    try {
                        try {
                            ImportElementsPage.access$23(ImportElementsPage.this, link, monitor, false, false);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        ImportElementsPage.access$19(ImportElementsPage.this, null);
                    }
                }
                monitor.done();
                ImportElementsPage.access$19(ImportElementsPage.this, null);
            }
        };
        this.getContainer().run(true, true, runnable);
    }

    private void importFromGoogleReader() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                List types;
                Exception error;
                boolean canceled;
                InputStream in;
                block53: {
                    block54: {
                        block51: {
                            block52: {
                                String googleAuthToken;
                                block49: {
                                    block50: {
                                        ICredentials credentials;
                                        block47: {
                                            block48: {
                                                block45: {
                                                    block46: {
                                                        in = null;
                                                        canceled = false;
                                                        error = null;
                                                        monitor.beginTask(Messages.ImportElementsPage_IMPORT_GOOGLE_READER, -1);
                                                        monitor.subTask(Messages.ImportElementsPage_CONNECTING);
                                                        ImportElementsPage.this.fCurrentProgressMonitor = monitor;
                                                        if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) break block45;
                                                        canceled = true;
                                                        if (!canceled && error == null) break block46;
                                                        ImportElementsPage.this.fCurrentProgressMonitor = null;
                                                    }
                                                    if (in != null) {
                                                        try {
                                                            if ((canceled || error != null) && in instanceof IAbortable) {
                                                                ((IAbortable)in).abort();
                                                            } else {
                                                                in.close();
                                                            }
                                                        }
                                                        catch (IOException e) {
                                                            throw new InvocationTargetException(e);
                                                        }
                                                    }
                                                    return;
                                                }
                                                credentials = Owl.getConnectionService().getAuthCredentials(URI.create("https://www.google.com/accounts/ClientLogin"), null);
                                                if (credentials != null) break block47;
                                                canceled = true;
                                                if (!canceled && error == null) break block48;
                                                ImportElementsPage.this.fCurrentProgressMonitor = null;
                                            }
                                            if (in != null) {
                                                try {
                                                    if ((canceled || error != null) && in instanceof IAbortable) {
                                                        ((IAbortable)in).abort();
                                                    } else {
                                                        in.close();
                                                    }
                                                }
                                                catch (IOException e) {
                                                    throw new InvocationTargetException(e);
                                                }
                                            }
                                            return;
                                        }
                                        googleAuthToken = SyncUtils.getGoogleAuthToken((String)credentials.getUsername(), (String)credentials.getPassword(), (boolean)true, (IProgressMonitor)monitor);
                                        if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) break block49;
                                        canceled = true;
                                        if (!canceled && error == null) break block50;
                                        ImportElementsPage.this.fCurrentProgressMonitor = null;
                                    }
                                    if (in != null) {
                                        try {
                                            if ((canceled || error != null) && in instanceof IAbortable) {
                                                ((IAbortable)in).abort();
                                            } else {
                                                in.close();
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new InvocationTargetException(e);
                                        }
                                    }
                                    return;
                                }
                                in = ImportElementsPage.this.openStream(URI.create("https://www.google.com/reader/subscriptions/export"), monitor, 30000, false, false, googleAuthToken);
                                if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) break block51;
                                canceled = true;
                                if (!canceled && error == null) break block52;
                                ImportElementsPage.this.fCurrentProgressMonitor = null;
                            }
                            if (in != null) {
                                try {
                                    if ((canceled || error != null) && in instanceof IAbortable) {
                                        ((IAbortable)in).abort();
                                    } else {
                                        in.close();
                                    }
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            return;
                        }
                        types = Owl.getInterpreter().importFrom(in);
                        ImportElementsPage.this.enableSynchronization(types);
                        if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) break block53;
                        canceled = true;
                        if (!canceled && error == null) break block54;
                        ImportElementsPage.this.fCurrentProgressMonitor = null;
                    }
                    if (in != null) {
                        try {
                            if ((canceled || error != null) && in instanceof IAbortable) {
                                ((IAbortable)in).abort();
                            } else {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    return;
                }
                try {
                    try {
                        try {
                            JobRunner.runInUIThread((Widget)ImportElementsPage.this.getShell(), new Runnable(){

                                public void run() {
                                    ImportElementsPage.this.setImportedElements(types);
                                    ImportElementsPage.this.updateMessage(true);
                                }
                            });
                        }
                        catch (Exception e) {
                            error = e;
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (canceled || error != null) {
                        ImportElementsPage.this.fCurrentProgressMonitor = null;
                    }
                    if (in != null) {
                        try {
                            if ((canceled || error != null) && in instanceof IAbortable) {
                                ((IAbortable)in).abort();
                            } else {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                monitor.done();
                ImportElementsPage.this.fCurrentProgressMonitor = null;
            }
        };
        this.getContainer().run(true, true, runnable);
    }

    private void enableSynchronization(List<IEntity> types) throws URISyntaxException {
        for (IEntity entity : types) {
            if (entity instanceof IFolder) {
                this.enableSynchronization((IFolder)entity);
                continue;
            }
            if (!(entity instanceof IBookMark)) continue;
            this.enableSynchronization((IBookMark)entity);
        }
        if (!types.isEmpty() && types.get(0) instanceof IFolder) {
            IModelFactory factory = Owl.getModelFactory();
            IFolder root = (IFolder)types.get(0);
            FeedLinkReference feedLinkRef = new FeedLinkReference(URI.create("reader://shared"));
            IBookMark bm = factory.createBookMark(null, root, feedLinkRef, Messages.ImportElementsPage_GR_SHARED_ITEMS);
            this.setSynchronizationProperties(bm);
            feedLinkRef = new FeedLinkReference(URI.create("reader://recommended"));
            bm = factory.createBookMark(null, root, feedLinkRef, Messages.ImportElementsPage_GR_RECOMMENDED_ITEMS);
            this.setSynchronizationProperties(bm);
            feedLinkRef = new FeedLinkReference(URI.create("reader://notes"));
            bm = factory.createBookMark(null, root, feedLinkRef, Messages.ImportElementsPage_GR_NOTES);
            this.setSynchronizationProperties(bm);
        }
    }

    private void enableSynchronization(IFolder folder) throws URISyntaxException {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IFolder) {
                this.enableSynchronization((IFolder)child);
                continue;
            }
            if (!(child instanceof IBookMark)) continue;
            this.enableSynchronization((IBookMark)child);
        }
    }

    private void enableSynchronization(IBookMark bm) throws URISyntaxException {
        FeedLinkReference feedLinkReference = bm.getFeedLinkReference();
        bm.setFeedLinkReference(new FeedLinkReference(this.enableSynchronization(feedLinkReference.getLink())));
        this.setSynchronizationProperties(bm);
    }

    private void setSynchronizationProperties(IBookMark bm) {
        IPreferenceScope preferences = Owl.getPreferenceService().getEntityScope((IEntity)bm);
        preferences.putBoolean(DefaultPreferences.BM_RELOAD_ON_STARTUP, true);
        preferences.putBoolean(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE, false);
    }

    private URI enableSynchronization(URI uri) throws URISyntaxException {
        String scheme = "https".equals(uri.getScheme()) ? "readers" : "reader";
        return new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    private void importFromKeywordSearch(final String keywords, final boolean isLocalizedSearch) throws Exception {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    monitor.beginTask(Messages.ImportElementsPage_SEARCHING_FOR_FEEDS, -1);
                    monitor.subTask(Messages.ImportElementsPage_CONNECTING);
                    ImportElementsPage.this.fCurrentProgressMonitor = monitor;
                    String linkVal = Controller.getDefault().toFeedSearchLink(keywords);
                    if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                        return;
                    }
                    try {
                        ImportElementsPage.this.importFromOnlineResourceBruteforce(new URI(linkVal), monitor, true, isLocalizedSearch);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                    ImportElementsPage.this.fCurrentProgressMonitor = null;
                }
            }
        };
        this.getContainer().run(true, true, runnable);
    }

    private void importFromOnlineResourceBruteforce(URI resourceLink, IProgressMonitor monitor, final boolean isKeywordSearch, boolean isLocalizedSearch) throws ConnectionException, IOException {
        URI feed;
        Pair<String, URI> result = this.readContent(resourceLink, isLocalizedSearch, monitor);
        if (result == null) {
            return;
        }
        String content = (String)result.getFirst();
        resourceLink = (URI)result.getSecond();
        ArrayList<String> links = new ArrayList<String>();
        if (!isKeywordSearch) {
            links.add(resourceLink.toString());
        }
        if (StringUtils.isSet((String)content)) {
            links.addAll(RegExUtils.extractLinksFromText((String)content, (boolean)false));
        }
        final String resourceLinkValue = resourceLink.toString();
        Collections.sort(links, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (URIUtils.looksLikeFeedLink((String)o1, (boolean)false)) {
                    return -1;
                }
                if (URIUtils.looksLikeFeedLink((String)o2, (boolean)false)) {
                    return 1;
                }
                if (!isKeywordSearch) {
                    if (o1.contains(resourceLinkValue)) {
                        return -1;
                    }
                    if (o2.contains(resourceLinkValue)) {
                        return 1;
                    }
                }
                return -1;
            }
        });
        if (!isKeywordSearch && (feed = CoreUtils.findFeed((BufferedReader)new BufferedReader(new StringReader(content)), (URI)resourceLink, (IProgressMonitor)monitor)) != null) {
            String feedStr = feed.toString();
            if (links.contains(feedStr)) {
                links.remove(feedStr);
            }
            links.add(0, feedStr);
        }
        this.importFromLinksBruteforce(links, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importFromLinksBruteforce(List<String> links, IProgressMonitor monitor) {
        if (monitor.isCanceled()) return;
        if (Controller.getDefault().isShuttingDown()) {
            return;
        }
        monitor.beginTask(Messages.ImportElementsPage_SEARCHING_FOR_FEEDS, links.size());
        monitor.subTask(Messages.ImportElementsPage_FETCHING_RESULTS);
        IFolder defaultRootFolder = Owl.getModelFactory().createFolder(null, null, Messages.ImportElementsPage_BOOKMARKS);
        defaultRootFolder.setProperty("org.rssowl.core.interpreter.typeimporter.TemporaryFolder", (Serializable)Boolean.valueOf(true));
        int counter = 0;
        ArrayList<String> foundBookMarkNames = new ArrayList<String>();
        IBookMarkDAO dao = (IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class);
        for (String feedLinkVal : links) {
            IFeed feed;
            URI feedLink;
            Exception error;
            boolean canceled;
            InputStream in;
            block39: {
                block42: {
                    block41: {
                        monitor.worked(1);
                        in = null;
                        canceled = false;
                        error = null;
                        feedLink = new URI(feedLinkVal);
                        if (counter == 1) {
                            monitor.subTask(Messages.ImportElementsPage_SINGLE_RESULT);
                        } else if (counter > 1) {
                            monitor.subTask(NLS.bind((String)Messages.ImportElementsPage_N_RESULTS, (Object)counter));
                        }
                        if (dao.exists(new FeedLinkReference(feedLink)) || feedLinkVal.endsWith("/") && dao.exists(new FeedLinkReference(new URI(feedLinkVal.substring(0, feedLinkVal.length() - 1)))) || !feedLinkVal.endsWith("/") && dao.exists(new FeedLinkReference(new URI(String.valueOf(feedLinkVal) + "/")))) {
                            if (in == null) continue;
                            try {
                                if ((canceled || error != null) && in instanceof IAbortable) {
                                    ((IAbortable)in).abort();
                                    continue;
                                }
                                in.close();
                            }
                            catch (IOException iOException) {}
                            continue;
                        }
                        if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) break block41;
                        in = this.openStream(feedLink, monitor, 7000, false, false, null);
                        if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) break block42;
                        canceled = true;
                    }
                    if (in == null) break;
                    try {
                        if ((canceled || error != null) && in instanceof IAbortable) {
                            ((IAbortable)in).abort();
                            break;
                        }
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                feed = Owl.getModelFactory().createFeed(null, feedLink);
                Owl.getInterpreter().interpret(in, feed, null);
                this.fLoadedFeedCache.put(feedLink, feed);
                if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) break block39;
                canceled = true;
                if (in == null) break;
                try {
                    if ((canceled || error != null) && in instanceof IAbortable) {
                        ((IAbortable)in).abort();
                        break;
                    }
                    in.close();
                }
                catch (IOException iOException) {}
                break;
            }
            try {
                try {
                    if (!feed.getNews().isEmpty() && StringUtils.isSet((String)feed.getTitle())) {
                        String title = feed.getTitle();
                        boolean sameTitleExists = foundBookMarkNames.contains(title);
                        if (sameTitleExists && StringUtils.isSet((String)feed.getFormat())) {
                            title = NLS.bind((String)Messages.ImportElementsPage_FEED_TITLE, (Object)title, (Object)feed.getFormat());
                        }
                        final IBookMark bookmark = Owl.getModelFactory().createBookMark(null, defaultRootFolder, new FeedLinkReference(feedLink), title);
                        foundBookMarkNames.add(bookmark.getName());
                        ++counter;
                        if (StringUtils.isSet((String)feed.getDescription())) {
                            bookmark.setProperty("org.rssowl.core.interpreter.typeimporter.Description", (Serializable)((Object)feed.getDescription()));
                        }
                        if (feed.getHomepage() != null) {
                            bookmark.setProperty("org.rssowl.core.interpreter.typeimporter.Homepage", (Serializable)feed.getHomepage());
                        }
                        JobRunner.runInUIThread((Widget)this.getShell(), new Runnable(){

                            public void run() {
                                ImportElementsPage.this.addImportedElement((IFolderChild)bookmark);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    error = e;
                    if (in == null) continue;
                    try {
                        if ((canceled || error != null) && in instanceof IAbortable) {
                            ((IAbortable)in).abort();
                            continue;
                        }
                        in.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    if ((canceled || error != null) && in instanceof IAbortable) {
                        ((IAbortable)in).abort();
                        throw throwable;
                    }
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            if (in == null) continue;
            try {
                if ((canceled || error != null) && in instanceof IAbortable) {
                    ((IAbortable)in).abort();
                    continue;
                }
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (counter != 0) return;
        JobRunner.runInUIThread((Widget)this.getShell(), new Runnable(){

            public void run() {
                ImportElementsPage.this.setMessage(Messages.ImportElementsPage_NO_FEEDS_FOUND, 1);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<String, URI> readContent(URI link, boolean isLocalizedSearch, IProgressMonitor monitor) throws ConnectionException, IOException {
        InputStream in = null;
        try {
            if (monitor.isCanceled()) return null;
            if (Controller.getDefault().isShuttingDown()) {
                return null;
            }
            in = this.openStream(link, monitor, 30000, true, isLocalizedSearch, null);
            if (monitor.isCanceled()) return null;
            if (Controller.getDefault().isShuttingDown()) {
                return null;
            }
            String content = StringUtils.readString((Reader)new InputStreamReader(in));
            if (in instanceof HttpConnectionInputStream) {
                Pair pair = Pair.create((Object)content, (Object)((HttpConnectionInputStream)in).getLink());
                return pair;
            }
            Pair pair = Pair.create((Object)content, (Object)link);
            return pair;
        }
        finally {
            if (in instanceof IAbortable) {
                ((IAbortable)in).abort();
            } else if (in != null) {
                in.close();
            }
        }
    }

    private InputStream openStream(URI link, IProgressMonitor monitor, int timeout, boolean setAcceptLanguage, boolean isLocalized, String authToken) throws ConnectionException {
        IProtocolHandler handler = Owl.getConnectionService().getHandler(link);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("CON_TIMEOUT", timeout);
        if (StringUtils.isSet((String)authToken)) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", SyncUtils.getGoogleAuthorizationHeader((String)authToken));
            properties.put("HEADERS", headers);
        }
        if (setAcceptLanguage) {
            StringBuilder languageHeader = new StringBuilder();
            String clientLanguage = Locale.getDefault().getLanguage();
            if (!isLocalized) {
                languageHeader.append(DEFAULT_LANGUAGE);
                if (StringUtils.isSet((String)clientLanguage) && !DEFAULT_LANGUAGE.equals(clientLanguage)) {
                    languageHeader.append(",").append(clientLanguage);
                }
            } else if (StringUtils.isSet((String)clientLanguage)) {
                languageHeader.append(clientLanguage);
            } else {
                languageHeader.append(DEFAULT_LANGUAGE);
            }
            properties.put("ACCEPT_LANGUAGE", languageHeader.toString());
        }
        return handler.openStream(link, monitor, properties);
    }

    private void setImportedElements(List<? extends IEntity> types) {
        ArrayList<IFolderChild> folderChilds = new ArrayList<IFolderChild>();
        for (IEntity iEntity : types) {
            if (iEntity instanceof IFolderChild) {
                folderChilds.add((IFolderChild)iEntity);
                continue;
            }
            if (iEntity instanceof ILabel) {
                this.fLabels.add((ILabel)iEntity);
                continue;
            }
            if (iEntity instanceof ISearchFilter) {
                this.fFilters.add((ISearchFilter)iEntity);
                continue;
            }
            if (!(iEntity instanceof IPreference)) continue;
            this.fPreferences.add((IPreference)iEntity);
        }
        if (!this.fHideExistingCheck.getSelection()) {
            this.fHideExistingCheck.setSelection(true);
            this.fViewer.addFilter((ViewerFilter)this.fExistingFilter);
        }
        this.fViewer.setInput(folderChilds);
        OwlUI.setAllChecked(this.fViewer.getTree(), true);
        this.fExistingFilter.clear();
    }

    private void addImportedElement(IFolderChild child) {
        Object input = this.fViewer.getInput();
        ((List)input).add(child);
        this.fViewer.add(input, (Object)child);
        this.fViewer.setChecked((Object)child, true);
        this.fViewer.reveal((Object)child);
    }

    private static class ExistingBookmarkFilter
    extends ViewerFilter {
        private IBookMarkDAO dao = (IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class);
        private Map<IFolderChild, Boolean> cache = new IdentityHashMap<IFolderChild, Boolean>();

        private ExistingBookmarkFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFolderChild) {
                return this.select((IFolderChild)element);
            }
            return true;
        }

        void clear() {
            this.cache.clear();
        }

        private boolean select(IFolderChild element) {
            if (element instanceof IBookMark) {
                IBookMark bm = (IBookMark)element;
                Boolean select = this.cache.get(bm);
                if (select == null) {
                    select = !this.dao.exists(bm.getFeedLinkReference());
                    this.cache.put((IFolderChild)bm, select);
                }
                return select;
            }
            if (element instanceof INewsBin) {
                INewsBin bin = (INewsBin)element;
                Boolean select = this.cache.get(bin);
                if (select == null) {
                    select = !CoreUtils.existsNewsBin((INewsBin)bin);
                    this.cache.put((IFolderChild)bin, select);
                }
                return select;
            }
            if (element instanceof ISearchMark) {
                ISearchMark searchmark = (ISearchMark)element;
                Boolean select = this.cache.get(searchmark);
                if (select == null) {
                    select = !CoreUtils.existsSearchMark((ISearchMark)searchmark);
                    this.cache.put((IFolderChild)searchmark, select);
                }
                return select;
            }
            if (element instanceof IFolder) {
                IFolder folder = (IFolder)element;
                Boolean select = this.cache.get(folder);
                if (select == null) {
                    List children = folder.getChildren();
                    for (IFolderChild child : children) {
                        select = this.select(child);
                        if (select.booleanValue()) break;
                    }
                    this.cache.put((IFolderChild)folder, select);
                }
                return select != null ? select : false;
            }
            return true;
        }
    }
}

