/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import org.rssowl.core.internal.persist.service.Counter;
import org.rssowl.core.internal.persist.service.DBManager;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.internal.persist.service.DatabaseListener;
import org.rssowl.core.persist.service.IDGenerator;

public class DB4OIDGenerator
implements IDGenerator,
DatabaseListener {
    private static final int BATCH_SIZE = 100;
    private long fCurrent = -1L;
    private long fMax;
    private ObjectContainer fDb;
    private Counter fCounter;

    public DB4OIDGenerator() {
        DBManager.getDefault().addEntityStoreListener(this);
    }

    public void databaseClosed(DatabaseEvent event) {
        this.setObjectContainer(null);
    }

    public void databaseOpened(DatabaseEvent event) {
        this.setObjectContainer(event.getObjectContainer());
    }

    private synchronized void setObjectContainer(ObjectContainer db) {
        this.fDb = db;
        if (this.fDb == null) {
            this.fCurrent = -1L;
            this.fCounter = null;
            this.fMax = 0L;
        } else {
            this.fCounter = this.loadOrCreateCounter();
            this.fCurrent = this.fCounter.getValue();
            this.fMax = this.increaseMax(true);
        }
    }

    public long getNext() {
        return this.getNext(true);
    }

    public synchronized long getNext(boolean commit) {
        this.checkCurrent();
        ++this.fCurrent;
        if (this.fCurrent > this.fMax) {
            this.fMax = this.increaseMax(commit);
        }
        return this.fCurrent;
    }

    private void checkCurrent() {
        if (this.fCurrent == -1L) {
            throw new IllegalStateException("current has not been initialised yet.");
        }
    }

    private long increaseMax(boolean commit) {
        this.fCounter.increment(100);
        this.fDb.set((Object)this.fCounter);
        if (commit) {
            this.fDb.commit();
        }
        return this.fCounter.getValue();
    }

    public synchronized void shutdown() {
        if (this.fCounter != null) {
            this.fMax = this.fCurrent;
            this.fCounter.setValue(this.fCurrent + 1L);
            this.fDb.set((Object)this.fCounter);
            this.fDb.commit();
        }
    }

    private Counter loadCounter() {
        ObjectSet counters = this.fDb.ext().query(Counter.class);
        if (!counters.isEmpty()) {
            return (Counter)counters.iterator().next();
        }
        return null;
    }

    private Counter loadOrCreateCounter() {
        Counter counter = this.loadCounter();
        if (counter == null) {
            counter = new Counter(0L);
        }
        return counter;
    }
}

