/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jcarrierpigeon;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.Timer;
import net.sf.jcarrierpigeon.Notification;

public class NotificationQueue
implements ActionListener {
    private Queue<Notification> queue = new LinkedList<Notification>();
    private Timer timer = new Timer(50, this);
    private Notification current = null;

    public synchronized void add(Notification notification) {
        if (this.queue.isEmpty() && this.current == null) {
            this.current = notification;
            this.current.animate();
        } else {
            this.queue.offer(notification);
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.current != null) {
            if (!this.queue.isEmpty() && !this.current.isRunning()) {
                this.current = this.queue.poll();
                this.current.animate();
            } else if (this.queue.isEmpty()) {
                this.timer.stop();
            }
        }
    }
}

