/*
 * Decompiled with CFR 0.152.
 */
package mediathek.res;

import java.io.File;
import javax.swing.ImageIcon;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.tool.GuiFunktionen;

public class GetIcon {
    private static final String PFAD_PROGRAMM = "/mediathek/res/programm/";
    private static final String PFAD_SENDER = "/mediathek/res/sender/";
    public static final String PFAD_RES = "/mediathek/res/";

    public static ImageIcon getIcon(String strIcon) {
        return GetIcon.getIcon(strIcon, PFAD_RES);
    }

    public static ImageIcon getSenderIcon(String strIcon) {
        return GetIcon.getIcon(strIcon, PFAD_SENDER);
    }

    public static ImageIcon getProgramIcon(String strIcon) {
        return GetIcon.getIcon(strIcon, PFAD_PROGRAMM);
    }

    public static ImageIcon getIcon(String strIcon, String path) {
        ImageIcon icon;
        if (Boolean.parseBoolean(Daten.mVConfig.get("Icon-Standard"))) {
            return GetIcon.getStandard(strIcon, path);
        }
        try {
            String pfad = GuiFunktionen.addsPfad(Daten.mVConfig.get("Icon-Pfad"), strIcon);
            icon = new File(pfad).exists() ? new ImageIcon(pfad) : GetIcon.getStandard(strIcon, path);
        }
        catch (Exception ex) {
            Log.fehlerMeldung(932107891, strIcon);
            icon = GetIcon.getStandard(strIcon, path);
        }
        return icon;
    }

    private static ImageIcon getStandard(String strIcon, String path) {
        return new ImageIcon(GetIcon.class.getResource(path + strIcon));
    }
}

