/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.UIManagerExt;

public abstract class LookAndFeelAddons {
    private static final Logger LOG = Logger.getLogger(LookAndFeelAddons.class.getName());
    private static List<ComponentAddon> contributedComponents = new ArrayList<ComponentAddon>();
    private static final Object APPCONTEXT_INITIALIZED = new Object();
    private static boolean trackingChanges = false;
    private static PropertyChangeListener changeListener;
    private static LookAndFeelAddons currentAddon;

    protected boolean matches() {
        return false;
    }

    protected boolean isSystemAddon() {
        return false;
    }

    public void initialize() {
        for (ComponentAddon addon : contributedComponents) {
            addon.initialize(this);
        }
    }

    public void uninitialize() {
        for (ComponentAddon addon : contributedComponents) {
            addon.uninitialize(this);
        }
    }

    public void loadDefaults(Object[] keysAndValues) {
        for (int i = keysAndValues.length - 2; i >= 0; i -= 2) {
            if (UIManager.getLookAndFeelDefaults().get(keysAndValues[i]) != null) continue;
            UIManager.getLookAndFeelDefaults().put(keysAndValues[i], keysAndValues[i + 1]);
        }
    }

    public void unloadDefaults(Object[] keysAndValues) {
    }

    public static void setAddon(String addonClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LookAndFeelAddons.setAddon(Class.forName(addonClassName, true, LookAndFeelAddons.getClassLoader()));
    }

    public static void setAddon(Class<?> addonClass) throws InstantiationException, IllegalAccessException {
        LookAndFeelAddons addon = (LookAndFeelAddons)addonClass.newInstance();
        LookAndFeelAddons.setAddon(addon);
    }

    public static void setAddon(LookAndFeelAddons addon) {
        if (currentAddon != null) {
            currentAddon.uninitialize();
        }
        addon.initialize();
        currentAddon = addon;
        UIManager.put(APPCONTEXT_INITIALIZED, Boolean.TRUE);
        UIManager.getLookAndFeelDefaults().put(APPCONTEXT_INITIALIZED, Boolean.TRUE);
    }

    public static LookAndFeelAddons getAddon() {
        return currentAddon;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = null;
        try {
            cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return LookAndFeelAddons.class.getClassLoader();
                }
            });
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        if (cl == null) {
            final Thread t = Thread.currentThread();
            try {
                cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return t.getContextClassLoader();
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (cl == null) {
            try {
                cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return ClassLoader.getSystemClassLoader();
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return cl;
    }

    public static String getBestMatchAddonClassName() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        String className = null;
        if (UIManager.getCrossPlatformLookAndFeelClassName().equals(laf.getClass().getName())) {
            className = LookAndFeelAddons.getCrossPlatformAddonClassName();
        } else if (UIManager.getSystemLookAndFeelClassName().equals(laf.getClass().getName())) {
            className = LookAndFeelAddons.getSystemAddonClassName();
        } else {
            Iterable<LookAndFeelAddons> loadedAddons = LookAndFeelAddons.getProvidedLookAndFeelAddons();
            for (LookAndFeelAddons addon : loadedAddons) {
                if (!addon.matches()) continue;
                className = addon.getClass().getName();
                break;
            }
        }
        if (className == null) {
            className = LookAndFeelAddons.getSystemAddonClassName();
        }
        return className;
    }

    public static String getCrossPlatformAddonClassName() {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("swing.crossplatformlafaddon", "org.jdesktop.swingx.plaf.metal.MetalLookAndFeelAddons");
                }
            });
        }
        catch (SecurityException securityException) {
            return "org.jdesktop.swingx.plaf.metal.MetalLookAndFeelAddons";
        }
    }

    public static String getSystemAddonClassName() {
        Iterable<LookAndFeelAddons> loadedAddons = LookAndFeelAddons.getProvidedLookAndFeelAddons();
        String className = null;
        for (LookAndFeelAddons addon : loadedAddons) {
            if (!addon.isSystemAddon()) continue;
            className = addon.getClass().getName();
            break;
        }
        if (className == null) {
            className = LookAndFeelAddons.getCrossPlatformAddonClassName();
        }
        return className;
    }

    protected static Iterable<LookAndFeelAddons> getProvidedLookAndFeelAddons() {
        final ServiceLoader<LookAndFeelAddons> loader = ServiceLoader.load(LookAndFeelAddons.class, LookAndFeelAddons.getClassLoader());
        AccessController.doPrivileged(new PrivilegedAction<Iterable<LookAndFeelAddons>>(){

            @Override
            public Iterable<LookAndFeelAddons> run() {
                loader.iterator().hasNext();
                return loader;
            }
        });
        return loader;
    }

    public static void contribute(ComponentAddon component) {
        contributedComponents.add(component);
        if (currentAddon != null) {
            component.initialize(currentAddon);
        }
    }

    public static void uncontribute(ComponentAddon component) {
        contributedComponents.remove(component);
        if (currentAddon != null) {
            component.uninitialize(currentAddon);
        }
    }

    public static ComponentUI getUI(JComponent component, Class<?> expectedUIClass) {
        LookAndFeelAddons.maybeInitialize();
        String uiClassname = (String)UIManager.get(component.getUIClassID());
        if (uiClassname == null) {
            Logger logger = Logger.getLogger("LookAndFeelAddons");
            logger.warning("Failed to retrieve UI for " + component.getClass().getName() + " with UIClassID " + component.getUIClassID());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Existing UI defaults keys: " + new ArrayList(UIManager.getDefaults().keySet()));
            }
            uiClassname = "org.jdesktop.swingx.plaf.basic.Basic" + expectedUIClass.getSimpleName();
        }
        try {
            Class<?> uiClass = Class.forName(uiClassname);
            UIManager.put(uiClassname, uiClass);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        ComponentUI ui = UIManager.getUI(component);
        if (expectedUIClass.isInstance(ui)) {
            return ui;
        }
        if (ui == null) {
            LookAndFeelAddons.barkOnUIError("no ComponentUI class for: " + component);
        } else {
            String realUI = ui.getClass().getName();
            Class<?> realUIClass = null;
            try {
                realUIClass = expectedUIClass.getClassLoader().loadClass(realUI);
            }
            catch (ClassNotFoundException e) {
                LookAndFeelAddons.barkOnUIError("failed to load class " + realUI);
            }
            if (realUIClass != null) {
                try {
                    Method createUIMethod = realUIClass.getMethod("createUI", JComponent.class);
                    return (ComponentUI)createUIMethod.invoke(null, component);
                }
                catch (NoSuchMethodException e) {
                    LookAndFeelAddons.barkOnUIError("static createUI() method not found in " + realUIClass);
                }
                catch (Exception e) {
                    LookAndFeelAddons.barkOnUIError("createUI() failed for " + component + " " + e);
                }
            }
        }
        return null;
    }

    private static void barkOnUIError(String message) {
        System.err.println(message);
        new Error().printStackTrace();
    }

    private static synchronized void maybeInitialize() {
        UIDefaults defaults;
        if (currentAddon != null && !(defaults = UIManager.getLookAndFeelDefaults()).getBoolean(APPCONTEXT_INITIALIZED)) {
            LookAndFeelAddons.setAddon(currentAddon);
        }
    }

    public static synchronized void setTrackingLookAndFeelChanges(boolean tracking) {
        if (trackingChanges != tracking) {
            if (tracking) {
                if (changeListener == null) {
                    changeListener = new UpdateAddon();
                }
                UIManager.addPropertyChangeListener(changeListener);
            } else {
                if (changeListener != null) {
                    UIManager.removePropertyChangeListener(changeListener);
                }
                changeListener = null;
            }
            trackingChanges = tracking;
        }
    }

    public static synchronized boolean isTrackingLookAndFeelChanges() {
        return trackingChanges;
    }

    public static void installBackgroundPainter(JComponent c, String painter) {
        Class<?> clazz = c.getClass();
        try {
            Method getter = clazz.getMethod("getBackgroundPainter", new Class[0]);
            Method setter = clazz.getMethod("setBackgroundPainter", Painter.class);
            Painter p = (Painter)getter.invoke((Object)c, new Object[0]);
            if (p == null || p instanceof UIResource) {
                setter.invoke((Object)c, UIManagerExt.getPainter(painter));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot set painter on " + c.getClass());
        }
    }

    public static void uninstallBackgroundPainter(JComponent c) {
        Class<?> clazz = c.getClass();
        try {
            Method getter = clazz.getMethod("getBackgroundPainter", new Class[0]);
            Method setter = clazz.getMethod("setBackgroundPainter", Painter.class);
            Painter p = (Painter)getter.invoke((Object)c, new Object[0]);
            if (p == null || p instanceof UIResource) {
                setter.invoke((Object)c, new Object[]{null});
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot set painter on " + c.getClass());
        }
    }

    static {
        String addonClassname = LookAndFeelAddons.getBestMatchAddonClassName();
        try {
            addonClassname = System.getProperty("swing.addon", addonClassname);
        }
        catch (SecurityException ignore) {
            LOG.log(Level.FINE, "not allowed to access property swing.addon", ignore);
        }
        try {
            LookAndFeelAddons.setAddon(addonClassname);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        LookAndFeelAddons.setTrackingLookAndFeelChanges(true);
    }

    private static class UpdateAddon
    implements PropertyChangeListener {
        private UpdateAddon() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                LookAndFeelAddons.setAddon(LookAndFeelAddons.getBestMatchAddonClassName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

