/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action.playlist;

import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Response;
import com.pugh.sockso.web.Server;
import com.pugh.sockso.web.action.FileServer;
import com.pugh.sockso.web.action.WebAction;
import com.pugh.sockso.web.action.playlist.PlaylistTemplate;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Playlister
extends WebAction {
    private final Server sv;
    private final String extension;

    protected abstract PlaylistTemplate getPlaylistTemplate();

    protected Playlister(Server sv, String extension) {
        this.sv = sv;
        this.extension = extension;
    }

    @Override
    public void handleRequest() throws IOException, SQLException, BadRequestException {
        Request req = this.getRequest();
        String type = req.getUrlParam(1);
        if (type.equals("random")) {
            this.createRandomPlaylist();
        } else {
            this.createPlaylist(req.getPlayParams(false));
        }
    }

    public void createRandomPlaylist() throws IOException, SQLException {
        this.showPlaylist(this.getRandomTracks());
    }

    public void createPlaylist(String[] args) throws SQLException, BadRequestException, IOException {
        Database db = this.getDatabase();
        Request req = this.getRequest();
        String orderBySql = req.getArgument("orderBy").equals("random") ? " order by rand() " : "";
        Vector<Track> tracks = Track.getTracksFromPlayArgs(db, args, orderBySql);
        this.showPlaylist(tracks);
    }

    protected void showPlaylist(Vector<Track> tracks) throws IOException {
        this.sendHeaders();
        PlaylistTemplate tpl = this.getPlaylistTemplate();
        tpl.setProperties(this.getProperties());
        tpl.setUser(this.getUser());
        tpl.setRequest(this.getRequest());
        tpl.setTracks(tracks);
        tpl.setServer(this.sv);
        this.getResponse().showTemplate(tpl.makeRenderer());
    }

    private void sendHeaders() {
        Response res = this.getResponse();
        String filename = "playlist." + this.extension;
        res.addHeader("Content-type", FileServer.getMimeType(filename));
        res.addHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
        res.addHeader("Expires", "0");
        res.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        res.addHeader("Pragma", "nocache");
    }
}

