/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.profiler.api;

import java.util.Arrays;
import java.util.List;
import org.netbeans.api.java.platform.JavaPlatform;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ProfilerServerSettings {
    private JavaPlatform javaPlatform;
    private String[] jvmArgs;
    private String[] env;

    public ProfilerServerSettings(JavaPlatform javaPlatform, String[] stringArray, String[] stringArray2) {
        if (javaPlatform == null) {
            throw new NullPointerException("The javaPlatform argument must not be null.");
        }
        if (stringArray == null) {
            throw new NullPointerException("The jvmArgs argument must not be null.");
        }
        if (stringArray2 == null) {
            throw new NullPointerException("The env argument must not be null.");
        }
        this.javaPlatform = javaPlatform;
        this.jvmArgs = stringArray;
        this.env = stringArray2;
    }

    public JavaPlatform getJavaPlatform() {
        return this.javaPlatform;
    }

    public String[] getJvmArgs() {
        return this.jvmArgs;
    }

    public String[] getEnv() {
        return this.env;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProfilerServerSettings)) {
            return false;
        }
        ProfilerServerSettings profilerServerSettings = (ProfilerServerSettings)object;
        FileObject fileObject = (FileObject)this.javaPlatform.getInstallFolders().iterator().next();
        FileObject fileObject2 = (FileObject)profilerServerSettings.javaPlatform.getInstallFolders().iterator().next();
        if (!FileUtil.toFile((FileObject)fileObject).equals(FileUtil.toFile((FileObject)fileObject2))) {
            return false;
        }
        if (this.jvmArgs.length != profilerServerSettings.jvmArgs.length) {
            return false;
        }
        List<String> list = Arrays.asList(this.jvmArgs);
        for (int i = 0; i < profilerServerSettings.jvmArgs.length; ++i) {
            if (list.contains(profilerServerSettings.jvmArgs[i])) continue;
            return false;
        }
        if (this.env.length != profilerServerSettings.env.length) {
            return false;
        }
        List<String> list2 = Arrays.asList(this.env);
        for (int i = 0; i < profilerServerSettings.env.length; ++i) {
            if (list2.contains(profilerServerSettings.env[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        FileObject fileObject = (FileObject)this.javaPlatform.getInstallFolders().iterator().next();
        n = 37 * n + FileUtil.toFile((FileObject)fileObject).hashCode();
        Object[] objectArray = (String[])this.jvmArgs.clone();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            n = 37 * n + ((String)objectArray[i]).hashCode();
        }
        Object[] objectArray2 = (String[])this.env.clone();
        Arrays.sort(objectArray2);
        for (int i = 0; i < objectArray2.length; ++i) {
            n = 37 * n + ((String)objectArray2[i]).hashCode();
        }
        return n;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ProfilerServerSettings [\n");
        stringBuffer.append("  javaPlatform: " + this.javaPlatform.getDisplayName() + "\n");
        stringBuffer.append("  jvmarg:   ");
        for (n = 0; n < this.jvmArgs.length; ++n) {
            stringBuffer.append(this.jvmArgs[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("  env:      ");
        for (n = 0; n < this.env.length; ++n) {
            stringBuffer.append(this.env[n] + " ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

