/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.wizard.AddServerInstanceWizard;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerChooserVisual
extends JPanel {
    private final List listeners = new ArrayList();
    private AddServerInstanceWizard wizard;
    private HashMap displayNames = new HashMap();
    private boolean updatingDisplayName = false;
    private JTextField displayNameEditField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JList serverListBox;

    public ServerChooserVisual() {
        this.initComponents();
        ServerAdapter serverAdapter = (ServerAdapter)((ComboBoxModel)this.serverListBox.getModel()).getSelectedItem();
        this.serverListBox.setSelectedValue(serverAdapter, true);
        if (serverAdapter != null) {
            this.fillDisplayName(serverAdapter.getServer());
        }
        this.displayNameEditField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ServerChooserVisual.this.displayNameEditFieldUpdate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ServerChooserVisual.this.displayNameEditFieldUpdate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ServerChooserVisual.this.displayNameEditFieldUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    public void read(AddServerInstanceWizard addServerInstanceWizard) {
        Object object;
        if (this.wizard == null) {
            this.wizard = addServerInstanceWizard;
        }
        if ((object = addServerInstanceWizard.getProperty("ServInstWizard_displayName")) != null) {
            this.displayNameEditField.setText((String)object);
        }
    }

    public void store(AddServerInstanceWizard addServerInstanceWizard) {
        addServerInstanceWizard.putProperty("ServInstWizard_displayName", this.displayNameEditField.getText());
        Object e = this.serverListBox.getSelectedValue();
        if (e != null) {
            addServerInstanceWizard.putProperty("ServInstWizard_server", ((ServerAdapter)e).getServer());
        }
    }

    public boolean hasValidData() {
        boolean bl;
        boolean bl2 = bl = this.isServerValid() && this.isDisplayNameValid();
        if (bl) {
            this.wizard.setErrorMessage(null);
        }
        return bl;
    }

    private boolean isServerValid() {
        boolean bl;
        boolean bl2 = bl = this.serverListBox.getSelectedValue() != null;
        if (!bl) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerChooserVisual.class, (String)"MSG_SCV_ChooseServer"));
        }
        return bl;
    }

    private boolean isDisplayNameValid() {
        String string = this.displayNameEditField.getText().trim();
        if (string.length() <= 0) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerChooserVisual.class, (String)"MSG_SCV_DisplayName"));
            return false;
        }
        if (this.getServerInstance(string) != null) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerChooserVisual.class, (String)"MSG_SCV_DisplayNameExists"));
            return false;
        }
        return true;
    }

    private ServerInstance getServerInstance(String string) {
        for (ServerInstance serverInstance : ServerRegistry.getInstance().getInstances()) {
            if (serverInstance.getDisplayName() == null || !serverInstance.getDisplayName().equalsIgnoreCase(string)) continue;
            return serverInstance;
        }
        return null;
    }

    private void displayNameEditFieldUpdate() {
        if (!this.updatingDisplayName) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object object = this.listeners;
        synchronized (object) {
            arrayList = new ArrayList(this.listeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((ChangeListener)object.next()).stateChanged(changeEvent);
        }
    }

    private String generateDisplayName(Server server) {
        String string;
        int n = 0;
        do {
            string = server.getDisplayName();
            if (n != 0) {
                string = string + " (" + String.valueOf(n) + ")";
            }
            ++n;
        } while (this.getServerInstance(string) != null);
        return string;
    }

    private void fillDisplayName(Server server) {
        String string = (String)this.displayNames.get(server);
        if (string == null) {
            string = this.generateDisplayName(server);
        }
        this.updatingDisplayName = true;
        this.displayNameEditField.setText(string);
        this.updatingDisplayName = false;
        this.fireChange();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.displayNameEditField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.serverListBox = new JList();
        this.setName(NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_Name"));
        this.jLabel1.setLabelFor(this.serverListBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_Server"));
        this.jLabel2.setLabelFor(this.displayNameEditField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_DisplayName"));
        this.displayNameEditField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ServerChooserVisual.this.displayNameEditFieldKeyReleased(keyEvent);
            }
        });
        this.serverListBox.setModel(new ServerModel());
        this.serverListBox.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ServerChooserVisual.this.serverListBoxValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.serverListBox);
        this.serverListBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_NAME_Server"));
        this.serverListBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_DESC_Server"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.displayNameEditField, -1, 375, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 375, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jScrollPane1, -1, 202, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.displayNameEditField, -2, -1, -2)).addContainerGap()));
        this.displayNameEditField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_NAME_DisplayName"));
        this.displayNameEditField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_DESC_DisplayName"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_NAME"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_DESC"));
    }

    private void serverListBoxValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            ServerAdapter serverAdapter = (ServerAdapter)this.serverListBox.getSelectedValue();
            if (serverAdapter != null) {
                Server server = serverAdapter.getServer();
                if (server != null) {
                    this.fillDisplayName(server);
                }
            } else {
                this.fireChange();
            }
        }
    }

    private void displayNameEditFieldKeyReleased(KeyEvent keyEvent) {
        ServerAdapter serverAdapter = (ServerAdapter)this.serverListBox.getSelectedValue();
        if (serverAdapter != null) {
            this.displayNames.put(serverAdapter.getServer(), this.displayNameEditField.getText());
        }
    }

    private static class ServerAdapter
    implements Comparable {
        private Server server;

        public ServerAdapter(Server server) {
            this.server = server;
        }

        public Server getServer() {
            return this.server;
        }

        public String toString() {
            return this.server.getDisplayName();
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }
    }

    private static class ServerModel
    implements ComboBoxModel {
        private List servers = new ArrayList();
        private ServerAdapter selected;

        public ServerModel() {
            Collection<Server> collection = ServerRegistry.getInstance().getServers();
            for (Server server : collection) {
                OptionalDeploymentManagerFactory optionalDeploymentManagerFactory = server.getOptionalFactory();
                if (optionalDeploymentManagerFactory == null || optionalDeploymentManagerFactory.getAddInstanceIterator() == null) continue;
                ServerAdapter serverAdapter = new ServerAdapter(server);
                this.servers.add(serverAdapter);
                String string = server.getShortName();
                if (null != string && string.startsWith("gfv3")) {
                    this.selected = serverAdapter;
                }
                if (null != this.selected || !"J2EE".equals(string)) continue;
                this.selected = serverAdapter;
            }
            Collections.sort(this.servers);
            if (this.selected == null) {
                this.selected = this.servers.size() > 0 ? (ServerAdapter)this.servers.get(0) : null;
            }
        }

        public Object getElementAt(int n) {
            return this.servers.get(n);
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public int getSize() {
            return this.servers.size();
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object object) {
            this.selected = (ServerAdapter)object;
        }
    }
}

