/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.impl.InstancePropertiesImpl;
import org.netbeans.modules.j2ee.deployment.impl.ProgressObjectUtil;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.TimedOutException;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.plugins.spi.AntDeploymentProvider;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.deployment.plugins.spi.FindJSPServlet;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerInstanceDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.plugins.spi.TargetModuleIDResolver;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInstance
implements Node.Cookie,
Comparable {
    public static final int STATE_WAITING = 1;
    public static final int STATE_STOPPED = 2;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_DEBUGGING = 4;
    public static final int STATE_SUSPENDED = 5;
    public static final int STATE_PROFILING = 6;
    public static final int STATE_PROFILER_BLOCKING = 7;
    public static final int STATE_PROFILER_STARTING = 8;
    private static final int RUNNING_CHECK_TIMEOUT = 10000;
    private static final int DEBUGGING_CHECK_TIMEOUT = 10000;
    private static final long DEFAULT_TIMEOUT = 1200000L;
    private static final Logger LOGGER = Logger.getLogger(ServerInstance.class.getName());
    private final String url;
    private final Server server;
    private DeploymentManager manager;
    private DeploymentManager disconnectedManager;
    private IncrementalDeployment incrementalDeployment;
    private ServerInstanceDescriptor instanceDescriptor;
    private TargetModuleIDResolver tmidResolver;
    private J2eePlatform j2eePlatform;
    private J2eePlatformImpl j2eePlatformImpl;
    private StartServer startServer;
    private FindJSPServlet findJSPServlet;
    private DatasourceManager dsMgr;
    private DatasourceManager ddsMgr;
    private MessageDestinationDeployment msgDestDeploymentConnected;
    private MessageDestinationDeployment msgDestDeploymentDisconnected;
    private final Set targetsStartedByIde = new HashSet();
    private Map targets;
    private boolean managerStartedByIde = false;
    private ServerTarget coTarget = null;
    private final InstancePropertiesImpl instanceProperties;
    private final HashMap debugInfo = new HashMap();
    private volatile int serverState = 2;
    private final List stateListeners = new ArrayList();
    private long lastCheck = 0L;
    private boolean isRunning = false;
    private final ChangeSupport managerChangeSupport = new ChangeSupport((Object)this);
    private static volatile ServerInstance profiledServerInstance;
    private ProfilerServerSettings profilerSettings;
    private final DebuggerStateListener debuggerStateListener;

    public ServerInstance(Server server, String string) {
        this.server = server;
        this.url = string;
        this.instanceProperties = new InstancePropertiesImpl(string);
        this.debuggerStateListener = new DebuggerStateListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)this.debuggerStateListener);
    }

    public InstancePropertiesImpl getInstanceProperties() {
        return this.instanceProperties;
    }

    public String getDisplayName() {
        return this.instanceProperties.getProperty("displayName");
    }

    public void addManagerChangeListener(ChangeListener changeListener) {
        this.managerChangeSupport.addChangeListener(changeListener);
    }

    public void removeManagerChangeListener(ChangeListener changeListener) {
        this.managerChangeSupport.removeChangeListener(changeListener);
    }

    private long getTimeout(String string, long l) {
        long l2 = l;
        String string2 = this.instanceProperties.getProperty(string);
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.log(Level.FINE, "could not parse timeout property", numberFormatException);
            }
        }
        return l2;
    }

    private long getStartupTimeout() {
        return this.getTimeout("startupTimeout", 1200000L);
    }

    private long getShutdownTimeout() {
        return this.getTimeout("shutdownTimeout", 1200000L);
    }

    long getDeploymentTimeout() {
        return this.getTimeout("deploymentTimeout", 1200000L);
    }

    public Server getServer() {
        return this.server;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager() {
        DeploymentManager deploymentManager = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            deploymentManager = this.manager;
        }
        if (deploymentManager != null) {
            return deploymentManager;
        }
        try {
            serverInstance = ServerRegistry.getInstanceFileObject(this.url);
            if (serverInstance == null) {
                String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_NullInstanceFileObject", (Object)this.url);
                throw new IllegalStateException(string);
            }
            String string = (String)serverInstance.getAttribute("username");
            String string2 = (String)serverInstance.getAttribute("password");
            deploymentManager = this.server.getDeploymentManager(this.url, string, string2);
            boolean bl = false;
            ServerInstance serverInstance2 = this;
            synchronized (serverInstance2) {
                bl = this.manager != deploymentManager;
                this.manager = deploymentManager;
            }
            if (bl) {
                this.firePossibleManagerChange();
            }
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            throw new RuntimeException(deploymentManagerCreationException);
        }
        return deploymentManager;
    }

    public synchronized boolean isConnected() {
        return this.manager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDisconnectedDeploymentManager() throws DeploymentManagerCreationException {
        DeploymentManager deploymentManager = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            deploymentManager = this.disconnectedManager;
        }
        if (deploymentManager != null) {
            return deploymentManager;
        }
        serverInstance = ServerRegistry.getInstanceFileObject(this.url);
        if (serverInstance == null) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_NullInstanceFileObject", (Object)this.url);
            throw new DeploymentManagerCreationException(string);
        }
        deploymentManager = this.server.getDisconnectedDeploymentManager(this.url);
        boolean bl = false;
        ServerInstance serverInstance2 = this;
        synchronized (serverInstance2) {
            bl = this.manager == null && this.disconnectedManager != deploymentManager;
            this.disconnectedManager = deploymentManager;
        }
        if (bl) {
            this.firePossibleManagerChange();
        }
        return deploymentManager;
    }

    public J2eePlatform getJ2eePlatform() {
        return this.j2eePlatform;
    }

    public void setJ2eePlatform(J2eePlatform j2eePlatform) {
        this.j2eePlatform = j2eePlatform;
    }

    public J2eePlatformImpl getJ2eePlatformImpl() {
        block3: {
            J2eePlatformFactory j2eePlatformFactory;
            if (this.j2eePlatformImpl == null && (j2eePlatformFactory = this.server.getJ2eePlatformFactory()) != null) {
                try {
                    this.j2eePlatformImpl = j2eePlatformFactory.getJ2eePlatformImpl(this.isConnected() ? this.getDeploymentManager() : this.getDisconnectedDeploymentManager());
                }
                catch (DeploymentManagerCreationException deploymentManagerCreationException) {
                    FileObject fileObject = ServerRegistry.getInstanceFileObject(this.url);
                    if (fileObject == null) break block3;
                    Exceptions.printStackTrace((Throwable)deploymentManagerCreationException);
                }
            }
        }
        return this.j2eePlatformImpl;
    }

    public ServerDebugInfo getServerDebugInfo(Target target) {
        assert (this.debugInfo != null);
        ServerDebugInfo serverDebugInfo = null;
        if (target == null) {
            serverDebugInfo = (ServerDebugInfo)this.debugInfo.get(null);
        } else {
            Iterator iterator = this.debugInfo.keySet().iterator();
            while (serverDebugInfo == null && iterator.hasNext()) {
                Target target2 = (Target)iterator.next();
                if (target2 != target && (target2 == null || !target2.getName().equals(target.getName()))) continue;
                serverDebugInfo = (ServerDebugInfo)this.debugInfo.get(target2);
            }
        }
        return serverDebugInfo;
    }

    public void refresh() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int n = ServerInstance.this.getServerState();
                    ServerInstance.this.setServerState(1);
                    if (ServerInstance.this == profiledServerInstance) {
                        int n2 = ProfilerSupport.getState();
                        if (n2 == 1) {
                            ServerInstance.this.setServerState(8);
                            return;
                        }
                        if (n2 == 2) {
                            ServerInstance.this.setServerState(7);
                            return;
                        }
                        if (n2 == 4 || n2 == 3) {
                            ServerInstance.this.initCoTarget();
                            ServerInstance.this.setServerState(6);
                            return;
                        }
                        profiledServerInstance = null;
                    }
                    if (ServerInstance.this.isSuspended()) {
                        ServerInstance.this.setServerState(5);
                    } else if (ServerInstance.this.isDebuggable(null)) {
                        if (n != 5) {
                            ServerInstance.this.reset();
                        }
                        ServerInstance.this.initCoTarget();
                        ServerInstance.this.setServerState(4);
                    } else if (ServerInstance.this.isReallyRunning()) {
                        ServerInstance.this.reset();
                        ServerInstance.this.initCoTarget();
                        ServerInstance.this.setServerState(3);
                    } else {
                        ServerInstance.this.reset();
                        ServerInstance.this.setServerState(2);
                    }
                }
                finally {
                    if (ServerInstance.this.getServerState() == 1) {
                        ServerInstance.this.setServerState(2);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DeploymentManager deploymentManager = null;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            deploymentManager = this.manager;
            this.manager = null;
            this.disconnectedManager = null;
            this.incrementalDeployment = null;
            this.tmidResolver = null;
            this.startServer = null;
            this.findJSPServlet = null;
            this.coTarget = null;
            this.targets = null;
        }
        this.firePossibleManagerChange();
        if (deploymentManager != null) {
            deploymentManager.release();
        }
    }

    public void remove() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this.debuggerStateListener);
        this.stopIfStartedByIde();
        if (this.getUrl() != null) {
            InputOutput inputOutput = UISupport.getServerIO(this.url);
            if (inputOutput != null && !inputOutput.isClosed()) {
                inputOutput.closeInputOutput();
            }
            ServerRegistry.getInstance().removeServerInstance(this.getUrl());
        } else {
            LOGGER.log(Level.WARNING, "Trying to remove {0}, but url is null", this.server != null ? this.server.getShortName() : null);
        }
    }

    public void stopIfStartedByIde() {
        if (this.managerStartedByIde) {
            if (this.canStopDontWait()) {
                this.stopDontWait();
            } else {
                String string = NbBundle.getMessage(ServerInstance.class, (String)"LBL_ShutDownServer", (Object)this.getDisplayName());
                final ProgressUI progressUI = new ProgressUI(string, true, null);
                progressUI.start();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Iterator iterator = ServerInstance.this.targetsStartedByIde.iterator();
                            while (iterator.hasNext()) {
                                ServerTarget serverTarget = ServerInstance.this.getServerTarget((String)iterator.next());
                                if (serverTarget == null) continue;
                                try {
                                    ServerInstance.this._stop(serverTarget.getTarget(), progressUI);
                                }
                                catch (ServerException serverException) {
                                    Logger.getLogger("global").log(Level.INFO, null, serverException);
                                }
                            }
                            if (ServerInstance.this.isReallyRunning() || ServerInstance.this.isSuspended()) {
                                try {
                                    ServerInstance.this._stop(progressUI);
                                }
                                catch (ServerException serverException) {
                                    Logger.getLogger("global").log(Level.INFO, null, serverException);
                                }
                            }
                        }
                        finally {
                            progressUI.finish();
                        }
                    }
                });
                progressUI.showProgressDialog();
            }
        }
    }

    public void setServerState(int n) {
        int n2 = this.serverState;
        this.serverState = n;
        this.fireStateChanged(n2, n);
    }

    public int getServerState() {
        return this.serverState;
    }

    public boolean isRemoveForbidden() {
        String string = this.instanceProperties.getProperty("removeForbidden");
        return Boolean.valueOf(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTarget[] getTargets() {
        Map map = this.getTargetMap();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            return map.values().toArray(new ServerTarget[map.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTargetList() {
        Map map = this.getTargetMap();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            return map.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map getTargetMap() {
        HashMap<String, ServerTarget> hashMap = null;
        Target[] targetArray = this;
        synchronized (this) {
            hashMap = this.targets;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (hashMap != null && hashMap.size() >= 1) return hashMap;
            targetArray = null;
            StartServer startServer = this.getStartServer();
            try {
                if (!this.isRunning() && startServer != null && startServer.needsStartForTargetList() && ProfilerSupport.getState() == 0) {
                    super.start();
                }
                do {
                    if ((targetArray = this.getDeploymentManager().getTargets()) != null || ProfilerSupport.getState() != 4) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                } while (targetArray == null && ProfilerSupport.getState() == 4);
            }
            catch (IllegalStateException illegalStateException) {
                LOGGER.log(Level.INFO, null, illegalStateException);
            }
            if (targetArray == null) {
                targetArray = new Target[]{};
            }
            hashMap = new HashMap<String, ServerTarget>();
            for (int i = 0; i < targetArray.length; ++i) {
                hashMap.put(targetArray[i].getName(), new ServerTarget((ServerInstance)this, targetArray[i]));
            }
            Target[] targetArray2 = this;
            synchronized (this) {
                this.targets = hashMap;
                // ** MonitorExit[var4_9] (shouldn't be in output)
                return hashMap;
            }
        }
    }

    public ServerTarget getServerTarget(String string) {
        return (ServerTarget)this.getTargetMap().get(string);
    }

    public Target getTarget(String string) {
        return this.getServerTarget(string).getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartServer getStartServer() {
        DeploymentManager deploymentManager = null;
        try {
            deploymentManager = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            Logger.getLogger(ServerInstance.class.getName()).log(Level.INFO, null, deploymentManagerCreationException);
            return null;
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.startServer == null) {
                this.startServer = this.server.getOptionalFactory().getStartServer(deploymentManager);
            }
            return this.startServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalDeployment getIncrementalDeployment() {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.incrementalDeployment == null) {
                this.incrementalDeployment = this.server.getOptionalFactory().getIncrementalDeployment(deploymentManager);
            }
            return this.incrementalDeployment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInstanceDescriptor getServerInstanceDescriptor() {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.instanceDescriptor == null) {
                this.instanceDescriptor = this.server.getOptionalFactory().getServerInstanceDescriptor(deploymentManager);
            }
            return this.instanceDescriptor;
        }
    }

    public AntDeploymentProvider getAntDeploymentProvider() {
        try {
            return this.server.getOptionalFactory().getAntDeploymentProvider(this.getDisconnectedDeploymentManager());
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            Logger.getLogger("global").log(Level.INFO, null, deploymentManagerCreationException);
            return null;
        }
    }

    public JDBCDriverDeployer getJDBCDriverDeployer() {
        try {
            return this.server.getOptionalFactory().getJDBCDriverDeployer(this.getDisconnectedDeploymentManager());
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            Logger.getLogger("global").log(Level.INFO, null, deploymentManagerCreationException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleIDResolver getTargetModuleIDResolver() {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.tmidResolver == null) {
                this.tmidResolver = this.server.getOptionalFactory().getTargetModuleIDResolver(deploymentManager);
            }
            return this.tmidResolver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FindJSPServlet getFindJSPServlet() {
        DeploymentManager deploymentManager = null;
        try {
            deploymentManager = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            throw new RuntimeException(deploymentManagerCreationException);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.findJSPServlet == null) {
                this.findJSPServlet = this.server.getOptionalFactory().getFindJSPServlet(deploymentManager);
            }
            return this.findJSPServlet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasourceManager getDatasourceManager() {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.dsMgr == null) {
                this.dsMgr = this.server.getOptionalFactory().getDatasourceManager(deploymentManager);
            }
            return this.dsMgr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasourceManager getDisconnectedDatasourceManager() {
        DeploymentManager deploymentManager = null;
        try {
            deploymentManager = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            throw new RuntimeException(deploymentManagerCreationException);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.ddsMgr == null) {
                this.ddsMgr = this.server.getOptionalFactory().getDatasourceManager(deploymentManager);
            }
            return this.ddsMgr;
        }
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        DatasourceManager datasourceManager = this.getDisconnectedDatasourceManager();
        Set<Datasource> set = Collections.emptySet();
        if (datasourceManager != null) {
            set = datasourceManager.getDatasources();
        }
        return set;
    }

    public void deployDatasources(Set<Datasource> set) throws ConfigurationException, DatasourceAlreadyExistsException {
        DatasourceManager datasourceManager = this.getDatasourceManager();
        if (datasourceManager != null) {
            datasourceManager.deployDatasources(set);
        }
    }

    private synchronized MessageDestinationDeployment getMessageDestinationDeploymentConnected() {
        if (this.msgDestDeploymentConnected == null) {
            this.msgDestDeploymentConnected = this.server.getOptionalFactory().getMessageDestinationDeployment(this.getDeploymentManager());
        }
        return this.msgDestDeploymentConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageDestinationDeployment getMessageDestinationDeploymentDisconnected() {
        DeploymentManager deploymentManager = null;
        try {
            deploymentManager = this.getDisconnectedDeploymentManager();
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            throw new RuntimeException(deploymentManagerCreationException);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.msgDestDeploymentDisconnected == null) {
                this.msgDestDeploymentDisconnected = this.server.getOptionalFactory().getMessageDestinationDeployment(deploymentManager);
            }
            return this.msgDestDeploymentDisconnected;
        }
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        MessageDestinationDeployment messageDestinationDeployment = this.getMessageDestinationDeploymentDisconnected();
        if (messageDestinationDeployment != null) {
            return messageDestinationDeployment.getMessageDestinations();
        }
        return Collections.emptySet();
    }

    public void deployMessageDestinations(Set<MessageDestination> set) throws ConfigurationException {
        Parameters.notNull((CharSequence)"destinations", set);
        MessageDestinationDeployment messageDestinationDeployment = this.getMessageDestinationDeploymentConnected();
        if (messageDestinationDeployment != null) {
            messageDestinationDeployment.deployMessageDestinations(set);
        }
    }

    public boolean isRunningLastCheck() {
        if (this.lastCheck > 0L) {
            return this.isRunning;
        }
        return false;
    }

    public boolean isReallyRunning() {
        return this.isRunningWithinMillis(0L);
    }

    public boolean isRunning() {
        return this.isRunningWithinMillis(2000L);
    }

    public boolean isRunningWithinMillis(long l) {
        if (System.currentTimeMillis() - this.lastCheck < l) {
            return this.isRunning;
        }
        final StartServer startServer = this.getStartServer();
        this.isRunning = startServer != null ? this.safeTrueTest(new SafeTrueTest(){

            public void run() {
                this.setResult(startServer.isRunning());
            }
        }, 10000L) : false;
        this.lastCheck = System.currentTimeMillis();
        return this.isRunning;
    }

    public boolean isDebuggable(final Target target) {
        final StartServer startServer = this.getStartServer();
        if (startServer != null) {
            return this.safeTrueTest(new SafeTrueTest(){

                public void run() {
                    this.setResult(startServer.isDebuggable(target));
                }
            }, 10000L);
        }
        return false;
    }

    public ConflictData anotherServerDebuggable(Target target) {
        Target target2;
        ConflictData conflictData = null;
        StartServer startServer = this.getStartServer();
        if (startServer == null) {
            return null;
        }
        ServerDebugInfo serverDebugInfo = this.getServerDebugInfo(target);
        if (serverDebugInfo == null && (serverDebugInfo = startServer.getDebugInfo(target2 = this._retrieveTarget(target))) == null) {
            LOGGER.log(Level.FINE, "DebuggerInfo cannot be found for: " + this.toString());
            return null;
        }
        target2 = ServerRegistry.getInstance().getServerInstances();
        for (int i = 0; conflictData == null && i < ((Target)target2).length; ++i) {
            Target target3;
            ServerDebugInfo serverDebugInfo2;
            Target target4 = target2[i];
            if (this.url.equalsIgnoreCase(target4.getUrl()) || !target4.isDebuggable(null) || (serverDebugInfo2 = target4.getServerDebugInfo(target3 = super._retrieveTarget(null))) == null || !serverDebugInfo.getTransport().equals(serverDebugInfo2.getTransport())) continue;
            if (serverDebugInfo.getTransport() == "dt_socket") {
                if (!serverDebugInfo.getHost().equalsIgnoreCase(serverDebugInfo2.getHost()) || serverDebugInfo.getPort() != serverDebugInfo2.getPort()) continue;
                conflictData = new ConflictData((ServerInstance)target4, serverDebugInfo);
                continue;
            }
            if (!serverDebugInfo.getShmemName().equalsIgnoreCase(serverDebugInfo2.getShmemName())) continue;
            conflictData = new ConflictData((ServerInstance)target4, serverDebugInfo);
        }
        return conflictData;
    }

    public boolean isSuspended() {
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        Target target = this._retrieveTarget(null);
        ServerDebugInfo serverDebugInfo = this.getServerDebugInfo(target);
        if (serverDebugInfo == null) {
            LOGGER.log(Level.FINE, "DebuggerInfo cannot be found for: " + this.toString());
            return false;
        }
        for (int i = 0; i < sessionArray.length; ++i) {
            JPDADebugger jPDADebugger;
            Object object;
            String string;
            Object object2;
            Session session = sessionArray[i];
            if (session == null || (object2 = session.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attachingDICookie = (AttachingDICookie)object2;
            if (!(serverDebugInfo.getTransport().equals("dt_shmem") ? (string = attachingDICookie.getSharedMemoryName()) != null && string.equalsIgnoreCase(serverDebugInfo.getShmemName()) && (object = session.lookupFirst(null, JPDADebugger.class)) != null && (jPDADebugger = (JPDADebugger)object).getState() == 3 : (string = attachingDICookie.getHostName()) != null && this.isSameHost(string, serverDebugInfo.getHost()) && attachingDICookie.getPortNumber() == serverDebugInfo.getPort() && (object = session.lookupFirst(null, JPDADebugger.class)) != null && (jPDADebugger = (JPDADebugger)object).getState() == 3)) continue;
            return true;
        }
        return false;
    }

    public boolean isDebugSupported() {
        StartServer startServer = this.getStartServer();
        if (startServer == null) {
            return false;
        }
        return startServer.supportsStartDebugging(null);
    }

    public boolean isProfileSupported() {
        Profiler profiler = ServerRegistry.getProfiler();
        if (profiler == null) {
            return false;
        }
        StartServer startServer = this.getStartServer();
        if (startServer == null) {
            return false;
        }
        return startServer.supportsStartProfiling(null);
    }

    public Set getTargetsStartedByIde() {
        HashSet<ServerTarget> hashSet = new HashSet<ServerTarget>();
        for (String string : this.targetsStartedByIde) {
            hashSet.add(this.getServerTarget(string));
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ProgressUI progressUI) throws ServerException {
        try {
            this.setServerState(1);
            this.startTarget(null, progressUI);
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDebug(ProgressUI progressUI) throws ServerException {
        try {
            this.setServerState(1);
            this.startTarget(null, progressUI, Deployment.Mode.DEBUG);
            this._retrieveDebugInfo(null);
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProfile(ProfilerServerSettings profilerServerSettings, boolean bl, ProgressUI progressUI) throws ServerException {
        ServerInstance serverInstance = profiledServerInstance;
        if (serverInstance != null && serverInstance != this) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerProfiling", (Object)serverInstance.getDisplayName());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.CANCEL_OPTION) {
                String string2 = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ProfilingCancelled", (Object)this.getDisplayName());
                throw new ServerException(string2);
            }
        }
        try {
            this.setServerState(1);
            this._startProfile(null, profilerServerSettings, bl, progressUI);
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(ProgressUI progressUI) throws ServerException {
        try {
            this.setServerState(1);
            boolean bl = this.isDebuggable(null);
            boolean bl2 = profiledServerInstance == this;
            boolean bl3 = true;
            if (bl2 || this.isReallyRunning() || this.isSuspended()) {
                this._stop(progressUI);
            }
            if (bl3) {
                if (bl2) {
                    this._startProfile(null, this.profilerSettings, true, progressUI);
                } else if (bl) {
                    this.startDebugTarget(null, progressUI);
                } else {
                    this.startTarget(null, progressUI);
                }
            }
        }
        finally {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ProgressUI progressUI) throws ServerException {
        try {
            this.setServerState(1);
            if (profiledServerInstance == this || this.isReallyRunning() || this.isSuspended()) {
                this._stop(progressUI);
            }
            this.debugInfo.clear();
        }
        finally {
            this.refresh();
        }
    }

    public DeploymentManager getDeploymentManagerForConfiguration() throws DeploymentManagerCreationException {
        StartServer startServer = this.getStartServer();
        if (startServer != null && startServer.needsStartForConfigure()) {
            this.start();
            return this.getDeploymentManager();
        }
        return this.getDisconnectedDeploymentManager();
    }

    public void startTarget(Target target, ProgressUI progressUI) throws ServerException {
        this.startTarget(target, progressUI, Deployment.Mode.RUN);
    }

    public void startDebugTarget(Target target, ProgressUI progressUI) throws ServerException {
        this.startTarget(target, progressUI, Deployment.Mode.DEBUG);
        this._retrieveDebugInfo(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ServerInstance.this.start();
                }
            });
            return;
        }
        if (this.isRunning()) {
            return;
        }
        String string = NbBundle.getMessage(ServerInstance.class, (String)"LBL_StartServerProgressMonitor", (Object)this.getDisplayName());
        ProgressUI progressUI = new ProgressUI(string, false);
        try {
            progressUI.start();
            this.start(progressUI);
        }
        catch (ServerException serverException) {
            Logger.getLogger("global").log(Level.INFO, null, serverException);
        }
        finally {
            progressUI.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startProfile(ProfilerServerSettings profilerServerSettings, boolean bl, Deployment.Logger logger) {
        String string = NbBundle.getMessage(ServerInstance.class, (String)"LBL_StartServerInProfileMode", (Object)this.getDisplayName());
        ProgressUI progressUI = new ProgressUI(string, false, logger);
        try {
            progressUI.start();
            this.startProfile(profilerServerSettings, bl, progressUI);
            boolean bl2 = true;
            return bl2;
        }
        catch (ServerException serverException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            progressUI.finish();
        }
    }

    public void stopDontWait() {
        if (this.isReallyRunning()) {
            StartServer startServer = this.getStartServer();
            assert (startServer.canStopDeploymentManagerSilently()) : "server does not support silent stop of deployment manager";
            startServer.stopDeploymentManagerSilently();
        }
    }

    public boolean canStopDontWait() {
        StartServer startServer = this.getStartServer();
        return startServer.canStopDeploymentManagerSilently();
    }

    private void resolveServerConflict(Target target, ProgressUI progressUI, ConflictData conflictData) throws ServerException {
        ServerInstance serverInstance = conflictData.getServerInstance();
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerRunning", (Object[])new Object[]{serverInstance.getDisplayName(), conflictData.getServerDebugInfo().getHost(), conflictData.getServerDebugInfo().getTransport().equals("dt_socket") ? "socket" : "shared memory", conflictData.getServerDebugInfo().getTransport().equals("dt_socket") ? Integer.toString(conflictData.getServerDebugInfo().getPort()) : conflictData.getServerDebugInfo().getShmemName()}), 3);
        confirmation.setOptionType(2);
        JButton jButton = new JButton(NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerStopYes"));
        JButton jButton2 = new JButton(NbBundle.getMessage(ServerInstance.class, (String)"MSG_AnotherServerStopNo"));
        jButton.setDefaultCapable(true);
        confirmation.setOptions(new Object[]{jButton, jButton2});
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object != jButton) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ServerStartupCancelled", (Object)this.getDisplayName());
            throw new ServerException(string);
        }
        if (!serverInstance.getStartServer().supportsStartDeploymentManager()) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingThisServerNotSupported", (Object)this.getDisplayName());
            throw new ServerException(string);
        }
        serverInstance.stop(progressUI);
    }

    private void startTarget(Target target, ProgressUI progressUI, Deployment.Mode mode) throws ServerException {
        StartServer startServer = this.getStartServer();
        if (startServer == null) {
            progressUI.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_PluginHasNoStartServerClass", (Object)this.getServer()));
            return;
        }
        if (this.isSuspended()) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ServerSuspended", (Object)this.getServer());
            throw new ServerException(string);
        }
        boolean bl = startServer.supportsStartDeploymentManager();
        boolean bl2 = startServer.supportsStartDebugging(target);
        boolean bl3 = startServer.needsRestart(target);
        if (startServer.isAlsoTargetServer(target)) {
            switch (mode) {
                case PROFILE: {
                    assert (false);
                }
                case DEBUG: {
                    if (startServer.isDebuggable(target)) {
                        if (!bl3) {
                            return;
                        }
                        if (!bl || !bl2) {
                            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_RestartingThisServerNotSupported", (Object)this.getDisplayName());
                            throw new ServerException(string);
                        }
                        this._stop(progressUI);
                    } else if (this.isReallyRunning()) {
                        if (!bl || !bl2) {
                            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_DebugginThisServerNotSupported", (Object)this.getDisplayName());
                            throw new ServerException(string);
                        }
                        this._stop(progressUI);
                    }
                    if (!bl2) {
                        String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_DebugginThisServerNotSupported", (Object)this.getDisplayName());
                        throw new ServerException(string);
                    }
                    ConflictData conflictData = this.anotherServerDebuggable(target);
                    if (conflictData != null) {
                        this.resolveServerConflict(target, progressUI, conflictData);
                    }
                    this._startDebug(target, progressUI);
                    break;
                }
                case RUN: {
                    if (this.isReallyRunning()) {
                        if (!bl3) {
                            return;
                        }
                        if (!bl) {
                            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_RestartingThisServerNotSupported", (Object)this.getDisplayName());
                            throw new ServerException(string);
                        }
                        this._stop(progressUI);
                    }
                    if (!bl) {
                        String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingThisServerNotSupported", (Object)this.getDisplayName());
                        throw new ServerException(string);
                    }
                    this._start(progressUI);
                }
            }
        } else {
            if (!this.isReallyRunning()) {
                if (!bl) {
                    String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartingThisServerNotSupported", (Object)this.getDisplayName());
                    throw new ServerException(string);
                }
                this._start(progressUI);
            }
            switch (mode) {
                case DEBUG: {
                    if (startServer.isDebuggable(target)) {
                        if (!bl3) {
                            return;
                        }
                        this._stop(target, progressUI);
                    } else if (startServer.isRunning(target)) {
                        this._stop(target, progressUI);
                    }
                    ConflictData conflictData = this.anotherServerDebuggable(target);
                    if (conflictData != null) {
                        this.resolveServerConflict(target, progressUI, conflictData);
                    }
                    this._startDebug(target, progressUI);
                    break;
                }
                case RUN: {
                    if (startServer.isRunning(target)) {
                        if (!bl3) {
                            return;
                        }
                        this._stop(target, progressUI);
                    }
                    this._start(target, progressUI);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _start(ProgressUI progressUI) throws ServerException {
        ProgressObject progressObject = this.getStartServer().startDeploymentManager();
        try {
            boolean bl = ProgressObjectUtil.trackProgressObject(progressUI, progressObject, this.getStartupTimeout());
            if (!bl) {
                throw new ServerException(progressObject.getDeploymentStatus().getMessage());
            }
        }
        catch (TimedOutException timedOutException) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartServerTimeout", (Object)this.getDisplayName());
            throw new ServerException(string);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            this.managerStartedByIde = true;
            this.coTarget = null;
            this.targets = null;
            this.initCoTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startDebug(Target target, ProgressUI progressUI) throws ServerException {
        ProgressObject progressObject = this.getStartServer().startDebugging(target);
        try {
            boolean bl = ProgressObjectUtil.trackProgressObject(progressUI, progressObject, this.getStartupTimeout());
            if (!bl) {
                throw new ServerException(progressObject.getDeploymentStatus().getMessage());
            }
        }
        catch (TimedOutException timedOutException) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartDebugTimeout", (Object)this.getDisplayName());
            throw new ServerException(string);
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            this.managerStartedByIde = true;
            this.coTarget = null;
            this.targets = null;
            this.initCoTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startProfile(Target target, ProfilerServerSettings profilerServerSettings, boolean bl, ProgressUI progressUI) throws ServerException {
        Profiler profiler;
        ProfilerServerSettings profilerServerSettings2;
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            profilerServerSettings2 = this.profilerSettings;
        }
        serverInstance = profiledServerInstance;
        if (serverInstance == this && !bl && profilerServerSettings.equals(profilerServerSettings2)) {
            return;
        }
        if (serverInstance != null && serverInstance != this) {
            serverInstance.stop(progressUI);
            profiledServerInstance = null;
        }
        if (profiledServerInstance == this || this.isReallyRunning() || this.isDebuggable(target)) {
            this._stop(progressUI);
            this.debugInfo.clear();
            profiledServerInstance = null;
        }
        if ((profiler = ServerRegistry.getProfiler()) == null) {
            throw new ServerException(NbBundle.getMessage(ServerInstance.class, (String)"MSG_ProfilerNotRegistered"));
        }
        profiler.notifyStarting();
        ProgressObject progressObject = this.getStartServer().startProfiling(target, profilerServerSettings);
        try {
            boolean bl2 = ProgressObjectUtil.trackProgressObject(progressUI, progressObject, 1200000L);
            if (!bl2) {
                throw new ServerException(progressObject.getDeploymentStatus().getMessage());
            }
        }
        catch (TimedOutException timedOutException) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartProfileTimeout", (Object)this.getDisplayName());
            throw new ServerException(string);
        }
        profiledServerInstance = this;
        ServerInstance serverInstance2 = this;
        synchronized (serverInstance2) {
            this.profilerSettings = profilerServerSettings;
            this.managerStartedByIde = true;
        }
    }

    private void shutdownProfiler(ProgressUI progressUI) throws ServerException {
        progressUI.progress(NbBundle.getMessage(ServerInstance.class, (String)"MSG_StoppingProfiler"));
        Profiler profiler = ServerRegistry.getProfiler();
        if (profiler != null) {
            ProgressObject progressObject = profiler.shutdown();
            try {
                boolean bl = ProgressObjectUtil.trackProgressObject(progressUI, progressObject, this.getShutdownTimeout());
                if (!bl) {
                    throw new ServerException(progressObject.getDeploymentStatus().getMessage());
                }
            }
            catch (TimedOutException timedOutException) {
                String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_ProfilerShutdownTimeout");
                throw new ServerException(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stop(ProgressUI progressUI) throws ServerException {
        Object object;
        if (profiledServerInstance == this) {
            this.shutdownProfiler(progressUI);
            profiledServerInstance = null;
        }
        ServerInstance serverInstance = this;
        synchronized (serverInstance) {
            if (this.isSuspended()) {
                Target target = this._retrieveTarget(null);
                object = this.getServerDebugInfo(target);
                Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
                for (int i = 0; i < sessionArray.length; ++i) {
                    String string;
                    AttachingDICookie attachingDICookie;
                    Session session = sessionArray[i];
                    if (session == null || (attachingDICookie = (AttachingDICookie)session.lookupFirst(null, AttachingDICookie.class)) == null) continue;
                    if (((ServerDebugInfo)object).getTransport().equals("dt_shmem")) {
                        string = attachingDICookie.getSharedMemoryName();
                        if (string == null || !string.equalsIgnoreCase(((ServerDebugInfo)object).getShmemName())) continue;
                        session.kill();
                        continue;
                    }
                    string = attachingDICookie.getHostName();
                    if (string == null || !this.isSameHost(string, ((ServerDebugInfo)object).getHost()) || attachingDICookie.getPortNumber() != ((ServerDebugInfo)object).getPort()) continue;
                    session.kill();
                }
            }
        }
        serverInstance = this.getStartServer().stopDeploymentManager();
        try {
            boolean bl = ProgressObjectUtil.trackProgressObject(progressUI, (ProgressObject)serverInstance, this.getShutdownTimeout());
            if (!bl) {
                throw new ServerException(serverInstance.getDeploymentStatus().getMessage());
            }
        }
        catch (TimedOutException timedOutException) {
            object = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StopServerTimeout", (Object)this.getDisplayName());
            throw new ServerException((String)object);
        }
        ServerInstance serverInstance2 = this;
        synchronized (serverInstance2) {
            this.managerStartedByIde = false;
        }
        this.reset();
    }

    private void _start(Target target, ProgressUI progressUI) throws ServerException {
        ServerTarget serverTarget = this.getServerTarget(target.getName());
        if (serverTarget.isRunning()) {
            return;
        }
        ProgressObject progressObject = serverTarget.start();
        try {
            boolean bl = ProgressObjectUtil.trackProgressObject(progressUI, progressObject, this.getStartupTimeout());
            if (!bl) {
                throw new ServerException(progressObject.getDeploymentStatus().getMessage());
            }
        }
        catch (TimedOutException timedOutException) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StartServerTimeout", (Object)target.getName());
            throw new ServerException(string);
        }
        this.targetsStartedByIde.add(serverTarget.getName());
    }

    private void _stop(Target target, ProgressUI progressUI) throws ServerException {
        ServerTarget serverTarget = this.getServerTarget(target.getName());
        if (serverTarget.isRunning()) {
            return;
        }
        ProgressObject progressObject = serverTarget.stop();
        try {
            boolean bl = ProgressObjectUtil.trackProgressObject(progressUI, progressObject, this.getShutdownTimeout());
            if (!bl) {
                throw new ServerException(progressObject.getDeploymentStatus().getMessage());
            }
        }
        catch (TimedOutException timedOutException) {
            String string = NbBundle.getMessage(ServerInstance.class, (String)"MSG_StopServerTimeout", (Object)target.getName());
            throw new ServerException(string);
        }
        this.targetsStartedByIde.remove(serverTarget.getName());
    }

    public boolean canStartServer() {
        return this.getStartServer() != null && this.getStartServer().supportsStartDeploymentManager();
    }

    public boolean isManagerOf(Target target) {
        return this.getTargetMap().keySet().contains(target.getName());
    }

    public synchronized ServerTarget getCoTarget() {
        return this.coTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCoTarget() {
        ServerTarget[] serverTargetArray = this.getTargets();
        for (int i = 0; i < serverTargetArray.length; ++i) {
            if (!this.getStartServer().isAlsoTargetServer(serverTargetArray[i].getTarget())) continue;
            ServerInstance serverInstance = this;
            synchronized (serverInstance) {
                this.coTarget = serverTargetArray[i];
                continue;
            }
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static boolean isProgressing(ProgressObject progressObject) {
        StateType stateType = progressObject.getDeploymentStatus().getState();
        return stateType == StateType.RUNNING || stateType == StateType.RELEASED;
    }

    public static boolean hasFailed(ProgressObject progressObject) {
        StateType stateType = progressObject.getDeploymentStatus().getState();
        return stateType == StateType.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(StateListener stateListener) {
        List list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.add(stateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(StateListener stateListener) {
        List list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.remove(stateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged(int n, int n2) {
        StateListener[] stateListenerArray;
        List list = this.stateListeners;
        synchronized (list) {
            stateListenerArray = this.stateListeners.toArray(new StateListener[this.stateListeners.size()]);
        }
        for (int i = 0; i < stateListenerArray.length; ++i) {
            stateListenerArray[i].stateChanged(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean safeTrueTest(SafeTrueTest safeTrueTest, long l) {
        try {
            new RequestProcessor().post((Runnable)safeTrueTest).waitFinished(l);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.INFO, null, interruptedException);
        }
        finally {
            return safeTrueTest.result();
        }
    }

    private ServerDebugInfo _retrieveDebugInfo(Target target) {
        StartServer startServer = this.getStartServer();
        if (startServer == null) {
            return null;
        }
        Target target2 = this._retrieveTarget(target);
        ServerDebugInfo serverDebugInfo = startServer.getDebugInfo(target2);
        if (serverDebugInfo != null || target2 != null) {
            this.debugInfo.remove(target2);
            this.debugInfo.put(target2, serverDebugInfo);
        }
        return serverDebugInfo;
    }

    private Target _retrieveTarget(Target target) {
        StartServer startServer = this.getStartServer();
        if (startServer == null) {
            return null;
        }
        Target target2 = null;
        if (!this.isReallyRunning() && startServer.needsStartForTargetList()) {
            Iterator iterator = this.debugInfo.keySet().iterator();
            while (target2 == null && iterator.hasNext()) {
                Target target3 = (Target)iterator.next();
                if (!startServer.isAlsoTargetServer(target3)) continue;
                target2 = target3;
            }
        } else {
            ServerTarget[] serverTargetArray = this.getTargets();
            for (int i = 0; target2 == null && i < serverTargetArray.length; ++i) {
                if (!startServer.isAlsoTargetServer(serverTargetArray[i].getTarget())) continue;
                target2 = serverTargetArray[i].getTarget();
            }
            if (target2 == null && serverTargetArray.length > 0) {
                target2 = serverTargetArray[0].getTarget();
            }
        }
        return target2;
    }

    public int compareTo(Object object) {
        if (!(object instanceof ServerInstance)) {
            throw new IllegalArgumentException();
        }
        return this.getDisplayName().compareTo(((ServerInstance)object).getDisplayName());
    }

    private void firePossibleManagerChange() {
        this.managerChangeSupport.fireChange();
    }

    private boolean isSameHost(String string, String string2) {
        Object object;
        if (string != null && string.equals(string2)) {
            return true;
        }
        if (("127.0.0.1".equals(string) || "localhost".equals(string)) && ("127.0.0.1".equals(string2) || "localhost".equals(string2))) {
            return true;
        }
        try {
            object = InetAddress.getLocalHost();
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
            int n = inetAddressArray.length;
            for (int i = 0; i < n; ++i) {
                InetAddress[] inetAddressArray2 = inetAddressArray[i];
                if (!((InetAddress)object).equals(inetAddressArray2) && !"127.0.0.1".equals(string) && !"localhost".equals(string)) continue;
                InetAddress[] inetAddressArray3 = InetAddress.getAllByName(string2);
                int n2 = inetAddressArray3.length;
                for (int j = 0; j < n2; ++j) {
                    InetAddress inetAddress = inetAddressArray3[j];
                    if (!((InetAddress)object).equals(inetAddress) && !"127.0.0.1".equals(string2) && !"localhost".equals(string2)) continue;
                    return true;
                }
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.log(Level.INFO, null, unknownHostException);
        }
        try {
            for (InetAddress inetAddress : InetAddress.getAllByName(string)) {
                for (InetAddress inetAddress2 : InetAddress.getAllByName(string2)) {
                    if (!inetAddress.equals(inetAddress2) && !inetAddress.getCanonicalHostName().equals(inetAddress2.getCanonicalHostName())) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.log(Level.INFO, null, unknownHostException);
        }
        try {
            object = NetworkInterface.getByInetAddress(InetAddress.getByName(string));
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(string2));
            if (object != null && ((NetworkInterface)object).equals(networkInterface)) {
                return true;
            }
        }
        catch (SocketException socketException) {
            LOGGER.log(Level.INFO, null, socketException);
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.log(Level.INFO, null, unknownHostException);
        }
        return false;
    }

    private class DebuggerStateListener
    extends DebuggerManagerAdapter {
        private RequestProcessor.Task refreshTask;

        private DebuggerStateListener() {
        }

        public void sessionAdded(Session session) {
            Target target = ServerInstance.this._retrieveTarget(null);
            ServerDebugInfo serverDebugInfo = ServerInstance.this.getServerDebugInfo(target);
            if (serverDebugInfo == null) {
                LOGGER.log(Level.FINE, "DebuggerInfo cannot be found for: " + ServerInstance.this);
                return;
            }
            AttachingDICookie attachingDICookie = (AttachingDICookie)session.lookupFirst(null, AttachingDICookie.class);
            if (attachingDICookie == null) {
                LOGGER.log(Level.FINE, "AttachingDICookie cannot be found for: " + ServerInstance.this);
                return;
            }
            if ("dt_shmem".equals(serverDebugInfo.getTransport())) {
                String string = attachingDICookie.getSharedMemoryName();
                if (string != null && string.equalsIgnoreCase(serverDebugInfo.getShmemName())) {
                    this.registerListener(session);
                }
            } else {
                String string = attachingDICookie.getHostName();
                if (string != null && ServerInstance.this.isSameHost(string, serverDebugInfo.getHost()) && attachingDICookie.getPortNumber() == serverDebugInfo.getPort()) {
                    this.registerListener(session);
                }
            }
        }

        public synchronized void sessionRemoved(Session session) {
            this.refreshTask = null;
        }

        private void registerListener(Session session) {
            final JPDADebugger jPDADebugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
            if (jPDADebugger != null) {
                jPDADebugger.addPropertyChangeListener("state", new PropertyChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        RequestProcessor.Task task;
                        DebuggerStateListener debuggerStateListener = DebuggerStateListener.this;
                        synchronized (debuggerStateListener) {
                            if (DebuggerStateListener.this.refreshTask == null) {
                                DebuggerStateListener.this.refreshTask = RequestProcessor.getDefault().create(new Runnable(){

                                    public void run() {
                                        if (jPDADebugger.getState() == 3) {
                                            ServerInstance.this.setServerState(5);
                                        } else {
                                            ServerInstance.this.setServerState(4);
                                        }
                                    }
                                });
                            }
                            task = DebuggerStateListener.this.refreshTask;
                        }
                        task.schedule(500);
                    }
                });
            }
        }
    }

    private static abstract class SafeTrueTest
    implements Runnable {
        private volatile boolean result = false;

        private SafeTrueTest() {
        }

        public abstract void run();

        public final boolean result() {
            return this.result;
        }

        public final void setResult(boolean bl) {
            this.result = bl;
        }
    }

    private static class ConflictData {
        private ServerInstance si;
        private ServerDebugInfo sdi;

        public ConflictData(ServerInstance serverInstance, ServerDebugInfo serverDebugInfo) {
            this.si = serverInstance;
            this.sdi = serverDebugInfo;
        }

        public ServerInstance getServerInstance() {
            return this.si;
        }

        public ServerDebugInfo getServerDebugInfo() {
            return this.sdi;
        }
    }

    public static interface StateListener {
        public void stateChanged(int var1, int var2);
    }
}

