/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.ui.TreeRootNode;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project project) {
        GrailsProject grailsProject = (GrailsProject)project.getLookup().lookup(GrailsProject.class);
        assert (grailsProject != null);
        return new SourcesNodeList(grailsProject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceGroupKey
    implements Comparable<SourceGroupKey> {
        public final SourceGroup group;
        public final FileObject fileObject;
        public final FileObject projectDir;

        SourceGroupKey(SourceGroup sourceGroup, FileObject fileObject) {
            this.group = sourceGroup;
            this.fileObject = sourceGroup.getRootFolder();
            this.projectDir = fileObject;
        }

        public int hashCode() {
            return this.fileObject.hashCode();
        }

        @Override
        public int compareTo(SourceGroupKey sourceGroupKey) {
            String string = FileUtil.getRelativePath((FileObject)this.projectDir, (FileObject)this.fileObject);
            String string2 = FileUtil.getRelativePath((FileObject)this.projectDir, (FileObject)sourceGroupKey.fileObject);
            return string.compareTo(string2);
        }

        public boolean equals(Object object) {
            if (!(object instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey sourceGroupKey = (SourceGroupKey)object;
            String string = this.group.getDisplayName();
            String string2 = sourceGroupKey.group.getDisplayName();
            return this.fileObject.equals(sourceGroupKey.fileObject) && string == null ? string2 == null : string.equals(string2);
        }

        public String toString() {
            return this.group.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesNodeList
    implements NodeList<SourceGroupKey>,
    ChangeListener {
        private GrailsProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public SourcesNodeList(GrailsProject grailsProject) {
            this.project = grailsProject;
        }

        public List<SourceGroupKey> keys() {
            FileObject fileObject = this.project.getProjectDirectory();
            if (fileObject == null || !fileObject.isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            List list = GroovySources.getGroovySourceGroups((Sources)sources);
            ArrayList<SourceGroupKey> arrayList = new ArrayList<SourceGroupKey>();
            for (SourceGroup sourceGroup : list) {
                if (sourceGroup.getRootFolder() == null) continue;
                arrayList.add(new SourceGroupKey(sourceGroup, fileObject));
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public Node node(SourceGroupKey sourceGroupKey) {
            return new TreeRootNode(sourceGroupKey.group, this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SourcesNodeList.this.changeSupport.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

