/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.commands;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommand;
import org.netbeans.modules.groovy.grailsproject.config.BuildConfig;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrailsCommandSupport {
    private static final ExecutionDescriptor GRAILS_DESCRIPTOR = new ExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).showProgress(true).optionsPath("Advanced/org-netbeans-modules-groovy-support-api-GroovySettings");
    private static final ExecutionDescriptor RUN_DESCRIPTOR = GRAILS_DESCRIPTOR.showSuspended(true);
    private static final ExecutionDescriptor.InputProcessorFactory ANSI_STRIPPING = new AnsiStrippingInputProcessorFactory();
    private static final Logger LOGGER = Logger.getLogger(GrailsCommandSupport.class.getName());
    private static final String WEB_APP_DIR = "web-app";
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private final GrailsProject project;
    private List<GrailsCommand> commands;
    private BuildConfigListener buildConfigListener;
    private ProjectConfigListener projectConfigListener;

    public GrailsCommandSupport(GrailsProject grailsProject) {
        this.project = grailsProject;
    }

    public synchronized List<GrailsCommand> getGrailsCommands() {
        return this.commands;
    }

    public ExecutionDescriptor getRunDescriptor() {
        return this.getDescriptor("run-app");
    }

    public ExecutionDescriptor getDescriptor(String string) {
        return this.getDescriptor(string, null, false);
    }

    public ExecutionDescriptor getDescriptor(String string, ExecutionDescriptor.InputProcessorFactory inputProcessorFactory) {
        return this.getDescriptor(string, inputProcessorFactory, false);
    }

    public ExecutionDescriptor getDescriptor(String string, ExecutionDescriptor.InputProcessorFactory inputProcessorFactory, final boolean bl) {
        if ("run-app".equals(string)) {
            ExecutionDescriptor executionDescriptor = RUN_DESCRIPTOR;
            ExecutionDescriptor.InputProcessorFactory inputProcessorFactory2 = new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{inputProcessor, InputProcessors.bridge((LineProcessor)new ServerURLProcessor(GrailsCommandSupport.this.project, bl))});
                }
            };
            executionDescriptor = inputProcessorFactory != null ? executionDescriptor.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new ProxyInputProcessorFactory(inputProcessorFactory2, inputProcessorFactory)) : executionDescriptor.outProcessorFactory(inputProcessorFactory2);
            return executionDescriptor;
        }
        if ("shell".equals(string)) {
            ExecutionDescriptor executionDescriptor = RUN_DESCRIPTOR.postExecution((Runnable)new RefreshProjectRunnable(this.project)).errProcessorFactory(ANSI_STRIPPING);
            executionDescriptor = inputProcessorFactory != null ? executionDescriptor.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new ProxyInputProcessorFactory(ANSI_STRIPPING, inputProcessorFactory)) : executionDescriptor.outProcessorFactory(ANSI_STRIPPING);
            return executionDescriptor;
        }
        ExecutionDescriptor executionDescriptor = GRAILS_DESCRIPTOR.postExecution((Runnable)new RefreshProjectRunnable(this.project)).errProcessorFactory(ANSI_STRIPPING);
        executionDescriptor = inputProcessorFactory != null ? executionDescriptor.outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new ProxyInputProcessorFactory(ANSI_STRIPPING, inputProcessorFactory)) : executionDescriptor.outProcessorFactory(ANSI_STRIPPING);
        return executionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGrailsCommands() {
        Callable callable = ExecutionSupport.getInstance().createSimpleCommand("help", GrailsProjectConfig.forProject((Project)this.project), new String[0]);
        final HelpLineProcessor helpLineProcessor = new HelpLineProcessor();
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                return InputProcessors.bridge((LineProcessor)helpLineProcessor);
            }
        });
        List list = Collections.emptyList();
        ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)"help");
        Future future = executionService.run();
        try {
            if ((Integer)future.get() == 0) {
                list = new ArrayList();
                for (String object : helpLineProcessor.getCommands()) {
                    list.add(new GrailsCommand(object, null, object));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.INFO, null, executionException);
        }
        GrailsCommandSupport grailsCommandSupport = this;
        synchronized (grailsCommandSupport) {
            GrailsProjectConfig grailsProjectConfig;
            if (this.buildConfigListener == null) {
                BuildConfig buildConfig = this.project.getBuildConfig();
                this.buildConfigListener = new BuildConfigListener();
                this.buildConfigListener.attachListeners(buildConfig);
                buildConfig.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.buildConfigListener, (Object)buildConfig));
            }
            if (this.projectConfigListener == null && (grailsProjectConfig = (GrailsProjectConfig)this.project.getLookup().lookup(GrailsProjectConfig.class)) != null) {
                this.projectConfigListener = new ProjectConfigListener();
                grailsProjectConfig.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.projectConfigListener, (Object)grailsProjectConfig));
            }
            this.commands = list;
        }
    }

    public void refreshGrailsCommandsLater(final Runnable runnable) {
        EXECUTOR.submit(new Runnable(){

            public void run() {
                GrailsCommandSupport.this.refreshGrailsCommands();
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    public static final void showURL(URL uRL, boolean bl, GrailsProject grailsProject) {
        boolean bl2 = WebClientToolsSessionStarterService.isAvailable();
        if (!bl || !bl2) {
            if (GrailsProjectConfig.forProject((Project)grailsProject).getDisplayBrowser()) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
        } else {
            Object object;
            URI uRI;
            Object object2;
            Lookup lookup;
            FileObject fileObject = grailsProject.getProjectDirectory().getFileObject(WEB_APP_DIR);
            GrailsProjectConfig grailsProjectConfig = GrailsProjectConfig.forProject((Project)grailsProject);
            String string = grailsProjectConfig.getPort();
            String string2 = uRL.getProtocol() + "://" + uRL.getHost() + ":" + string + "/" + grailsProject.getProjectDirectory().getName();
            String string3 = uRL.toExternalForm();
            if (!string3.startsWith(string2)) {
                LOGGER.warning("Could not construct URL mapper for JavaScript debugger.");
                lookup = Lookups.fixed((Object[])new Object[]{grailsProject});
            } else {
                object2 = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
                if (object2 == null) {
                    lookup = Lookups.fixed((Object[])new Object[]{grailsProject});
                } else {
                    try {
                        uRI = new URI(string2);
                        object = object2.getJSToNbJSLocationMapper(fileObject, uRI, null);
                        NbJSToJSLocationMapper nbJSToJSLocationMapper = object2.getNbJSToJSLocationMapper(fileObject, uRI, null);
                        lookup = Lookups.fixed((Object[])new Object[]{object, nbJSToJSLocationMapper, grailsProject});
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        LOGGER.log(Level.WARNING, "Server URI could not be constructed from displayed URL", uRISyntaxException);
                        lookup = Lookups.fixed((Object[])new Object[]{grailsProject});
                    }
                }
            }
            try {
                object2 = uRL.toURI();
                uRI = WebClientToolsProjectUtils.getFirefoxBrowser();
                object = grailsProjectConfig.getDebugBrowser();
                if (object == null) {
                    object = WebClientToolsProjectUtils.Browser.FIREFOX.name();
                }
                if (WebClientToolsProjectUtils.Browser.valueOf((String)object) == WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER) {
                    uRI = WebClientToolsProjectUtils.getInternetExplorerBrowser();
                }
                WebClientToolsSessionStarterService.startSession((URI)object2, (HtmlBrowser.Factory)uRI, (Lookup)lookup);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.log(Level.SEVERE, "Unable to obtain URI for URL", uRISyntaxException);
            }
            catch (WebClientToolsSessionException webClientToolsSessionException) {
                LOGGER.log(Level.SEVERE, "Unexpected exception launching javascript debugger", webClientToolsSessionException);
            }
        }
    }

    private class PluginListener
    implements FileChangeListener {
        private PluginListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            this.changed();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.changed();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.changed();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.changed();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.changed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changed() {
            GrailsCommandSupport grailsCommandSupport = GrailsCommandSupport.this;
            synchronized (grailsCommandSupport) {
                GrailsCommandSupport.this.commands = null;
            }
        }
    }

    private class BuildConfigListener
    implements PropertyChangeListener {
        private final PluginListener pluginListener;
        private File globalPluginsDir;
        private File projectPluginsDir;

        private BuildConfigListener() {
            this.pluginListener = new PluginListener();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (BuildConfig.BUILD_CONFIG_PLUGINS.equals(propertyChangeEvent.getPropertyName())) {
                GrailsCommandSupport grailsCommandSupport = GrailsCommandSupport.this;
                synchronized (grailsCommandSupport) {
                    this.attachListeners((BuildConfig)propertyChangeEvent.getSource());
                    GrailsCommandSupport.this.commands = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachListeners(BuildConfig buildConfig) {
            GrailsCommandSupport grailsCommandSupport = GrailsCommandSupport.this;
            synchronized (grailsCommandSupport) {
                File file = buildConfig.getGlobalPluginsDir();
                this.updateListener(this.pluginListener, this.globalPluginsDir, file);
                this.globalPluginsDir = file;
                File file2 = buildConfig.getProjectPluginsDir();
                if (file == null && file == file2 || file.equals(file2)) {
                    if (this.projectPluginsDir != null) {
                        FileUtil.removeFileChangeListener((FileChangeListener)this.pluginListener, (File)this.projectPluginsDir);
                    }
                    this.projectPluginsDir = null;
                    return;
                }
                this.updateListener(this.pluginListener, this.projectPluginsDir, file2);
                this.projectPluginsDir = file2;
            }
        }

        private void updateListener(FileChangeListener fileChangeListener, File file, File file2) {
            if (file == null || !file.equals(file2)) {
                if (file != null) {
                    FileUtil.removeFileChangeListener((FileChangeListener)fileChangeListener, (File)file);
                }
                if (file2 != null) {
                    FileUtil.addFileChangeListener((FileChangeListener)fileChangeListener, (File)file2);
                }
            }
        }
    }

    private class ProjectConfigListener
    implements PropertyChangeListener {
        private ProjectConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("grails.platform".equals(propertyChangeEvent.getPropertyName())) {
                GrailsCommandSupport grailsCommandSupport = GrailsCommandSupport.this;
                synchronized (grailsCommandSupport) {
                    GrailsCommandSupport.this.commands = null;
                }
            }
        }
    }

    private static class ProxyInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private final List<ExecutionDescriptor.InputProcessorFactory> factories = new ArrayList<ExecutionDescriptor.InputProcessorFactory>();

        public ProxyInputProcessorFactory(ExecutionDescriptor.InputProcessorFactory ... inputProcessorFactoryArray) {
            for (ExecutionDescriptor.InputProcessorFactory inputProcessorFactory : inputProcessorFactoryArray) {
                if (inputProcessorFactory == null) continue;
                this.factories.add(inputProcessorFactory);
            }
        }

        public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
            InputProcessor[] inputProcessorArray = new InputProcessor[this.factories.size()];
            for (int i = 0; i < inputProcessorArray.length; ++i) {
                inputProcessorArray[i] = this.factories.get(i).newInputProcessor(inputProcessor);
            }
            return InputProcessors.proxy((InputProcessor[])inputProcessorArray);
        }
    }

    private static class ServerURLProcessor
    implements LineProcessor {
        private final GrailsProject project;
        private final boolean debug;
        private boolean running;

        public ServerURLProcessor(GrailsProject grailsProject, boolean bl) {
            this.project = grailsProject;
            this.debug = bl;
        }

        public void processLine(String string) {
            if (!this.running && string.contains("Browse to http://")) {
                URL uRL;
                this.running = true;
                String string2 = string.substring(string.indexOf("http://"));
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    LOGGER.log(Level.WARNING, "Could not start browser", malformedURLException);
                    return;
                }
                GrailsServerState grailsServerState = (GrailsServerState)this.project.getLookup().lookup(GrailsServerState.class);
                if (grailsServerState != null) {
                    grailsServerState.setRunningUrl(uRL);
                }
                GrailsCommandSupport.showURL(uRL, this.debug, this.project);
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }

    private static class AnsiStrippingInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private AnsiStrippingInputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
            return InputProcessors.ansiStripping((InputProcessor)inputProcessor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HelpLineProcessor
    implements LineProcessor {
        private static final Pattern COMMAND_PATTERN = Pattern.compile("grails\\s(.*)");
        private static final Pattern EXCLUDE_PATTERN = Pattern.compile("Usage.*|Examples.*");
        private List<String> commands = Collections.synchronizedList(new ArrayList());
        private boolean excluded;

        private HelpLineProcessor() {
        }

        public void processLine(String string) {
            Matcher matcher = COMMAND_PATTERN.matcher(string);
            if (matcher.matches()) {
                if (!this.excluded) {
                    this.commands.add(matcher.group(1));
                }
            } else {
                this.excluded = EXCLUDE_PATTERN.matcher(string).matches();
            }
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public void close() {
        }

        public void reset() {
        }
    }
}

