/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.spring.beans.ui.customizer.ConfigFilesUIs;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectConfigFilesPanel
extends JPanel {
    private final RequestProcessor rp = new RequestProcessor("Spring config file detection thread", 1, true);
    private final Set<File> alreadySelectedFiles;
    private final Project project;
    private List<File> availableFiles;
    private DialogDescriptor descriptor;
    private RequestProcessor.Task detectTask;
    private JScrollPane configFileScrollPane;
    private JTable configFileTable;
    private JLabel detectedFilesLabel;
    private JLabel messageLabel;
    private JProgressBar progressBar;

    public static SelectConfigFilesPanel create(Project project, Set<File> set, ConfigFilesUIs.FileDisplayName fileDisplayName) {
        return new SelectConfigFilesPanel(project, set, fileDisplayName);
    }

    public static SelectConfigFilesPanel create(List<File> list, Set<File> set, ConfigFilesUIs.FileDisplayName fileDisplayName) {
        return new SelectConfigFilesPanel(list, set, fileDisplayName);
    }

    private SelectConfigFilesPanel(List<File> list, Set<File> set, ConfigFilesUIs.FileDisplayName fileDisplayName) {
        this.alreadySelectedFiles = set;
        this.availableFiles = list;
        this.project = null;
        this.initComponents(fileDisplayName);
    }

    private SelectConfigFilesPanel(Project project, Set<File> set, ConfigFilesUIs.FileDisplayName fileDisplayName) {
        this.project = project;
        this.alreadySelectedFiles = set;
        this.initComponents(fileDisplayName);
    }

    private void initComponents(ConfigFilesUIs.FileDisplayName fileDisplayName) {
        this.initComponents();
        ConfigFilesUIs.setupFilesSelectionTable(this.configFileTable, fileDisplayName);
        this.configFileTable.getParent().setBackground(this.configFileTable.getBackground());
        this.configFileTable.getSelectionModel().setSelectionMode(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        String string = NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_ConfigFilesTitle");
        this.descriptor = new DialogDescriptor((Object)this, string, true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectConfigFilesPanel.this.cancelDetection();
            }
        });
        if (this.availableFiles == null) {
            this.descriptor.setValid(false);
            this.configFileTable.setEnabled(true);
            this.progressBar.setIndeterminate(true);
            this.detectTask = this.rp.create((Runnable)new FileDetector());
            this.detectTask.schedule(0);
        } else {
            this.updateAvailableFiles(this.availableFiles);
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        return this.descriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public List<File> getAvailableFiles() {
        return this.availableFiles;
    }

    public List<File> getSelectedFiles() {
        return ConfigFilesUIs.getSelectedFiles(this.configFileTable);
    }

    private void cancelDetection() {
        if (this.detectTask != null) {
            this.detectTask.cancel();
        }
    }

    private void updateAvailableFiles(List<File> list) {
        this.availableFiles = list;
        this.configFileTable.setEnabled(true);
        ConfigFilesUIs.connectFilesSelectionTable(list, this.alreadySelectedFiles, this.configFileTable);
        this.configFileTable.getColumnModel().getColumn(0).setMaxWidth(0);
        String string = list.size() == 0 ? NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_NoFilesFound") : " ";
        this.messageLabel.setText(string);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setBackground(this.getBackground());
        this.descriptor.setValid(true);
    }

    private void initComponents() {
        this.detectedFilesLabel = new JLabel();
        this.configFileScrollPane = new JScrollPane();
        this.configFileTable = new JTable();
        this.progressBar = new JProgressBar();
        this.messageLabel = new JLabel();
        this.detectedFilesLabel.setText(NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_ConfigFiles"));
        this.configFileTable.setIntercellSpacing(new Dimension(0, 0));
        this.configFileTable.setShowHorizontalLines(false);
        this.configFileTable.setShowVerticalLines(false);
        this.configFileTable.setTableHeader(null);
        this.configFileScrollPane.setViewportView(this.configFileTable);
        this.progressBar.setString(" ");
        this.progressBar.setStringPainted(true);
        this.messageLabel.setText(NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_PleaseWait"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.configFileScrollPane, -1, 422, Short.MAX_VALUE).add(1, (Component)this.progressBar, -1, 422, Short.MAX_VALUE).add(1, (Component)this.detectedFilesLabel).add(1, (Component)this.messageLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.detectedFilesLabel).addPreferredGap(0).add((Component)this.configFileScrollPane, -1, 233, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.messageLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addContainerGap()));
    }

    private final class FileDetector
    implements Runnable {
        private FileDetector() {
        }

        public void run() {
            HashSet<File> hashSet = new HashSet<File>();
            for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)SelectConfigFilesPanel.this.project).getSourceGroups("java")) {
                for (FileObject fileObject : sourceGroup.getRootFolder().getChildren()) {
                    File file;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (!"text/x-springconfig+xml".equals(fileObject.getMIMEType()) || (file = FileUtil.toFile((FileObject)fileObject)) == null) continue;
                    hashSet.add(file);
                }
            }
            for (SpringConfigFileProvider springConfigFileProvider : SelectConfigFilesPanel.this.project.getLookup().lookupAll(SpringConfigFileProvider.class)) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                hashSet.addAll(springConfigFileProvider.getConfigFiles());
            }
            final ArrayList arrayList = new ArrayList(hashSet.size());
            arrayList.addAll(hashSet);
            Collections.sort(arrayList);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SelectConfigFilesPanel.this.updateAvailableFiles(arrayList);
                }
            });
        }
    }
}

